/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.base.Verify;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ByteArrayInputStream;

@CanIgnoreReturnValue
public class ByteReader {
    private final byte[] bytes;
    private final IndexedByteArrayInputStream indexed;
    private final ByteArrayDataInput input;

    public ByteReader(byte[] bytes, int pos) {
        this.bytes = bytes;
        this.indexed = new IndexedByteArrayInputStream(bytes, pos, bytes.length);
        this.input = ByteStreams.newDataInput((ByteArrayInputStream)this.indexed);
    }

    public ByteArrayDataInput seek(int i) {
        return ByteStreams.newDataInput((byte[])this.bytes, (int)i);
    }

    public int pos() {
        return this.indexed.pos();
    }

    public int u1() {
        return this.input.readUnsignedByte();
    }

    public int u2() {
        return this.input.readUnsignedShort();
    }

    public int u4() {
        return this.input.readInt();
    }

    public void skip(int n) {
        int skipped = this.input.skipBytes(n);
        Verify.verify((skipped == n ? 1 : 0) != 0, (String)"wanted %s, read %s", (int)n, (int)skipped);
    }

    static class IndexedByteArrayInputStream
    extends ByteArrayInputStream {
        IndexedByteArrayInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        int pos() {
            return this.pos;
        }
    }
}

