/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bytecode.BytecodeBinder;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.SimpleTopLevelIndex;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.ModuleSymbol;
import com.google.turbine.zip.Zip;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public final class CtSymClassBinder {
    public static @Nullable ClassPath bind(int version) throws IOException {
        String javaHome = StandardSystemProperty.JAVA_HOME.value();
        Objects.requireNonNull(javaHome, "attempted to use --release, but JAVA_HOME is not set");
        Path ctSym = Paths.get(javaHome, new String[0]).resolve("lib/ct.sym");
        if (!Files.exists(ctSym, new LinkOption[0])) {
            throw new IllegalStateException("lib/ct.sym does not exist in " + javaHome);
        }
        final HashMap<ClassSymbol, BytecodeBoundClass> map = new HashMap<ClassSymbol, BytecodeBoundClass>();
        HashMap<ModuleSymbol, ModuleInfo> modules = new HashMap<ModuleSymbol, ModuleInfo>();
        Env<ClassSymbol, BytecodeBoundClass> benv = new Env<ClassSymbol, BytecodeBoundClass>(){

            @Override
            public @Nullable BytecodeBoundClass get(ClassSymbol sym) {
                return (BytecodeBoundClass)map.get(sym);
            }
        };
        String releaseString = CtSymClassBinder.formatReleaseVersion(version);
        for (Zip.Entry ze : new Zip.ZipIterable(ctSym)) {
            int idx;
            String name = ze.name();
            if (!name.endsWith(".sig") || (idx = name.indexOf(47)) == -1 || !ze.name().substring(0, idx).contains(releaseString)) continue;
            if (CtSymClassBinder.isAtLeastJDK12()) {
                idx = name.indexOf(47, idx + 1);
            }
            if (name.substring(name.lastIndexOf(47) + 1).equals("module-info.sig")) {
                ModuleInfo moduleInfo = BytecodeBinder.bindModuleInfo(name, CtSymClassBinder.toByteArrayOrDie(ze));
                modules.put(new ModuleSymbol(moduleInfo.name()), moduleInfo);
                continue;
            }
            ClassSymbol sym = new ClassSymbol(name.substring(idx + 1, name.length() - ".sig".length()));
            map.putIfAbsent(sym, new BytecodeBoundClass(sym, CtSymClassBinder.toByteArrayOrDie(ze), benv, ctSym + "!" + ze.name()));
        }
        if (map.isEmpty()) {
            return null;
        }
        final SimpleEnv env = new SimpleEnv(ImmutableMap.copyOf(map));
        final SimpleEnv moduleEnv = new SimpleEnv(ImmutableMap.copyOf(modules));
        final TopLevelIndex index = SimpleTopLevelIndex.of((Iterable<ClassSymbol>)env.asMap().keySet());
        return new ClassPath(){

            @Override
            public Env<ClassSymbol, BytecodeBoundClass> env() {
                return env;
            }

            @Override
            public Env<ModuleSymbol, ModuleInfo> moduleEnv() {
                return moduleEnv;
            }

            @Override
            public TopLevelIndex index() {
                return index;
            }

            @Override
            public @Nullable Supplier<byte[]> resource(String input) {
                return null;
            }
        };
    }

    private static Supplier<byte[]> toByteArrayOrDie(final Zip.Entry ze) {
        return Suppliers.memoize((Supplier)new Supplier<byte[]>(){

            public byte[] get() {
                return ze.data();
            }
        });
    }

    @VisibleForTesting
    static String formatReleaseVersion(int n) {
        if (n <= 4 || n >= 36) {
            throw new IllegalArgumentException("invalid release version: " + n);
        }
        return Ascii.toUpperCase((String)Integer.toString(n, 36));
    }

    private static boolean isAtLeastJDK12() {
        int major;
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object version = versionMethod.invoke(null, new Object[0]);
            major = (Integer)version.getClass().getMethod("major", new Class[0]).invoke(version, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
        return major >= 12;
    }

    private CtSymClassBinder() {
    }
}

