/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;

@BugPattern(name="InvalidLink", summary="This @link tag looks wrong.", severity=BugPattern.SeverityLevel.WARNING)
public final class InvalidLink
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Pattern EXTRACT_TARGET = Pattern.compile("([^}]*)}");

    public Description matchClass(ClassTree classTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new InvalidLinkChecker(state, classTree, ImmutableSet.of()).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet parameters = (ImmutableSet)methodTree.getParameters().stream().map(v -> v.getName().toString()).collect(ImmutableSet.toImmutableSet());
            new InvalidLinkChecker(state, methodTree, parameters).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new InvalidLinkChecker(state, variableTree, ImmutableSet.of()).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private final class InvalidLinkChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final Tree tree;
        private final ImmutableSet<String> parameters;

        private InvalidLinkChecker(VisitorState state, Tree tree, ImmutableSet<String> parameters) {
            this.state = state;
            this.tree = tree;
            this.parameters = parameters;
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Void unused) {
            String body = erroneousTree.getBody();
            if (body.startsWith("{@link ")) {
                DocTree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (!(parent instanceof DCTree.DCDocComment)) {
                    return null;
                }
                DCTree.DCDocComment comment = (DCTree.DCDocComment)parent;
                int nextIndex = comment.getFullBody().indexOf(erroneousTree) + 1;
                if (nextIndex >= comment.getFullBody().size()) {
                    return null;
                }
                DocTree next = comment.getFullBody().get(nextIndex);
                Matcher match = EXTRACT_TARGET.matcher(next.toString());
                if (!match.matches()) {
                    return null;
                }
                String target = match.group(1);
                String reference = erroneousTree.getBody().replaceFirst("\\{@link ", "");
                String fixedLink = this.fixLink(reference, target);
                DCTree.DCDocComment docComment = Utils.getDocComment(this.state, this.tree);
                if (!(next instanceof DCTree.DCText)) {
                    return null;
                }
                DCTree.DCText nextText = (DCTree.DCText)next;
                int endPos = docComment.comment.getSourcePos(nextText.pos + nextText.text.indexOf("}") + 1);
                SuggestedFix fix = SuggestedFix.replace((int)Utils.getStartPosition(erroneousTree, this.state), (int)endPos, (String)fixedLink);
                this.state.reportMatch(InvalidLink.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage("{@link} cannot be used for HTTP links. Use an <a> tag instead.").addFix((Fix)fix).build());
            }
            return (Void)super.visitErroneous(erroneousTree, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitLink(LinkTree linkTree, Void unused) {
            if (linkTree.getReference() == null) {
                return (Void)super.visitLink(linkTree, null);
            }
            String reference = linkTree.getReference().getSignature();
            Element element = null;
            Log log = Log.instance(this.state.context);
            Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(log);
            try {
                element = JavacTrees.instance(this.state.context).getElement(new DocTreePath(this.getCurrentPath(), linkTree.getReference()));
            }
            catch (AssertionError | NullPointerException object) {
            }
            finally {
                log.popDiagnosticHandler(deferredDiagnosticHandler);
            }
            if (element != null || reference.contains(".")) {
                return (Void)super.visitLink(linkTree, null);
            }
            if (this.parameters.contains((Object)reference)) {
                String message = String.format("`%s` is a parameter; use {@code paramName} to refer to parameters inline.", reference);
                this.state.reportMatch(InvalidLink.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)Utils.replace(linkTree, String.format("{@code %s}", reference), this.state)).build());
                return (Void)super.visitLink(linkTree, null);
            }
            if (Character.isLowerCase(reference.charAt(0)) && !reference.contains("#")) {
                String message = String.format("`%s` is not known here. Should it be a reference to a method?", reference);
                int pos = Utils.getStartPosition(linkTree.getReference(), this.state);
                this.state.reportMatch(InvalidLink.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix((Fix)SuggestedFix.replace((int)pos, (int)pos, (String)"#")).build());
                return (Void)super.visitLink(linkTree, null);
            }
            if (reference.charAt(0) == '#') {
                this.state.reportMatch(InvalidLink.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(String.format("The reference `%s` to a method doesn't resolve to anything. Is it misspelt, or is the parameter list not correct? See https://docs.oracle.com/javase/8/docs/technotes/tools/unix/javadoc.html#JSSOR654 for documentation on how to form method links.", reference)).build());
            }
            return (Void)super.visitLink(linkTree, null);
        }

        private String fixLink(String reference, String label) {
            if (label.isEmpty()) {
                label = "link";
            }
            return String.format("<a href=\"%s\">%s</a>", reference, label);
        }
    }
}

