/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Modifier;

@BugPattern(name="PublicConstructorForAbstractClass", summary="Constructors of an abstract class can be declared protected as there is never a need for them to be public", explanation="Abstract classes' constructors are only ever called by subclasses, never directly by another class. Therefore they never need public constructors: protected is accessible enough.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class PublicConstructorForAbstractClass
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> PUBLIC_ABSTRACT_CONSTRUCTOR = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.methodHasVisibility((MethodVisibility.Visibility)MethodVisibility.Visibility.PUBLIC), Matchers.enclosingClass((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT))});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!PUBLIC_ABSTRACT_CONSTRUCTOR.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PROTECTED}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

