/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@BugPattern(name="JUnit4ClassAnnotationNonStatic", summary="This method should be static", severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4ClassAnnotationNonStatic
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final MultiMatcher<MethodTree, AnnotationTree> CLASS_INIT_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.junit.AfterClass"), Matchers.isType((String)"org.junit.BeforeClass")}));

    public Description matchMethod(MethodTree tree, VisitorState state) {
        MultiMatcher.MultiMatchResult matchResult = CLASS_INIT_ANNOTATION.multiMatchResult((Tree)tree, state);
        if (!matchResult.matches() || Matchers.isStatic().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(JUnit4ClassAnnotationNonStatic.messageForAnnos((List<AnnotationTree>)matchResult.matchingNodes())).addFix(SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC})).build();
    }

    private static String messageForAnnos(List<AnnotationTree> annotationTrees) {
        String annoNames = annotationTrees.stream().map(a -> Signatures.prettyType((Type)ASTHelpers.getType((Tree)a))).collect(Collectors.joining(" and "));
        return annoNames + " can only be applied to static methods.";
    }
}

