/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class Regexes {
    private static final ImmutableMap<Character, Character> REGEXCHAR_TO_LITERALCHAR = new ImmutableMap.Builder().put((Object)Character.valueOf('t'), (Object)Character.valueOf('\t')).put((Object)Character.valueOf('n'), (Object)Character.valueOf('\n')).put((Object)Character.valueOf('f'), (Object)Character.valueOf('\f')).put((Object)Character.valueOf('r'), (Object)Character.valueOf('\r')).build();
    private static final CharMatcher UNESCAPED_CONSTRUCT = CharMatcher.anyOf((CharSequence)"[].^$?*+{}()|");

    public static Optional<String> convertRegexToLiteral(String s) {
        try {
            Pattern.compile(s);
        }
        catch (PatternSyntaxException e) {
            return Optional.empty();
        }
        boolean inQuote = false;
        StringBuilder result = new StringBuilder();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char current = s.charAt(i);
            if (!inQuote && UNESCAPED_CONSTRUCT.matches(current)) {
                return Optional.empty();
            }
            if (current == '\\') {
                char escaped;
                if ((escaped = s.charAt(++i)) == 'Q') {
                    inQuote = true;
                    continue;
                }
                if (escaped == 'E') {
                    inQuote = false;
                    continue;
                }
                Character controlChar = (Character)REGEXCHAR_TO_LITERALCHAR.get((Object)Character.valueOf(escaped));
                if (controlChar != null) {
                    result.append(controlChar);
                    continue;
                }
                if (escaped == '\\') {
                    result.append('\\');
                    continue;
                }
                if (UNESCAPED_CONSTRUCT.matches(escaped)) {
                    result.append(escaped);
                    continue;
                }
                return Optional.empty();
            }
            result.append(current);
        }
        return Optional.of(result.toString());
    }

    private Regexes() {
    }
}

