#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 arch-hs
version:              0.10.2.0
visibility:           public
id:                   arch-hs-0.10.2.0-I9mIG59jfXa2EcY6qp5UKz
key:                  arch-hs-0.10.2.0-I9mIG59jfXa2EcY6qp5UKz
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  f3413eaa050b346388a4262d6fe2118b
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.CommunityDB
    Distribution.ArchHs.Compat Distribution.ArchHs.Core
    Distribution.ArchHs.Exception Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.0.2/site-local/arch-hs-0.10.2.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/arch-hs-0.10.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.10.2.0-I9mIG59jfXa2EcY6qp5UKz
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.0.2/site-local/arch-hs-0.10.2.0/include
depends:
    Cabal-3.4.1.0 Diff-0.4.1-2jMKpzJJQmAHzE6LyB7Qjk
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    algebraic-graphs-0.7-FoPtb6ASd7qJPZzT1Ebmg1
    arch-web-0.1.1-7F7XGKNHOuEH0t2Oqy08ef base-4.15.1.0
    bytestring-0.10.12.1 conduit-1.3.4.3-8itn5Qj41ZSLgRSjBhzqyF
    conduit-extra-1.3.6-LDUhnbBFGIILMmOycgbU6i containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.2 filepath-1.4.2.1
    hackage-db-2.1.2-IBbKh7LLkMRSPgctgWzyW
    http-client-0.7.13.1-IUPmZAWhHcS7Jd2UKXuikW
    http-client-tls-0.3.6.1-KvEPoRWqIbH3HwtuX8a907
    megaparsec-9.2.2-9J8e8j7w3nJKAXfYAylaYf
    microlens-0.4.13.0-8kbZITwqGed8vNsPXOVOwI
    microlens-th-0.4.3.10-H2JRp2jh1X4pUCK34kQqn
    neat-interpolation-0.5.1.3-E1R4kkjgxst4TthBU0qY1h
    optparse-simple-0.1.1.4-81AJZABPNI16Lh8drGJvzo
    polysemy-1.7.1.0-6y7Gw8alu22G0n0NI5GF7c
    prettyprinter-1.7.1-Kh082I8LQyjLFudtJnG2xP
    prettyprinter-ansi-terminal-1.1.3-1EdU9xpSi4b31RFlIAEoGC
    servant-client-0.19-J3segbi5hHRD1tkMWSMJXV
    split-0.2.3.5-1ZFbiAR4sQhKaqqBevLjN8
    tar-conduit-0.3.2-51yGEqXD1qxLbm1JPfEgn template-haskell-2.17.0.0
    text-1.2.5.0

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

