#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 Allure
version:              0.11.0.0
visibility:           public
id:                   Allure-0.11.0.0-DlgfSgUjDBj4kbdpngrXKR
key:                  Allure-0.11.0.0-DlgfSgUjDBj4kbdpngrXKR
license:              AGPL-3.0-or-later
maintainer:           Mikolaj Konarski <mikolaj.konarski@funktory.com>
author:               Andres Loeh, Mikolaj Konarski and others
homepage:             http://allureofthestars.com
synopsis:             Near-future Sci-Fi roguelike and tactical squad combat game
description:
    Allure of the Stars is a near-future Sci-Fi roguelike
    and tactical squad combat game. Binaries and the game manual
    are available at the homepage. You can also try the game out
    in the browser at <http://allureofthestars.com/play>.

    Not a single image in this game. You have to imagine everything
    yourself, like with a book (a grown-up book, without pictures).
    Once you learn to imagine things, though, you can keep exploring
    and mastering the world and making up stories for a long time.

    The game is written in Haskell using the LambdaHack roguelike
    game engine <http://hackage.haskell.org/package/LambdaHack>.
    Please see the changelog file for recent improvements
    and the issue tracker for short-term plans. Long term goals
    are high replayability and auto-balancing through procedural
    content generation and persistent content modification
    based on player behaviour. Contributions are welcome.

    This is a workaround .cabal file, flattened to eliminate
    internal libraries until generating haddocks for them
    is fixed. The original .cabal file is in .cabal.bkp file.

category:             Game
abi:                  5e51ad88dff9ef5c5d8e7dea245e326e
exposed:              True
exposed-modules:
    Client.UI.Content.Input Client.UI.Content.Screen Content.CaveKind
    Content.FactionKind Content.ItemKind Content.ItemKindActor
    Content.ItemKindBlast Content.ItemKindEmbed Content.ItemKindOrgan
    Content.ItemKindTemporary Content.ModeKind Content.PlaceKind
    Content.RuleKind Content.TileKind
    Implementation.MonadClientImplementation
    Implementation.MonadServerImplementation TieKnot

hidden-modules:       Paths_Allure
import-dirs:          /usr/lib/ghc-9.0.2/site-local/Allure-0.11.0.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/Allure-0.11.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/allure
hs-libraries:         HSAllure-0.11.0.0-DlgfSgUjDBj4kbdpngrXKR
depends:
    LambdaHack-0.11.0.0-5dZNvRnipMI8yqZBWUpOeJ
    async-2.2.4-9EoKZTgytm43s60GeTAIZR base-4.15.1.0
    enummapset-0.7.1.0-l8CPbiAlUSKGofWBluoBc
    file-embed-0.0.15.0-FF5xUPWKaB3GI64c6hgPnn filepath-1.4.2.1
    ghc-compact-0.1.0.0 hsini-0.5.1.2-FGs2NtL9BZzASnzAq3dqb0
    optparse-applicative-0.17.0.0-5RAB8jXJau3LDHQVpRHOkD
    primitive-0.7.4.0-CfTIpXUHtu665Ilg6bT1BW
    splitmix-0.1.0.4-Ekcjoaio8AJ1Z4nSJbcogE template-haskell-2.17.0.0
    text-1.2.5.0 th-lift-instances-0.1.20-5NHl0zPpjKhEmiENmzVd0c
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/allure/html/Allure.haddock
haddock-html:         /usr/share/doc/allure/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

