/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.outline;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.ExtTreeWillExpandListener;
import org.netbeans.swing.outline.OutlineModel;

public final class TreePathSupport {
    private List<TreeExpansionListener> eListeners = new ArrayList<TreeExpansionListener>();
    private List<TreeWillExpandListener> weListeners = new ArrayList<TreeWillExpandListener>();
    private AbstractLayoutCache layout;

    public TreePathSupport(OutlineModel outlineModel, AbstractLayoutCache abstractLayoutCache) {
        this.layout = abstractLayoutCache;
    }

    public void clear() {
    }

    public void expandPath(TreePath treePath) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.layout.isExpanded(treePath)) {
            return;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            this.expandPath(treePath2);
        }
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        try {
            this.fireTreeWillExpand(treeExpansionEvent, true);
            this.layout.setExpandedState(treePath, true);
            this.fireTreeExpansion(treeExpansionEvent, true);
        }
        catch (ExpandVetoException expandVetoException) {
            this.fireTreeExpansionVetoed(treeExpansionEvent, expandVetoException);
        }
    }

    public void collapsePath(TreePath treePath) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.layout.isExpanded(treePath)) {
            return;
        }
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        try {
            this.fireTreeWillExpand(treeExpansionEvent, false);
            this.layout.setExpandedState(treePath, false);
            this.fireTreeExpansion(treeExpansionEvent, false);
        }
        catch (ExpandVetoException expandVetoException) {
            this.fireTreeExpansionVetoed(treeExpansionEvent, expandVetoException);
        }
    }

    public void removePath(TreePath treePath) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeExpansion(TreeExpansionEvent treeExpansionEvent, boolean bl) {
        int n = this.eListeners.size();
        TreeExpansionListener[] treeExpansionListenerArray = new TreeExpansionListener[n];
        TreePathSupport treePathSupport = this;
        synchronized (treePathSupport) {
            treeExpansionListenerArray = this.eListeners.toArray(treeExpansionListenerArray);
        }
        for (int i = 0; i < treeExpansionListenerArray.length; ++i) {
            if (bl) {
                treeExpansionListenerArray[i].treeExpanded(treeExpansionEvent);
                continue;
            }
            treeExpansionListenerArray[i].treeCollapsed(treeExpansionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeWillExpand(TreeExpansionEvent treeExpansionEvent, boolean bl) throws ExpandVetoException {
        int n = this.weListeners.size();
        TreeWillExpandListener[] treeWillExpandListenerArray = new TreeWillExpandListener[n];
        TreePathSupport treePathSupport = this;
        synchronized (treePathSupport) {
            treeWillExpandListenerArray = this.weListeners.toArray(treeWillExpandListenerArray);
        }
        for (int i = 0; i < treeWillExpandListenerArray.length; ++i) {
            if (bl) {
                treeWillExpandListenerArray[i].treeWillExpand(treeExpansionEvent);
                continue;
            }
            treeWillExpandListenerArray[i].treeWillCollapse(treeExpansionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeExpansionVetoed(TreeExpansionEvent treeExpansionEvent, ExpandVetoException expandVetoException) {
        int n = this.weListeners.size();
        TreeWillExpandListener[] treeWillExpandListenerArray = new TreeWillExpandListener[n];
        TreePathSupport treePathSupport = this;
        synchronized (treePathSupport) {
            treeWillExpandListenerArray = this.weListeners.toArray(treeWillExpandListenerArray);
        }
        for (int i = 0; i < treeWillExpandListenerArray.length; ++i) {
            if (!(treeWillExpandListenerArray[i] instanceof ExtTreeWillExpandListener)) continue;
            ((ExtTreeWillExpandListener)treeWillExpandListenerArray[i]).treeExpansionVetoed(treeExpansionEvent, expandVetoException);
        }
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        assert (SwingUtilities.isEventDispatchThread());
        return treePath != null && this.layout.isExpanded(treePath);
    }

    public boolean isExpanded(TreePath treePath) {
        assert (SwingUtilities.isEventDispatchThread());
        if (treePath == null) {
            return false;
        }
        if (!this.layout.isRootVisible() && treePath.getParentPath() == null) {
            return true;
        }
        boolean bl = this.layout.isExpanded(treePath);
        if (!bl) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            return this.isExpanded(treePath2);
        }
        return true;
    }

    public boolean isVisible(TreePath treePath) {
        if (treePath != null) {
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 != null) {
                return this.isExpanded(treePath2);
            }
            return true;
        }
        return false;
    }

    public TreePath[] getExpandedDescendants(TreePath treePath) {
        assert (SwingUtilities.isEventDispatchThread());
        TreePath[] treePathArray = new TreePath[]{};
        if (this.isExpanded(treePath)) {
            ArrayList<TreePath> arrayList = null;
            Enumeration<TreePath> enumeration = this.layout.getVisiblePathsFrom(treePath);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    TreePath treePath2 = enumeration.nextElement();
                    if (treePath2 == treePath || !this.layout.isExpanded(treePath2) || !treePath.isDescendant(treePath2)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<TreePath>();
                    }
                    arrayList.add(treePath2);
                }
                if (arrayList != null) {
                    treePathArray = arrayList.toArray(treePathArray);
                }
            }
        }
        return treePathArray;
    }

    public synchronized void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.eListeners.add(treeExpansionListener);
    }

    public synchronized void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.eListeners.remove(treeExpansionListener);
    }

    public synchronized void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.weListeners.add(treeWillExpandListener);
    }

    public synchronized void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.weListeners.remove(treeWillExpandListener);
    }

    void treeStructureChanged(TreeModelEvent treeModelEvent) {
        Object object;
        TreePath treePath = treeModelEvent.getTreePath();
        TreeModel treeModel = this.layout.getModel();
        if (treePath == null && treeModel != null && (object = treeModel.getRoot()) != null) {
            treePath = new TreePath(object);
        }
        object = this.getExpandedDescendants(treePath);
        this.layout.treeStructureChanged(treeModelEvent);
        for (TreePath treePath2 : object) {
            this.layout.setExpandedState(treePath2, true);
        }
    }
}

