/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.tomcat.util.scan.JarFactory;

public class WebappServiceLoader<T> {
    private static final String CLASSES = "/WEB-INF/classes/";
    private static final String LIB = "/WEB-INF/lib/";
    private static final String SERVICES = "META-INF/services/";
    private final Context context;
    private final ServletContext servletContext;
    private final Pattern containerSciFilterPattern;

    public WebappServiceLoader(Context context) {
        this.context = context;
        this.servletContext = context.getServletContext();
        String string = context.getContainerSciFilter();
        this.containerSciFilterPattern = string != null && string.length() > 0 ? Pattern.compile(string) : null;
    }

    public List<T> load(Class<T> clazz) throws IOException {
        Serializable serializable;
        String string2 = SERVICES + clazz.getName();
        ClassLoader classLoader = this.context.getParentClassLoader();
        Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources(string2) : classLoader.getResources(string2);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        HashSet<URL> hashSet = new HashSet<URL>();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            hashSet.add((URL)serializable);
            this.parseConfigFile(linkedHashSet, (URL)serializable);
        }
        if (this.containerSciFilterPattern != null) {
            linkedHashSet.removeIf(string -> this.containerSciFilterPattern.matcher((CharSequence)string).find());
        }
        serializable = new LinkedHashSet();
        List list = (List)this.servletContext.getAttribute("javax.servlet.context.orderedLibs");
        if (list == null) {
            Enumeration<URL> enumeration2 = this.servletContext.getClassLoader().getResources(string2);
            while (enumeration2.hasMoreElements()) {
                URL uRL = enumeration2.nextElement();
                if (hashSet.contains(uRL)) continue;
                this.parseConfigFile((LinkedHashSet<String>)serializable, uRL);
            }
        } else {
            URL uRL = this.servletContext.getResource(CLASSES + string2);
            if (uRL != null) {
                this.parseConfigFile((LinkedHashSet<String>)serializable, uRL);
            }
            for (String string3 : list) {
                URL uRL2 = this.servletContext.getResource(LIB + string3);
                if (uRL2 == null) continue;
                String string4 = uRL2.toExternalForm();
                URL uRL3 = string4.endsWith("/") ? new URL(string4 + string2) : JarFactory.getJarEntryURL((URL)uRL2, (String)string2);
                try {
                    this.parseConfigFile((LinkedHashSet<String>)serializable, uRL3);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        linkedHashSet.addAll((Collection<String>)((Object)serializable));
        if (linkedHashSet.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadServices(clazz, linkedHashSet);
    }

    void parseConfigFile(LinkedHashSet<String> linkedHashSet, URL uRL) throws IOException {
        try (InputStream inputStream = uRL.openStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(35);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if ((string = string.trim()).length() == 0) continue;
                linkedHashSet.add(string);
            }
        }
    }

    List<T> loadServices(Class<T> clazz, LinkedHashSet<String> linkedHashSet) throws IOException {
        ClassLoader classLoader = this.servletContext.getClassLoader();
        ArrayList<T> arrayList = new ArrayList<T>(linkedHashSet.size());
        for (String string : linkedHashSet) {
            try {
                Class<?> clazz2 = Class.forName(string, true, classLoader);
                arrayList.add(clazz.cast(clazz2.getConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (ClassCastException | ReflectiveOperationException exception) {
                throw new IOException(exception);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }
}

