/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.naming.ContextAccessController;
import org.apache.naming.StringManager;

public class ContextBindings {
    private static final Map<Object, Context> objectBindings = new ConcurrentHashMap<Object, Context>();
    private static final Map<Thread, Context> threadBindings = new ConcurrentHashMap<Thread, Context>();
    private static final Map<Thread, Object> threadObjectBindings = new ConcurrentHashMap<Thread, Object>();
    private static final Map<ClassLoader, Context> clBindings = new ConcurrentHashMap<ClassLoader, Context>();
    private static final Map<ClassLoader, Object> clObjectBindings = new ConcurrentHashMap<ClassLoader, Object>();
    protected static final StringManager sm = StringManager.getManager(ContextBindings.class);

    public static void bindContext(Object object, Context context) {
        ContextBindings.bindContext(object, context, null);
    }

    public static void bindContext(Object object, Context context, Object object2) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            objectBindings.put(object, context);
        }
    }

    public static void unbindContext(Object object, Object object2) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            objectBindings.remove(object);
        }
    }

    static Context getContext(Object object) {
        return objectBindings.get(object);
    }

    public static void bindThread(Object object, Object object2) throws NamingException {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            Context context = objectBindings.get(object);
            if (context == null) {
                throw new NamingException(sm.getString("contextBindings.unknownContext", object));
            }
            threadBindings.put(Thread.currentThread(), context);
            threadObjectBindings.put(Thread.currentThread(), object);
        }
    }

    public static void unbindThread(Object object, Object object2) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            threadBindings.remove(Thread.currentThread());
            threadObjectBindings.remove(Thread.currentThread());
        }
    }

    public static Context getThread() throws NamingException {
        Context context = threadBindings.get(Thread.currentThread());
        if (context == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToThread"));
        }
        return context;
    }

    static String getThreadName() throws NamingException {
        Object object = threadObjectBindings.get(Thread.currentThread());
        if (object == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToThread"));
        }
        return object.toString();
    }

    public static boolean isThreadBound() {
        return threadBindings.containsKey(Thread.currentThread());
    }

    public static void bindClassLoader(Object object, Object object2, ClassLoader classLoader) throws NamingException {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            Context context = objectBindings.get(object);
            if (context == null) {
                throw new NamingException(sm.getString("contextBindings.unknownContext", object));
            }
            clBindings.put(classLoader, context);
            clObjectBindings.put(classLoader, object);
        }
    }

    public static void unbindClassLoader(Object object, Object object2, ClassLoader classLoader) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            Object object3 = clObjectBindings.get(classLoader);
            if (object3 == null || !object3.equals(object)) {
                return;
            }
            clBindings.remove(classLoader);
            clObjectBindings.remove(classLoader);
        }
    }

    public static Context getClassLoader() throws NamingException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Context context = null;
        do {
            if ((context = clBindings.get(classLoader)) == null) continue;
            return context;
        } while ((classLoader = classLoader.getParent()) != null);
        throw new NamingException(sm.getString("contextBindings.noContextBoundToCL"));
    }

    static String getClassLoaderName() throws NamingException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object object = null;
        do {
            if ((object = clObjectBindings.get(classLoader)) == null) continue;
            return object.toString();
        } while ((classLoader = classLoader.getParent()) != null);
        throw new NamingException(sm.getString("contextBindings.noContextBoundToCL"));
    }

    public static boolean isClassLoaderBound() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        do {
            if (!clBindings.containsKey(classLoader)) continue;
            return true;
        } while ((classLoader = classLoader.getParent()) != null);
        return false;
    }
}

