/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.util.ProcessIdUtil;

@Plugin(name="ProcessIdPatternConverter", category="Converter")
@ConverterKeys(value={"pid", "processId"})
public final class ProcessIdPatternConverter
extends LogEventPatternConverter {
    private static final String DEFAULT_DEFAULT_VALUE = "???";
    private final String pid;

    private ProcessIdPatternConverter(String ... options2) {
        super("Process ID", "pid");
        String defaultValue = options2.length > 0 ? options2[0] : DEFAULT_DEFAULT_VALUE;
        String discoveredPid = ProcessIdUtil.getProcessId();
        this.pid = discoveredPid.equals("-") ? defaultValue : discoveredPid;
    }

    public String getProcessId() {
        return this.pid;
    }

    public static void main(String[] args2) {
        System.out.println(new ProcessIdPatternConverter((String[])new String[0]).pid);
    }

    public static ProcessIdPatternConverter newInstance(String[] options2) {
        return new ProcessIdPatternConverter(options2);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        toAppendTo.append(this.pid);
    }
}

