/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.Illuminant;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.WhitePointColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\u001a'\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\"\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0005\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a'\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0004\"\u00020\bH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001aA\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\r0\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001aS\u0010\u0014\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u00152\u0006\u0010\u0016\u001a\u00020\u00172$\u0010\u0018\u001a \u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\r0\u0019H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001aA\u0010\u001c\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\r0\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"componentInfoList", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "c", "", "([Lcom/github/ajalt/colormath/ColorComponentInfo;)Ljava/util/List;", "polarComponentInfo", "name", "", "rectangularComponentInfo", "names", "([Ljava/lang/String;)Ljava/util/List;", "adaptToThis", "T", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/WhitePointColorSpace;", "color", "convert", "Lkotlin/Function1;", "(Lcom/github/ajalt/colormath/WhitePointColorSpace;Lcom/github/ajalt/colormath/Color;Lkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "doCreate", "Lcom/github/ajalt/colormath/ColorSpace;", "components", "", "init", "Lkotlin/Function4;", "", "(Lcom/github/ajalt/colormath/ColorSpace;[FLkotlin/jvm/functions/Function4;)Lcom/github/ajalt/colormath/Color;", "withValidComps", "block", "(Lcom/github/ajalt/colormath/ColorSpace;[FLkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "colormath"})
public final class ColorSpaceUtilsKt {
    @NotNull
    public static final <T extends Color> T withValidComps(@NotNull ColorSpace<T> $this$withValidComps, @NotNull float[] components, @NotNull Function1<? super float[], ? extends T> block) {
        Intrinsics.checkNotNullParameter($this$withValidComps, "<this>");
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withValidComps = false;
        int size = $this$withValidComps.getComponents().size();
        int n = size - 1;
        int n2 = components.length;
        n = n <= n2 ? (n2 <= size ? 1 : 0) : 0;
        n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size - 1) + " or " + size;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (T)((Color)block.invoke((float[])components));
    }

    @NotNull
    public static final <T extends Color> T doCreate(@NotNull ColorSpace<T> $this$doCreate, @NotNull float[] components, @NotNull Function4<? super Float, ? super Float, ? super Float, ? super Float, ? extends T> init) {
        float f;
        Intrinsics.checkNotNullParameter($this$doCreate, "<this>");
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(init, "init");
        boolean $i$f$doCreate = false;
        ColorSpace<T> $this$withValidComps$iv = $this$doCreate;
        boolean $i$f$withValidComps = false;
        int size$iv = $this$withValidComps$iv.getComponents().size();
        int n = size$iv - 1;
        int n2 = components.length;
        n = n <= n2 ? (n2 <= size$iv ? 1 : 0) : 0;
        n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "Invalid component array length: " + components.length + ", expected " + (size$iv - 1) + " or " + size$iv;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float[] it = components;
        boolean bl3 = false;
        Function4<Float, Float, Float, Float, T> function4 = init;
        Float f2 = Float.valueOf(components[0]);
        Float f3 = Float.valueOf(components[1]);
        Float f4 = Float.valueOf(components[2]);
        float[] fArray = components;
        int n3 = 3;
        boolean bl4 = false;
        if (n3 <= ArraysKt.getLastIndex(fArray)) {
            f = fArray[n3];
        } else {
            int n4 = n3;
            Float f5 = f4;
            Float f6 = f3;
            Float f7 = f2;
            Function4<Float, Float, Float, Float, T> function42 = function4;
            boolean bl5 = false;
            float f8 = 1.0f;
            function4 = function42;
            f2 = f7;
            f3 = f6;
            f4 = f5;
            f = f8;
        }
        return (T)((Color)function4.invoke(f2, f3, f4, Float.valueOf(f)));
    }

    @NotNull
    public static final <T extends Color> T adaptToThis(@NotNull WhitePointColorSpace<T> $this$adaptToThis, @NotNull Color color, @NotNull Function1<? super Color, ? extends T> convert2) {
        Intrinsics.checkNotNullParameter($this$adaptToThis, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(convert2, "convert");
        boolean $i$f$adaptToThis = false;
        ColorSpace<?> colorSpace = color.getSpace();
        WhitePointColorSpace whitePointColorSpace = colorSpace instanceof WhitePointColorSpace ? (WhitePointColorSpace)colorSpace : null;
        WhitePoint whitePoint = whitePointColorSpace == null ? null : whitePointColorSpace.getWhitePoint();
        return (T)(Intrinsics.areEqual(whitePoint == null ? Illuminant.INSTANCE.getD65() : whitePoint, $this$adaptToThis.getWhitePoint()) ? (Color)convert2.invoke(color) : (Color)convert2.invoke(color.toXYZ().adaptTo(XYZKt.XYZColorSpace($this$adaptToThis.getWhitePoint()))));
    }

    @NotNull
    public static final List<ColorComponentInfo> componentInfoList(ColorComponentInfo ... c) {
        Intrinsics.checkNotNullParameter(c, "c");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread(c);
        spreadBuilder.add(new ColorComponentInfo("alpha", false));
        return CollectionsKt.listOf(spreadBuilder.toArray(new ColorComponentInfo[spreadBuilder.size()]));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ColorComponentInfo> rectangularComponentInfo(String ... names) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, "names");
        Iterable $this$map$iv = CollectionsKt.plus((Collection)ArraysKt.asList(names), "alpha");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ColorComponentInfo colorComponentInfo = new ColorComponentInfo((String)it, false);
            collection.add(colorComponentInfo);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ColorComponentInfo> rectangularComponentInfo(@NotNull String name) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        CharSequence $this$map$iv = name;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var7_6 = $this$mapTo$iv$iv;
        for (int i = 0; i < var7_6.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = var7_6.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = String.valueOf((char)it);
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        return ColorSpaceUtilsKt.rectangularComponentInfo(Arrays.copyOf(stringArray2, stringArray2.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ColorComponentInfo> polarComponentInfo(@NotNull String name) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        CharSequence $this$map$iv = name;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        for (int i = 0; i < var6_6.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = var6_6.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ColorComponentInfo colorComponentInfo = new ColorComponentInfo(String.valueOf((char)it), it == 72);
            collection.add(colorComponentInfo);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), new ColorComponentInfo("alpha", false));
    }
}

