/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.htmlparser.jericho.MasonTagTypes;
import net.htmlparser.jericho.MicrosoftConditionalCommentTagTypes;
import net.htmlparser.jericho.PHPTagTypes;
import net.htmlparser.jericho.Source;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.pscan.OptionsPassiveScan;
import org.zaproxy.zap.extension.pscan.PassiveScanData;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PassiveScannerList;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.utils.Stats;

public class PassiveScanThread
extends Thread
implements ProxyListener,
SessionChangedListener {
    private static final Logger logger = LogManager.getLogger(PassiveScanThread.class);
    public static final int PROXY_LISTENER_ORDER = 5001;
    private static Set<Integer> optedInHistoryTypes = new HashSet<Integer>();
    private OptionsPassiveScan options = null;
    private PassiveScannerList scannerList = null;
    private int currentId = 1;
    private int lastId = -1;
    private int mainSleep = 5000;
    private int postSleep = 200;
    private volatile boolean shutDown = false;
    private final ExtensionHistory extHist;
    private final ExtensionAlert extAlert;
    private final PassiveScanParam pscanOptions;
    private TableHistory historyTable = null;
    private HistoryReference href = null;
    private Session session;
    private String currentRuleName = "";
    private String currentUrl = "";
    private long currentRuleStartTime = 0L;
    private Map<Integer, Integer> alertCounts = new HashMap<Integer, Integer>();

    @Deprecated
    public PassiveScanThread(PassiveScannerList passiveScannerList, ExtensionHistory extHist, ExtensionAlert extensionAlert) {
        this(passiveScannerList, extHist, extensionAlert, new PassiveScanParam());
    }

    public PassiveScanThread(PassiveScannerList passiveScannerList, ExtensionHistory extHist, ExtensionAlert extensionAlert, PassiveScanParam pscanOptions) {
        super("ZAP-PassiveScanner");
        this.setDaemon(true);
        if (extensionAlert == null) {
            throw new IllegalArgumentException("Parameter extensionAlert must not be null.");
        }
        this.scannerList = passiveScannerList;
        MicrosoftConditionalCommentTagTypes.register();
        PHPTagTypes.register();
        PHPTagTypes.PHP_SHORT.deregister();
        MasonTagTypes.register();
        this.extAlert = extensionAlert;
        this.extHist = extHist;
        this.pscanOptions = pscanOptions;
    }

    @Override
    public void run() {
        this.historyTable = Model.getSingleton().getDb().getTableHistory();
        this.session = Model.getSingleton().getSession();
        this.lastId = this.currentId = this.getLastHistoryId();
        while (!this.shutDown) {
            block38: {
                try {
                    if (this.href != null || this.lastId > this.currentId) {
                        ++this.currentId;
                    } else {
                        try {
                            Thread.sleep(this.mainSleep);
                            if (this.shutDown) {
                                return;
                            }
                            this.lastId = this.getLastHistoryId();
                        }
                        catch (InterruptedException e) {
                            try {
                                Thread.sleep(this.postSleep);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        this.href = this.getHistoryReference(this.currentId);
                    }
                    catch (Exception e) {
                        if (this.shutDown) {
                            return;
                        }
                        logger.error("Failed to read record " + this.currentId + " from History table", (Throwable)e);
                    }
                    if (this.href == null || this.pscanOptions.isScanOnlyInScope() && !this.session.isInScope(this.href)) break block38;
                    try {
                        HttpMessage msg = this.href.getHttpMessage();
                        Source src = new Source((CharSequence)msg.getResponseBody().toString());
                        this.currentUrl = msg.getRequestHeader().getURI().toString();
                        PassiveScanData passiveScanData = new PassiveScanData(msg);
                        int maxBodySize = this.pscanOptions.getMaxBodySizeInBytesToScan();
                        for (PassiveScanner scanner : this.scannerList.list()) {
                            try {
                                if (this.shutDown) {
                                    return;
                                }
                                int hrefHistoryType = this.href.getHistoryType();
                                if (scanner.isEnabled() && (scanner.appliesToHistoryType(hrefHistoryType) || optedInHistoryTypes.contains(hrefHistoryType))) {
                                    boolean cleanScanner = false;
                                    if (scanner instanceof PluginPassiveScanner) {
                                        ((PluginPassiveScanner)scanner).init(this, msg, passiveScanData);
                                        cleanScanner = true;
                                    } else {
                                        scanner.setParent(this);
                                    }
                                    this.currentRuleName = scanner.getName();
                                    this.currentRuleStartTime = System.currentTimeMillis();
                                    boolean scanned = false;
                                    if (maxBodySize <= 0 || msg.getRequestBody().length() < maxBodySize) {
                                        scanner.scanHttpRequestSend(msg, this.href.getHistoryId());
                                        scanned = true;
                                    } else {
                                        Stats.incCounter("stats.pscan.reqBodyTooBig");
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("Request to " + msg.getRequestHeader().getURI() + " body size " + msg.getRequestBody().length() + " larger than max configured " + maxBodySize);
                                        }
                                    }
                                    if (msg.isResponseFromTargetHost()) {
                                        if (maxBodySize <= 0 || msg.getResponseBody().length() < maxBodySize) {
                                            scanner.scanHttpResponseReceive(msg, this.href.getHistoryId(), src);
                                            scanned = true;
                                        } else {
                                            Stats.incCounter("stats.pscan.respBodyTooBig");
                                            if (logger.isDebugEnabled()) {
                                                logger.debug("Response from " + msg.getRequestHeader().getURI() + " body size " + msg.getResponseBody().length() + " larger than max configured " + maxBodySize);
                                            }
                                        }
                                    }
                                    if (cleanScanner) {
                                        ((PluginPassiveScanner)scanner).clean();
                                    }
                                    if (scanned) {
                                        long timeTaken = System.currentTimeMillis() - this.currentRuleStartTime;
                                        if (scanner instanceof PluginPassiveScanner) {
                                            PluginPassiveScanner pps = (PluginPassiveScanner)scanner;
                                            Stats.incCounter("stats.pscan." + pps.getPluginId() + ".time", timeTaken);
                                        }
                                        Stats.incCounter("stats.pscan." + this.currentRuleName, timeTaken);
                                        if (timeTaken > 5000L) {
                                            String responseInfo = "";
                                            if (msg.isResponseFromTargetHost()) {
                                                responseInfo = msg.getResponseHeader().getHeader("Content-Type") + " " + msg.getResponseBody().length();
                                            }
                                            logger.warn("Passive Scan rule " + this.currentRuleName + " took " + timeTaken / 1000L + " seconds to scan " + this.currentUrl + " " + responseInfo);
                                        }
                                    }
                                }
                            }
                            catch (Throwable e) {
                                if (this.shutDown) {
                                    return;
                                }
                                logger.error("Scanner " + scanner.getName() + " failed on record " + this.currentId + " from History table: " + this.href.getMethod() + " " + this.href.getURI(), e);
                            }
                            this.currentRuleName = "";
                            this.currentRuleStartTime = 0L;
                        }
                    }
                    catch (Exception e) {
                        if (HistoryReference.getTemporaryTypes().contains(this.href.getHistoryType())) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Temporary record " + this.currentId + " no longer available:", (Throwable)e);
                            }
                        }
                        logger.error("Parser failed on record " + this.currentId + " from History table", (Throwable)e);
                    }
                    this.currentUrl = "";
                }
                catch (Exception e) {
                    if (this.shutDown) {
                        return;
                    }
                    logger.error("Failed on record " + this.currentId + " from History table", (Throwable)e);
                }
            }
            int recordsToScan = this.getRecordsToScan();
            Stats.setHighwaterMark("stats.pscan.recordsToScan", recordsToScan);
            if (!View.isInitialised()) continue;
            Control.getSingleton().getExtensionLoader().getExtension(ExtensionPassiveScan.class).getScanStatus().setScanCount(recordsToScan);
        }
    }

    private HistoryReference getHistoryReference(int historyReferenceId) {
        if (this.extHist != null) {
            return this.extHist.getHistoryReference(historyReferenceId);
        }
        try {
            return new HistoryReference(historyReferenceId);
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            return null;
        }
    }

    private int getLastHistoryId() {
        return this.historyTable.lastIndex();
    }

    protected int getRecordsToScan() {
        if (this.historyTable == null) {
            return 0;
        }
        return this.getLastHistoryId() - this.getLastScannedId();
    }

    private int getLastScannedId() {
        if (this.currentId > this.lastId) {
            return this.currentId - 1;
        }
        return this.currentId;
    }

    public void raiseAlert(int id, Alert alert) {
        if (this.shutDown) {
            return;
        }
        if (this.currentId != id) {
            logger.error("Alert id != currentId! " + id + " " + this.currentId);
        }
        alert.setSource(Alert.Source.PASSIVE);
        this.extAlert.alertFound(alert, this.href);
        if (this.pscanOptions.getMaxAlertsPerRule() > 0) {
            PassiveScanner scanner;
            Integer count = this.alertCounts.get(alert.getPluginId());
            if (count == null) {
                count = 0;
            }
            this.alertCounts.put(alert.getPluginId(), count + 1);
            if (count > this.pscanOptions.getMaxAlertsPerRule() && (scanner = this.scannerList.getScanner(alert.getPluginId())) != null) {
                logger.info("Disabling passive scanner " + scanner.getName() + " as it has raised more than " + this.pscanOptions.getMaxAlertsPerRule() + " alerts.");
                scanner.setEnabled(false);
            }
        }
    }

    @Deprecated
    public void addTag(int id, String tag) {
        this.addTag(tag);
    }

    public void addTag(String tag) {
        if (this.shutDown) {
            return;
        }
        try {
            if (!this.href.getTags().contains(tag)) {
                this.href.addTag(tag);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 5001;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage msg) {
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage msg) {
        this.interrupt();
        return true;
    }

    @Override
    public void sessionChanged(Session session) {
        this.historyTable = Model.getSingleton().getDb().getTableHistory();
        this.href = null;
        this.lastId = this.currentId = this.historyTable.lastIndex();
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    public void shutdown() {
        this.shutDown = true;
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    public static void addApplicableHistoryType(int type) {
        optedInHistoryTypes.add(type);
    }

    public static void removeApplicableHistoryType(int type) {
        optedInHistoryTypes.remove(type);
    }

    public static Set<Integer> getOptedInHistoryTypes() {
        return Collections.unmodifiableSet(optedInHistoryTypes);
    }

    public static Set<Integer> getApplicableHistoryTypes() {
        HashSet<Integer> allApplicableTypes = new HashSet<Integer>();
        allApplicableTypes.addAll(PluginPassiveScanner.getDefaultHistoryTypes());
        if (!optedInHistoryTypes.isEmpty()) {
            allApplicableTypes.addAll(optedInHistoryTypes);
        }
        return allApplicableTypes;
    }

    public String getCurrentRuleName() {
        return this.currentRuleName;
    }

    public String getCurrentUrl() {
        return this.currentUrl;
    }

    public long getCurrentRuleStartTime() {
        return this.currentRuleStartTime;
    }
}

