/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import ch.csnc.extension.util.OptionsParamExperimentalSliSupport;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.parosproxy.paros.extension.option.OptionsParamCertificate;
import org.parosproxy.paros.extension.option.OptionsParamView;
import org.parosproxy.paros.network.ConnectionParam;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfParam;
import org.zaproxy.zap.extension.api.OptionsParamApi;
import org.zaproxy.zap.extension.autoupdate.OptionsParamCheckForUpdates;
import org.zaproxy.zap.extension.ext.ExtensionParam;
import org.zaproxy.zap.extension.globalexcludeurl.GlobalExcludeURLParam;

public class OptionsParam
extends AbstractParam {
    private static final Logger logger = LogManager.getLogger(OptionsParam.class);
    private static final String USER_DIR = "userDir";
    private ProxyParam proxyParam = new ProxyParam();
    private ConnectionParam connectionParam = new ConnectionParam();
    private OptionsParamView viewParam = new OptionsParamView();
    private OptionsParamCertificate certificateParam = new OptionsParamCertificate();
    private OptionsParamCheckForUpdates checkForUpdatesParam = new OptionsParamCheckForUpdates();
    private OptionsParamApi apiParam = new OptionsParamApi();
    private GlobalExcludeURLParam globalExcludeURLParam = new GlobalExcludeURLParam();
    private OptionsParamExperimentalSliSupport experimentalFeaturesParam = new OptionsParamExperimentalSliSupport();
    private DatabaseParam databaseParam = new DatabaseParam();
    private ExtensionParam extensionParam = new ExtensionParam();
    private Vector<AbstractParam> paramSetList = new Vector();
    private Map<Class<? extends AbstractParam>, AbstractParam> abstractParamsMap = new HashMap<Class<? extends AbstractParam>, AbstractParam>();
    private boolean gui = true;
    private File userDirectory = SystemUtils.getUserHome();

    public ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    public ProxyParam getProxyParam() {
        return this.proxyParam;
    }

    public void setProxyParam(ProxyParam proxyParam) {
        this.proxyParam = proxyParam;
    }

    public void setConnectionParam(ConnectionParam connectionParam) {
        this.connectionParam = connectionParam;
    }

    public void setViewParam(OptionsParamView viewParam) {
        this.viewParam = viewParam;
    }

    public OptionsParamView getViewParam() {
        return this.viewParam;
    }

    public OptionsParamCheckForUpdates getCheckForUpdatesParam() {
        return this.checkForUpdatesParam;
    }

    public void setCertificateParam(OptionsParamCertificate certificateParam) {
        this.certificateParam = certificateParam;
    }

    public OptionsParamCertificate getCertificateParam() {
        return this.certificateParam;
    }

    public void addParamSet(AbstractParam paramSet) {
        this.paramSetList.add(paramSet);
        this.abstractParamsMap.put(paramSet.getClass(), paramSet);
        paramSet.load(this.getConfig());
    }

    public void removeParamSet(AbstractParam paramSet) {
        this.paramSetList.remove(paramSet);
        this.abstractParamsMap.remove(paramSet.getClass());
    }

    public <T extends AbstractParam> T getParamSet(Class<T> clazz) {
        AbstractParam abstractParam;
        if (clazz != null && (abstractParam = this.abstractParamsMap.get(clazz)) != null) {
            return (T)((AbstractParam)clazz.cast(abstractParam));
        }
        return null;
    }

    @Override
    protected void parse() {
        this.getConnectionParam().load(this.getConfig());
        this.getProxyParam().load(this.getConfig());
        this.getCertificateParam().load(this.getConfig());
        this.getViewParam().load(this.getConfig());
        this.getCheckForUpdatesParam().load(this.getConfig());
        this.getApiParam().load(this.getConfig());
        this.getGlobalExcludeURLParam().load(this.getConfig());
        this.getExperimentalFeaturesParam().load(this.getConfig());
        this.getDatabaseParam().load(this.getConfig());
        this.getExtensionParam().load(this.getConfig());
        String userDir = null;
        try {
            userDir = this.getConfig().getString(USER_DIR);
            if (userDir != null) {
                this.userDirectory = new File(userDir);
            }
        }
        catch (Exception e) {
            try {
                File file = (File)this.getConfig().getProperty(USER_DIR);
                if (file != null && file.isDirectory()) {
                    this.userDirectory = file;
                }
            }
            catch (Exception e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
        }
    }

    public void reloadConfigParamSets() {
        for (int i = 0; i < this.paramSetList.size(); ++i) {
            this.paramSetList.get(i).load(this.getConfig());
        }
    }

    public void resetAll() {
        for (int i = 0; i < this.paramSetList.size(); ++i) {
            this.paramSetList.get(i).reset();
        }
    }

    public boolean isGUI() {
        return this.gui;
    }

    public void setGUI(boolean gui) {
        this.gui = gui;
    }

    public File getUserDirectory() {
        return this.userDirectory;
    }

    public void setUserDirectory(File currentDirectory) {
        this.userDirectory = currentDirectory;
        this.getConfig().setProperty(USER_DIR, (Object)currentDirectory.getAbsolutePath());
        try {
            this.getConfig().save();
        }
        catch (ConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public AntiCsrfParam getAntiCsrfParam() {
        return this.getParamSet(AntiCsrfParam.class);
    }

    public GlobalExcludeURLParam getGlobalExcludeURLParam() {
        return this.globalExcludeURLParam;
    }

    public OptionsParamApi getApiParam() {
        return this.apiParam;
    }

    public OptionsParamExperimentalSliSupport getExperimentalFeaturesParam() {
        return this.experimentalFeaturesParam;
    }

    public DatabaseParam getDatabaseParam() {
        return this.databaseParam;
    }

    public ExtensionParam getExtensionParam() {
        return this.extensionParam;
    }
}

