"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Large = exports.Uppercase = exports.Muted = exports.Small = exports.Bold = exports.Text = exports.textStyle = exports.filterTextProps = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _util = require("../util");

var _Identity = require("../Identity");

/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var filterTextProps = function filterTextProps(props) {
  return (0, _util.filterProps)(props, ['block', 'bold', 'center', 'color', 'fontSize', 'light', 'muted', 'noWrap', 'textTransform', 'truncate']);
};

exports.filterTextProps = filterTextProps;

var textStyle = function textStyle(theme, _ref) {
  var _ref$block = _ref.block,
      block = _ref$block === void 0 ? false : _ref$block,
      _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? false : _ref$bold,
      _ref$center = _ref.center,
      center = _ref$center === void 0 ? false : _ref$center,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? theme.general.color : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '16px' : _ref$fontSize,
      _ref$light = _ref.light,
      light = _ref$light === void 0 ? false : _ref$light,
      _ref$muted = _ref.muted,
      muted = _ref$muted === void 0 ? false : _ref$muted,
      _ref$noWrap = _ref.noWrap,
      noWrap = _ref$noWrap === void 0 ? false : _ref$noWrap,
      _ref$textTransform = _ref.textTransform,
      textTransform = _ref$textTransform === void 0 ? 'none' : _ref$textTransform,
      _ref$truncate = _ref.truncate,
      truncate = _ref$truncate === void 0 ? false : _ref$truncate;
  return {
    color: muted ? _Identity.COLOR.GRAY : color,
    display: block ? 'block' : 'inline',
    fontSize: fontSize,
    fontWeight: bold ? 600 : light ? 200 : 300,
    overflow: truncate ? 'hidden' : undefined,
    textAlign: center ? 'center' : 'left',
    textOverflow: truncate ? 'ellipsis' : undefined,
    textTransform: textTransform,
    whiteSpace: noWrap ? 'nowrap' : undefined
  };
};

exports.textStyle = textStyle;

var Text = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)("span", (0, _extends2["default"])({
    ref: ref,
    css: function css(theme) {
      return textStyle(theme, props);
    }
  }, filterTextProps(props)));
});

exports.Text = Text;

var Bold = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Text, (0, _extends2["default"])({
    ref: ref,
    bold: true
  }, props));
});

exports.Bold = Bold;

var Small = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Text, (0, _extends2["default"])({
    ref: ref,
    fontSize: '12px'
  }, props));
});

exports.Small = Small;

var Muted = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Text, (0, _extends2["default"])({
    ref: ref,
    muted: true
  }, props));
});

exports.Muted = Muted;

var Uppercase = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Text, (0, _extends2["default"])({
    ref: ref,
    textTransform: 'uppercase'
  }, props));
});

exports.Uppercase = Uppercase;

var Large = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Text, (0, _extends2["default"])({
    ref: ref,
    fontSize: '48px',
    light: true
  }, props));
});

exports.Large = Large;
//# sourceMappingURL=Text.js.map