"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Modal = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _color = _interopRequireDefault(require("color"));

var _Icon = require("../Icon");

var _Identity = require("../Identity");

var _mediaQueries = require("../mediaQueries");

var _util = require("../util");

var _Overlay = require("./Overlay");

var _excluded = ["actions", "children", "bodyStyle", "fullscreen", "onClose", "onBackgroundClick"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var modalBodyStyle = function modalBodyStyle(theme, _ref) {
  var _ref$fullscreen = _ref.fullscreen,
      fullscreen = _ref$fullscreen === void 0 ? false : _ref$fullscreen;
  return (0, _defineProperty2["default"])({
    alignItems: 'center',
    backgroundColor: _Identity.COLOR.tint(theme.general.backgroundColor, 0.16),
    borderRadius: fullscreen ? 0 : '8px',
    bottom: fullscreen ? 0 : undefined,
    boxShadow: fullscreen ? 'none' : '0 16px 64px 0 rgba(0, 0, 0, 0.16)',
    display: 'flex',
    flexDirection: 'column',
    justifyContent: fullscreen ? 'center' : 'space-between',
    left: fullscreen ? 0 : undefined,
    margin: 'auto',
    position: fullscreen ? 'fixed' : 'relative',
    right: fullscreen ? 0 : undefined,
    top: fullscreen ? 0 : undefined,
    transform: 'translate3d(0, 0, 0)',
    zIndex: 9999
  }, _mediaQueries.media[_mediaQueries.QueryKeys.TABLET_DOWN], {
    width: fullscreen ? 'initial' : '100%'
  });
};

var filterModalBodyProps = function filterModalBodyProps(props) {
  return (0, _util.filterProps)(props, ['fullscreen']);
};

var ModalBody = function ModalBody(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: function css(theme) {
      return modalBodyStyle(theme, props);
    }
  }, filterModalBodyProps(props)));
};

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "y8zv8r",
  styles: "align-items:center;cursor:pointer;display:flex;justify-content:center;position:absolute;right:16px;top:16px"
} : {
  name: "sobyuy-ModalClose",
  styles: "align-items:center;cursor:pointer;display:flex;justify-content:center;position:absolute;right:16px;top:16px;label:ModalClose;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var ModalClose = function ModalClose(props) {
  return (0, _react.jsx)(_Icon.CloseIcon, (0, _extends2["default"])({
    width: 16,
    height: 16,
    css: _ref3
  }, props));
};

var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1gkutfn",
  styles: "max-width:100%;overflow-y:auto;padding:40px"
} : {
  name: "26qwdj-ModalContent",
  styles: "max-width:100%;overflow-y:auto;padding:40px;label:ModalContent;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var ModalContent = function ModalContent(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: _ref4
  }, props));
};

var modalBackgroundStyle = function modalBackgroundStyle(props) {
  return _objectSpread(_objectSpread({}, (0, _Overlay.overlayBackgroundStyle)(props)), {}, {
    backgroundColor: 'rgba(50, 54, 57, 0.4)'
  });
};

var ModalBackground = function ModalBackground(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: modalBackgroundStyle(props)
  }, props));
};

var modalActionsWrapperStyles = function modalActionsWrapperStyles() {
  return {
    borderTop: "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_72),
    bottom: 0,
    display: 'flex',
    div: {
      '&:hover': {
        backgroundColor: _Identity.COLOR.opaque(_Identity.COLOR.GRAY_DARKEN_72, 0.04)
      },
      '&:active': {
        backgroundColor: _Identity.COLOR.opaque(_Identity.COLOR.GRAY_DARKEN_72, 0.08)
      },
      borderRight: "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_72)
    },
    'div:first-child': {
      borderBottomLeftRadius: 8
    },
    'div:last-child': {
      borderBottomRightRadius: 8,
      borderRight: 0
    },
    position: 'absolute',
    width: '100%'
  };
};

var modalActionStyles = function modalActionStyles(_ref5) {
  var bold = _ref5.bold;
  return {
    '&:hover': {
      color: (0, _color["default"])(_Identity.COLOR.BLUE).mix((0, _color["default"])(_Identity.COLOR.BLACK), 0.16).toString()
    },
    color: _Identity.COLOR.BLUE,
    cursor: 'pointer',
    display: 'flex',
    flex: 1,
    fontWeight: bold ? 'bold' : 'normal',
    justifyContent: 'center',
    padding: '8px 0'
  };
};

var ModalActions = function ModalActions(_ref6) {
  var actions = _ref6.actions;
  return (0, _react.jsx)("div", {
    css: modalActionsWrapperStyles()
  }, actions.map(function (action) {
    return (0, _react.jsx)("div", {
      key: action.title,
      onClick: action.onClick,
      css: modalActionStyles({
        bold: action.bold
      }),
      "data-uie-name": action.dataUieName
    }, action.title);
  }));
};

var Modal = function Modal(_ref7) {
  var _ref7$actions = _ref7.actions,
      actions = _ref7$actions === void 0 ? [] : _ref7$actions,
      children = _ref7.children,
      bodyStyle = _ref7.bodyStyle,
      fullscreen = _ref7.fullscreen,
      onClose = _ref7.onClose,
      onBackgroundClick = _ref7.onBackgroundClick,
      props = (0, _objectWithoutProperties2["default"])(_ref7, _excluded);
  return (0, _react.jsx)(_Overlay.OverlayWrapper, (0, _extends2["default"])({}, props, {
    "data-uie-name": "modal"
  }), (0, _react.jsx)(ModalBody, {
    fullscreen: fullscreen,
    style: bodyStyle
  }, (0, _react.jsx)(ModalContent, null, children), onClose !== _util.noop && (0, _react.jsx)(ModalClose, {
    onClick: onClose,
    "data-uie-name": "do-close"
  }), actions.length > 0 && (0, _react.jsx)(ModalActions, {
    actions: actions,
    "data-uie-name": "modal-actions"
  })), !fullscreen && (0, _react.jsx)(ModalBackground, {
    onClick: onBackgroundClick === _util.noop ? onClose : onBackgroundClick,
    "data-uie-name": "modal-background"
  }));
};

exports.Modal = Modal;
Modal.defaultProps = {
  actions: [],
  fullscreen: false,
  onBackgroundClick: _util.noop,
  onClose: _util.noop
};
//# sourceMappingURL=Modal.js.map