"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Loading = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _taggedTemplateLiteral2 = _interopRequireDefault(require("@babel/runtime/helpers/taggedTemplateLiteral"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _Identity = require("../Identity");

var _motions = require("../Identity/motions");

var _templateObject;

var _excluded = ["progress", "size", "color"];

var Loading = function Loading(_ref) {
  var _ref$progress = _ref.progress,
      progress = _ref$progress === void 0 ? undefined : _ref$progress,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 43 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? '#218fd1' : _ref$color,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  var pathLength = 125.68;
  var rotationOffset = -0.75;
  var rotationDelay = _motions.DURATION.EXTRA_LONG * rotationOffset;
  var fillAnimation = (0, _react.keyframes)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2["default"])(["\n    0% {\n      stroke-dashoffset: ", ";\n    }\n    100% {\n      stroke-dashoffset: 0;\n    }\n  "])), pathLength + pathLength);
  return (0, _react.jsx)("svg", (0, _extends2["default"])({
    width: size,
    height: size,
    viewBox: "0 0 43 43",
    strokeWidth: "3",
    fill: "none"
  }, props), (0, _react.jsx)("circle", {
    cx: "21.5",
    cy: "21.5",
    r: "20",
    stroke: _Identity.COLOR.opaque(color, 0.08)
  }), (0, _react.jsx)("circle", {
    css: !progress && {
      animation: "".concat(fillAnimation, " ").concat(_motions.DURATION.EXTRA_LONG, "ms ease-in-out infinite,\n              ").concat(_motions.ANIMATION.rotate, " ").concat(_motions.DURATION.EXTRA_LONG, "ms linear ").concat(rotationDelay, "ms infinite"),
      strokeDasharray: pathLength,
      transformOrigin: '50% 50%'
    },
    cx: "21.5",
    cy: "21.5",
    r: "20",
    stroke: color,
    strokeLinecap: "round",
    strokeDasharray: pathLength,
    strokeDashoffset: progress && "".concat(pathLength - pathLength * progress)
  }));
};

exports.Loading = Loading;
Loading.defaultProps = {
  progress: undefined,
  size: 43
};
//# sourceMappingURL=Loading.js.map