"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuItem = exports.MenuModal = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react2 = _interopRequireDefault(require("react"));

var _Identity = require("../Identity/");

var _motions = require("../Identity/motions");

var _mediaQueries = require("../mediaQueries");

var _Overlay = require("../Modal/Overlay");

var _util = require("../util");

var _excluded = ["children", "onBackgroundClick"],
    _excluded2 = ["children"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var menuModalWrapperStyle = function menuModalWrapperStyle(props) {
  return _objectSpread(_objectSpread({}, (0, _Overlay.overlayBackgroundStyle)(props)), {}, {
    alignItems: 'flex-end',
    alignSelf: 'flex-end',
    display: 'flex',
    overflowY: 'hidden',
    padding: 0
  });
};

var MenuModalWrapper = function MenuModalWrapper(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: menuModalWrapperStyle
  }, props));
};

var MenuModalBody = function MenuModalBody(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: function css(theme) {
      return (0, _defineProperty2["default"])({
        animation: "".concat(_motions.ANIMATION.bottomUpMovement, " ").concat(_motions.DURATION.DEFAULT, "ms ").concat(_motions.EASE.EXPONENTIAL),
        backgroundColor: _Identity.COLOR.tint(theme.general.backgroundColor, 0.16),
        boxShadow: '0 16px 64px 0 rgba(0, 0, 0, 0.16)',
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'space-between',
        marginLeft: 'auto',
        marginRight: 'auto',
        padding: '8px 16px',
        position: 'relative',
        width: '767px',
        zIndex: 9999
      }, _mediaQueries.media[_mediaQueries.QueryKeys.TABLET_DOWN], {
        width: '100%'
      });
    }
  }, props));
};

var MenuModalContent = function MenuModalContent(props) {
  return (0, _react.jsx)("ul", (0, _extends2["default"])({
    css: /*#__PURE__*/(0, _react.css)({
      li: {
        borderBottom: "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_72)
      },
      'li:last-child': {
        borderBottom: 0
      },
      margin: 0,
      maxWidth: '100%',
      minWidth: '100%',
      padding: 0
    }, process.env.NODE_ENV === "production" ? "" : ";label:MenuModalContent;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  }, props));
};

var modalBackgroundStyle = function modalBackgroundStyle(props) {
  return _objectSpread(_objectSpread({}, (0, _Overlay.overlayBackgroundStyle)(props)), {}, {
    background: 'rgba(50, 54, 57, 0.4)'
  });
};

var MenuModalBackground = function MenuModalBackground(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: modalBackgroundStyle
  }, props));
};

var MenuModal = function MenuModal(_ref2) {
  var _ref2$children = _ref2.children,
      children = _ref2$children === void 0 ? null : _ref2$children,
      _ref2$onBackgroundCli = _ref2.onBackgroundClick,
      onBackgroundClick = _ref2$onBackgroundCli === void 0 ? _util.noop : _ref2$onBackgroundCli,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded);
  return (0, _react.jsx)(MenuModalWrapper, props, (0, _react.jsx)(MenuModalBody, null, (0, _react.jsx)(MenuModalContent, null, children)), (0, _react.jsx)(MenuModalBackground, {
    onClick: onBackgroundClick,
    "data-uie-name": "menu-background"
  }));
};

exports.MenuModal = MenuModal;

var MenuItem = function MenuItem(_ref3) {
  var _ref3$children = _ref3.children,
      children = _ref3$children === void 0 ? null : _ref3$children,
      props = (0, _objectWithoutProperties2["default"])(_ref3, _excluded2);
  return (0, _react.jsx)("li", (0, _extends2["default"])({
    css: function css(theme) {
      return {
        alignItems: 'center',
        color: theme.general.color,
        cursor: 'pointer',
        display: 'flex',
        height: '56px',
        listStyleType: 'none',
        maxWidth: '100%'
      };
    }
  }, props), children);
};

exports.MenuItem = MenuItem;
//# sourceMappingURL=MenuModal.js.map