"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuSubLink = exports.menuSubLinkStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _color = _interopRequireDefault(require("color"));

var _Identity = require("../../Identity");

var _motions = require("../../Identity/motions");

var _mediaQueries = require("../../mediaQueries");

var _Text = require("../../Text");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var menuSubLinkStyle = function menuSubLinkStyle(theme, props) {
  var _objectSpread2;

  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, props)), {}, (_objectSpread2 = {
    '&:hover': {
      color: (0, _color["default"])(theme.general.color).mix((0, _color["default"])(_Identity.COLOR.BLACK), 0.16).toString()
    },
    color: theme.general.color,
    cursor: 'pointer',
    fontWeight: 600,
    textDecoration: 'none',
    transition: _motions.defaultTransition
  }, (0, _defineProperty2["default"])(_objectSpread2, _mediaQueries.media[_mediaQueries.QueryKeys.DESKTOP], {
    '&:first-of-type': {
      marginLeft: 0
    },
    '&:last-child': {
      marginRight: 0
    },
    fontSize: '11px',
    margin: '0 26px 0 10px',
    textTransform: 'uppercase'
  }), (0, _defineProperty2["default"])(_objectSpread2, _mediaQueries.media[_mediaQueries.QueryKeys.TABLET_DOWN], {
    border: 'none',
    fontSize: '32px !important',
    fontWeight: '300 !important',
    maxWidth: '480px',
    padding: '8px 24px',
    textTransform: 'none !important'
  }), _objectSpread2));
};

exports.menuSubLinkStyle = menuSubLinkStyle;

var MenuSubLink = function MenuSubLink(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: function css(theme) {
      return menuSubLinkStyle(theme, props);
    }
  }, props));
};

exports.MenuSubLink = MenuSubLink;
//# sourceMappingURL=MenuSubLink.js.map