"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Column = exports.Columns = exports.filterColumnsProps = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@emotion/react");

var _mediaQueries = require("../mediaQueries");

var _util = require("../util");

var _sizes = require("./sizes");

/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var filterColumnsProps = function filterColumnsProps(props) {
  return (0, _util.filterProps)(props, ['query']);
};

exports.filterColumnsProps = filterColumnsProps;

var columnsStyle = function columnsStyle(_ref) {
  var _ref$query = _ref.query,
      query = _ref$query === void 0 ? _mediaQueries.QueryKeys.MOBILE : _ref$query;
  return (0, _defineProperty2["default"])({
    display: 'flex',
    marginLeft: "-".concat(_sizes.GUTTER, "px")
  }, _mediaQueries.media[query], {
    flexDirection: 'column'
  });
};

var Columns = function Columns(props) {
  return (0, _react2.jsx)("div", (0, _extends2["default"])({
    css: columnsStyle(props)
  }, filterColumnsProps(props)));
};

exports.Columns = Columns;

var columnStyle = function columnStyle(props) {
  return {
    display: 'block',
    flexBasis: '0',
    flexGrow: 1,
    flexShrink: 1,
    marginLeft: "".concat(_sizes.GUTTER, "px")
  };
};

var Column = function Column(props) {
  return (0, _react2.jsx)("div", (0, _extends2["default"])({
    css: columnStyle(props)
  }, props));
};

exports.Column = Column;
//# sourceMappingURL=Column.js.map