"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AvatarGrid = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = require("@emotion/react");

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react2 = _interopRequireDefault(require("react"));

var _Misc = require("../Misc/");

var _util = require("../util");

var _Avatar = require("./Avatar");

var _colors = require("./colors");

var _excluded = ["borderWidth", "size", "items", "fetchImages"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var avatarGridStyle = function avatarGridStyle(_ref) {
  var borderWidth = _ref.borderWidth,
      size = _ref.size,
      _ref$backgroundColor = _ref.backgroundColor,
      backgroundColor = _ref$backgroundColor === void 0 ? _colors.COLOR.GRAY_DARKEN_48 : _ref$backgroundColor,
      _ref$borderColor = _ref.borderColor,
      borderColor = _ref$borderColor === void 0 ? _colors.COLOR.GRAY_DARKEN_48 : _ref$borderColor;
  return {
    alignItems: 'start',
    backgroundColor: backgroundColor,
    border: "".concat(borderWidth, "px solid ").concat(borderColor),
    borderRadius: '16%',
    display: 'grid',
    gridGap: borderWidth,
    gridTemplateColumns: 'repeat(2, 1fr)',
    gridTemplateRows: 'repeat(2, 1fr)',
    height: "".concat(size, "px"),
    justifyItems: 'center',
    minWidth: "".concat(size, "px"),
    overflow: 'hidden',
    width: "".concat(size, "px")
  };
};

var filteredAvatarGridProps = function filteredAvatarGridProps(props) {
  return (0, _util.filterProps)(props, ['backgroundColor', 'borderColor', 'items', 'size', 'borderWidth']);
};

var AvatarGrid = function AvatarGrid(_ref2) {
  var _ref2$borderWidth = _ref2.borderWidth,
      borderWidth = _ref2$borderWidth === void 0 ? 1 : _ref2$borderWidth,
      _ref2$size = _ref2.size,
      size = _ref2$size === void 0 ? _Avatar.DEFAULT_AVATAR_SIZE : _ref2$size,
      items = _ref2.items,
      fetchImages = _ref2.fetchImages,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded);

  var allProps = _objectSpread({
    borderWidth: borderWidth,
    items: items,
    size: size
  }, props);

  var slicedItems = items.slice(0, 4);
  var missing = 4 - slicedItems.length;

  for (var index = 0; index < missing; index++) {
    slicedItems.push(null);
  }

  return (0, _react.jsx)(_Misc.IsInViewport, (0, _extends2["default"])({
    checkViewportOnce: true,
    onEnterViewport: fetchImages,
    css: avatarGridStyle(allProps)
  }, filteredAvatarGridProps(allProps)), slicedItems.map(function (item) {
    return item ? (0, _react.jsx)(_Avatar.Avatar, {
      key: Math.random().toString(),
      backgroundColor: item.backgroundColor || _colors.COLOR.GRAY_DARKEN_80,
      url: item.url,
      color: item.color,
      forceInitials: item.forceInitials,
      isAvatarGridItem: true,
      name: item.name,
      size: size / 2 - borderWidth,
      style: {
        height: '100%',
        width: '100%'
      }
    }) : (0, _react.jsx)("div", {
      key: Math.random().toString(),
      css: /*#__PURE__*/(0, _react.css)({
        backgroundColor: _colors.COLOR.GRAY_DARKEN_80,
        height: '100%',
        width: '100%'
      }, process.env.NODE_ENV === "production" ? "" : ";label:AvatarGrid;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkF2YXRhckdyaWQudHN4Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQThGWSIsImZpbGUiOiJBdmF0YXJHcmlkLnRzeCIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBXaXJlXG4gKiBDb3B5cmlnaHQgKEMpIDIwMTkgV2lyZSBTd2lzcyBHbWJIXG4gKlxuICogVGhpcyBwcm9ncmFtIGlzIGZyZWUgc29mdHdhcmU6IHlvdSBjYW4gcmVkaXN0cmlidXRlIGl0IGFuZC9vciBtb2RpZnlcbiAqIGl0IHVuZGVyIHRoZSB0ZXJtcyBvZiB0aGUgR05VIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgYXMgcHVibGlzaGVkIGJ5XG4gKiB0aGUgRnJlZSBTb2Z0d2FyZSBGb3VuZGF0aW9uLCBlaXRoZXIgdmVyc2lvbiAzIG9mIHRoZSBMaWNlbnNlLCBvclxuICogKGF0IHlvdXIgb3B0aW9uKSBhbnkgbGF0ZXIgdmVyc2lvbi5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZGlzdHJpYnV0ZWQgaW4gdGhlIGhvcGUgdGhhdCBpdCB3aWxsIGJlIHVzZWZ1bCxcbiAqIGJ1dCBXSVRIT1VUIEFOWSBXQVJSQU5UWTsgd2l0aG91dCBldmVuIHRoZSBpbXBsaWVkIHdhcnJhbnR5IG9mXG4gKiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTUyBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UuIFNlZSB0aGVcbiAqIEdOVSBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGZvciBtb3JlIGRldGFpbHMuXG4gKlxuICogWW91IHNob3VsZCBoYXZlIHJlY2VpdmVkIGEgY29weSBvZiB0aGUgR05VIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiAqIGFsb25nIHdpdGggdGhpcyBwcm9ncmFtLiBJZiBub3QsIHNlZSBodHRwOi8vd3d3LmdudS5vcmcvbGljZW5zZXMvLlxuICpcbiAqL1xuXG4vKiogQGpzeCBqc3ggKi9cbmltcG9ydCB7Q1NTT2JqZWN0LCBqc3h9IGZyb20gJ0BlbW90aW9uL3JlYWN0JztcbmltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5cbmltcG9ydCB0eXBlIHtBdmF0YXJQcm9wc30gZnJvbSAnLi4vSWRlbnRpdHkvJztcbmltcG9ydCB7SXNJblZpZXdwb3J0fSBmcm9tICcuLi9NaXNjLyc7XG5pbXBvcnQge2ZpbHRlclByb3BzfSBmcm9tICcuLi91dGlsJztcbmltcG9ydCB7QXZhdGFyLCBERUZBVUxUX0FWQVRBUl9TSVpFfSBmcm9tICcuL0F2YXRhcic7XG5pbXBvcnQge0NPTE9SfSBmcm9tICcuL2NvbG9ycyc7XG5cbmludGVyZmFjZSBQcm9wczxUID0gSFRNTERpdkVsZW1lbnQ+IGV4dGVuZHMgUmVhY3QuSFRNTFByb3BzPFQ+IHtcbiAgYmFja2dyb3VuZENvbG9yPzogc3RyaW5nO1xuICBib3JkZXJDb2xvcj86IHN0cmluZztcbiAgYm9yZGVyV2lkdGg/OiBudW1iZXI7XG4gIGZldGNoSW1hZ2VzPzogKCkgPT4gdm9pZDtcbiAgaXRlbXM6IE9taXQ8QXZhdGFyUHJvcHMsICdib3JkZXJDb2xvcicgfCAnc2l6ZScgfCAnYm9yZGVyQ29sb3InIHwgJ2lzQXZhdGFyR3JpZEl0ZW0nIHwgJ2ZldGNoSW1hZ2UnPltdO1xuICBzaXplPzogbnVtYmVyO1xufVxuXG5jb25zdCBhdmF0YXJHcmlkU3R5bGU6IDxUPihwcm9wczogUHJvcHM8VD4pID0+IENTU09iamVjdCA9ICh7XG4gIGJvcmRlcldpZHRoLFxuICBzaXplLFxuICBiYWNrZ3JvdW5kQ29sb3IgPSBDT0xPUi5HUkFZX0RBUktFTl80OCxcbiAgYm9yZGVyQ29sb3IgPSBDT0xPUi5HUkFZX0RBUktFTl80OCxcbn0pID0+IHtcbiAgcmV0dXJuIHtcbiAgICBhbGlnbkl0ZW1zOiAnc3RhcnQnLFxuICAgIGJhY2tncm91bmRDb2xvcjogYmFja2dyb3VuZENvbG9yLFxuICAgIGJvcmRlcjogYCR7Ym9yZGVyV2lkdGh9cHggc29saWQgJHtib3JkZXJDb2xvcn1gLFxuICAgIGJvcmRlclJhZGl1czogJzE2JScsXG4gICAgZGlzcGxheTogJ2dyaWQnLFxuICAgIGdyaWRHYXA6IGJvcmRlcldpZHRoLFxuICAgIGdyaWRUZW1wbGF0ZUNvbHVtbnM6ICdyZXBlYXQoMiwgMWZyKScsXG4gICAgZ3JpZFRlbXBsYXRlUm93czogJ3JlcGVhdCgyLCAxZnIpJyxcbiAgICBoZWlnaHQ6IGAke3NpemV9cHhgLFxuICAgIGp1c3RpZnlJdGVtczogJ2NlbnRlcicsXG4gICAgbWluV2lkdGg6IGAke3NpemV9cHhgLFxuICAgIG92ZXJmbG93OiAnaGlkZGVuJyxcbiAgICB3aWR0aDogYCR7c2l6ZX1weGAsXG4gIH07XG59O1xuXG5jb25zdCBmaWx0ZXJlZEF2YXRhckdyaWRQcm9wcyA9IChwcm9wczogUHJvcHMpID0+XG4gIGZpbHRlclByb3BzKHByb3BzLCBbJ2JhY2tncm91bmRDb2xvcicsICdib3JkZXJDb2xvcicsICdpdGVtcycsICdzaXplJywgJ2JvcmRlcldpZHRoJ10pO1xuXG5leHBvcnQgY29uc3QgQXZhdGFyR3JpZCA9ICh7Ym9yZGVyV2lkdGggPSAxLCBzaXplID0gREVGQVVMVF9BVkFUQVJfU0laRSwgaXRlbXMsIGZldGNoSW1hZ2VzLCAuLi5wcm9wc306IFByb3BzKSA9PiB7XG4gIGNvbnN0IGFsbFByb3BzID0ge2JvcmRlcldpZHRoLCBpdGVtcywgc2l6ZSwgLi4ucHJvcHN9O1xuICBjb25zdCBzbGljZWRJdGVtcyA9IGl0ZW1zLnNsaWNlKDAsIDQpO1xuICBjb25zdCBtaXNzaW5nID0gNCAtIHNsaWNlZEl0ZW1zLmxlbmd0aDtcbiAgZm9yIChsZXQgaW5kZXggPSAwOyBpbmRleCA8IG1pc3Npbmc7IGluZGV4KyspIHtcbiAgICBzbGljZWRJdGVtcy5wdXNoKG51bGwpO1xuICB9XG4gIHJldHVybiAoXG4gICAgPElzSW5WaWV3cG9ydFxuICAgICAgY2hlY2tWaWV3cG9ydE9uY2VcbiAgICAgIG9uRW50ZXJWaWV3cG9ydD17ZmV0Y2hJbWFnZXN9XG4gICAgICBjc3M9e2F2YXRhckdyaWRTdHlsZShhbGxQcm9wcyl9XG4gICAgICB7Li4uZmlsdGVyZWRBdmF0YXJHcmlkUHJvcHMoYWxsUHJvcHMpfVxuICAgID5cbiAgICAgIHtzbGljZWRJdGVtcy5tYXAoaXRlbSA9PlxuICAgICAgICBpdGVtID8gKFxuICAgICAgICAgIDxBdmF0YXJcbiAgICAgICAgICAgIGtleT17TWF0aC5yYW5kb20oKS50b1N0cmluZygpfVxuICAgICAgICAgICAgYmFja2dyb3VuZENvbG9yPXtpdGVtLmJhY2tncm91bmRDb2xvciB8fCBDT0xPUi5HUkFZX0RBUktFTl84MH1cbiAgICAgICAgICAgIHVybD17aXRlbS51cmx9XG4gICAgICAgICAgICBjb2xvcj17aXRlbS5jb2xvcn1cbiAgICAgICAgICAgIGZvcmNlSW5pdGlhbHM9e2l0ZW0uZm9yY2VJbml0aWFsc31cbiAgICAgICAgICAgIGlzQXZhdGFyR3JpZEl0ZW1cbiAgICAgICAgICAgIG5hbWU9e2l0ZW0ubmFtZX1cbiAgICAgICAgICAgIHNpemU9e3NpemUgLyAyIC0gYm9yZGVyV2lkdGh9XG4gICAgICAgICAgICBzdHlsZT17e2hlaWdodDogJzEwMCUnLCB3aWR0aDogJzEwMCUnfX1cbiAgICAgICAgICAvPlxuICAgICAgICApIDogKFxuICAgICAgICAgIDxkaXZcbiAgICAgICAgICAgIGtleT17TWF0aC5yYW5kb20oKS50b1N0cmluZygpfVxuICAgICAgICAgICAgY3NzPXt7XG4gICAgICAgICAgICAgIGJhY2tncm91bmRDb2xvcjogQ09MT1IuR1JBWV9EQVJLRU5fODAsXG4gICAgICAgICAgICAgIGhlaWdodDogJzEwMCUnLFxuICAgICAgICAgICAgICB3aWR0aDogJzEwMCUnLFxuICAgICAgICAgICAgfX1cbiAgICAgICAgICAvPlxuICAgICAgICApLFxuICAgICAgKX1cbiAgICA8L0lzSW5WaWV3cG9ydD5cbiAgKTtcbn07XG4iXX0= */")
    });
  }));
};

exports.AvatarGrid = AvatarGrid;
//# sourceMappingURL=AvatarGrid.js.map