"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BottomUpMovement = exports.TopDownMovement = exports.RightLeftMovement = exports.LeftRightMovement = exports.Slide = exports.XAxisMovement = exports.YAxisMovement = exports.Opacity = exports.Transition = exports.TransitionContainer = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _motions = require("./motions");

var _excluded = ["animationStyle", "timeout", "component", "children"],
    _excluded2 = ["startValue", "endValue", "timeout"],
    _excluded3 = ["startValue", "endValue", "timeout"],
    _excluded4 = ["startValue", "endValue", "timeout"],
    _excluded5 = ["startValue", "endValue", "timeout"];

/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
var _require = require('react-transition-group'),
    CSSTransition = _require.CSSTransition,
    TransitionGroup = _require.TransitionGroup;

var TransitionContainer = function TransitionContainer(props) {
  return /*#__PURE__*/_react2["default"].createElement(TransitionGroup, props);
};

exports.TransitionContainer = TransitionContainer;

var Transition = function Transition(_ref) {
  var animationStyle = _ref.animationStyle,
      timeout = _ref.timeout,
      _ref$component = _ref.component,
      component = _ref$component === void 0 ? 'div' : _ref$component,
      children = _ref.children,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return /*#__PURE__*/_react2["default"].createElement(_react.ClassNames, null, function (_ref2) {
    var css = _ref2.css;
    return /*#__PURE__*/_react2["default"].createElement(CSSTransition, (0, _extends2["default"])({
      timeout: timeout,
      classNames: css(animationStyle)
    }, props), component ? /*#__PURE__*/_react2["default"].createElement(component, {}, children) : children);
  });
};

exports.Transition = Transition;

var Opacity = function Opacity(_ref3) {
  var _ref3$startValue = _ref3.startValue,
      startValue = _ref3$startValue === void 0 ? 0 : _ref3$startValue,
      _ref3$endValue = _ref3.endValue,
      endValue = _ref3$endValue === void 0 ? 1 : _ref3$endValue,
      _ref3$timeout = _ref3.timeout,
      timeout = _ref3$timeout === void 0 ? _motions.DURATION.DEFAULT : _ref3$timeout,
      props = (0, _objectWithoutProperties2["default"])(_ref3, _excluded2);
  return /*#__PURE__*/_react2["default"].createElement(Transition, (0, _extends2["default"])({
    animationStyle: {
      '&-enter': {
        opacity: startValue
      },
      '&-enter-active': {
        opacity: endValue,
        transition: "all ".concat(timeout, "ms ").concat(_motions.EASE.QUART)
      },
      '&-exit': {
        opacity: endValue
      },
      '&-exit-active': {
        opacity: startValue,
        pointerEvents: 'none',
        transition: "all ".concat(timeout, "ms ").concat(_motions.EASE.QUART)
      },
      '&-exit-done': {
        opacity: startValue
      }
    },
    timeout: timeout
  }, props));
};

exports.Opacity = Opacity;

var YAxisMovement = function YAxisMovement(_ref4) {
  var _ref4$startValue = _ref4.startValue,
      startValue = _ref4$startValue === void 0 ? '-100%' : _ref4$startValue,
      _ref4$endValue = _ref4.endValue,
      endValue = _ref4$endValue === void 0 ? '0%' : _ref4$endValue,
      _ref4$timeout = _ref4.timeout,
      timeout = _ref4$timeout === void 0 ? _motions.DURATION.DEFAULT : _ref4$timeout,
      props = (0, _objectWithoutProperties2["default"])(_ref4, _excluded3);
  return /*#__PURE__*/_react2["default"].createElement(Transition, (0, _extends2["default"])({
    animationStyle: {
      '&-enter': {
        transform: "translateY(".concat(startValue, ")")
      },
      '&-enter-active': {
        transform: "translateY(".concat(endValue, ")"),
        transition: "all ".concat(timeout, "ms ").concat(_motions.EASE.EXPONENTIAL)
      },
      '&-exit': {
        transform: "translateY(".concat(endValue, ")")
      },
      '&-exit-active': {
        pointerEvents: 'none',
        transform: "translateY(".concat(startValue, ")"),
        transition: "all ".concat(timeout, "ms ").concat(_motions.EASE.EXPONENTIAL)
      },
      '&-exit-done': {
        transform: "translateY(".concat(startValue, ")")
      }
    },
    timeout: timeout
  }, props));
};

exports.YAxisMovement = YAxisMovement;

var XAxisMovement = function XAxisMovement(_ref5) {
  var _ref5$startValue = _ref5.startValue,
      startValue = _ref5$startValue === void 0 ? '-100%' : _ref5$startValue,
      _ref5$endValue = _ref5.endValue,
      endValue = _ref5$endValue === void 0 ? '0%' : _ref5$endValue,
      _ref5$timeout = _ref5.timeout,
      timeout = _ref5$timeout === void 0 ? _motions.DURATION.DEFAULT : _ref5$timeout,
      props = (0, _objectWithoutProperties2["default"])(_ref5, _excluded4);
  return /*#__PURE__*/_react2["default"].createElement(Transition, (0, _extends2["default"])({
    animationStyle: {
      '&-enter': {
        transform: "translateX(".concat(startValue, ")")
      },
      '&-enter-active': {
        transform: "translateX(".concat(endValue, ")"),
        transition: "all ".concat(timeout, "ms ").concat(_motions.EASE.EXPONENTIAL)
      },
      '&-exit': {
        transform: "translateX(".concat(endValue, ")")
      },
      '&-exit-active': {
        pointerEvents: 'none',
        transform: "translateX(".concat(startValue, ")"),
        transition: "all ".concat(timeout, "ms ").concat(_motions.EASE.EXPONENTIAL)
      },
      '&-exit-done': {
        transform: "translateX(".concat(startValue, ")")
      }
    },
    timeout: timeout
  }, props));
};

exports.XAxisMovement = XAxisMovement;

var Slide = function Slide(_ref6) {
  var _ref6$startValue = _ref6.startValue,
      startValue = _ref6$startValue === void 0 ? '-100%' : _ref6$startValue,
      _ref6$endValue = _ref6.endValue,
      endValue = _ref6$endValue === void 0 ? '0%' : _ref6$endValue,
      _ref6$timeout = _ref6.timeout,
      timeout = _ref6$timeout === void 0 ? _motions.DURATION.DEFAULT : _ref6$timeout,
      props = (0, _objectWithoutProperties2["default"])(_ref6, _excluded5);
  return /*#__PURE__*/_react2["default"].createElement(Transition, (0, _extends2["default"])({
    animationStyle: {
      '&-enter': {
        marginTop: startValue
      },
      '&-enter-active': {
        marginTop: endValue,
        transition: "all ".concat(timeout, "ms ").concat(_motions.EASE.QUART)
      },
      '&-exit': {
        marginTop: endValue
      },
      '&-exit-active': {
        marginTop: startValue,
        pointerEvents: 'none',
        transition: "all ".concat(timeout, "ms ").concat(_motions.EASE.QUART)
      },
      '&-exit-done': {
        marginTop: startValue
      }
    },
    timeout: timeout
  }, props));
};

exports.Slide = Slide;

var LeftRightMovement = function LeftRightMovement(props) {
  return /*#__PURE__*/_react2["default"].createElement(XAxisMovement, (0, _extends2["default"])({
    startValue: "-100vh",
    endValue: "0vh"
  }, props));
};

exports.LeftRightMovement = LeftRightMovement;

var RightLeftMovement = function RightLeftMovement(props) {
  return /*#__PURE__*/_react2["default"].createElement(XAxisMovement, (0, _extends2["default"])({
    startValue: "100vh",
    endValue: "0vh"
  }, props));
};

exports.RightLeftMovement = RightLeftMovement;

var TopDownMovement = function TopDownMovement(props) {
  return /*#__PURE__*/_react2["default"].createElement(YAxisMovement, (0, _extends2["default"])({
    startValue: "-100%",
    endValue: "0%"
  }, props));
};

exports.TopDownMovement = TopDownMovement;

var BottomUpMovement = function BottomUpMovement(props) {
  return /*#__PURE__*/_react2["default"].createElement(YAxisMovement, (0, _extends2["default"])({
    startValue: "100%",
    endValue: "0%"
  }, props));
};

exports.BottomUpMovement = BottomUpMovement;
//# sourceMappingURL=Animation.js.map