// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f750.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32f750
// +build stm32,stm32f750

// STM32F750
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32F750"
	CPU          = "CM7"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Window watchdog
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD = 1

	// External interrupt/event controller
	IRQ_TAMP_STAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// FLASH
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	IRQ_DMA1_Stream0 = 11

	IRQ_DMA1_Stream1 = 12

	IRQ_DMA1_Stream2 = 13

	IRQ_DMA1_Stream3 = 14

	IRQ_DMA1_Stream4 = 15

	IRQ_DMA1_Stream5 = 16

	IRQ_DMA1_Stream6 = 17

	// Common ADC registers
	IRQ_ADC = 18

	// Controller area network
	IRQ_CAN1_TX = 19

	// Controller area network
	IRQ_CAN1_RX0 = 20

	// Controller area network
	IRQ_CAN1_RX1 = 21

	// Controller area network
	IRQ_CAN1_SCE = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Advanced-timers
	IRQ_TIM1_BRK_TIM9 = 24

	// Advanced-timers
	IRQ_TIM1_UP_TIM10 = 25

	// Advanced-timers
	IRQ_TIM1_TRG_COM_TIM11 = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// General purpose timers
	IRQ_TIM2 = 28

	// General purpose timers
	IRQ_TIM3 = 29

	IRQ_TIM4 = 30

	// Inter-integrated circuit
	IRQ_I2C1_EV = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface
	IRQ_SPI1 = 35

	// Serial peripheral interface
	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTC_ALARM = 41

	// USB on the go full speed
	IRQ_OTG_FS_WKUP = 42

	IRQ_TIM8_BRK_TIM12 = 43

	IRQ_TIM8_UP_TIM13 = 44

	IRQ_TIM8_TRG_COM_TIM14 = 45

	IRQ_TIM8_CC = 46

	IRQ_DMA1_Stream7 = 47

	// Flexible memory controller
	IRQ_FMC = 48

	// Secure digital input/output interface
	IRQ_SDMMC1 = 49

	// General purpose timers
	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Basic timers
	IRQ_TIM6_DAC = 54

	IRQ_TIM7 = 55

	// DMA controller
	IRQ_DMA2_Stream0 = 56

	// DMA controller
	IRQ_DMA2_Stream1 = 57

	// DMA controller
	IRQ_DMA2_Stream2 = 58

	// DMA controller
	IRQ_DMA2_Stream3 = 59

	// DMA controller
	IRQ_DMA2_Stream4 = 60

	// Ethernet: DMA controller operation
	IRQ_ETH = 61

	// Ethernet: DMA controller operation
	IRQ_ETH_WKUP = 62

	IRQ_CAN2_TX = 63

	IRQ_CAN2_RX0 = 64

	IRQ_CAN2_RX1 = 65

	IRQ_CAN2_SCE = 66

	// USB on the go full speed
	IRQ_OTG_FS = 67

	// DMA controller
	IRQ_DMA2_Stream5 = 68

	// DMA controller
	IRQ_DMA2_Stream6 = 69

	// DMA controller
	IRQ_DMA2_Stream7 = 70

	IRQ_USART6 = 71

	IRQ_I2C3_EV = 72

	IRQ_I2C3_ER = 73

	// USB on the go high speed
	IRQ_OTG_HS_EP1_OUT = 74

	// USB on the go high speed
	IRQ_OTG_HS_EP1_IN = 75

	// USB on the go high speed
	IRQ_OTG_HS_WKUP = 76

	// USB on the go high speed
	IRQ_OTG_HS = 77

	// Digital camera interface
	IRQ_DCMI = 78

	// Cryptographic processor
	IRQ_CRYP = 79

	// Random number generator
	IRQ_HASH_RNG = 80

	// Floting point unit
	IRQ_FPU = 81

	IRQ_UART7 = 82

	IRQ_UART8 = 83

	IRQ_SPI4 = 84

	IRQ_SPI5 = 85

	IRQ_SPI6 = 86

	// Serial audio interface
	IRQ_SAI1 = 87

	// LCD-TFT Controller
	IRQ_LTDC = 88

	// LCD-TFT Controller
	IRQ_LTDC_ER = 89

	// DMA2D controller
	IRQ_DMA2D = 90

	IRQ_SAI2 = 91

	// QuadSPI interface
	IRQ_QuadSPI = 92

	// Low power timer
	IRQ_LPTIMER1 = 93

	// HDMI-CEC controller
	IRQ_HDMI_CEC = 94

	IRQ_I2C4_EV = 95

	IRQ_I2C4_ER = 96

	// Receiver Interface
	IRQ_SPDIFRX = 97

	// Highest interrupt number on this device.
	IRQ_max = 97
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export TAMP_STAMP_IRQHandler
func interruptTAMP_STAMP() {
	callHandlers(IRQ_TAMP_STAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_Stream0_IRQHandler
func interruptDMA1_Stream0() {
	callHandlers(IRQ_DMA1_Stream0)
}

//export DMA1_Stream1_IRQHandler
func interruptDMA1_Stream1() {
	callHandlers(IRQ_DMA1_Stream1)
}

//export DMA1_Stream2_IRQHandler
func interruptDMA1_Stream2() {
	callHandlers(IRQ_DMA1_Stream2)
}

//export DMA1_Stream3_IRQHandler
func interruptDMA1_Stream3() {
	callHandlers(IRQ_DMA1_Stream3)
}

//export DMA1_Stream4_IRQHandler
func interruptDMA1_Stream4() {
	callHandlers(IRQ_DMA1_Stream4)
}

//export DMA1_Stream5_IRQHandler
func interruptDMA1_Stream5() {
	callHandlers(IRQ_DMA1_Stream5)
}

//export DMA1_Stream6_IRQHandler
func interruptDMA1_Stream6() {
	callHandlers(IRQ_DMA1_Stream6)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export CAN1_TX_IRQHandler
func interruptCAN1_TX() {
	callHandlers(IRQ_CAN1_TX)
}

//export CAN1_RX0_IRQHandler
func interruptCAN1_RX0() {
	callHandlers(IRQ_CAN1_RX0)
}

//export CAN1_RX1_IRQHandler
func interruptCAN1_RX1() {
	callHandlers(IRQ_CAN1_RX1)
}

//export CAN1_SCE_IRQHandler
func interruptCAN1_SCE() {
	callHandlers(IRQ_CAN1_SCE)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_TIM9_IRQHandler
func interruptTIM1_BRK_TIM9() {
	callHandlers(IRQ_TIM1_BRK_TIM9)
}

//export TIM1_UP_TIM10_IRQHandler
func interruptTIM1_UP_TIM10() {
	callHandlers(IRQ_TIM1_UP_TIM10)
}

//export TIM1_TRG_COM_TIM11_IRQHandler
func interruptTIM1_TRG_COM_TIM11() {
	callHandlers(IRQ_TIM1_TRG_COM_TIM11)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_ALARM_IRQHandler
func interruptRTC_ALARM() {
	callHandlers(IRQ_RTC_ALARM)
}

//export OTG_FS_WKUP_IRQHandler
func interruptOTG_FS_WKUP() {
	callHandlers(IRQ_OTG_FS_WKUP)
}

//export TIM8_BRK_TIM12_IRQHandler
func interruptTIM8_BRK_TIM12() {
	callHandlers(IRQ_TIM8_BRK_TIM12)
}

//export TIM8_UP_TIM13_IRQHandler
func interruptTIM8_UP_TIM13() {
	callHandlers(IRQ_TIM8_UP_TIM13)
}

//export TIM8_TRG_COM_TIM14_IRQHandler
func interruptTIM8_TRG_COM_TIM14() {
	callHandlers(IRQ_TIM8_TRG_COM_TIM14)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export DMA1_Stream7_IRQHandler
func interruptDMA1_Stream7() {
	callHandlers(IRQ_DMA1_Stream7)
}

//export FMC_IRQHandler
func interruptFMC() {
	callHandlers(IRQ_FMC)
}

//export SDMMC1_IRQHandler
func interruptSDMMC1() {
	callHandlers(IRQ_SDMMC1)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export TIM6_DAC_IRQHandler
func interruptTIM6_DAC() {
	callHandlers(IRQ_TIM6_DAC)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_Stream0_IRQHandler
func interruptDMA2_Stream0() {
	callHandlers(IRQ_DMA2_Stream0)
}

//export DMA2_Stream1_IRQHandler
func interruptDMA2_Stream1() {
	callHandlers(IRQ_DMA2_Stream1)
}

//export DMA2_Stream2_IRQHandler
func interruptDMA2_Stream2() {
	callHandlers(IRQ_DMA2_Stream2)
}

//export DMA2_Stream3_IRQHandler
func interruptDMA2_Stream3() {
	callHandlers(IRQ_DMA2_Stream3)
}

//export DMA2_Stream4_IRQHandler
func interruptDMA2_Stream4() {
	callHandlers(IRQ_DMA2_Stream4)
}

//export ETH_IRQHandler
func interruptETH() {
	callHandlers(IRQ_ETH)
}

//export ETH_WKUP_IRQHandler
func interruptETH_WKUP() {
	callHandlers(IRQ_ETH_WKUP)
}

//export CAN2_TX_IRQHandler
func interruptCAN2_TX() {
	callHandlers(IRQ_CAN2_TX)
}

//export CAN2_RX0_IRQHandler
func interruptCAN2_RX0() {
	callHandlers(IRQ_CAN2_RX0)
}

//export CAN2_RX1_IRQHandler
func interruptCAN2_RX1() {
	callHandlers(IRQ_CAN2_RX1)
}

//export CAN2_SCE_IRQHandler
func interruptCAN2_SCE() {
	callHandlers(IRQ_CAN2_SCE)
}

//export OTG_FS_IRQHandler
func interruptOTG_FS() {
	callHandlers(IRQ_OTG_FS)
}

//export DMA2_Stream5_IRQHandler
func interruptDMA2_Stream5() {
	callHandlers(IRQ_DMA2_Stream5)
}

//export DMA2_Stream6_IRQHandler
func interruptDMA2_Stream6() {
	callHandlers(IRQ_DMA2_Stream6)
}

//export DMA2_Stream7_IRQHandler
func interruptDMA2_Stream7() {
	callHandlers(IRQ_DMA2_Stream7)
}

//export USART6_IRQHandler
func interruptUSART6() {
	callHandlers(IRQ_USART6)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export OTG_HS_EP1_OUT_IRQHandler
func interruptOTG_HS_EP1_OUT() {
	callHandlers(IRQ_OTG_HS_EP1_OUT)
}

//export OTG_HS_EP1_IN_IRQHandler
func interruptOTG_HS_EP1_IN() {
	callHandlers(IRQ_OTG_HS_EP1_IN)
}

//export OTG_HS_WKUP_IRQHandler
func interruptOTG_HS_WKUP() {
	callHandlers(IRQ_OTG_HS_WKUP)
}

//export OTG_HS_IRQHandler
func interruptOTG_HS() {
	callHandlers(IRQ_OTG_HS)
}

//export DCMI_IRQHandler
func interruptDCMI() {
	callHandlers(IRQ_DCMI)
}

//export CRYP_IRQHandler
func interruptCRYP() {
	callHandlers(IRQ_CRYP)
}

//export HASH_RNG_IRQHandler
func interruptHASH_RNG() {
	callHandlers(IRQ_HASH_RNG)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export UART7_IRQHandler
func interruptUART7() {
	callHandlers(IRQ_UART7)
}

//export UART8_IRQHandler
func interruptUART8() {
	callHandlers(IRQ_UART8)
}

//export SPI4_IRQHandler
func interruptSPI4() {
	callHandlers(IRQ_SPI4)
}

//export SPI5_IRQHandler
func interruptSPI5() {
	callHandlers(IRQ_SPI5)
}

//export SPI6_IRQHandler
func interruptSPI6() {
	callHandlers(IRQ_SPI6)
}

//export SAI1_IRQHandler
func interruptSAI1() {
	callHandlers(IRQ_SAI1)
}

//export LTDC_IRQHandler
func interruptLTDC() {
	callHandlers(IRQ_LTDC)
}

//export LTDC_ER_IRQHandler
func interruptLTDC_ER() {
	callHandlers(IRQ_LTDC_ER)
}

//export DMA2D_IRQHandler
func interruptDMA2D() {
	callHandlers(IRQ_DMA2D)
}

//export SAI2_IRQHandler
func interruptSAI2() {
	callHandlers(IRQ_SAI2)
}

//export QuadSPI_IRQHandler
func interruptQuadSPI() {
	callHandlers(IRQ_QuadSPI)
}

//export LPTIMER1_IRQHandler
func interruptLPTIMER1() {
	callHandlers(IRQ_LPTIMER1)
}

//export HDMI_CEC_IRQHandler
func interruptHDMI_CEC() {
	callHandlers(IRQ_HDMI_CEC)
}

//export I2C4_EV_IRQHandler
func interruptI2C4_EV() {
	callHandlers(IRQ_I2C4_EV)
}

//export I2C4_ER_IRQHandler
func interruptI2C4_ER() {
	callHandlers(IRQ_I2C4_ER)
}

//export SPDIFRX_IRQHandler
func interruptSPDIFRX() {
	callHandlers(IRQ_SPDIFRX)
}

// Peripherals.
var (
	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))

	// Hash processor
	HASH = (*HASH_Type)(unsafe.Pointer(uintptr(0x50060400)))

	// Cryptographic processor
	CRYP = (*CRYP_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// Digital camera interface
	DCMI = (*DCMI_Type)(unsafe.Pointer(uintptr(0x50050000)))

	// Flexible memory controller
	FMC = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// Debug support
	DBGMCU = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Analog-to-digital converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Common ADC registers
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012300)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General purpose timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General purpose timers
	TIM9 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General-purpose-timers
	TIM10 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Ethernet: media access control (MAC)
	Ethernet_MAC = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Ethernet: MAC management counters
	Ethernet_MMC = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028100)))

	// Ethernet: Precision time protocol
	Ethernet_PTP = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028700)))

	// Ethernet: DMA controller operation
	Ethernet_DMA = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// Cryptographic processor
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Controller area network
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// FLASH
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))

	// LCD-TFT Controller
	LTDC = (*LTDC_Type)(unsafe.Pointer(uintptr(0x40016800)))

	// Serial audio interface
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// DMA2D controller
	DMA2D = (*DMA2D_Type)(unsafe.Pointer(uintptr(0x4002b000)))

	// QuadSPI interface
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))

	// HDMI-CEC controller
	CEC = (*CEC_Type)(unsafe.Pointer(uintptr(0x40006c00)))

	// Receiver Interface
	SPDIFRX = (*SPDIF_RX_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Secure digital input/output interface
	SDMMC1 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// USB on the go full speed
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// USB on the go full speed
	OTG_FS_HOST = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00)))

	// USB on the go high speed
	OTG_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// USB on the go high speed
	OTG_HS_HOST = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040400)))

	// USB on the go high speed
	OTG_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040800)))

	// USB on the go high speed
	OTG_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040e00)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Processor features
	PF = (*PF_Type)(unsafe.Pointer(uintptr(0xe000ed78)))

	// Access control
	AC = (*AC_Type)(unsafe.Pointer(uintptr(0xe000ef90)))

	// General purpose timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// General-purpose I/Os
	GPIOK = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022800)))

	// General-purpose I/Os
	GPIOJ = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022400)))

	// General-purpose I/Os
	GPIOI = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Serial peripheral interface
	SPI5 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Serial peripheral interface
	SPI6 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015400)))

	// Analog-to-digital converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012100)))

	// Analog-to-digital converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012200)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// General purpose timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General purpose timers
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// General-purpose-timers
	TIM11 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// General-purpose-timers
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// General-purpose-timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Controller area network
	CAN2 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006800)))

	// Serial audio interface
	SAI2 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015c00)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Inter-integrated circuit
	I2C4 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART8 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART7 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007800)))
)

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// RNG.CR: control register
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// RNG.SR: status register
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// RNG.DR: data register
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// Hash processor
type HASH_Type struct {
	CR       volatile.Register32 // 0x0
	DIN      volatile.Register32 // 0x4
	STR      volatile.Register32 // 0x8
	HR0      volatile.Register32 // 0xC
	HR1      volatile.Register32 // 0x10
	HR2      volatile.Register32 // 0x14
	HR3      volatile.Register32 // 0x18
	HR4      volatile.Register32 // 0x1C
	IMR      volatile.Register32 // 0x20
	SR       volatile.Register32 // 0x24
	_        [208]byte
	CSR0     volatile.Register32 // 0xF8
	CSR1     volatile.Register32 // 0xFC
	CSR2     volatile.Register32 // 0x100
	CSR3     volatile.Register32 // 0x104
	CSR4     volatile.Register32 // 0x108
	CSR5     volatile.Register32 // 0x10C
	CSR6     volatile.Register32 // 0x110
	CSR7     volatile.Register32 // 0x114
	CSR8     volatile.Register32 // 0x118
	CSR9     volatile.Register32 // 0x11C
	CSR10    volatile.Register32 // 0x120
	CSR11    volatile.Register32 // 0x124
	CSR12    volatile.Register32 // 0x128
	CSR13    volatile.Register32 // 0x12C
	CSR14    volatile.Register32 // 0x130
	CSR15    volatile.Register32 // 0x134
	CSR16    volatile.Register32 // 0x138
	CSR17    volatile.Register32 // 0x13C
	CSR18    volatile.Register32 // 0x140
	CSR19    volatile.Register32 // 0x144
	CSR20    volatile.Register32 // 0x148
	CSR21    volatile.Register32 // 0x14C
	CSR22    volatile.Register32 // 0x150
	CSR23    volatile.Register32 // 0x154
	CSR24    volatile.Register32 // 0x158
	CSR25    volatile.Register32 // 0x15C
	CSR26    volatile.Register32 // 0x160
	CSR27    volatile.Register32 // 0x164
	CSR28    volatile.Register32 // 0x168
	CSR29    volatile.Register32 // 0x16C
	CSR30    volatile.Register32 // 0x170
	CSR31    volatile.Register32 // 0x174
	CSR32    volatile.Register32 // 0x178
	CSR33    volatile.Register32 // 0x17C
	CSR34    volatile.Register32 // 0x180
	CSR35    volatile.Register32 // 0x184
	CSR36    volatile.Register32 // 0x188
	CSR37    volatile.Register32 // 0x18C
	CSR38    volatile.Register32 // 0x190
	CSR39    volatile.Register32 // 0x194
	CSR40    volatile.Register32 // 0x198
	CSR41    volatile.Register32 // 0x19C
	CSR42    volatile.Register32 // 0x1A0
	CSR43    volatile.Register32 // 0x1A4
	CSR44    volatile.Register32 // 0x1A8
	CSR45    volatile.Register32 // 0x1AC
	CSR46    volatile.Register32 // 0x1B0
	CSR47    volatile.Register32 // 0x1B4
	CSR48    volatile.Register32 // 0x1B8
	CSR49    volatile.Register32 // 0x1BC
	CSR50    volatile.Register32 // 0x1C0
	CSR51    volatile.Register32 // 0x1C4
	CSR52    volatile.Register32 // 0x1C8
	CSR53    volatile.Register32 // 0x1CC
	_        [320]byte
	HASH_HR0 volatile.Register32 // 0x310
	HASH_HR1 volatile.Register32 // 0x314
	HASH_HR2 volatile.Register32 // 0x318
	HASH_HR3 volatile.Register32 // 0x31C
	HASH_HR4 volatile.Register32 // 0x320
	HASH_HR5 volatile.Register32 // 0x324
	HASH_HR6 volatile.Register32 // 0x328
	HASH_HR7 volatile.Register32 // 0x32C
}

// HASH.CR: control register
func (o *HASH_Type) SetCR_INIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HASH_Type) GetCR_INIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *HASH_Type) SetCR_DMAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HASH_Type) GetCR_DMAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HASH_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30)|value<<4)
}
func (o *HASH_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30) >> 4
}
func (o *HASH_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *HASH_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *HASH_Type) SetCR_ALGO0(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HASH_Type) GetCR_ALGO0() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *HASH_Type) SetCR_NBW(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *HASH_Type) GetCR_NBW() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *HASH_Type) SetCR_DINNE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *HASH_Type) GetCR_DINNE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *HASH_Type) SetCR_MDMAT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *HASH_Type) GetCR_MDMAT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *HASH_Type) SetCR_LKEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *HASH_Type) GetCR_LKEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *HASH_Type) SetCR_ALGO1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *HASH_Type) GetCR_ALGO1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}

// HASH.DIN: data input register
func (o *HASH_Type) SetDIN(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, value)
}
func (o *HASH_Type) GetDIN() uint32 {
	return volatile.LoadUint32(&o.DIN.Reg)
}

// HASH.STR: start register
func (o *HASH_Type) SetSTR_DCAL(value uint32) {
	volatile.StoreUint32(&o.STR.Reg, volatile.LoadUint32(&o.STR.Reg)&^(0x100)|value<<8)
}
func (o *HASH_Type) GetSTR_DCAL() uint32 {
	return (volatile.LoadUint32(&o.STR.Reg) & 0x100) >> 8
}
func (o *HASH_Type) SetSTR_NBLW(value uint32) {
	volatile.StoreUint32(&o.STR.Reg, volatile.LoadUint32(&o.STR.Reg)&^(0x1f)|value)
}
func (o *HASH_Type) GetSTR_NBLW() uint32 {
	return volatile.LoadUint32(&o.STR.Reg) & 0x1f
}

// HASH.HR0: digest registers
func (o *HASH_Type) SetHR0(value uint32) {
	volatile.StoreUint32(&o.HR0.Reg, value)
}
func (o *HASH_Type) GetHR0() uint32 {
	return volatile.LoadUint32(&o.HR0.Reg)
}

// HASH.HR1: digest registers
func (o *HASH_Type) SetHR1(value uint32) {
	volatile.StoreUint32(&o.HR1.Reg, value)
}
func (o *HASH_Type) GetHR1() uint32 {
	return volatile.LoadUint32(&o.HR1.Reg)
}

// HASH.HR2: digest registers
func (o *HASH_Type) SetHR2(value uint32) {
	volatile.StoreUint32(&o.HR2.Reg, value)
}
func (o *HASH_Type) GetHR2() uint32 {
	return volatile.LoadUint32(&o.HR2.Reg)
}

// HASH.HR3: digest registers
func (o *HASH_Type) SetHR3(value uint32) {
	volatile.StoreUint32(&o.HR3.Reg, value)
}
func (o *HASH_Type) GetHR3() uint32 {
	return volatile.LoadUint32(&o.HR3.Reg)
}

// HASH.HR4: digest registers
func (o *HASH_Type) SetHR4(value uint32) {
	volatile.StoreUint32(&o.HR4.Reg, value)
}
func (o *HASH_Type) GetHR4() uint32 {
	return volatile.LoadUint32(&o.HR4.Reg)
}

// HASH.IMR: interrupt enable register
func (o *HASH_Type) SetIMR_DCIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HASH_Type) GetIMR_DCIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HASH_Type) SetIMR_DINIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HASH_Type) GetIMR_DINIE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// HASH.SR: status register
func (o *HASH_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HASH_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HASH_Type) SetSR_DMAS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HASH_Type) GetSR_DMAS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HASH_Type) SetSR_DCIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HASH_Type) GetSR_DCIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HASH_Type) SetSR_DINIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HASH_Type) GetSR_DINIS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// HASH.CSR0: context swap registers
func (o *HASH_Type) SetCSR0(value uint32) {
	volatile.StoreUint32(&o.CSR0.Reg, value)
}
func (o *HASH_Type) GetCSR0() uint32 {
	return volatile.LoadUint32(&o.CSR0.Reg)
}

// HASH.CSR1: context swap registers
func (o *HASH_Type) SetCSR1(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, value)
}
func (o *HASH_Type) GetCSR1() uint32 {
	return volatile.LoadUint32(&o.CSR1.Reg)
}

// HASH.CSR2: context swap registers
func (o *HASH_Type) SetCSR2(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, value)
}
func (o *HASH_Type) GetCSR2() uint32 {
	return volatile.LoadUint32(&o.CSR2.Reg)
}

// HASH.CSR3: context swap registers
func (o *HASH_Type) SetCSR3(value uint32) {
	volatile.StoreUint32(&o.CSR3.Reg, value)
}
func (o *HASH_Type) GetCSR3() uint32 {
	return volatile.LoadUint32(&o.CSR3.Reg)
}

// HASH.CSR4: context swap registers
func (o *HASH_Type) SetCSR4(value uint32) {
	volatile.StoreUint32(&o.CSR4.Reg, value)
}
func (o *HASH_Type) GetCSR4() uint32 {
	return volatile.LoadUint32(&o.CSR4.Reg)
}

// HASH.CSR5: context swap registers
func (o *HASH_Type) SetCSR5(value uint32) {
	volatile.StoreUint32(&o.CSR5.Reg, value)
}
func (o *HASH_Type) GetCSR5() uint32 {
	return volatile.LoadUint32(&o.CSR5.Reg)
}

// HASH.CSR6: context swap registers
func (o *HASH_Type) SetCSR6(value uint32) {
	volatile.StoreUint32(&o.CSR6.Reg, value)
}
func (o *HASH_Type) GetCSR6() uint32 {
	return volatile.LoadUint32(&o.CSR6.Reg)
}

// HASH.CSR7: context swap registers
func (o *HASH_Type) SetCSR7(value uint32) {
	volatile.StoreUint32(&o.CSR7.Reg, value)
}
func (o *HASH_Type) GetCSR7() uint32 {
	return volatile.LoadUint32(&o.CSR7.Reg)
}

// HASH.CSR8: context swap registers
func (o *HASH_Type) SetCSR8(value uint32) {
	volatile.StoreUint32(&o.CSR8.Reg, value)
}
func (o *HASH_Type) GetCSR8() uint32 {
	return volatile.LoadUint32(&o.CSR8.Reg)
}

// HASH.CSR9: context swap registers
func (o *HASH_Type) SetCSR9(value uint32) {
	volatile.StoreUint32(&o.CSR9.Reg, value)
}
func (o *HASH_Type) GetCSR9() uint32 {
	return volatile.LoadUint32(&o.CSR9.Reg)
}

// HASH.CSR10: context swap registers
func (o *HASH_Type) SetCSR10(value uint32) {
	volatile.StoreUint32(&o.CSR10.Reg, value)
}
func (o *HASH_Type) GetCSR10() uint32 {
	return volatile.LoadUint32(&o.CSR10.Reg)
}

// HASH.CSR11: context swap registers
func (o *HASH_Type) SetCSR11(value uint32) {
	volatile.StoreUint32(&o.CSR11.Reg, value)
}
func (o *HASH_Type) GetCSR11() uint32 {
	return volatile.LoadUint32(&o.CSR11.Reg)
}

// HASH.CSR12: context swap registers
func (o *HASH_Type) SetCSR12(value uint32) {
	volatile.StoreUint32(&o.CSR12.Reg, value)
}
func (o *HASH_Type) GetCSR12() uint32 {
	return volatile.LoadUint32(&o.CSR12.Reg)
}

// HASH.CSR13: context swap registers
func (o *HASH_Type) SetCSR13(value uint32) {
	volatile.StoreUint32(&o.CSR13.Reg, value)
}
func (o *HASH_Type) GetCSR13() uint32 {
	return volatile.LoadUint32(&o.CSR13.Reg)
}

// HASH.CSR14: context swap registers
func (o *HASH_Type) SetCSR14(value uint32) {
	volatile.StoreUint32(&o.CSR14.Reg, value)
}
func (o *HASH_Type) GetCSR14() uint32 {
	return volatile.LoadUint32(&o.CSR14.Reg)
}

// HASH.CSR15: context swap registers
func (o *HASH_Type) SetCSR15(value uint32) {
	volatile.StoreUint32(&o.CSR15.Reg, value)
}
func (o *HASH_Type) GetCSR15() uint32 {
	return volatile.LoadUint32(&o.CSR15.Reg)
}

// HASH.CSR16: context swap registers
func (o *HASH_Type) SetCSR16(value uint32) {
	volatile.StoreUint32(&o.CSR16.Reg, value)
}
func (o *HASH_Type) GetCSR16() uint32 {
	return volatile.LoadUint32(&o.CSR16.Reg)
}

// HASH.CSR17: context swap registers
func (o *HASH_Type) SetCSR17(value uint32) {
	volatile.StoreUint32(&o.CSR17.Reg, value)
}
func (o *HASH_Type) GetCSR17() uint32 {
	return volatile.LoadUint32(&o.CSR17.Reg)
}

// HASH.CSR18: context swap registers
func (o *HASH_Type) SetCSR18(value uint32) {
	volatile.StoreUint32(&o.CSR18.Reg, value)
}
func (o *HASH_Type) GetCSR18() uint32 {
	return volatile.LoadUint32(&o.CSR18.Reg)
}

// HASH.CSR19: context swap registers
func (o *HASH_Type) SetCSR19(value uint32) {
	volatile.StoreUint32(&o.CSR19.Reg, value)
}
func (o *HASH_Type) GetCSR19() uint32 {
	return volatile.LoadUint32(&o.CSR19.Reg)
}

// HASH.CSR20: context swap registers
func (o *HASH_Type) SetCSR20(value uint32) {
	volatile.StoreUint32(&o.CSR20.Reg, value)
}
func (o *HASH_Type) GetCSR20() uint32 {
	return volatile.LoadUint32(&o.CSR20.Reg)
}

// HASH.CSR21: context swap registers
func (o *HASH_Type) SetCSR21(value uint32) {
	volatile.StoreUint32(&o.CSR21.Reg, value)
}
func (o *HASH_Type) GetCSR21() uint32 {
	return volatile.LoadUint32(&o.CSR21.Reg)
}

// HASH.CSR22: context swap registers
func (o *HASH_Type) SetCSR22(value uint32) {
	volatile.StoreUint32(&o.CSR22.Reg, value)
}
func (o *HASH_Type) GetCSR22() uint32 {
	return volatile.LoadUint32(&o.CSR22.Reg)
}

// HASH.CSR23: context swap registers
func (o *HASH_Type) SetCSR23(value uint32) {
	volatile.StoreUint32(&o.CSR23.Reg, value)
}
func (o *HASH_Type) GetCSR23() uint32 {
	return volatile.LoadUint32(&o.CSR23.Reg)
}

// HASH.CSR24: context swap registers
func (o *HASH_Type) SetCSR24(value uint32) {
	volatile.StoreUint32(&o.CSR24.Reg, value)
}
func (o *HASH_Type) GetCSR24() uint32 {
	return volatile.LoadUint32(&o.CSR24.Reg)
}

// HASH.CSR25: context swap registers
func (o *HASH_Type) SetCSR25(value uint32) {
	volatile.StoreUint32(&o.CSR25.Reg, value)
}
func (o *HASH_Type) GetCSR25() uint32 {
	return volatile.LoadUint32(&o.CSR25.Reg)
}

// HASH.CSR26: context swap registers
func (o *HASH_Type) SetCSR26(value uint32) {
	volatile.StoreUint32(&o.CSR26.Reg, value)
}
func (o *HASH_Type) GetCSR26() uint32 {
	return volatile.LoadUint32(&o.CSR26.Reg)
}

// HASH.CSR27: context swap registers
func (o *HASH_Type) SetCSR27(value uint32) {
	volatile.StoreUint32(&o.CSR27.Reg, value)
}
func (o *HASH_Type) GetCSR27() uint32 {
	return volatile.LoadUint32(&o.CSR27.Reg)
}

// HASH.CSR28: context swap registers
func (o *HASH_Type) SetCSR28(value uint32) {
	volatile.StoreUint32(&o.CSR28.Reg, value)
}
func (o *HASH_Type) GetCSR28() uint32 {
	return volatile.LoadUint32(&o.CSR28.Reg)
}

// HASH.CSR29: context swap registers
func (o *HASH_Type) SetCSR29(value uint32) {
	volatile.StoreUint32(&o.CSR29.Reg, value)
}
func (o *HASH_Type) GetCSR29() uint32 {
	return volatile.LoadUint32(&o.CSR29.Reg)
}

// HASH.CSR30: context swap registers
func (o *HASH_Type) SetCSR30(value uint32) {
	volatile.StoreUint32(&o.CSR30.Reg, value)
}
func (o *HASH_Type) GetCSR30() uint32 {
	return volatile.LoadUint32(&o.CSR30.Reg)
}

// HASH.CSR31: context swap registers
func (o *HASH_Type) SetCSR31(value uint32) {
	volatile.StoreUint32(&o.CSR31.Reg, value)
}
func (o *HASH_Type) GetCSR31() uint32 {
	return volatile.LoadUint32(&o.CSR31.Reg)
}

// HASH.CSR32: context swap registers
func (o *HASH_Type) SetCSR32(value uint32) {
	volatile.StoreUint32(&o.CSR32.Reg, value)
}
func (o *HASH_Type) GetCSR32() uint32 {
	return volatile.LoadUint32(&o.CSR32.Reg)
}

// HASH.CSR33: context swap registers
func (o *HASH_Type) SetCSR33(value uint32) {
	volatile.StoreUint32(&o.CSR33.Reg, value)
}
func (o *HASH_Type) GetCSR33() uint32 {
	return volatile.LoadUint32(&o.CSR33.Reg)
}

// HASH.CSR34: context swap registers
func (o *HASH_Type) SetCSR34(value uint32) {
	volatile.StoreUint32(&o.CSR34.Reg, value)
}
func (o *HASH_Type) GetCSR34() uint32 {
	return volatile.LoadUint32(&o.CSR34.Reg)
}

// HASH.CSR35: context swap registers
func (o *HASH_Type) SetCSR35(value uint32) {
	volatile.StoreUint32(&o.CSR35.Reg, value)
}
func (o *HASH_Type) GetCSR35() uint32 {
	return volatile.LoadUint32(&o.CSR35.Reg)
}

// HASH.CSR36: context swap registers
func (o *HASH_Type) SetCSR36(value uint32) {
	volatile.StoreUint32(&o.CSR36.Reg, value)
}
func (o *HASH_Type) GetCSR36() uint32 {
	return volatile.LoadUint32(&o.CSR36.Reg)
}

// HASH.CSR37: context swap registers
func (o *HASH_Type) SetCSR37(value uint32) {
	volatile.StoreUint32(&o.CSR37.Reg, value)
}
func (o *HASH_Type) GetCSR37() uint32 {
	return volatile.LoadUint32(&o.CSR37.Reg)
}

// HASH.CSR38: context swap registers
func (o *HASH_Type) SetCSR38(value uint32) {
	volatile.StoreUint32(&o.CSR38.Reg, value)
}
func (o *HASH_Type) GetCSR38() uint32 {
	return volatile.LoadUint32(&o.CSR38.Reg)
}

// HASH.CSR39: context swap registers
func (o *HASH_Type) SetCSR39(value uint32) {
	volatile.StoreUint32(&o.CSR39.Reg, value)
}
func (o *HASH_Type) GetCSR39() uint32 {
	return volatile.LoadUint32(&o.CSR39.Reg)
}

// HASH.CSR40: context swap registers
func (o *HASH_Type) SetCSR40(value uint32) {
	volatile.StoreUint32(&o.CSR40.Reg, value)
}
func (o *HASH_Type) GetCSR40() uint32 {
	return volatile.LoadUint32(&o.CSR40.Reg)
}

// HASH.CSR41: context swap registers
func (o *HASH_Type) SetCSR41(value uint32) {
	volatile.StoreUint32(&o.CSR41.Reg, value)
}
func (o *HASH_Type) GetCSR41() uint32 {
	return volatile.LoadUint32(&o.CSR41.Reg)
}

// HASH.CSR42: context swap registers
func (o *HASH_Type) SetCSR42(value uint32) {
	volatile.StoreUint32(&o.CSR42.Reg, value)
}
func (o *HASH_Type) GetCSR42() uint32 {
	return volatile.LoadUint32(&o.CSR42.Reg)
}

// HASH.CSR43: context swap registers
func (o *HASH_Type) SetCSR43(value uint32) {
	volatile.StoreUint32(&o.CSR43.Reg, value)
}
func (o *HASH_Type) GetCSR43() uint32 {
	return volatile.LoadUint32(&o.CSR43.Reg)
}

// HASH.CSR44: context swap registers
func (o *HASH_Type) SetCSR44(value uint32) {
	volatile.StoreUint32(&o.CSR44.Reg, value)
}
func (o *HASH_Type) GetCSR44() uint32 {
	return volatile.LoadUint32(&o.CSR44.Reg)
}

// HASH.CSR45: context swap registers
func (o *HASH_Type) SetCSR45(value uint32) {
	volatile.StoreUint32(&o.CSR45.Reg, value)
}
func (o *HASH_Type) GetCSR45() uint32 {
	return volatile.LoadUint32(&o.CSR45.Reg)
}

// HASH.CSR46: context swap registers
func (o *HASH_Type) SetCSR46(value uint32) {
	volatile.StoreUint32(&o.CSR46.Reg, value)
}
func (o *HASH_Type) GetCSR46() uint32 {
	return volatile.LoadUint32(&o.CSR46.Reg)
}

// HASH.CSR47: context swap registers
func (o *HASH_Type) SetCSR47(value uint32) {
	volatile.StoreUint32(&o.CSR47.Reg, value)
}
func (o *HASH_Type) GetCSR47() uint32 {
	return volatile.LoadUint32(&o.CSR47.Reg)
}

// HASH.CSR48: context swap registers
func (o *HASH_Type) SetCSR48(value uint32) {
	volatile.StoreUint32(&o.CSR48.Reg, value)
}
func (o *HASH_Type) GetCSR48() uint32 {
	return volatile.LoadUint32(&o.CSR48.Reg)
}

// HASH.CSR49: context swap registers
func (o *HASH_Type) SetCSR49(value uint32) {
	volatile.StoreUint32(&o.CSR49.Reg, value)
}
func (o *HASH_Type) GetCSR49() uint32 {
	return volatile.LoadUint32(&o.CSR49.Reg)
}

// HASH.CSR50: context swap registers
func (o *HASH_Type) SetCSR50(value uint32) {
	volatile.StoreUint32(&o.CSR50.Reg, value)
}
func (o *HASH_Type) GetCSR50() uint32 {
	return volatile.LoadUint32(&o.CSR50.Reg)
}

// HASH.CSR51: context swap registers
func (o *HASH_Type) SetCSR51(value uint32) {
	volatile.StoreUint32(&o.CSR51.Reg, value)
}
func (o *HASH_Type) GetCSR51() uint32 {
	return volatile.LoadUint32(&o.CSR51.Reg)
}

// HASH.CSR52: context swap registers
func (o *HASH_Type) SetCSR52(value uint32) {
	volatile.StoreUint32(&o.CSR52.Reg, value)
}
func (o *HASH_Type) GetCSR52() uint32 {
	return volatile.LoadUint32(&o.CSR52.Reg)
}

// HASH.CSR53: context swap registers
func (o *HASH_Type) SetCSR53(value uint32) {
	volatile.StoreUint32(&o.CSR53.Reg, value)
}
func (o *HASH_Type) GetCSR53() uint32 {
	return volatile.LoadUint32(&o.CSR53.Reg)
}

// HASH.HASH_HR0: HASH digest register
func (o *HASH_Type) SetHASH_HR0(value uint32) {
	volatile.StoreUint32(&o.HASH_HR0.Reg, value)
}
func (o *HASH_Type) GetHASH_HR0() uint32 {
	return volatile.LoadUint32(&o.HASH_HR0.Reg)
}

// HASH.HASH_HR1: HASH digest register
func (o *HASH_Type) SetHASH_HR1(value uint32) {
	volatile.StoreUint32(&o.HASH_HR1.Reg, value)
}
func (o *HASH_Type) GetHASH_HR1() uint32 {
	return volatile.LoadUint32(&o.HASH_HR1.Reg)
}

// HASH.HASH_HR2: HASH digest register
func (o *HASH_Type) SetHASH_HR2(value uint32) {
	volatile.StoreUint32(&o.HASH_HR2.Reg, value)
}
func (o *HASH_Type) GetHASH_HR2() uint32 {
	return volatile.LoadUint32(&o.HASH_HR2.Reg)
}

// HASH.HASH_HR3: HASH digest register
func (o *HASH_Type) SetHASH_HR3(value uint32) {
	volatile.StoreUint32(&o.HASH_HR3.Reg, value)
}
func (o *HASH_Type) GetHASH_HR3() uint32 {
	return volatile.LoadUint32(&o.HASH_HR3.Reg)
}

// HASH.HASH_HR4: HASH digest register
func (o *HASH_Type) SetHASH_HR4(value uint32) {
	volatile.StoreUint32(&o.HASH_HR4.Reg, value)
}
func (o *HASH_Type) GetHASH_HR4() uint32 {
	return volatile.LoadUint32(&o.HASH_HR4.Reg)
}

// HASH.HASH_HR5: HASH digest register
func (o *HASH_Type) SetHASH_HR5(value uint32) {
	volatile.StoreUint32(&o.HASH_HR5.Reg, value)
}
func (o *HASH_Type) GetHASH_HR5() uint32 {
	return volatile.LoadUint32(&o.HASH_HR5.Reg)
}

// HASH.HASH_HR6: HASH digest register
func (o *HASH_Type) SetHASH_HR6(value uint32) {
	volatile.StoreUint32(&o.HASH_HR6.Reg, value)
}
func (o *HASH_Type) GetHASH_HR6() uint32 {
	return volatile.LoadUint32(&o.HASH_HR6.Reg)
}

// HASH.HASH_HR7: HASH digest register
func (o *HASH_Type) SetHASH_HR7(value uint32) {
	volatile.StoreUint32(&o.HASH_HR7.Reg, value)
}
func (o *HASH_Type) GetHASH_HR7() uint32 {
	return volatile.LoadUint32(&o.HASH_HR7.Reg)
}

// Cryptographic processor
type CRYP_Type struct {
	CR         volatile.Register32 // 0x0
	SR         volatile.Register32 // 0x4
	DIN        volatile.Register32 // 0x8
	DOUT       volatile.Register32 // 0xC
	DMACR      volatile.Register32 // 0x10
	IMSCR      volatile.Register32 // 0x14
	RISR       volatile.Register32 // 0x18
	MISR       volatile.Register32 // 0x1C
	KEY        [4]CRYP_KEY_Type    // 0x20
	INIT       [2]CRYP_INIT_Type   // 0x40
	CSGCMCCM0R volatile.Register32 // 0x50
	CSGCMCCM1R volatile.Register32 // 0x54
	CSGCMCCM2R volatile.Register32 // 0x58
	CSGCMCCM3R volatile.Register32 // 0x5C
	CSGCMCCM4R volatile.Register32 // 0x60
	CSGCMCCM5R volatile.Register32 // 0x64
	CSGCMCCM6R volatile.Register32 // 0x68
	CSGCMCCM7R volatile.Register32 // 0x6C
	CSGCM0R    volatile.Register32 // 0x70
	CSGCM1R    volatile.Register32 // 0x74
	CSGCM2R    volatile.Register32 // 0x78
	CSGCM3R    volatile.Register32 // 0x7C
	CSGCM4R    volatile.Register32 // 0x80
	CSGCM5R    volatile.Register32 // 0x84
	CSGCM6R    volatile.Register32 // 0x88
	CSGCM7R    volatile.Register32 // 0x8C
}

// CRYP.CR: control register
func (o *CRYP_Type) SetCR_ALGODIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_Type) GetCR_ALGODIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *CRYP_Type) SetCR_ALGOMODE0(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *CRYP_Type) GetCR_ALGOMODE0() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *CRYP_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *CRYP_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *CRYP_Type) SetCR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *CRYP_Type) GetCR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *CRYP_Type) SetCR_FFLUSH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *CRYP_Type) GetCR_FFLUSH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *CRYP_Type) SetCR_CRYPEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *CRYP_Type) GetCR_CRYPEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *CRYP_Type) SetCR_GCM_CCMPH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *CRYP_Type) GetCR_GCM_CCMPH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *CRYP_Type) SetCR_ALGOMODE3(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *CRYP_Type) GetCR_ALGOMODE3() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}

// CRYP.SR: status register
func (o *CRYP_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *CRYP_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *CRYP_Type) SetSR_OFFU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *CRYP_Type) GetSR_OFFU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *CRYP_Type) SetSR_OFNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_Type) GetSR_OFNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *CRYP_Type) SetSR_IFNF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetSR_IFNF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetSR_IFEM(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetSR_IFEM() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// CRYP.DIN: data input register
func (o *CRYP_Type) SetDIN(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, value)
}
func (o *CRYP_Type) GetDIN() uint32 {
	return volatile.LoadUint32(&o.DIN.Reg)
}

// CRYP.DOUT: data output register
func (o *CRYP_Type) SetDOUT(value uint32) {
	volatile.StoreUint32(&o.DOUT.Reg, value)
}
func (o *CRYP_Type) GetDOUT() uint32 {
	return volatile.LoadUint32(&o.DOUT.Reg)
}

// CRYP.DMACR: DMA control register
func (o *CRYP_Type) SetDMACR_DOEN(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetDMACR_DOEN() uint32 {
	return (volatile.LoadUint32(&o.DMACR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetDMACR_DIEN(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetDMACR_DIEN() uint32 {
	return volatile.LoadUint32(&o.DMACR.Reg) & 0x1
}

// CRYP.IMSCR: interrupt mask set/clear register
func (o *CRYP_Type) SetIMSCR_OUTIM(value uint32) {
	volatile.StoreUint32(&o.IMSCR.Reg, volatile.LoadUint32(&o.IMSCR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetIMSCR_OUTIM() uint32 {
	return (volatile.LoadUint32(&o.IMSCR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetIMSCR_INIM(value uint32) {
	volatile.StoreUint32(&o.IMSCR.Reg, volatile.LoadUint32(&o.IMSCR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetIMSCR_INIM() uint32 {
	return volatile.LoadUint32(&o.IMSCR.Reg) & 0x1
}

// CRYP.RISR: raw interrupt status register
func (o *CRYP_Type) SetRISR_OUTRIS(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetRISR_OUTRIS() uint32 {
	return (volatile.LoadUint32(&o.RISR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetRISR_INRIS(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetRISR_INRIS() uint32 {
	return volatile.LoadUint32(&o.RISR.Reg) & 0x1
}

// CRYP.MISR: masked interrupt status register
func (o *CRYP_Type) SetMISR_OUTMIS(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetMISR_OUTMIS() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetMISR_INMIS(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetMISR_INMIS() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}

// CRYP.CSGCMCCM0R: context swap register
func (o *CRYP_Type) SetCSGCMCCM0R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM0R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM0R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM0R.Reg)
}

// CRYP.CSGCMCCM1R: context swap register
func (o *CRYP_Type) SetCSGCMCCM1R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM1R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM1R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM1R.Reg)
}

// CRYP.CSGCMCCM2R: context swap register
func (o *CRYP_Type) SetCSGCMCCM2R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM2R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM2R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM2R.Reg)
}

// CRYP.CSGCMCCM3R: context swap register
func (o *CRYP_Type) SetCSGCMCCM3R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM3R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM3R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM3R.Reg)
}

// CRYP.CSGCMCCM4R: context swap register
func (o *CRYP_Type) SetCSGCMCCM4R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM4R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM4R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM4R.Reg)
}

// CRYP.CSGCMCCM5R: context swap register
func (o *CRYP_Type) SetCSGCMCCM5R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM5R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM5R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM5R.Reg)
}

// CRYP.CSGCMCCM6R: context swap register
func (o *CRYP_Type) SetCSGCMCCM6R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM6R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM6R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM6R.Reg)
}

// CRYP.CSGCMCCM7R: context swap register
func (o *CRYP_Type) SetCSGCMCCM7R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM7R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM7R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM7R.Reg)
}

// CRYP.CSGCM0R: context swap register
func (o *CRYP_Type) SetCSGCM0R(value uint32) {
	volatile.StoreUint32(&o.CSGCM0R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM0R() uint32 {
	return volatile.LoadUint32(&o.CSGCM0R.Reg)
}

// CRYP.CSGCM1R: context swap register
func (o *CRYP_Type) SetCSGCM1R(value uint32) {
	volatile.StoreUint32(&o.CSGCM1R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM1R() uint32 {
	return volatile.LoadUint32(&o.CSGCM1R.Reg)
}

// CRYP.CSGCM2R: context swap register
func (o *CRYP_Type) SetCSGCM2R(value uint32) {
	volatile.StoreUint32(&o.CSGCM2R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM2R() uint32 {
	return volatile.LoadUint32(&o.CSGCM2R.Reg)
}

// CRYP.CSGCM3R: context swap register
func (o *CRYP_Type) SetCSGCM3R(value uint32) {
	volatile.StoreUint32(&o.CSGCM3R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM3R() uint32 {
	return volatile.LoadUint32(&o.CSGCM3R.Reg)
}

// CRYP.CSGCM4R: context swap register
func (o *CRYP_Type) SetCSGCM4R(value uint32) {
	volatile.StoreUint32(&o.CSGCM4R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM4R() uint32 {
	return volatile.LoadUint32(&o.CSGCM4R.Reg)
}

// CRYP.CSGCM5R: context swap register
func (o *CRYP_Type) SetCSGCM5R(value uint32) {
	volatile.StoreUint32(&o.CSGCM5R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM5R() uint32 {
	return volatile.LoadUint32(&o.CSGCM5R.Reg)
}

// CRYP.CSGCM6R: context swap register
func (o *CRYP_Type) SetCSGCM6R(value uint32) {
	volatile.StoreUint32(&o.CSGCM6R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM6R() uint32 {
	return volatile.LoadUint32(&o.CSGCM6R.Reg)
}

// CRYP.CSGCM7R: context swap register
func (o *CRYP_Type) SetCSGCM7R(value uint32) {
	volatile.StoreUint32(&o.CSGCM7R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM7R() uint32 {
	return volatile.LoadUint32(&o.CSGCM7R.Reg)
}

type CRYP_KEY_Type struct {
	KLR volatile.Register32 // 0x20
	KRR volatile.Register32 // 0x24
}

// CRYP_KEY.KLR: key registers
func (o *CRYP_KEY_Type) SetKLR_B224(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x1)|value)
}
func (o *CRYP_KEY_Type) GetKLR_B224() uint32 {
	return volatile.LoadUint32(&o.KLR.Reg) & 0x1
}
func (o *CRYP_KEY_Type) SetKLR_B225(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_KEY_Type) GetKLR_B225() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x2) >> 1
}
func (o *CRYP_KEY_Type) SetKLR_B226(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_KEY_Type) GetKLR_B226() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x4) >> 2
}
func (o *CRYP_KEY_Type) SetKLR_B227(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x8)|value<<3)
}
func (o *CRYP_KEY_Type) GetKLR_B227() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x8) >> 3
}
func (o *CRYP_KEY_Type) SetKLR_B228(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x10)|value<<4)
}
func (o *CRYP_KEY_Type) GetKLR_B228() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x10) >> 4
}
func (o *CRYP_KEY_Type) SetKLR_B229(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x20)|value<<5)
}
func (o *CRYP_KEY_Type) GetKLR_B229() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x20) >> 5
}
func (o *CRYP_KEY_Type) SetKLR_B230(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x40)|value<<6)
}
func (o *CRYP_KEY_Type) GetKLR_B230() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x40) >> 6
}
func (o *CRYP_KEY_Type) SetKLR_B231(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x80)|value<<7)
}
func (o *CRYP_KEY_Type) GetKLR_B231() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x80) >> 7
}
func (o *CRYP_KEY_Type) SetKLR_B232(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x100)|value<<8)
}
func (o *CRYP_KEY_Type) GetKLR_B232() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x100) >> 8
}
func (o *CRYP_KEY_Type) SetKLR_B233(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x200)|value<<9)
}
func (o *CRYP_KEY_Type) GetKLR_B233() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x200) >> 9
}
func (o *CRYP_KEY_Type) SetKLR_B234(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x400)|value<<10)
}
func (o *CRYP_KEY_Type) GetKLR_B234() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x400) >> 10
}
func (o *CRYP_KEY_Type) SetKLR_B235(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x800)|value<<11)
}
func (o *CRYP_KEY_Type) GetKLR_B235() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x800) >> 11
}
func (o *CRYP_KEY_Type) SetKLR_B236(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x1000)|value<<12)
}
func (o *CRYP_KEY_Type) GetKLR_B236() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x1000) >> 12
}
func (o *CRYP_KEY_Type) SetKLR_B237(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x2000)|value<<13)
}
func (o *CRYP_KEY_Type) GetKLR_B237() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x2000) >> 13
}
func (o *CRYP_KEY_Type) SetKLR_B238(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x4000)|value<<14)
}
func (o *CRYP_KEY_Type) GetKLR_B238() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x4000) >> 14
}
func (o *CRYP_KEY_Type) SetKLR_B239(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x8000)|value<<15)
}
func (o *CRYP_KEY_Type) GetKLR_B239() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x8000) >> 15
}
func (o *CRYP_KEY_Type) SetKLR_B240(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x10000)|value<<16)
}
func (o *CRYP_KEY_Type) GetKLR_B240() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x10000) >> 16
}
func (o *CRYP_KEY_Type) SetKLR_B241(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x20000)|value<<17)
}
func (o *CRYP_KEY_Type) GetKLR_B241() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x20000) >> 17
}
func (o *CRYP_KEY_Type) SetKLR_B242(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x40000)|value<<18)
}
func (o *CRYP_KEY_Type) GetKLR_B242() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x40000) >> 18
}
func (o *CRYP_KEY_Type) SetKLR_B243(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x80000)|value<<19)
}
func (o *CRYP_KEY_Type) GetKLR_B243() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x80000) >> 19
}
func (o *CRYP_KEY_Type) SetKLR_B244(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x100000)|value<<20)
}
func (o *CRYP_KEY_Type) GetKLR_B244() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x100000) >> 20
}
func (o *CRYP_KEY_Type) SetKLR_B245(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x200000)|value<<21)
}
func (o *CRYP_KEY_Type) GetKLR_B245() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x200000) >> 21
}
func (o *CRYP_KEY_Type) SetKLR_B246(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x400000)|value<<22)
}
func (o *CRYP_KEY_Type) GetKLR_B246() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x400000) >> 22
}
func (o *CRYP_KEY_Type) SetKLR_B247(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x800000)|value<<23)
}
func (o *CRYP_KEY_Type) GetKLR_B247() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x800000) >> 23
}
func (o *CRYP_KEY_Type) SetKLR_B248(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x1000000)|value<<24)
}
func (o *CRYP_KEY_Type) GetKLR_B248() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x1000000) >> 24
}
func (o *CRYP_KEY_Type) SetKLR_B249(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x2000000)|value<<25)
}
func (o *CRYP_KEY_Type) GetKLR_B249() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x2000000) >> 25
}
func (o *CRYP_KEY_Type) SetKLR_B250(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x4000000)|value<<26)
}
func (o *CRYP_KEY_Type) GetKLR_B250() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x4000000) >> 26
}
func (o *CRYP_KEY_Type) SetKLR_B251(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x8000000)|value<<27)
}
func (o *CRYP_KEY_Type) GetKLR_B251() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x8000000) >> 27
}
func (o *CRYP_KEY_Type) SetKLR_B252(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x10000000)|value<<28)
}
func (o *CRYP_KEY_Type) GetKLR_B252() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x10000000) >> 28
}
func (o *CRYP_KEY_Type) SetKLR_B253(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x20000000)|value<<29)
}
func (o *CRYP_KEY_Type) GetKLR_B253() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x20000000) >> 29
}
func (o *CRYP_KEY_Type) SetKLR_B254(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x40000000)|value<<30)
}
func (o *CRYP_KEY_Type) GetKLR_B254() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x40000000) >> 30
}
func (o *CRYP_KEY_Type) SetKLR_B255(value uint32) {
	volatile.StoreUint32(&o.KLR.Reg, volatile.LoadUint32(&o.KLR.Reg)&^(0x80000000)|value<<31)
}
func (o *CRYP_KEY_Type) GetKLR_B255() uint32 {
	return (volatile.LoadUint32(&o.KLR.Reg) & 0x80000000) >> 31
}

// CRYP_KEY.KRR: key registers
func (o *CRYP_KEY_Type) SetKRR_B192(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x1)|value)
}
func (o *CRYP_KEY_Type) GetKRR_B192() uint32 {
	return volatile.LoadUint32(&o.KRR.Reg) & 0x1
}
func (o *CRYP_KEY_Type) SetKRR_B193(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_KEY_Type) GetKRR_B193() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x2) >> 1
}
func (o *CRYP_KEY_Type) SetKRR_B194(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_KEY_Type) GetKRR_B194() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x4) >> 2
}
func (o *CRYP_KEY_Type) SetKRR_B195(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x8)|value<<3)
}
func (o *CRYP_KEY_Type) GetKRR_B195() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x8) >> 3
}
func (o *CRYP_KEY_Type) SetKRR_B196(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x10)|value<<4)
}
func (o *CRYP_KEY_Type) GetKRR_B196() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x10) >> 4
}
func (o *CRYP_KEY_Type) SetKRR_B197(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x20)|value<<5)
}
func (o *CRYP_KEY_Type) GetKRR_B197() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x20) >> 5
}
func (o *CRYP_KEY_Type) SetKRR_B198(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x40)|value<<6)
}
func (o *CRYP_KEY_Type) GetKRR_B198() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x40) >> 6
}
func (o *CRYP_KEY_Type) SetKRR_B199(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x80)|value<<7)
}
func (o *CRYP_KEY_Type) GetKRR_B199() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x80) >> 7
}
func (o *CRYP_KEY_Type) SetKRR_B200(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x100)|value<<8)
}
func (o *CRYP_KEY_Type) GetKRR_B200() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x100) >> 8
}
func (o *CRYP_KEY_Type) SetKRR_B201(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x200)|value<<9)
}
func (o *CRYP_KEY_Type) GetKRR_B201() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x200) >> 9
}
func (o *CRYP_KEY_Type) SetKRR_B202(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x400)|value<<10)
}
func (o *CRYP_KEY_Type) GetKRR_B202() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x400) >> 10
}
func (o *CRYP_KEY_Type) SetKRR_B203(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x800)|value<<11)
}
func (o *CRYP_KEY_Type) GetKRR_B203() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x800) >> 11
}
func (o *CRYP_KEY_Type) SetKRR_B204(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x1000)|value<<12)
}
func (o *CRYP_KEY_Type) GetKRR_B204() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x1000) >> 12
}
func (o *CRYP_KEY_Type) SetKRR_B205(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x2000)|value<<13)
}
func (o *CRYP_KEY_Type) GetKRR_B205() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x2000) >> 13
}
func (o *CRYP_KEY_Type) SetKRR_B206(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x4000)|value<<14)
}
func (o *CRYP_KEY_Type) GetKRR_B206() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x4000) >> 14
}
func (o *CRYP_KEY_Type) SetKRR_B207(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x8000)|value<<15)
}
func (o *CRYP_KEY_Type) GetKRR_B207() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x8000) >> 15
}
func (o *CRYP_KEY_Type) SetKRR_B208(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x10000)|value<<16)
}
func (o *CRYP_KEY_Type) GetKRR_B208() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x10000) >> 16
}
func (o *CRYP_KEY_Type) SetKRR_B209(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x20000)|value<<17)
}
func (o *CRYP_KEY_Type) GetKRR_B209() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x20000) >> 17
}
func (o *CRYP_KEY_Type) SetKRR_B210(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x40000)|value<<18)
}
func (o *CRYP_KEY_Type) GetKRR_B210() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x40000) >> 18
}
func (o *CRYP_KEY_Type) SetKRR_B211(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x80000)|value<<19)
}
func (o *CRYP_KEY_Type) GetKRR_B211() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x80000) >> 19
}
func (o *CRYP_KEY_Type) SetKRR_B212(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x100000)|value<<20)
}
func (o *CRYP_KEY_Type) GetKRR_B212() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x100000) >> 20
}
func (o *CRYP_KEY_Type) SetKRR_B213(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x200000)|value<<21)
}
func (o *CRYP_KEY_Type) GetKRR_B213() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x200000) >> 21
}
func (o *CRYP_KEY_Type) SetKRR_B214(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x400000)|value<<22)
}
func (o *CRYP_KEY_Type) GetKRR_B214() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x400000) >> 22
}
func (o *CRYP_KEY_Type) SetKRR_B215(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x800000)|value<<23)
}
func (o *CRYP_KEY_Type) GetKRR_B215() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x800000) >> 23
}
func (o *CRYP_KEY_Type) SetKRR_B216(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x1000000)|value<<24)
}
func (o *CRYP_KEY_Type) GetKRR_B216() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x1000000) >> 24
}
func (o *CRYP_KEY_Type) SetKRR_B217(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x2000000)|value<<25)
}
func (o *CRYP_KEY_Type) GetKRR_B217() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x2000000) >> 25
}
func (o *CRYP_KEY_Type) SetKRR_B218(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x4000000)|value<<26)
}
func (o *CRYP_KEY_Type) GetKRR_B218() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x4000000) >> 26
}
func (o *CRYP_KEY_Type) SetKRR_B219(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x8000000)|value<<27)
}
func (o *CRYP_KEY_Type) GetKRR_B219() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x8000000) >> 27
}
func (o *CRYP_KEY_Type) SetKRR_B220(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x10000000)|value<<28)
}
func (o *CRYP_KEY_Type) GetKRR_B220() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x10000000) >> 28
}
func (o *CRYP_KEY_Type) SetKRR_B221(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x20000000)|value<<29)
}
func (o *CRYP_KEY_Type) GetKRR_B221() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x20000000) >> 29
}
func (o *CRYP_KEY_Type) SetKRR_B222(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x40000000)|value<<30)
}
func (o *CRYP_KEY_Type) GetKRR_B222() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x40000000) >> 30
}
func (o *CRYP_KEY_Type) SetKRR_B223(value uint32) {
	volatile.StoreUint32(&o.KRR.Reg, volatile.LoadUint32(&o.KRR.Reg)&^(0x80000000)|value<<31)
}
func (o *CRYP_KEY_Type) GetKRR_B223() uint32 {
	return (volatile.LoadUint32(&o.KRR.Reg) & 0x80000000) >> 31
}

type CRYP_INIT_Type struct {
	IVLR volatile.Register32 // 0x40
	IVRR volatile.Register32 // 0x44
}

// CRYP_INIT.IVLR: initialization vector registers
func (o *CRYP_INIT_Type) SetIVLR_IV31(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x1)|value)
}
func (o *CRYP_INIT_Type) GetIVLR_IV31() uint32 {
	return volatile.LoadUint32(&o.IVLR.Reg) & 0x1
}
func (o *CRYP_INIT_Type) SetIVLR_IV30(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_INIT_Type) GetIVLR_IV30() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x2) >> 1
}
func (o *CRYP_INIT_Type) SetIVLR_IV29(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_INIT_Type) GetIVLR_IV29() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x4) >> 2
}
func (o *CRYP_INIT_Type) SetIVLR_IV28(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x8)|value<<3)
}
func (o *CRYP_INIT_Type) GetIVLR_IV28() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x8) >> 3
}
func (o *CRYP_INIT_Type) SetIVLR_IV27(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x10)|value<<4)
}
func (o *CRYP_INIT_Type) GetIVLR_IV27() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x10) >> 4
}
func (o *CRYP_INIT_Type) SetIVLR_IV26(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x20)|value<<5)
}
func (o *CRYP_INIT_Type) GetIVLR_IV26() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x20) >> 5
}
func (o *CRYP_INIT_Type) SetIVLR_IV25(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x40)|value<<6)
}
func (o *CRYP_INIT_Type) GetIVLR_IV25() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x40) >> 6
}
func (o *CRYP_INIT_Type) SetIVLR_IV24(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x80)|value<<7)
}
func (o *CRYP_INIT_Type) GetIVLR_IV24() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x80) >> 7
}
func (o *CRYP_INIT_Type) SetIVLR_IV23(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x100)|value<<8)
}
func (o *CRYP_INIT_Type) GetIVLR_IV23() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x100) >> 8
}
func (o *CRYP_INIT_Type) SetIVLR_IV22(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x200)|value<<9)
}
func (o *CRYP_INIT_Type) GetIVLR_IV22() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x200) >> 9
}
func (o *CRYP_INIT_Type) SetIVLR_IV21(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x400)|value<<10)
}
func (o *CRYP_INIT_Type) GetIVLR_IV21() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x400) >> 10
}
func (o *CRYP_INIT_Type) SetIVLR_IV20(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x800)|value<<11)
}
func (o *CRYP_INIT_Type) GetIVLR_IV20() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x800) >> 11
}
func (o *CRYP_INIT_Type) SetIVLR_IV19(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x1000)|value<<12)
}
func (o *CRYP_INIT_Type) GetIVLR_IV19() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x1000) >> 12
}
func (o *CRYP_INIT_Type) SetIVLR_IV18(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x2000)|value<<13)
}
func (o *CRYP_INIT_Type) GetIVLR_IV18() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x2000) >> 13
}
func (o *CRYP_INIT_Type) SetIVLR_IV17(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x4000)|value<<14)
}
func (o *CRYP_INIT_Type) GetIVLR_IV17() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x4000) >> 14
}
func (o *CRYP_INIT_Type) SetIVLR_IV16(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x8000)|value<<15)
}
func (o *CRYP_INIT_Type) GetIVLR_IV16() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x8000) >> 15
}
func (o *CRYP_INIT_Type) SetIVLR_IV15(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x10000)|value<<16)
}
func (o *CRYP_INIT_Type) GetIVLR_IV15() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x10000) >> 16
}
func (o *CRYP_INIT_Type) SetIVLR_IV14(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x20000)|value<<17)
}
func (o *CRYP_INIT_Type) GetIVLR_IV14() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x20000) >> 17
}
func (o *CRYP_INIT_Type) SetIVLR_IV13(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x40000)|value<<18)
}
func (o *CRYP_INIT_Type) GetIVLR_IV13() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x40000) >> 18
}
func (o *CRYP_INIT_Type) SetIVLR_IV12(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x80000)|value<<19)
}
func (o *CRYP_INIT_Type) GetIVLR_IV12() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x80000) >> 19
}
func (o *CRYP_INIT_Type) SetIVLR_IV11(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x100000)|value<<20)
}
func (o *CRYP_INIT_Type) GetIVLR_IV11() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x100000) >> 20
}
func (o *CRYP_INIT_Type) SetIVLR_IV10(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x200000)|value<<21)
}
func (o *CRYP_INIT_Type) GetIVLR_IV10() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x200000) >> 21
}
func (o *CRYP_INIT_Type) SetIVLR_IV9(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x400000)|value<<22)
}
func (o *CRYP_INIT_Type) GetIVLR_IV9() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x400000) >> 22
}
func (o *CRYP_INIT_Type) SetIVLR_IV8(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x800000)|value<<23)
}
func (o *CRYP_INIT_Type) GetIVLR_IV8() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x800000) >> 23
}
func (o *CRYP_INIT_Type) SetIVLR_IV7(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x1000000)|value<<24)
}
func (o *CRYP_INIT_Type) GetIVLR_IV7() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x1000000) >> 24
}
func (o *CRYP_INIT_Type) SetIVLR_IV6(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x2000000)|value<<25)
}
func (o *CRYP_INIT_Type) GetIVLR_IV6() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x2000000) >> 25
}
func (o *CRYP_INIT_Type) SetIVLR_IV5(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x4000000)|value<<26)
}
func (o *CRYP_INIT_Type) GetIVLR_IV5() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x4000000) >> 26
}
func (o *CRYP_INIT_Type) SetIVLR_IV4(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x8000000)|value<<27)
}
func (o *CRYP_INIT_Type) GetIVLR_IV4() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x8000000) >> 27
}
func (o *CRYP_INIT_Type) SetIVLR_IV3(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x10000000)|value<<28)
}
func (o *CRYP_INIT_Type) GetIVLR_IV3() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x10000000) >> 28
}
func (o *CRYP_INIT_Type) SetIVLR_IV2(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x20000000)|value<<29)
}
func (o *CRYP_INIT_Type) GetIVLR_IV2() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x20000000) >> 29
}
func (o *CRYP_INIT_Type) SetIVLR_IV1(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x40000000)|value<<30)
}
func (o *CRYP_INIT_Type) GetIVLR_IV1() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x40000000) >> 30
}
func (o *CRYP_INIT_Type) SetIVLR_IV0(value uint32) {
	volatile.StoreUint32(&o.IVLR.Reg, volatile.LoadUint32(&o.IVLR.Reg)&^(0x80000000)|value<<31)
}
func (o *CRYP_INIT_Type) GetIVLR_IV0() uint32 {
	return (volatile.LoadUint32(&o.IVLR.Reg) & 0x80000000) >> 31
}

// CRYP_INIT.IVRR: initialization vector registers
func (o *CRYP_INIT_Type) SetIVRR_IV63(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x1)|value)
}
func (o *CRYP_INIT_Type) GetIVRR_IV63() uint32 {
	return volatile.LoadUint32(&o.IVRR.Reg) & 0x1
}
func (o *CRYP_INIT_Type) SetIVRR_IV62(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_INIT_Type) GetIVRR_IV62() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x2) >> 1
}
func (o *CRYP_INIT_Type) SetIVRR_IV61(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_INIT_Type) GetIVRR_IV61() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x4) >> 2
}
func (o *CRYP_INIT_Type) SetIVRR_IV60(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x8)|value<<3)
}
func (o *CRYP_INIT_Type) GetIVRR_IV60() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x8) >> 3
}
func (o *CRYP_INIT_Type) SetIVRR_IV59(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x10)|value<<4)
}
func (o *CRYP_INIT_Type) GetIVRR_IV59() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x10) >> 4
}
func (o *CRYP_INIT_Type) SetIVRR_IV58(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x20)|value<<5)
}
func (o *CRYP_INIT_Type) GetIVRR_IV58() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x20) >> 5
}
func (o *CRYP_INIT_Type) SetIVRR_IV57(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x40)|value<<6)
}
func (o *CRYP_INIT_Type) GetIVRR_IV57() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x40) >> 6
}
func (o *CRYP_INIT_Type) SetIVRR_IV56(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x80)|value<<7)
}
func (o *CRYP_INIT_Type) GetIVRR_IV56() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x80) >> 7
}
func (o *CRYP_INIT_Type) SetIVRR_IV55(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x100)|value<<8)
}
func (o *CRYP_INIT_Type) GetIVRR_IV55() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x100) >> 8
}
func (o *CRYP_INIT_Type) SetIVRR_IV54(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x200)|value<<9)
}
func (o *CRYP_INIT_Type) GetIVRR_IV54() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x200) >> 9
}
func (o *CRYP_INIT_Type) SetIVRR_IV53(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x400)|value<<10)
}
func (o *CRYP_INIT_Type) GetIVRR_IV53() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x400) >> 10
}
func (o *CRYP_INIT_Type) SetIVRR_IV52(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x800)|value<<11)
}
func (o *CRYP_INIT_Type) GetIVRR_IV52() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x800) >> 11
}
func (o *CRYP_INIT_Type) SetIVRR_IV51(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x1000)|value<<12)
}
func (o *CRYP_INIT_Type) GetIVRR_IV51() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x1000) >> 12
}
func (o *CRYP_INIT_Type) SetIVRR_IV50(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x2000)|value<<13)
}
func (o *CRYP_INIT_Type) GetIVRR_IV50() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x2000) >> 13
}
func (o *CRYP_INIT_Type) SetIVRR_IV49(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x4000)|value<<14)
}
func (o *CRYP_INIT_Type) GetIVRR_IV49() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x4000) >> 14
}
func (o *CRYP_INIT_Type) SetIVRR_IV48(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x8000)|value<<15)
}
func (o *CRYP_INIT_Type) GetIVRR_IV48() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x8000) >> 15
}
func (o *CRYP_INIT_Type) SetIVRR_IV47(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x10000)|value<<16)
}
func (o *CRYP_INIT_Type) GetIVRR_IV47() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x10000) >> 16
}
func (o *CRYP_INIT_Type) SetIVRR_IV46(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x20000)|value<<17)
}
func (o *CRYP_INIT_Type) GetIVRR_IV46() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x20000) >> 17
}
func (o *CRYP_INIT_Type) SetIVRR_IV45(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x40000)|value<<18)
}
func (o *CRYP_INIT_Type) GetIVRR_IV45() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x40000) >> 18
}
func (o *CRYP_INIT_Type) SetIVRR_IV44(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x80000)|value<<19)
}
func (o *CRYP_INIT_Type) GetIVRR_IV44() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x80000) >> 19
}
func (o *CRYP_INIT_Type) SetIVRR_IV43(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x100000)|value<<20)
}
func (o *CRYP_INIT_Type) GetIVRR_IV43() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x100000) >> 20
}
func (o *CRYP_INIT_Type) SetIVRR_IV42(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x200000)|value<<21)
}
func (o *CRYP_INIT_Type) GetIVRR_IV42() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x200000) >> 21
}
func (o *CRYP_INIT_Type) SetIVRR_IV41(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x400000)|value<<22)
}
func (o *CRYP_INIT_Type) GetIVRR_IV41() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x400000) >> 22
}
func (o *CRYP_INIT_Type) SetIVRR_IV40(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x800000)|value<<23)
}
func (o *CRYP_INIT_Type) GetIVRR_IV40() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x800000) >> 23
}
func (o *CRYP_INIT_Type) SetIVRR_IV39(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x1000000)|value<<24)
}
func (o *CRYP_INIT_Type) GetIVRR_IV39() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x1000000) >> 24
}
func (o *CRYP_INIT_Type) SetIVRR_IV38(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x2000000)|value<<25)
}
func (o *CRYP_INIT_Type) GetIVRR_IV38() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x2000000) >> 25
}
func (o *CRYP_INIT_Type) SetIVRR_IV37(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x4000000)|value<<26)
}
func (o *CRYP_INIT_Type) GetIVRR_IV37() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x4000000) >> 26
}
func (o *CRYP_INIT_Type) SetIVRR_IV36(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x8000000)|value<<27)
}
func (o *CRYP_INIT_Type) GetIVRR_IV36() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x8000000) >> 27
}
func (o *CRYP_INIT_Type) SetIVRR_IV35(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x10000000)|value<<28)
}
func (o *CRYP_INIT_Type) GetIVRR_IV35() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x10000000) >> 28
}
func (o *CRYP_INIT_Type) SetIVRR_IV34(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x20000000)|value<<29)
}
func (o *CRYP_INIT_Type) GetIVRR_IV34() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x20000000) >> 29
}
func (o *CRYP_INIT_Type) SetIVRR_IV33(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x40000000)|value<<30)
}
func (o *CRYP_INIT_Type) GetIVRR_IV33() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x40000000) >> 30
}
func (o *CRYP_INIT_Type) SetIVRR_IV32(value uint32) {
	volatile.StoreUint32(&o.IVRR.Reg, volatile.LoadUint32(&o.IVRR.Reg)&^(0x80000000)|value<<31)
}
func (o *CRYP_INIT_Type) GetIVRR_IV32() uint32 {
	return (volatile.LoadUint32(&o.IVRR.Reg) & 0x80000000) >> 31
}

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// DCMI.CR: control register 1
func (o *DCMI_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DCMI_Type) GetCR_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DCMI_Type) SetCR_EDM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DCMI_Type) GetCR_EDM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DCMI_Type) SetCR_FCRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DCMI_Type) GetCR_FCRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *DCMI_Type) SetCR_VSPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DCMI_Type) GetCR_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DCMI_Type) SetCR_HSPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DCMI_Type) GetCR_HSPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DCMI_Type) SetCR_PCKPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DCMI_Type) GetCR_PCKPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DCMI_Type) SetCR_ESS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetCR_ESS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetCR_JPEG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetCR_JPEG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetCR_CROP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetCR_CROP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetCR_CM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetCR_CM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetCR_CAPTURE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetCR_CAPTURE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DCMI.SR: status register
func (o *DCMI_Type) SetSR_FNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetSR_FNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetSR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetSR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetSR_HSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetSR_HSYNC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// DCMI.RIS: raw interrupt status register
func (o *DCMI_Type) SetRIS_LINE_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetRIS_LINE_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetRIS_VSYNC_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetRIS_VSYNC_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetRIS_ERR_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetRIS_ERR_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetRIS_OVR_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetRIS_OVR_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetRIS_FRAME_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetRIS_FRAME_RIS() uint32 {
	return volatile.LoadUint32(&o.RIS.Reg) & 0x1
}

// DCMI.IER: interrupt enable register
func (o *DCMI_Type) SetIER_LINE_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetIER_LINE_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetIER_VSYNC_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetIER_VSYNC_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetIER_ERR_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetIER_ERR_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetIER_OVR_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetIER_OVR_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetIER_FRAME_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetIER_FRAME_IE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// DCMI.MIS: masked interrupt status register
func (o *DCMI_Type) SetMIS_LINE_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetMIS_LINE_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetMIS_VSYNC_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetMIS_VSYNC_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetMIS_ERR_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetMIS_ERR_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetMIS_OVR_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetMIS_OVR_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetMIS_FRAME_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetMIS_FRAME_MIS() uint32 {
	return volatile.LoadUint32(&o.MIS.Reg) & 0x1
}

// DCMI.ICR: interrupt clear register
func (o *DCMI_Type) SetICR_LINE_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetICR_LINE_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetICR_VSYNC_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetICR_VSYNC_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetICR_ERR_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetICR_ERR_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetICR_OVR_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetICR_OVR_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetICR_FRAME_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetICR_FRAME_ISC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// DCMI.ESCR: embedded synchronization code register
func (o *DCMI_Type) SetESCR_FEC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetESCR_FEC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetESCR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetESCR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetESCR_LSC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetESCR_LSC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetESCR_FSC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetESCR_FSC() uint32 {
	return volatile.LoadUint32(&o.ESCR.Reg) & 0xff
}

// DCMI.ESUR: embedded synchronization unmask register
func (o *DCMI_Type) SetESUR_FEU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetESUR_FEU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetESUR_LEU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetESUR_LEU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetESUR_LSU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetESUR_LSU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetESUR_FSU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetESUR_FSU() uint32 {
	return volatile.LoadUint32(&o.ESUR.Reg) & 0xff
}

// DCMI.CWSTRT: crop window start
func (o *DCMI_Type) SetCWSTRT_VST(value uint32) {
	volatile.StoreUint32(&o.CWSTRT.Reg, volatile.LoadUint32(&o.CWSTRT.Reg)&^(0x1fff0000)|value<<16)
}
func (o *DCMI_Type) GetCWSTRT_VST() uint32 {
	return (volatile.LoadUint32(&o.CWSTRT.Reg) & 0x1fff0000) >> 16
}
func (o *DCMI_Type) SetCWSTRT_HOFFCNT(value uint32) {
	volatile.StoreUint32(&o.CWSTRT.Reg, volatile.LoadUint32(&o.CWSTRT.Reg)&^(0x3fff)|value)
}
func (o *DCMI_Type) GetCWSTRT_HOFFCNT() uint32 {
	return volatile.LoadUint32(&o.CWSTRT.Reg) & 0x3fff
}

// DCMI.CWSIZE: crop window size
func (o *DCMI_Type) SetCWSIZE_VLINE(value uint32) {
	volatile.StoreUint32(&o.CWSIZE.Reg, volatile.LoadUint32(&o.CWSIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *DCMI_Type) GetCWSIZE_VLINE() uint32 {
	return (volatile.LoadUint32(&o.CWSIZE.Reg) & 0x3fff0000) >> 16
}
func (o *DCMI_Type) SetCWSIZE_CAPCNT(value uint32) {
	volatile.StoreUint32(&o.CWSIZE.Reg, volatile.LoadUint32(&o.CWSIZE.Reg)&^(0x3fff)|value)
}
func (o *DCMI_Type) GetCWSIZE_CAPCNT() uint32 {
	return volatile.LoadUint32(&o.CWSIZE.Reg) & 0x3fff
}

// DCMI.DR: data register
func (o *DCMI_Type) SetDR_Byte3(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetDR_Byte3() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetDR_Byte2(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetDR_Byte2() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetDR_Byte1(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetDR_Byte1() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetDR_Byte0(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetDR_Byte0() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xff
}

// Flexible memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [96]byte
	PCR   volatile.Register32 // 0x80
	SR    volatile.Register32 // 0x84
	PMEM  volatile.Register32 // 0x88
	PATT  volatile.Register32 // 0x8C
	_     [4]byte
	ECCR  volatile.Register32 // 0x94
	_     [108]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
	_     [32]byte
	SDCR1 volatile.Register32 // 0x140
	SDCR2 volatile.Register32 // 0x144
	SDTR1 volatile.Register32 // 0x148
	SDTR2 volatile.Register32 // 0x14C
	SDCMR volatile.Register32 // 0x150
	SDRTR volatile.Register32 // 0x154
	SDSR  volatile.Register32 // 0x158
}

// FSMC.BCR1: SRAM/NOR-Flash chip-select control register 1
func (o *FSMC_Type) SetBCR1_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100000)|value<<20)
}
func (o *FSMC_Type) GetBCR1_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100000) >> 20
}
func (o *FSMC_Type) SetBCR1_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR1_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR1_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR1_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR1_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR1_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR1_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR1_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR1_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR1_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR1_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR1_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR1_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR1_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR1_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR1_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR1_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR1_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR1_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR1_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR1_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR1_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR1_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR1_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR1.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR1_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR1_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR1_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200000)|value<<21)
}
func (o *FSMC_Type) GetBCR1_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200000) >> 21
}
func (o *FSMC_Type) SetBCR1_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR1_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x70000) >> 16
}

// FSMC.BTR1: SRAM/NOR-Flash chip-select timing register 1
func (o *FSMC_Type) SetBTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR1.Reg) & 0xf
}

// FSMC.BCR2: SRAM/NOR-Flash chip-select control register 2
func (o *FSMC_Type) SetBCR2_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR2_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR2_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR2_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR2_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR2_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR2_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR2_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR2_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR2_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR2_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR2_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR2_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR2_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR2_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR2_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR2_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR2_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR2_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR2_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR2_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR2_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR2_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR2_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR2_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR2_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR2.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR2_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR2_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x70000) >> 16
}

// FSMC.BTR2: SRAM/NOR-Flash chip-select timing register 2
func (o *FSMC_Type) SetBTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR2.Reg) & 0xf
}

// FSMC.BCR3: SRAM/NOR-Flash chip-select control register 3
func (o *FSMC_Type) SetBCR3_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR3_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR3_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR3_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR3_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR3_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR3_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR3_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR3_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR3_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR3_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR3_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR3_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR3_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR3_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR3_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR3_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR3_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR3_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR3_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR3_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR3_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR3_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR3_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR3_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR3_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR3_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR3_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR3.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR3_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR3_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x70000) >> 16
}

// FSMC.BTR3: SRAM/NOR-Flash chip-select timing register 3
func (o *FSMC_Type) SetBTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR3.Reg) & 0xf
}

// FSMC.BCR4: SRAM/NOR-Flash chip-select control register 4
func (o *FSMC_Type) SetBCR4_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR4_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR4_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR4_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR4_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR4_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR4_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR4_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR4_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR4_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR4_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR4_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR4_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR4_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR4_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR4_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR4_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR4_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR4_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR4_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR4_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR4_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR4_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR4_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR4_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR4_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR4_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR4_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR4.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR4_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR4_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x70000) >> 16
}

// FSMC.BTR4: SRAM/NOR-Flash chip-select timing register 4
func (o *FSMC_Type) SetBTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR4.Reg) & 0xf
}

// FSMC.PCR: PC Card/NAND Flash control register
func (o *FSMC_Type) SetPCR_ECCPS(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0xe0000)|value<<17)
}
func (o *FSMC_Type) GetPCR_ECCPS() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0xe0000) >> 17
}
func (o *FSMC_Type) SetPCR_TAR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e000)|value<<13)
}
func (o *FSMC_Type) GetPCR_TAR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e000) >> 13
}
func (o *FSMC_Type) SetPCR_TCLR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e00)|value<<9)
}
func (o *FSMC_Type) GetPCR_TCLR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e00) >> 9
}
func (o *FSMC_Type) SetPCR_ECCEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetPCR_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetPCR_PWID(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetPCR_PWID() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetPCR_PTYP(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetPCR_PTYP() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetPCR_PBKEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetPCR_PBKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetPCR_PWAITEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetPCR_PWAITEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x2) >> 1
}

// FSMC.SR: FIFO status and interrupt register
func (o *FSMC_Type) SetSR_FEMPT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetSR_FEMPT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetSR_IFEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FSMC_Type) GetSR_IFEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FSMC_Type) SetSR_ILEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FSMC_Type) GetSR_ILEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FSMC_Type) SetSR_IREN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetSR_IREN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetSR_IFS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetSR_IFS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetSR_ILS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetSR_ILS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetSR_IRS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetSR_IRS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// FSMC.PMEM: Common memory space timing register
func (o *FSMC_Type) SetPMEM_MEMHIZ(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPMEM_MEMHIZ() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPMEM_MEMHOLD(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPMEM_MEMHOLD() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPMEM_MEMWAIT(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPMEM_MEMWAIT() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPMEM_MEMSET(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPMEM_MEMSET() uint32 {
	return volatile.LoadUint32(&o.PMEM.Reg) & 0xff
}

// FSMC.PATT: Attribute memory space timing register
func (o *FSMC_Type) SetPATT_ATTHIZ(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPATT_ATTHIZ() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPATT_ATTHOLD(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPATT_ATTHOLD() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPATT_ATTWAIT(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPATT_ATTWAIT() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPATT_ATTSET(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPATT_ATTSET() uint32 {
	return volatile.LoadUint32(&o.PATT.Reg) & 0xff
}

// FSMC.ECCR: ECC result register
func (o *FSMC_Type) SetECCR(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, value)
}
func (o *FSMC_Type) GetECCR() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg)
}

// FSMC.BWTR1: SRAM/NOR-Flash write timing registers 1
func (o *FSMC_Type) SetBWTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR1.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR2: SRAM/NOR-Flash write timing registers 2
func (o *FSMC_Type) SetBWTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR2.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR3: SRAM/NOR-Flash write timing registers 3
func (o *FSMC_Type) SetBWTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR3.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR4: SRAM/NOR-Flash write timing registers 4
func (o *FSMC_Type) SetBWTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR4.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0000) >> 16
}

// FSMC.SDCR1: SDRAM Control Register 1
func (o *FSMC_Type) SetSDCR1_NC(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x3)|value)
}
func (o *FSMC_Type) GetSDCR1_NC() uint32 {
	return volatile.LoadUint32(&o.SDCR1.Reg) & 0x3
}
func (o *FSMC_Type) SetSDCR1_NR(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetSDCR1_NR() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetSDCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetSDCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetSDCR1_NB(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetSDCR1_NB() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetSDCR1_CAS(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x180)|value<<7)
}
func (o *FSMC_Type) GetSDCR1_CAS() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x180) >> 7
}
func (o *FSMC_Type) SetSDCR1_WP(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetSDCR1_WP() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetSDCR1_SDCLK(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0xc00)|value<<10)
}
func (o *FSMC_Type) GetSDCR1_SDCLK() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0xc00) >> 10
}
func (o *FSMC_Type) SetSDCR1_RBURST(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetSDCR1_RBURST() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetSDCR1_RPIPE(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x6000)|value<<13)
}
func (o *FSMC_Type) GetSDCR1_RPIPE() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x6000) >> 13
}

// FSMC.SDCR2: SDRAM Control Register 2
func (o *FSMC_Type) SetSDCR2_NC(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x3)|value)
}
func (o *FSMC_Type) GetSDCR2_NC() uint32 {
	return volatile.LoadUint32(&o.SDCR2.Reg) & 0x3
}
func (o *FSMC_Type) SetSDCR2_NR(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetSDCR2_NR() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetSDCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetSDCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetSDCR2_NB(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetSDCR2_NB() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetSDCR2_CAS(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x180)|value<<7)
}
func (o *FSMC_Type) GetSDCR2_CAS() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x180) >> 7
}
func (o *FSMC_Type) SetSDCR2_WP(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetSDCR2_WP() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetSDCR2_SDCLK(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0xc00)|value<<10)
}
func (o *FSMC_Type) GetSDCR2_SDCLK() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0xc00) >> 10
}
func (o *FSMC_Type) SetSDCR2_RBURST(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetSDCR2_RBURST() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetSDCR2_RPIPE(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x6000)|value<<13)
}
func (o *FSMC_Type) GetSDCR2_RPIPE() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x6000) >> 13
}

// FSMC.SDTR1: SDRAM Timing register 1
func (o *FSMC_Type) SetSDTR1_TMRD(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetSDTR1_TMRD() uint32 {
	return volatile.LoadUint32(&o.SDTR1.Reg) & 0xf
}
func (o *FSMC_Type) SetSDTR1_TXSR(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetSDTR1_TXSR() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetSDTR1_TRAS(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf00)|value<<8)
}
func (o *FSMC_Type) GetSDTR1_TRAS() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf00) >> 8
}
func (o *FSMC_Type) SetSDTR1_TRC(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf000)|value<<12)
}
func (o *FSMC_Type) GetSDTR1_TRC() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf000) >> 12
}
func (o *FSMC_Type) SetSDTR1_TWR(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetSDTR1_TWR() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetSDTR1_TRP(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetSDTR1_TRP() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetSDTR1_TRCD(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetSDTR1_TRCD() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf000000) >> 24
}

// FSMC.SDTR2: SDRAM Timing register 2
func (o *FSMC_Type) SetSDTR2_TMRD(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetSDTR2_TMRD() uint32 {
	return volatile.LoadUint32(&o.SDTR2.Reg) & 0xf
}
func (o *FSMC_Type) SetSDTR2_TXSR(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetSDTR2_TXSR() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetSDTR2_TRAS(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf00)|value<<8)
}
func (o *FSMC_Type) GetSDTR2_TRAS() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf00) >> 8
}
func (o *FSMC_Type) SetSDTR2_TRC(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf000)|value<<12)
}
func (o *FSMC_Type) GetSDTR2_TRC() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf000) >> 12
}
func (o *FSMC_Type) SetSDTR2_TWR(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetSDTR2_TWR() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetSDTR2_TRP(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetSDTR2_TRP() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetSDTR2_TRCD(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetSDTR2_TRCD() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf000000) >> 24
}

// FSMC.SDCMR: SDRAM Command Mode register
func (o *FSMC_Type) SetSDCMR_MODE(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x7)|value)
}
func (o *FSMC_Type) GetSDCMR_MODE() uint32 {
	return volatile.LoadUint32(&o.SDCMR.Reg) & 0x7
}
func (o *FSMC_Type) SetSDCMR_CTB2(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetSDCMR_CTB2() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetSDCMR_CTB1(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x10)|value<<4)
}
func (o *FSMC_Type) GetSDCMR_CTB1() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x10) >> 4
}
func (o *FSMC_Type) SetSDCMR_NRFS(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x1e0)|value<<5)
}
func (o *FSMC_Type) GetSDCMR_NRFS() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x1e0) >> 5
}
func (o *FSMC_Type) SetSDCMR_MRD(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x3ffe00)|value<<9)
}
func (o *FSMC_Type) GetSDCMR_MRD() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x3ffe00) >> 9
}

// FSMC.SDRTR: SDRAM Refresh Timer register
func (o *FSMC_Type) SetSDRTR_CRE(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetSDRTR_CRE() uint32 {
	return volatile.LoadUint32(&o.SDRTR.Reg) & 0x1
}
func (o *FSMC_Type) SetSDRTR_COUNT(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x3ffe)|value<<1)
}
func (o *FSMC_Type) GetSDRTR_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SDRTR.Reg) & 0x3ffe) >> 1
}
func (o *FSMC_Type) SetSDRTR_REIE(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetSDRTR_REIE() uint32 {
	return (volatile.LoadUint32(&o.SDRTR.Reg) & 0x4000) >> 14
}

// FSMC.SDSR: SDRAM Status register
func (o *FSMC_Type) SetSDSR_RE(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetSDSR_RE() uint32 {
	return volatile.LoadUint32(&o.SDSR.Reg) & 0x1
}
func (o *FSMC_Type) SetSDSR_MODES1(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x6)|value<<1)
}
func (o *FSMC_Type) GetSDSR_MODES1() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x6) >> 1
}
func (o *FSMC_Type) SetSDSR_MODES2(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x18)|value<<3)
}
func (o *FSMC_Type) GetSDSR_MODES2() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x18) >> 3
}
func (o *FSMC_Type) SetSDSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x20)|value<<5)
}
func (o *FSMC_Type) GetSDSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x20) >> 5
}

// Debug support
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// DBG.IDCODE: IDCODE
func (o *DBG_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBG_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBG_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBG_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBG.CR: Control Register
func (o *DBG_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBG_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetCR_TRACE_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DBG_Type) GetCR_TRACE_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}

// DBG.APB1_FZ: Debug MCU APB1 Freeze registe
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM5_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM5_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x8) >> 3
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM6_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x10)|value<<4)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM6_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x10) >> 4
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM7_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM7_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM12_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x40)|value<<6)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM12_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x40) >> 6
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM13_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x80)|value<<7)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM13_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x80) >> 7
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM14_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x100)|value<<8)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM14_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x100) >> 8
}
func (o *DBG_Type) SetAPB1_FZ_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800)|value<<11)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800) >> 11
}
func (o *DBG_Type) SetAPB1_FZ_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1000)|value<<12)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1000) >> 12
}
func (o *DBG_Type) SetAPB1_FZ_DBG_J2C1_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x200000)|value<<21)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_J2C1_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x200000) >> 21
}
func (o *DBG_Type) SetAPB1_FZ_DBG_J2C2_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400000)|value<<22)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_J2C2_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400000) >> 22
}
func (o *DBG_Type) SetAPB1_FZ_DBG_J2C3SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800000)|value<<23)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_J2C3SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800000) >> 23
}
func (o *DBG_Type) SetAPB1_FZ_DBG_CAN1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2000000)|value<<25)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_CAN1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2000000) >> 25
}
func (o *DBG_Type) SetAPB1_FZ_DBG_CAN2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4000000)|value<<26)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_CAN2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4000000) >> 26
}

// DBG.APB2_FZ: Debug MCU APB2 Freeze registe
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM1_STOP() uint32 {
	return volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM8_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM8_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM9_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x10000)|value<<16)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM9_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x10000) >> 16
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM10_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x20000)|value<<17)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM10_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x20000) >> 17
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM11_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x40000)|value<<18)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM11_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x40000) >> 18
}

// DMA controller
type DMA_Type struct {
	LISR   volatile.Register32 // 0x0
	HISR   volatile.Register32 // 0x4
	LIFCR  volatile.Register32 // 0x8
	HIFCR  volatile.Register32 // 0xC
	S0CR   volatile.Register32 // 0x10
	S0NDTR volatile.Register32 // 0x14
	S0PAR  volatile.Register32 // 0x18
	S0M0AR volatile.Register32 // 0x1C
	S0M1AR volatile.Register32 // 0x20
	S0FCR  volatile.Register32 // 0x24
	S1CR   volatile.Register32 // 0x28
	S1NDTR volatile.Register32 // 0x2C
	S1PAR  volatile.Register32 // 0x30
	S1M0AR volatile.Register32 // 0x34
	S1M1AR volatile.Register32 // 0x38
	S1FCR  volatile.Register32 // 0x3C
	S2CR   volatile.Register32 // 0x40
	S2NDTR volatile.Register32 // 0x44
	S2PAR  volatile.Register32 // 0x48
	S2M0AR volatile.Register32 // 0x4C
	S2M1AR volatile.Register32 // 0x50
	S2FCR  volatile.Register32 // 0x54
	S3CR   volatile.Register32 // 0x58
	S3NDTR volatile.Register32 // 0x5C
	S3PAR  volatile.Register32 // 0x60
	S3M0AR volatile.Register32 // 0x64
	S3M1AR volatile.Register32 // 0x68
	S3FCR  volatile.Register32 // 0x6C
	S4CR   volatile.Register32 // 0x70
	S4NDTR volatile.Register32 // 0x74
	S4PAR  volatile.Register32 // 0x78
	S4M0AR volatile.Register32 // 0x7C
	S4M1AR volatile.Register32 // 0x80
	S4FCR  volatile.Register32 // 0x84
	S5CR   volatile.Register32 // 0x88
	S5NDTR volatile.Register32 // 0x8C
	S5PAR  volatile.Register32 // 0x90
	S5M0AR volatile.Register32 // 0x94
	S5M1AR volatile.Register32 // 0x98
	S5FCR  volatile.Register32 // 0x9C
	S6CR   volatile.Register32 // 0xA0
	S6NDTR volatile.Register32 // 0xA4
	S6PAR  volatile.Register32 // 0xA8
	S6M0AR volatile.Register32 // 0xAC
	S6M1AR volatile.Register32 // 0xB0
	S6FCR  volatile.Register32 // 0xB4
	S7CR   volatile.Register32 // 0xB8
	S7NDTR volatile.Register32 // 0xBC
	S7PAR  volatile.Register32 // 0xC0
	S7M0AR volatile.Register32 // 0xC4
	S7M1AR volatile.Register32 // 0xC8
	S7FCR  volatile.Register32 // 0xCC
}

// DMA.LISR: low interrupt status register
func (o *DMA_Type) SetLISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLISR_DMEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLISR_DMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLISR_FEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLISR_FEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLISR_DMEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLISR_DMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLISR_FEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLISR_FEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLISR_DMEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLISR_DMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLISR_FEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLISR_FEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLISR_TCIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLISR_TCIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLISR_HTIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLISR_HTIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLISR_TEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLISR_TEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLISR_DMEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLISR_DMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLISR_FEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLISR_FEIF0() uint32 {
	return volatile.LoadUint32(&o.LISR.Reg) & 0x1
}

// DMA.HISR: high interrupt status register
func (o *DMA_Type) SetHISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHISR_DMEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHISR_DMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHISR_FEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHISR_FEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHISR_DMEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHISR_DMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHISR_FEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHISR_FEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHISR_DMEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHISR_DMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHISR_FEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHISR_FEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHISR_DMEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHISR_DMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHISR_FEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHISR_FEIF4() uint32 {
	return volatile.LoadUint32(&o.HISR.Reg) & 0x1
}

// DMA.LIFCR: low interrupt flag clear register
func (o *DMA_Type) SetLIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLIFCR_CDMEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLIFCR_CDMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLIFCR_CFEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLIFCR_CFEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLIFCR_CDMEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLIFCR_CDMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLIFCR_CFEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLIFCR_CFEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLIFCR_CDMEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLIFCR_CDMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLIFCR_CFEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLIFCR_CFEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLIFCR_CTCIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLIFCR_CTCIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLIFCR_CHTIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLIFCR_CHTIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLIFCR_CTEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLIFCR_CTEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLIFCR_CDMEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLIFCR_CDMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLIFCR_CFEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLIFCR_CFEIF0() uint32 {
	return volatile.LoadUint32(&o.LIFCR.Reg) & 0x1
}

// DMA.HIFCR: high interrupt flag clear register
func (o *DMA_Type) SetHIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHIFCR_CDMEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHIFCR_CDMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHIFCR_CFEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHIFCR_CFEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHIFCR_CDMEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHIFCR_CDMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHIFCR_CFEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHIFCR_CFEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHIFCR_CDMEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHIFCR_CDMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHIFCR_CFEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHIFCR_CFEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHIFCR_CDMEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHIFCR_CDMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHIFCR_CFEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHIFCR_CFEIF4() uint32 {
	return volatile.LoadUint32(&o.HIFCR.Reg) & 0x1
}

// DMA.S0CR: stream x configuration register
func (o *DMA_Type) SetS0CR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_Type) GetS0CR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_Type) SetS0CR_MBURST(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_Type) GetS0CR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_Type) SetS0CR_PBURST(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_Type) GetS0CR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x600000) >> 21
}
func (o *DMA_Type) SetS0CR_CT(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetS0CR_CT() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetS0CR_DBM(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetS0CR_DBM() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetS0CR_PL(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetS0CR_PL() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetS0CR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetS0CR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetS0CR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetS0CR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x6000) >> 13
}
func (o *DMA_Type) SetS0CR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_Type) GetS0CR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x1800) >> 11
}
func (o *DMA_Type) SetS0CR_MINC(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetS0CR_MINC() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetS0CR_PINC(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetS0CR_PINC() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetS0CR_CIRC(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetS0CR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetS0CR_DIR(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetS0CR_DIR() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetS0CR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetS0CR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetS0CR_TCIE(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetS0CR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetS0CR_HTIE(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetS0CR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetS0CR_TEIE(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS0CR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS0CR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetS0CR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.S0CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetS0CR_EN(value uint32) {
	volatile.StoreUint32(&o.S0CR.Reg, volatile.LoadUint32(&o.S0CR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetS0CR_EN() uint32 {
	return volatile.LoadUint32(&o.S0CR.Reg) & 0x1
}

// DMA.S0NDTR: stream x number of data register
func (o *DMA_Type) SetS0NDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.S0NDTR.Reg, volatile.LoadUint32(&o.S0NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetS0NDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.S0NDTR.Reg) & 0xffff
}

// DMA.S0PAR: stream x peripheral address register
func (o *DMA_Type) SetS0PAR(value uint32) {
	volatile.StoreUint32(&o.S0PAR.Reg, value)
}
func (o *DMA_Type) GetS0PAR() uint32 {
	return volatile.LoadUint32(&o.S0PAR.Reg)
}

// DMA.S0M0AR: stream x memory 0 address register
func (o *DMA_Type) SetS0M0AR(value uint32) {
	volatile.StoreUint32(&o.S0M0AR.Reg, value)
}
func (o *DMA_Type) GetS0M0AR() uint32 {
	return volatile.LoadUint32(&o.S0M0AR.Reg)
}

// DMA.S0M1AR: stream x memory 1 address register
func (o *DMA_Type) SetS0M1AR(value uint32) {
	volatile.StoreUint32(&o.S0M1AR.Reg, value)
}
func (o *DMA_Type) GetS0M1AR() uint32 {
	return volatile.LoadUint32(&o.S0M1AR.Reg)
}

// DMA.S0FCR: stream x FIFO control register
func (o *DMA_Type) SetS0FCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.S0FCR.Reg, volatile.LoadUint32(&o.S0FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetS0FCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.S0FCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetS0FCR_FS(value uint32) {
	volatile.StoreUint32(&o.S0FCR.Reg, volatile.LoadUint32(&o.S0FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_Type) GetS0FCR_FS() uint32 {
	return (volatile.LoadUint32(&o.S0FCR.Reg) & 0x38) >> 3
}
func (o *DMA_Type) SetS0FCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.S0FCR.Reg, volatile.LoadUint32(&o.S0FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS0FCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.S0FCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS0FCR_FTH(value uint32) {
	volatile.StoreUint32(&o.S0FCR.Reg, volatile.LoadUint32(&o.S0FCR.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetS0FCR_FTH() uint32 {
	return volatile.LoadUint32(&o.S0FCR.Reg) & 0x3
}

// DMA.S1CR: stream x configuration register
func (o *DMA_Type) SetS1CR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_Type) GetS1CR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_Type) SetS1CR_MBURST(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_Type) GetS1CR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_Type) SetS1CR_PBURST(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_Type) GetS1CR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x600000) >> 21
}
func (o *DMA_Type) SetS1CR_ACK(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetS1CR_ACK() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetS1CR_CT(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetS1CR_CT() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetS1CR_DBM(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetS1CR_DBM() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetS1CR_PL(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetS1CR_PL() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetS1CR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetS1CR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetS1CR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetS1CR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x6000) >> 13
}
func (o *DMA_Type) SetS1CR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_Type) GetS1CR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x1800) >> 11
}
func (o *DMA_Type) SetS1CR_MINC(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetS1CR_MINC() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetS1CR_PINC(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetS1CR_PINC() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetS1CR_CIRC(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetS1CR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetS1CR_DIR(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetS1CR_DIR() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetS1CR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetS1CR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetS1CR_TCIE(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetS1CR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetS1CR_HTIE(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetS1CR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetS1CR_TEIE(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS1CR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS1CR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetS1CR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.S1CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetS1CR_EN(value uint32) {
	volatile.StoreUint32(&o.S1CR.Reg, volatile.LoadUint32(&o.S1CR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetS1CR_EN() uint32 {
	return volatile.LoadUint32(&o.S1CR.Reg) & 0x1
}

// DMA.S1NDTR: stream x number of data register
func (o *DMA_Type) SetS1NDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.S1NDTR.Reg, volatile.LoadUint32(&o.S1NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetS1NDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.S1NDTR.Reg) & 0xffff
}

// DMA.S1PAR: stream x peripheral address register
func (o *DMA_Type) SetS1PAR(value uint32) {
	volatile.StoreUint32(&o.S1PAR.Reg, value)
}
func (o *DMA_Type) GetS1PAR() uint32 {
	return volatile.LoadUint32(&o.S1PAR.Reg)
}

// DMA.S1M0AR: stream x memory 0 address register
func (o *DMA_Type) SetS1M0AR(value uint32) {
	volatile.StoreUint32(&o.S1M0AR.Reg, value)
}
func (o *DMA_Type) GetS1M0AR() uint32 {
	return volatile.LoadUint32(&o.S1M0AR.Reg)
}

// DMA.S1M1AR: stream x memory 1 address register
func (o *DMA_Type) SetS1M1AR(value uint32) {
	volatile.StoreUint32(&o.S1M1AR.Reg, value)
}
func (o *DMA_Type) GetS1M1AR() uint32 {
	return volatile.LoadUint32(&o.S1M1AR.Reg)
}

// DMA.S1FCR: stream x FIFO control register
func (o *DMA_Type) SetS1FCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.S1FCR.Reg, volatile.LoadUint32(&o.S1FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetS1FCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.S1FCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetS1FCR_FS(value uint32) {
	volatile.StoreUint32(&o.S1FCR.Reg, volatile.LoadUint32(&o.S1FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_Type) GetS1FCR_FS() uint32 {
	return (volatile.LoadUint32(&o.S1FCR.Reg) & 0x38) >> 3
}
func (o *DMA_Type) SetS1FCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.S1FCR.Reg, volatile.LoadUint32(&o.S1FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS1FCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.S1FCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS1FCR_FTH(value uint32) {
	volatile.StoreUint32(&o.S1FCR.Reg, volatile.LoadUint32(&o.S1FCR.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetS1FCR_FTH() uint32 {
	return volatile.LoadUint32(&o.S1FCR.Reg) & 0x3
}

// DMA.S2CR: stream x configuration register
func (o *DMA_Type) SetS2CR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_Type) GetS2CR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_Type) SetS2CR_MBURST(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_Type) GetS2CR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_Type) SetS2CR_PBURST(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_Type) GetS2CR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x600000) >> 21
}
func (o *DMA_Type) SetS2CR_ACK(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetS2CR_ACK() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetS2CR_CT(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetS2CR_CT() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetS2CR_DBM(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetS2CR_DBM() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetS2CR_PL(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetS2CR_PL() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetS2CR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetS2CR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetS2CR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetS2CR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x6000) >> 13
}
func (o *DMA_Type) SetS2CR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_Type) GetS2CR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x1800) >> 11
}
func (o *DMA_Type) SetS2CR_MINC(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetS2CR_MINC() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetS2CR_PINC(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetS2CR_PINC() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetS2CR_CIRC(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetS2CR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetS2CR_DIR(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetS2CR_DIR() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetS2CR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetS2CR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetS2CR_TCIE(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetS2CR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetS2CR_HTIE(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetS2CR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetS2CR_TEIE(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS2CR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS2CR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetS2CR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.S2CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetS2CR_EN(value uint32) {
	volatile.StoreUint32(&o.S2CR.Reg, volatile.LoadUint32(&o.S2CR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetS2CR_EN() uint32 {
	return volatile.LoadUint32(&o.S2CR.Reg) & 0x1
}

// DMA.S2NDTR: stream x number of data register
func (o *DMA_Type) SetS2NDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.S2NDTR.Reg, volatile.LoadUint32(&o.S2NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetS2NDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.S2NDTR.Reg) & 0xffff
}

// DMA.S2PAR: stream x peripheral address register
func (o *DMA_Type) SetS2PAR(value uint32) {
	volatile.StoreUint32(&o.S2PAR.Reg, value)
}
func (o *DMA_Type) GetS2PAR() uint32 {
	return volatile.LoadUint32(&o.S2PAR.Reg)
}

// DMA.S2M0AR: stream x memory 0 address register
func (o *DMA_Type) SetS2M0AR(value uint32) {
	volatile.StoreUint32(&o.S2M0AR.Reg, value)
}
func (o *DMA_Type) GetS2M0AR() uint32 {
	return volatile.LoadUint32(&o.S2M0AR.Reg)
}

// DMA.S2M1AR: stream x memory 1 address register
func (o *DMA_Type) SetS2M1AR(value uint32) {
	volatile.StoreUint32(&o.S2M1AR.Reg, value)
}
func (o *DMA_Type) GetS2M1AR() uint32 {
	return volatile.LoadUint32(&o.S2M1AR.Reg)
}

// DMA.S2FCR: stream x FIFO control register
func (o *DMA_Type) SetS2FCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.S2FCR.Reg, volatile.LoadUint32(&o.S2FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetS2FCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.S2FCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetS2FCR_FS(value uint32) {
	volatile.StoreUint32(&o.S2FCR.Reg, volatile.LoadUint32(&o.S2FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_Type) GetS2FCR_FS() uint32 {
	return (volatile.LoadUint32(&o.S2FCR.Reg) & 0x38) >> 3
}
func (o *DMA_Type) SetS2FCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.S2FCR.Reg, volatile.LoadUint32(&o.S2FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS2FCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.S2FCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS2FCR_FTH(value uint32) {
	volatile.StoreUint32(&o.S2FCR.Reg, volatile.LoadUint32(&o.S2FCR.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetS2FCR_FTH() uint32 {
	return volatile.LoadUint32(&o.S2FCR.Reg) & 0x3
}

// DMA.S3CR: stream x configuration register
func (o *DMA_Type) SetS3CR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_Type) GetS3CR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_Type) SetS3CR_MBURST(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_Type) GetS3CR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_Type) SetS3CR_PBURST(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_Type) GetS3CR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x600000) >> 21
}
func (o *DMA_Type) SetS3CR_ACK(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetS3CR_ACK() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetS3CR_CT(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetS3CR_CT() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetS3CR_DBM(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetS3CR_DBM() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetS3CR_PL(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetS3CR_PL() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetS3CR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetS3CR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetS3CR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetS3CR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x6000) >> 13
}
func (o *DMA_Type) SetS3CR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_Type) GetS3CR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x1800) >> 11
}
func (o *DMA_Type) SetS3CR_MINC(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetS3CR_MINC() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetS3CR_PINC(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetS3CR_PINC() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetS3CR_CIRC(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetS3CR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetS3CR_DIR(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetS3CR_DIR() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetS3CR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetS3CR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetS3CR_TCIE(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetS3CR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetS3CR_HTIE(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetS3CR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetS3CR_TEIE(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS3CR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS3CR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetS3CR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.S3CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetS3CR_EN(value uint32) {
	volatile.StoreUint32(&o.S3CR.Reg, volatile.LoadUint32(&o.S3CR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetS3CR_EN() uint32 {
	return volatile.LoadUint32(&o.S3CR.Reg) & 0x1
}

// DMA.S3NDTR: stream x number of data register
func (o *DMA_Type) SetS3NDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.S3NDTR.Reg, volatile.LoadUint32(&o.S3NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetS3NDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.S3NDTR.Reg) & 0xffff
}

// DMA.S3PAR: stream x peripheral address register
func (o *DMA_Type) SetS3PAR(value uint32) {
	volatile.StoreUint32(&o.S3PAR.Reg, value)
}
func (o *DMA_Type) GetS3PAR() uint32 {
	return volatile.LoadUint32(&o.S3PAR.Reg)
}

// DMA.S3M0AR: stream x memory 0 address register
func (o *DMA_Type) SetS3M0AR(value uint32) {
	volatile.StoreUint32(&o.S3M0AR.Reg, value)
}
func (o *DMA_Type) GetS3M0AR() uint32 {
	return volatile.LoadUint32(&o.S3M0AR.Reg)
}

// DMA.S3M1AR: stream x memory 1 address register
func (o *DMA_Type) SetS3M1AR(value uint32) {
	volatile.StoreUint32(&o.S3M1AR.Reg, value)
}
func (o *DMA_Type) GetS3M1AR() uint32 {
	return volatile.LoadUint32(&o.S3M1AR.Reg)
}

// DMA.S3FCR: stream x FIFO control register
func (o *DMA_Type) SetS3FCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.S3FCR.Reg, volatile.LoadUint32(&o.S3FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetS3FCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.S3FCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetS3FCR_FS(value uint32) {
	volatile.StoreUint32(&o.S3FCR.Reg, volatile.LoadUint32(&o.S3FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_Type) GetS3FCR_FS() uint32 {
	return (volatile.LoadUint32(&o.S3FCR.Reg) & 0x38) >> 3
}
func (o *DMA_Type) SetS3FCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.S3FCR.Reg, volatile.LoadUint32(&o.S3FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS3FCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.S3FCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS3FCR_FTH(value uint32) {
	volatile.StoreUint32(&o.S3FCR.Reg, volatile.LoadUint32(&o.S3FCR.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetS3FCR_FTH() uint32 {
	return volatile.LoadUint32(&o.S3FCR.Reg) & 0x3
}

// DMA.S4CR: stream x configuration register
func (o *DMA_Type) SetS4CR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_Type) GetS4CR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_Type) SetS4CR_MBURST(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_Type) GetS4CR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_Type) SetS4CR_PBURST(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_Type) GetS4CR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x600000) >> 21
}
func (o *DMA_Type) SetS4CR_ACK(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetS4CR_ACK() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetS4CR_CT(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetS4CR_CT() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetS4CR_DBM(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetS4CR_DBM() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetS4CR_PL(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetS4CR_PL() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetS4CR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetS4CR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetS4CR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetS4CR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x6000) >> 13
}
func (o *DMA_Type) SetS4CR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_Type) GetS4CR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x1800) >> 11
}
func (o *DMA_Type) SetS4CR_MINC(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetS4CR_MINC() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetS4CR_PINC(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetS4CR_PINC() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetS4CR_CIRC(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetS4CR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetS4CR_DIR(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetS4CR_DIR() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetS4CR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetS4CR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetS4CR_TCIE(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetS4CR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetS4CR_HTIE(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetS4CR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetS4CR_TEIE(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS4CR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS4CR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetS4CR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.S4CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetS4CR_EN(value uint32) {
	volatile.StoreUint32(&o.S4CR.Reg, volatile.LoadUint32(&o.S4CR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetS4CR_EN() uint32 {
	return volatile.LoadUint32(&o.S4CR.Reg) & 0x1
}

// DMA.S4NDTR: stream x number of data register
func (o *DMA_Type) SetS4NDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.S4NDTR.Reg, volatile.LoadUint32(&o.S4NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetS4NDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.S4NDTR.Reg) & 0xffff
}

// DMA.S4PAR: stream x peripheral address register
func (o *DMA_Type) SetS4PAR(value uint32) {
	volatile.StoreUint32(&o.S4PAR.Reg, value)
}
func (o *DMA_Type) GetS4PAR() uint32 {
	return volatile.LoadUint32(&o.S4PAR.Reg)
}

// DMA.S4M0AR: stream x memory 0 address register
func (o *DMA_Type) SetS4M0AR(value uint32) {
	volatile.StoreUint32(&o.S4M0AR.Reg, value)
}
func (o *DMA_Type) GetS4M0AR() uint32 {
	return volatile.LoadUint32(&o.S4M0AR.Reg)
}

// DMA.S4M1AR: stream x memory 1 address register
func (o *DMA_Type) SetS4M1AR(value uint32) {
	volatile.StoreUint32(&o.S4M1AR.Reg, value)
}
func (o *DMA_Type) GetS4M1AR() uint32 {
	return volatile.LoadUint32(&o.S4M1AR.Reg)
}

// DMA.S4FCR: stream x FIFO control register
func (o *DMA_Type) SetS4FCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.S4FCR.Reg, volatile.LoadUint32(&o.S4FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetS4FCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.S4FCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetS4FCR_FS(value uint32) {
	volatile.StoreUint32(&o.S4FCR.Reg, volatile.LoadUint32(&o.S4FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_Type) GetS4FCR_FS() uint32 {
	return (volatile.LoadUint32(&o.S4FCR.Reg) & 0x38) >> 3
}
func (o *DMA_Type) SetS4FCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.S4FCR.Reg, volatile.LoadUint32(&o.S4FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS4FCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.S4FCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS4FCR_FTH(value uint32) {
	volatile.StoreUint32(&o.S4FCR.Reg, volatile.LoadUint32(&o.S4FCR.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetS4FCR_FTH() uint32 {
	return volatile.LoadUint32(&o.S4FCR.Reg) & 0x3
}

// DMA.S5CR: stream x configuration register
func (o *DMA_Type) SetS5CR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_Type) GetS5CR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_Type) SetS5CR_MBURST(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_Type) GetS5CR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_Type) SetS5CR_PBURST(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_Type) GetS5CR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x600000) >> 21
}
func (o *DMA_Type) SetS5CR_ACK(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetS5CR_ACK() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetS5CR_CT(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetS5CR_CT() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetS5CR_DBM(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetS5CR_DBM() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetS5CR_PL(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetS5CR_PL() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetS5CR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetS5CR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetS5CR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetS5CR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x6000) >> 13
}
func (o *DMA_Type) SetS5CR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_Type) GetS5CR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x1800) >> 11
}
func (o *DMA_Type) SetS5CR_MINC(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetS5CR_MINC() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetS5CR_PINC(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetS5CR_PINC() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetS5CR_CIRC(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetS5CR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetS5CR_DIR(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetS5CR_DIR() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetS5CR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetS5CR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetS5CR_TCIE(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetS5CR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetS5CR_HTIE(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetS5CR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetS5CR_TEIE(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS5CR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS5CR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetS5CR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.S5CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetS5CR_EN(value uint32) {
	volatile.StoreUint32(&o.S5CR.Reg, volatile.LoadUint32(&o.S5CR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetS5CR_EN() uint32 {
	return volatile.LoadUint32(&o.S5CR.Reg) & 0x1
}

// DMA.S5NDTR: stream x number of data register
func (o *DMA_Type) SetS5NDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.S5NDTR.Reg, volatile.LoadUint32(&o.S5NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetS5NDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.S5NDTR.Reg) & 0xffff
}

// DMA.S5PAR: stream x peripheral address register
func (o *DMA_Type) SetS5PAR(value uint32) {
	volatile.StoreUint32(&o.S5PAR.Reg, value)
}
func (o *DMA_Type) GetS5PAR() uint32 {
	return volatile.LoadUint32(&o.S5PAR.Reg)
}

// DMA.S5M0AR: stream x memory 0 address register
func (o *DMA_Type) SetS5M0AR(value uint32) {
	volatile.StoreUint32(&o.S5M0AR.Reg, value)
}
func (o *DMA_Type) GetS5M0AR() uint32 {
	return volatile.LoadUint32(&o.S5M0AR.Reg)
}

// DMA.S5M1AR: stream x memory 1 address register
func (o *DMA_Type) SetS5M1AR(value uint32) {
	volatile.StoreUint32(&o.S5M1AR.Reg, value)
}
func (o *DMA_Type) GetS5M1AR() uint32 {
	return volatile.LoadUint32(&o.S5M1AR.Reg)
}

// DMA.S5FCR: stream x FIFO control register
func (o *DMA_Type) SetS5FCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.S5FCR.Reg, volatile.LoadUint32(&o.S5FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetS5FCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.S5FCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetS5FCR_FS(value uint32) {
	volatile.StoreUint32(&o.S5FCR.Reg, volatile.LoadUint32(&o.S5FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_Type) GetS5FCR_FS() uint32 {
	return (volatile.LoadUint32(&o.S5FCR.Reg) & 0x38) >> 3
}
func (o *DMA_Type) SetS5FCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.S5FCR.Reg, volatile.LoadUint32(&o.S5FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS5FCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.S5FCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS5FCR_FTH(value uint32) {
	volatile.StoreUint32(&o.S5FCR.Reg, volatile.LoadUint32(&o.S5FCR.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetS5FCR_FTH() uint32 {
	return volatile.LoadUint32(&o.S5FCR.Reg) & 0x3
}

// DMA.S6CR: stream x configuration register
func (o *DMA_Type) SetS6CR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_Type) GetS6CR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_Type) SetS6CR_MBURST(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_Type) GetS6CR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_Type) SetS6CR_PBURST(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_Type) GetS6CR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x600000) >> 21
}
func (o *DMA_Type) SetS6CR_ACK(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetS6CR_ACK() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetS6CR_CT(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetS6CR_CT() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetS6CR_DBM(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetS6CR_DBM() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetS6CR_PL(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetS6CR_PL() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetS6CR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetS6CR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetS6CR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetS6CR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x6000) >> 13
}
func (o *DMA_Type) SetS6CR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_Type) GetS6CR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x1800) >> 11
}
func (o *DMA_Type) SetS6CR_MINC(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetS6CR_MINC() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetS6CR_PINC(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetS6CR_PINC() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetS6CR_CIRC(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetS6CR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetS6CR_DIR(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetS6CR_DIR() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetS6CR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetS6CR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetS6CR_TCIE(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetS6CR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetS6CR_HTIE(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetS6CR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetS6CR_TEIE(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS6CR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS6CR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetS6CR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.S6CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetS6CR_EN(value uint32) {
	volatile.StoreUint32(&o.S6CR.Reg, volatile.LoadUint32(&o.S6CR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetS6CR_EN() uint32 {
	return volatile.LoadUint32(&o.S6CR.Reg) & 0x1
}

// DMA.S6NDTR: stream x number of data register
func (o *DMA_Type) SetS6NDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.S6NDTR.Reg, volatile.LoadUint32(&o.S6NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetS6NDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.S6NDTR.Reg) & 0xffff
}

// DMA.S6PAR: stream x peripheral address register
func (o *DMA_Type) SetS6PAR(value uint32) {
	volatile.StoreUint32(&o.S6PAR.Reg, value)
}
func (o *DMA_Type) GetS6PAR() uint32 {
	return volatile.LoadUint32(&o.S6PAR.Reg)
}

// DMA.S6M0AR: stream x memory 0 address register
func (o *DMA_Type) SetS6M0AR(value uint32) {
	volatile.StoreUint32(&o.S6M0AR.Reg, value)
}
func (o *DMA_Type) GetS6M0AR() uint32 {
	return volatile.LoadUint32(&o.S6M0AR.Reg)
}

// DMA.S6M1AR: stream x memory 1 address register
func (o *DMA_Type) SetS6M1AR(value uint32) {
	volatile.StoreUint32(&o.S6M1AR.Reg, value)
}
func (o *DMA_Type) GetS6M1AR() uint32 {
	return volatile.LoadUint32(&o.S6M1AR.Reg)
}

// DMA.S6FCR: stream x FIFO control register
func (o *DMA_Type) SetS6FCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.S6FCR.Reg, volatile.LoadUint32(&o.S6FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetS6FCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.S6FCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetS6FCR_FS(value uint32) {
	volatile.StoreUint32(&o.S6FCR.Reg, volatile.LoadUint32(&o.S6FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_Type) GetS6FCR_FS() uint32 {
	return (volatile.LoadUint32(&o.S6FCR.Reg) & 0x38) >> 3
}
func (o *DMA_Type) SetS6FCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.S6FCR.Reg, volatile.LoadUint32(&o.S6FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS6FCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.S6FCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS6FCR_FTH(value uint32) {
	volatile.StoreUint32(&o.S6FCR.Reg, volatile.LoadUint32(&o.S6FCR.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetS6FCR_FTH() uint32 {
	return volatile.LoadUint32(&o.S6FCR.Reg) & 0x3
}

// DMA.S7CR: stream x configuration register
func (o *DMA_Type) SetS7CR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_Type) GetS7CR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_Type) SetS7CR_MBURST(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_Type) GetS7CR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_Type) SetS7CR_PBURST(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_Type) GetS7CR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x600000) >> 21
}
func (o *DMA_Type) SetS7CR_ACK(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetS7CR_ACK() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetS7CR_CT(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetS7CR_CT() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetS7CR_DBM(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetS7CR_DBM() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetS7CR_PL(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_Type) GetS7CR_PL() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x30000) >> 16
}
func (o *DMA_Type) SetS7CR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetS7CR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetS7CR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_Type) GetS7CR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x6000) >> 13
}
func (o *DMA_Type) SetS7CR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_Type) GetS7CR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x1800) >> 11
}
func (o *DMA_Type) SetS7CR_MINC(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetS7CR_MINC() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetS7CR_PINC(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetS7CR_PINC() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetS7CR_CIRC(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetS7CR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetS7CR_DIR(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_Type) GetS7CR_DIR() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0xc0) >> 6
}
func (o *DMA_Type) SetS7CR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetS7CR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetS7CR_TCIE(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetS7CR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetS7CR_HTIE(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetS7CR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetS7CR_TEIE(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS7CR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS7CR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetS7CR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.S7CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetS7CR_EN(value uint32) {
	volatile.StoreUint32(&o.S7CR.Reg, volatile.LoadUint32(&o.S7CR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetS7CR_EN() uint32 {
	return volatile.LoadUint32(&o.S7CR.Reg) & 0x1
}

// DMA.S7NDTR: stream x number of data register
func (o *DMA_Type) SetS7NDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.S7NDTR.Reg, volatile.LoadUint32(&o.S7NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetS7NDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.S7NDTR.Reg) & 0xffff
}

// DMA.S7PAR: stream x peripheral address register
func (o *DMA_Type) SetS7PAR(value uint32) {
	volatile.StoreUint32(&o.S7PAR.Reg, value)
}
func (o *DMA_Type) GetS7PAR() uint32 {
	return volatile.LoadUint32(&o.S7PAR.Reg)
}

// DMA.S7M0AR: stream x memory 0 address register
func (o *DMA_Type) SetS7M0AR(value uint32) {
	volatile.StoreUint32(&o.S7M0AR.Reg, value)
}
func (o *DMA_Type) GetS7M0AR() uint32 {
	return volatile.LoadUint32(&o.S7M0AR.Reg)
}

// DMA.S7M1AR: stream x memory 1 address register
func (o *DMA_Type) SetS7M1AR(value uint32) {
	volatile.StoreUint32(&o.S7M1AR.Reg, value)
}
func (o *DMA_Type) GetS7M1AR() uint32 {
	return volatile.LoadUint32(&o.S7M1AR.Reg)
}

// DMA.S7FCR: stream x FIFO control register
func (o *DMA_Type) SetS7FCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.S7FCR.Reg, volatile.LoadUint32(&o.S7FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetS7FCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.S7FCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetS7FCR_FS(value uint32) {
	volatile.StoreUint32(&o.S7FCR.Reg, volatile.LoadUint32(&o.S7FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_Type) GetS7FCR_FS() uint32 {
	return (volatile.LoadUint32(&o.S7FCR.Reg) & 0x38) >> 3
}
func (o *DMA_Type) SetS7FCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.S7FCR.Reg, volatile.LoadUint32(&o.S7FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetS7FCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.S7FCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetS7FCR_FTH(value uint32) {
	volatile.StoreUint32(&o.S7FCR.Reg, volatile.LoadUint32(&o.S7FCR.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetS7FCR_FTH() uint32 {
	return volatile.LoadUint32(&o.S7FCR.Reg) & 0x3
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	AHB3RSTR   volatile.Register32 // 0x18
	_          [4]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	AHB3ENR    volatile.Register32 // 0x38
	_          [4]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	AHB3LPENR  volatile.Register32 // 0x58
	_          [4]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
	PLLSAICFGR volatile.Register32 // 0x88
	DCKCFGR1   volatile.Register32 // 0x8C
	DCKCFGR2   volatile.Register32 // 0x90
}

// RCC.CR: clock control register
func (o *RCC_Type) SetCR_PLLI2SRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCR_PLLI2SRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCR_PLLI2SON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCR_PLLI2SON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetCR_HSICAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf8)|value<<3)
}
func (o *RCC_Type) GetCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf8) >> 3
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RCC_Type) SetCR_PLLSAIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCR_PLLSAIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCR_PLLSAION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCR_PLLSAION() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}

// RCC.PLLCFGR: PLL configuration register
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3f)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3f
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xf000000) >> 24
}

// RCC.CFGR: clock configuration register
func (o *RCC_Type) SetCFGR_MCO2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetCFGR_MCO2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0000000) >> 30
}
func (o *RCC_Type) SetCFGR_MCO2PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x38000000)|value<<27)
}
func (o *RCC_Type) GetCFGR_MCO2PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x38000000) >> 27
}
func (o *RCC_Type) SetCFGR_MCO1PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCO1PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *RCC_Type) SetCFGR_I2SSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCFGR_I2SSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCFGR_MCO1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x600000)|value<<21)
}
func (o *RCC_Type) GetCFGR_MCO1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x600000) >> 21
}
func (o *RCC_Type) SetCFGR_RTCPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1f0000)|value<<16)
}
func (o *RCC_Type) GetCFGR_RTCPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1f0000) >> 16
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1c00)|value<<10)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1c00) >> 10
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}

// RCC.CIR: clock interrupt register
func (o *RCC_Type) SetCIR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCIR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCIR_PLLSAIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetCIR_PLLSAIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetCIR_PLLI2SRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetCIR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetCIR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetCIR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCIR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCIR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCIR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCIR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCIR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCIR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCIR_LSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCIR_PLLSAIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetCIR_PLLSAIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetCIR_PLLI2SRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetCIR_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCIR_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCIR_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCIR_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCIR_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIR_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCIR_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIR_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIR_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIR_LSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIR_PLLSAIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCIR_PLLSAIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCIR_PLLI2SRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIR.Reg) & 0x1
}

// RCC.AHB1RSTR: AHB1 peripheral reset register
func (o *RCC_Type) SetAHB1RSTR_OTGHSRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB1RSTR_OTGHSRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB1RSTR_ETHMACRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB1RSTR_ETHMACRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB1RSTR_DMA2DRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2DRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1RSTR_GPIOKRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOKRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAHB1RSTR_GPIOJRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOJRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB1RSTR_GPIOIRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1RSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1RSTR_GPIOGRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1RSTR_GPIOFRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOFRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1RSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1RSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1RSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}

// RCC.AHB2RSTR: AHB2 peripheral reset register
func (o *RCC_Type) SetAHB2RSTR_OTGFSRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2RSTR_OTGFSRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2RSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2RSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2RSTR_HSAHRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2RSTR_HSAHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2RSTR_CRYPRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2RSTR_CRYPRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2RSTR_DCMIRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2RSTR_DCMIRST() uint32 {
	return volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x1
}

// RCC.AHB3RSTR: AHB3 peripheral reset register
func (o *RCC_Type) SetAHB3RSTR_FMCRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3RSTR_FMCRST() uint32 {
	return volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3RSTR_QSPIRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB3RSTR_QSPIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x2) >> 1
}

// RCC.APB1RSTR: APB1 peripheral reset register
func (o *RCC_Type) SetAPB1RSTR_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1RSTR_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1RSTR_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1RSTR_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1RSTR_TIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1RSTR_TIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1RSTR_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1RSTR_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1RSTR_TIM7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR_TIM7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR_TIM12RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1RSTR_TIM12RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1RSTR_TIM13RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1RSTR_TIM13RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1RSTR_TIM14RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1RSTR_TIM14RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1RSTR_WWDGRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1RSTR_WWDGRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1RSTR_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1RSTR_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1RSTR_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1RSTR_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1RSTR_UART4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1RSTR_UART4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1RSTR_UART5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1RSTR_UART5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1RSTR_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR_CAN1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1RSTR_CAN1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1RSTR_CAN2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1RSTR_CAN2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1RSTR_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1RSTR_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1RSTR_DACRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1RSTR_DACRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1RSTR_UART7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1RSTR_UART7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1RSTR_UART8RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1RSTR_UART8RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1RSTR_SPDIFRXRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB1RSTR_SPDIFRXRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB1RSTR_CECRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPB1RSTR_CECRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPB1RSTR_LPTIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1RSTR_LPTIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1RSTR_I2C4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1RSTR_I2C4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x1000000) >> 24
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2RSTR_TIM8RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2RSTR_TIM8RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2RSTR_USART6RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2RSTR_USART6RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2RSTR_ADCRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2RSTR_ADCRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_SPI4RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2RSTR_SPI4RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_SYSCFGRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_TIM9RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2RSTR_TIM9RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2RSTR_TIM10RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM10RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_TIM11RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM11RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_SPI5RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2RSTR_SPI5RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2RSTR_SPI6RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2RSTR_SPI6RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2RSTR_SAI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2RSTR_SAI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2RSTR_LTDCRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB2RSTR_LTDCRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB2RSTR_SAI2RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB2RSTR_SAI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB2RSTR_SDMMC1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_SDMMC1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}

// RCC.AHB1ENR: AHB1 peripheral clock register
func (o *RCC_Type) SetAHB1ENR_OTGHSULPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHB1ENR_OTGHSULPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHB1ENR_OTGHSEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB1ENR_OTGHSEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB1ENR_ETHMACPTPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHB1ENR_ETHMACPTPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAHB1ENR_ETHMACRXEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAHB1ENR_ETHMACRXEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAHB1ENR_ETHMACTXEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAHB1ENR_ETHMACTXEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAHB1ENR_ETHMACEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB1ENR_ETHMACEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB1ENR_DMA2DEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAHB1ENR_DMA2DEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1ENR_DTCMRAMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHB1ENR_DTCMRAMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAHB1ENR_BKPSRAMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB1ENR_BKPSRAMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1ENR_GPIOKEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAHB1ENR_GPIOKEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAHB1ENR_GPIOJEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB1ENR_GPIOJEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB1ENR_GPIOIEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1ENR_GPIOIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1ENR_GPIOGEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1ENR_GPIOGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1ENR_GPIOFEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1ENR_GPIOFEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}

// RCC.AHB2ENR: AHB2 peripheral clock enable register
func (o *RCC_Type) SetAHB2ENR_OTGFSEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2ENR_OTGFSEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2ENR_HASHEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2ENR_HASHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2ENR_CRYPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2ENR_CRYPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2ENR_DCMIEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2ENR_DCMIEN() uint32 {
	return volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x1
}

// RCC.AHB3ENR: AHB3 peripheral clock enable register
func (o *RCC_Type) SetAHB3ENR_FMCEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3ENR_FMCEN() uint32 {
	return volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3ENR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB3ENR_QSPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x2) >> 1
}

// RCC.APB1ENR: APB1 peripheral clock enable register
func (o *RCC_Type) SetAPB1ENR_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1ENR_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1ENR_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1ENR_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1ENR_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1ENR_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1ENR_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1ENR_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1ENR_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR_TIM12EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1ENR_TIM12EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1ENR_TIM13EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1ENR_TIM13EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1ENR_TIM14EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1ENR_TIM14EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1ENR_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1ENR_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1ENR_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1ENR_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1ENR_UART4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1ENR_UART4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1ENR_UART5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1ENR_UART5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1ENR_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR_CAN1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1ENR_CAN1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1ENR_CAN2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1ENR_CAN2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1ENR_PWREN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1ENR_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1ENR_DACEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1ENR_DACEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1ENR_UART7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1ENR_UART7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1ENR_UART8EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1ENR_UART8EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1ENR_SPDIFRXEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB1ENR_SPDIFRXEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB1ENR_CECEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPB1ENR_CECEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPB1ENR_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1ENR_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1ENR_I2C4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1ENR_I2C4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x1000000) >> 24
}

// RCC.APB2ENR: APB2 peripheral clock enable register
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2ENR_TIM8EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2ENR_TIM8EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2ENR_USART6EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2ENR_USART6EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2ENR_ADC1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2ENR_ADC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2ENR_ADC2EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2ENR_ADC2EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB2ENR_ADC3EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB2ENR_ADC3EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_SPI4EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2ENR_SPI4EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_SYSCFGEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_TIM9EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2ENR_TIM9EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2ENR_TIM10EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM10EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_TIM11EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM11EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_SPI5EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2ENR_SPI5EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2ENR_SPI6EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2ENR_SPI6EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2ENR_SAI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2ENR_SAI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2ENR_LTDCEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB2ENR_LTDCEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB2ENR_SAI2EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB2ENR_SAI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB2ENR_SDMMC1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_SDMMC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}

// RCC.AHB1LPENR: AHB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB1LPENR_GPIOALPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOALPEN() uint32 {
	return volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1LPENR_GPIOBLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOBLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1LPENR_GPIOCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1LPENR_GPIODLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1LPENR_GPIODLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1LPENR_GPIOELPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOELPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1LPENR_GPIOFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1LPENR_GPIOGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1LPENR_GPIOHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1LPENR_GPIOILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1LPENR_GPIOJLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOJLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAHB1LPENR_GPIOKLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOKLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAHB1LPENR_CRCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1LPENR_CRCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1LPENR_FLITFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHB1LPENR_FLITFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHB1LPENR_SRAM1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1LPENR_SRAM2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB1LPENR_BKPSRAMLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB1LPENR_BKPSRAMLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB1LPENR_SRAM3LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB1LPENR_DMA1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1LPENR_DMA1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1LPENR_DMA2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1LPENR_DMA2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1LPENR_DMA2DLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAHB1LPENR_DMA2DLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAHB1LPENR_ETHMACLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHB1LPENR_ETHMACLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHB1LPENR_ETHMACTXLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAHB1LPENR_ETHMACTXLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAHB1LPENR_ETHMACRXLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAHB1LPENR_ETHMACRXLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAHB1LPENR_ETHMACPTPLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHB1LPENR_ETHMACPTPLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAHB1LPENR_OTGHSLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB1LPENR_OTGHSLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB1LPENR_OTGHSULPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHB1LPENR_OTGHSULPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHB1LPENR_AXILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB1LPENR_AXILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB1LPENR_DTCMLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHB1LPENR_DTCMLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x100000) >> 20
}

// RCC.AHB2LPENR: AHB2 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB2LPENR_OTGFSLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2LPENR_OTGFSLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2LPENR_RNGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2LPENR_RNGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2LPENR_HASHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB2LPENR_HASHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB2LPENR_CRYPLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2LPENR_CRYPLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB2LPENR_DCMILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2LPENR_DCMILPEN() uint32 {
	return volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x1
}

// RCC.AHB3LPENR: AHB3 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB3LPENR_FMCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3LPENR_FMCLPEN() uint32 {
	return volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3LPENR_QSPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB3LPENR_QSPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x2) >> 1
}

// RCC.APB1LPENR: APB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAPB1LPENR_TIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1LPENR_TIM2LPEN() uint32 {
	return volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1LPENR_TIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1LPENR_TIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1LPENR_TIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1LPENR_TIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1LPENR_TIM5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1LPENR_TIM5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1LPENR_TIM6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1LPENR_TIM6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1LPENR_TIM7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1LPENR_TIM7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1LPENR_TIM12LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1LPENR_TIM12LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1LPENR_TIM13LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1LPENR_TIM13LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1LPENR_TIM14LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1LPENR_TIM14LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1LPENR_WWDGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1LPENR_WWDGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1LPENR_SPI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1LPENR_SPI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1LPENR_SPI3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1LPENR_SPI3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1LPENR_USART2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1LPENR_USART2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1LPENR_USART3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1LPENR_USART3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1LPENR_UART4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1LPENR_UART4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1LPENR_UART5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1LPENR_UART5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1LPENR_I2C1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1LPENR_I2C1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1LPENR_I2C2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1LPENR_I2C2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1LPENR_I2C3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1LPENR_I2C3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1LPENR_CAN1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1LPENR_CAN1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1LPENR_CAN2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1LPENR_CAN2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1LPENR_PWRLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1LPENR_PWRLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1LPENR_DACLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1LPENR_DACLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1LPENR_UART7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1LPENR_UART7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1LPENR_UART8LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1LPENR_UART8LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1LPENR_SPDIFRXLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB1LPENR_SPDIFRXLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB1LPENR_CECLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPB1LPENR_CECLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPB1LPENR_LPTIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1LPENR_LPTIM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1LPENR_I2C4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1LPENR_I2C4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x1000000) >> 24
}

// RCC.APB2LPENR: APB2 peripheral clock enabled in low power mode register
func (o *RCC_Type) SetAPB2LPENR_TIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2LPENR_TIM1LPEN() uint32 {
	return volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2LPENR_TIM8LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2LPENR_TIM8LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2LPENR_USART1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2LPENR_USART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2LPENR_USART6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2LPENR_USART6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2LPENR_ADC1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2LPENR_ADC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2LPENR_ADC2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2LPENR_ADC2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB2LPENR_ADC3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB2LPENR_ADC3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB2LPENR_SPI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2LPENR_SPI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2LPENR_SPI4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2LPENR_SPI4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2LPENR_SYSCFGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2LPENR_SYSCFGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2LPENR_TIM9LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2LPENR_TIM9LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2LPENR_TIM10LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2LPENR_TIM10LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2LPENR_TIM11LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2LPENR_TIM11LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2LPENR_SPI5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2LPENR_SPI5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2LPENR_SPI6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB2LPENR_SPI6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB2LPENR_SAI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2LPENR_SAI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2LPENR_LTDCLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB2LPENR_LTDCLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB2LPENR_SAI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB2LPENR_SAI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB2LPENR_SDMMC1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2LPENR_SDMMC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x800) >> 11
}

// RCC.BDCR: Backup domain control register
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}
func (o *RCC_Type) SetBDCR_LSEDRV(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEDRV() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}

// RCC.CSR: clock control & status register
func (o *RCC_Type) SetCSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_WDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_WDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_PORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_PORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PADRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PADRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// RCC.SSCGR: spread spectrum clock generation register
func (o *RCC_Type) SetSSCGR_SSCGEN(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetSSCGR_SSCGEN() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetSSCGR_SPREADSEL(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetSSCGR_SPREADSEL() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetSSCGR_INCSTEP(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0xfffe000)|value<<13)
}
func (o *RCC_Type) GetSSCGR_INCSTEP() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0xfffe000) >> 13
}
func (o *RCC_Type) SetSSCGR_MODPER(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x1fff)|value)
}
func (o *RCC_Type) GetSSCGR_MODPER() uint32 {
	return volatile.LoadUint32(&o.SSCGR.Reg) & 0x1fff
}

// RCC.PLLI2SCFGR: PLLI2S configuration register
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SR(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SR() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SQ(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SQ() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0xf000000) >> 24
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SN(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SN() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SP(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SP() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x30000) >> 16
}

// RCC.PLLSAICFGR: PLL configuration register
func (o *RCC_Type) SetPLLSAICFGR_PLLSAIN(value uint32) {
	volatile.StoreUint32(&o.PLLSAICFGR.Reg, volatile.LoadUint32(&o.PLLSAICFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLSAICFGR_PLLSAIN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAICFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLSAICFGR_PLLSAIP(value uint32) {
	volatile.StoreUint32(&o.PLLSAICFGR.Reg, volatile.LoadUint32(&o.PLLSAICFGR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetPLLSAICFGR_PLLSAIP() uint32 {
	return (volatile.LoadUint32(&o.PLLSAICFGR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetPLLSAICFGR_PLLSAIQ(value uint32) {
	volatile.StoreUint32(&o.PLLSAICFGR.Reg, volatile.LoadUint32(&o.PLLSAICFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLSAICFGR_PLLSAIQ() uint32 {
	return (volatile.LoadUint32(&o.PLLSAICFGR.Reg) & 0xf000000) >> 24
}
func (o *RCC_Type) SetPLLSAICFGR_PLLSAIR(value uint32) {
	volatile.StoreUint32(&o.PLLSAICFGR.Reg, volatile.LoadUint32(&o.PLLSAICFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetPLLSAICFGR_PLLSAIR() uint32 {
	return (volatile.LoadUint32(&o.PLLSAICFGR.Reg) & 0x70000000) >> 28
}

// RCC.DCKCFGR1: dedicated clocks configuration register
func (o *RCC_Type) SetDCKCFGR1_PLLI2SDIVQ(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0x1f)|value)
}
func (o *RCC_Type) GetDCKCFGR1_PLLI2SDIVQ() uint32 {
	return volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0x1f
}
func (o *RCC_Type) SetDCKCFGR1_PLLSAIDIVQ(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0x1f00)|value<<8)
}
func (o *RCC_Type) GetDCKCFGR1_PLLSAIDIVQ() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0x1f00) >> 8
}
func (o *RCC_Type) SetDCKCFGR1_PLLSAIDIVR(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetDCKCFGR1_PLLSAIDIVR() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetDCKCFGR1_SAI1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetDCKCFGR1_SAI1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetDCKCFGR1_SAI2SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetDCKCFGR1_SAI2SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetDCKCFGR1_TIMPRE(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetDCKCFGR1_TIMPRE() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0x1000000) >> 24
}

// RCC.DCKCFGR2: dedicated clocks configuration register
func (o *RCC_Type) SetDCKCFGR2_USART1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetDCKCFGR2_USART1SEL() uint32 {
	return volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x3
}
func (o *RCC_Type) SetDCKCFGR2_USART2SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetDCKCFGR2_USART2SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetDCKCFGR2_USART3SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x30)|value<<4)
}
func (o *RCC_Type) GetDCKCFGR2_USART3SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x30) >> 4
}
func (o *RCC_Type) SetDCKCFGR2_UART4SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc0)|value<<6)
}
func (o *RCC_Type) GetDCKCFGR2_UART4SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc0) >> 6
}
func (o *RCC_Type) SetDCKCFGR2_UART5SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetDCKCFGR2_UART5SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetDCKCFGR2_USART6SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc00)|value<<10)
}
func (o *RCC_Type) GetDCKCFGR2_USART6SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc00) >> 10
}
func (o *RCC_Type) SetDCKCFGR2_UART7SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x3000)|value<<12)
}
func (o *RCC_Type) GetDCKCFGR2_UART7SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x3000) >> 12
}
func (o *RCC_Type) SetDCKCFGR2_UART8SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc000)|value<<14)
}
func (o *RCC_Type) GetDCKCFGR2_UART8SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc000) >> 14
}
func (o *RCC_Type) SetDCKCFGR2_I2C1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetDCKCFGR2_I2C1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetDCKCFGR2_I2C2SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc0000)|value<<18)
}
func (o *RCC_Type) GetDCKCFGR2_I2C2SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc0000) >> 18
}
func (o *RCC_Type) SetDCKCFGR2_I2C3SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetDCKCFGR2_I2C3SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetDCKCFGR2_I2C4SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetDCKCFGR2_I2C4SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetDCKCFGR2_LPTIM1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x3000000)|value<<24)
}
func (o *RCC_Type) GetDCKCFGR2_LPTIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x3000000) >> 24
}
func (o *RCC_Type) SetDCKCFGR2_CECSEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetDCKCFGR2_CECSEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetDCKCFGR2_CK48MSEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetDCKCFGR2_CK48MSEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetDCKCFGR2_SDMMC1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetDCKCFGR2_SDMMC1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x10000000) >> 28
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function lowregister
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// GPIO.BRR: GPIO port bit reset register
func (o *GPIO_Type) SetBRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBRR_BR0() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8000) >> 15
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
}

// SYSCFG.MEMRMP: memory remap register
func (o *SYSCFG_Type) SetMEMRMP_MEM_BOOT(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetMEMRMP_MEM_BOOT() uint32 {
	return volatile.LoadUint32(&o.MEMRMP.Reg) & 0x1
}
func (o *SYSCFG_Type) SetMEMRMP_SWP_FMC(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0xc00)|value<<10)
}
func (o *SYSCFG_Type) GetMEMRMP_SWP_FMC() uint32 {
	return (volatile.LoadUint32(&o.MEMRMP.Reg) & 0xc00) >> 10
}

// SYSCFG.PMC: peripheral mode configuration register
func (o *SYSCFG_Type) SetPMC_MII_RMII_SEL(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCFG_Type) GetPMC_MII_RMII_SEL() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x800000) >> 23
}
func (o *SYSCFG_Type) SetPMC_ADC1DC2(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetPMC_ADC1DC2() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetPMC_ADC2DC2(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetPMC_ADC2DC2() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetPMC_ADC3DC2(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetPMC_ADC3DC2() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x40000) >> 18
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf
}

// SYSCFG.CMPCR: Compensation cell control register
func (o *SYSCFG_Type) SetCMPCR_READY(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCMPCR_READY() uint32 {
	return (volatile.LoadUint32(&o.CMPCR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCMPCR_CMP_PD(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCMPCR_CMP_PD() uint32 {
	return volatile.LoadUint32(&o.CMPCR.Reg) & 0x1
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_CRCL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_CRCL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_NSSP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCR2_NSSP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_DS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCR2_DS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCR2_FRXTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR2_FRXTH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR2_LDMA_RX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR2_LDMA_RX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR2_LDMA_TX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR2_LDMA_TX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_FRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_FRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_CHSIDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_CHSIDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_FRLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x600)|value<<9)
}
func (o *SPI_Type) GetSR_FRLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x600) >> 9
}
func (o *SPI_Type) SetSR_FTLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1800)|value<<11)
}
func (o *SPI_Type) GetSR_FTLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1800) >> 11
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// SPI.I2SCFGR: I2S configuration register
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}
func (o *SPI_Type) SetI2SCFGR_ASTRTEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetI2SCFGR_ASTRTEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1000) >> 12
}

// SPI.I2SPR: I2S prescaler register
func (o *SPI_Type) SetI2SPR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetI2SPR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint32 {
	return volatile.LoadUint32(&o.I2SPR.Reg) & 0xff
}

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// ADC.SR: status register
func (o *ADC_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSR_STRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSR_STRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSR_JSTRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSR_JSTRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSR_JEOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSR_EOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSR_EOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetSR_AWD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSR_AWD() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// ADC.CR1: control register 1
func (o *ADC_Type) SetCR1_OVRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCR1_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCR1_RES(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3000000)|value<<24)
}
func (o *ADC_Type) GetCR1_RES() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3000000) >> 24
}
func (o *ADC_Type) SetCR1_AWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCR1_AWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCR1_JAWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR1_JAWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR1_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe000)|value<<13)
}
func (o *ADC_Type) GetCR1_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe000) >> 13
}
func (o *ADC_Type) SetCR1_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCR1_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCR1_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR1_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR1_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR1_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR1_AWDSGL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR1_AWDSGL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR1_SCAN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR1_SCAN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR1_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCR1_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCR1_AWDIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCR1_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCR1_EOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR1_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR1_AWDCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetCR1_AWDCH() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1f
}

// ADC.CR2: control register 2
func (o *ADC_Type) SetCR2_SWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR2_SWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR2_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetCR2_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetCR2_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetCR2_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetCR2_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR2_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR2_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetCR2_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetCR2_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetCR2_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetCR2_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR2_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR2_EOCS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR2_EOCS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR2_DDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR2_DDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR2_DMA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR2_DMA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR2_CONT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR2_CONT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR2_ADON(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR2_ADON() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// ADC.SMPR1: sample time register 1
func (o *ADC_Type) SetSMPR1(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, value)
}
func (o *ADC_Type) GetSMPR1() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg)
}

// ADC.SMPR2: sample time register 2
func (o *ADC_Type) SetSMPR2(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, value)
}
func (o *ADC_Type) GetSMPR2() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg)
}

// ADC.JOFR1: injected channel data offset register x
func (o *ADC_Type) SetJOFR1_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR1.Reg, volatile.LoadUint32(&o.JOFR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR1_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR1.Reg) & 0xfff
}

// ADC.JOFR2: injected channel data offset register x
func (o *ADC_Type) SetJOFR2_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR2.Reg, volatile.LoadUint32(&o.JOFR2.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR2_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR2.Reg) & 0xfff
}

// ADC.JOFR3: injected channel data offset register x
func (o *ADC_Type) SetJOFR3_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR3.Reg, volatile.LoadUint32(&o.JOFR3.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR3_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR3.Reg) & 0xfff
}

// ADC.JOFR4: injected channel data offset register x
func (o *ADC_Type) SetJOFR4_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR4.Reg, volatile.LoadUint32(&o.JOFR4.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR4_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR4.Reg) & 0xfff
}

// ADC.HTR: watchdog higher threshold register
func (o *ADC_Type) SetHTR_HT(value uint32) {
	volatile.StoreUint32(&o.HTR.Reg, volatile.LoadUint32(&o.HTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetHTR_HT() uint32 {
	return volatile.LoadUint32(&o.HTR.Reg) & 0xfff
}

// ADC.LTR: watchdog lower threshold register
func (o *ADC_Type) SetLTR_LT(value uint32) {
	volatile.StoreUint32(&o.LTR.Reg, volatile.LoadUint32(&o.LTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLTR_LT() uint32 {
	return volatile.LoadUint32(&o.LTR.Reg) & 0xfff
}

// ADC.SQR1: regular sequence register 1
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSQR1_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR1_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR1_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR1_SQ15() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR1_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR1_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR1_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR1_SQ13() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0x1f
}

// ADC.SQR2: regular sequence register 2
func (o *ADC_Type) SetSQR2_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR2_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR2_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR2_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR2_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR2_SQ10() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: regular sequence register 3
func (o *ADC_Type) SetSQR3_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR3_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR3_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR3_SQ5() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR3_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR3_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR3_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR3_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR3_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR3_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR3_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ1() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.JSQR: injected sequence register
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x1f
}

// ADC.JDR1: injected data register x
func (o *ADC_Type) SetJDR1_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, volatile.LoadUint32(&o.JDR1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR1_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg) & 0xffff
}

// ADC.JDR2: injected data register x
func (o *ADC_Type) SetJDR2_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, volatile.LoadUint32(&o.JDR2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR2_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg) & 0xffff
}

// ADC.JDR3: injected data register x
func (o *ADC_Type) SetJDR3_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, volatile.LoadUint32(&o.JDR3.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR3_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg) & 0xffff
}

// ADC.JDR4: injected data register x
func (o *ADC_Type) SetJDR4_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, volatile.LoadUint32(&o.JDR4.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR4_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg) & 0xffff
}

// ADC.DR: regular data register
func (o *ADC_Type) SetDR_DATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_DATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// DAC.CR: control register
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x380000)|value<<19)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x380000) >> 19
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DAC_Type) SetCR_BOFF2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetCR_BOFF2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCR_BOFF1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_BOFF1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DAC.SWTRIGR: software trigger register
func (o *DAC_Type) SetSWTRIGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetSWTRIGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x1
}

// DAC.DHR12R1: channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}

// DAC.DOR1: channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: status register
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}

// Power control
type PWR_Type struct {
	CR1  volatile.Register32 // 0x0
	CSR1 volatile.Register32 // 0x4
	CR2  volatile.Register32 // 0x8
	CSR2 volatile.Register32 // 0xC
}

// PWR.CR1: power control register
func (o *PWR_Type) SetCR1_LPDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR1_LPDS() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *PWR_Type) SetCR1_PDDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR1_PDDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR1_CSBF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR1_CSBF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR1_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR1_PVDE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR1_PLS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe0)|value<<5)
}
func (o *PWR_Type) GetCR1_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe0) >> 5
}
func (o *PWR_Type) SetCR1_DBP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR1_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR1_FPDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR1_FPDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR1_LPUDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR1_LPUDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR1_MRUDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCR1_MRUDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCR1_ADCDC1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR1_ADCDC1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCR1_VOS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc000)|value<<14)
}
func (o *PWR_Type) GetCR1_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc000) >> 14
}
func (o *PWR_Type) SetCR1_ODEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWR_Type) GetCR1_ODEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *PWR_Type) SetCR1_ODSWEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWR_Type) GetCR1_ODSWEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *PWR_Type) SetCR1_UDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc0000)|value<<18)
}
func (o *PWR_Type) GetCR1_UDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc0000) >> 18
}

// PWR.CSR1: power control/status register
func (o *PWR_Type) SetCSR1_WUIF(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCSR1_WUIF() uint32 {
	return volatile.LoadUint32(&o.CSR1.Reg) & 0x1
}
func (o *PWR_Type) SetCSR1_SBF(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCSR1_SBF() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCSR1_PVDO(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCSR1_PVDO() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCSR1_BRR(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCSR1_BRR() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCSR1_BRE(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCSR1_BRE() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCSR1_VOSRDY(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCSR1_VOSRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCSR1_ODRDY(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWR_Type) GetCSR1_ODRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x10000) >> 16
}
func (o *PWR_Type) SetCSR1_ODSWRDY(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWR_Type) GetCSR1_ODSWRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x20000) >> 17
}
func (o *PWR_Type) SetCSR1_UDRDY(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0xc0000)|value<<18)
}
func (o *PWR_Type) GetCSR1_UDRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0xc0000) >> 18
}

// PWR.CR2: power control register
func (o *PWR_Type) SetCR2_CWUPF1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR2_CWUPF1() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *PWR_Type) SetCR2_CWUPF2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR2_CWUPF2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR2_CWUPF3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR2_CWUPF3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR2_CWUPF4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR2_CWUPF4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR2_CWUPF5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR2_CWUPF5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR2_CWUPF6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR2_CWUPF6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR2_WUPP1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR2_WUPP1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR2_WUPP2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR2_WUPP2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR2_WUPP3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR2_WUPP3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR2_WUPP4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCR2_WUPP4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCR2_WUPP5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetCR2_WUPP5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetCR2_WUPP6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR2_WUPP6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}

// PWR.CSR2: power control/status register
func (o *PWR_Type) SetCSR2_WUPF1(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCSR2_WUPF1() uint32 {
	return volatile.LoadUint32(&o.CSR2.Reg) & 0x1
}
func (o *PWR_Type) SetCSR2_WUPF2(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCSR2_WUPF2() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCSR2_WUPF3(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCSR2_WUPF3() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCSR2_WUPF4(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCSR2_WUPF4() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCSR2_WUPF5(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCSR2_WUPF5() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCSR2_WUPF6(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCSR2_WUPF6() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCSR2_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCSR2_EWUP1() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCSR2_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCSR2_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCSR2_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCSR2_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCSR2_EWUP4(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCSR2_EWUP4() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCSR2_EWUP5(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetCSR2_EWUP5() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetCSR2_EWUP6(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCSR2_EWUP6() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x2000) >> 13
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x180)|value<<7)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x180) >> 7
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	_            [4]byte
	CCMR3_Output volatile.Register32 // 0x54
	CCR5         volatile.Register32 // 0x58
	CCR6         volatile.Register32 // 0x5C
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TIM_Type) SetCR1_UIFREMAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR1_UIFREMAP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_OIS4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetCR2_OIS4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetCR2_OIS3N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCR2_OIS3N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCR2_OIS3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCR2_OIS3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCR2_OIS2N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR2_OIS2N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *TIM_Type) SetCR2_OIS5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCR2_OIS5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCR2_OIS6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *TIM_Type) GetCR2_OIS6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *TIM_Type) SetCR2_MMS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetCR2_MMS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00000) >> 20
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_SMS_3(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSMCR_SMS_3() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}
func (o *TIM_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TIM_Type) SetSR_B2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetSR_B2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetSR_CC5IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSR_CC5IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSR_CC6IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetSR_CC6IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}
func (o *TIM_Type) SetEGR_B2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetEGR_B2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x100) >> 8
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR1_Output_OC1M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR2_Output_OC3M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR2_Output_OC4M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x1000000) >> 24
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC3NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCER_CC3NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC2NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetCCER_CC2NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}
func (o *TIM_Type) SetCCER_CC5E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCER_CC5E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCER_CC5P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetCCER_CC5P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20000) >> 17
}
func (o *TIM_Type) SetCCER_CC6E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100000)|value<<20)
}
func (o *TIM_Type) GetCCER_CC6E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100000) >> 20
}
func (o *TIM_Type) SetCCER_CC6P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200000)|value<<21)
}
func (o *TIM_Type) GetCCER_CC6P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200000) >> 21
}
func (o *TIM_Type) SetCCER_CC4NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCER_CC4NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8000) >> 15
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}
func (o *TIM_Type) SetCNT_UIFCPY(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCNT_UIFCPY() uint32 {
	return (volatile.LoadUint32(&o.CNT.Reg) & 0x80000000) >> 31
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.RCR: repetition counter register
func (o *TIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xff
}

// TIM.CCR1: capture/compare register
func (o *TIM_Type) SetCCR1_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register
func (o *TIM_Type) SetCCR2_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.CCR3: capture/compare register
func (o *TIM_Type) SetCCR3_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR3_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIM.CCR4: capture/compare register
func (o *TIM_Type) SetCCR4_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR4_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIM.BDTR: break and dead-time register
func (o *TIM_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}
func (o *TIM_Type) SetBDTR_BKF(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf0000)|value<<16)
}
func (o *TIM_Type) GetBDTR_BKF() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf0000) >> 16
}
func (o *TIM_Type) SetBDTR_BK2F(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetBDTR_BK2F() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf00000) >> 20
}
func (o *TIM_Type) SetBDTR_BK2E(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetBDTR_BK2E() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetBDTR_BK2P(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000000)|value<<25)
}
func (o *TIM_Type) GetBDTR_BK2P() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000000) >> 25
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, value)
}
func (o *TIM_Type) GetDMAR() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg)
}

// TIM.CCMR3_Output: capture/compare mode register 3 (output mode)
func (o *TIM_Type) SetCCMR3_Output_OC5FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR3_Output_OC5FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR3_Output_OC5PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR3_Output_OC5PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR3_Output_OC5M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR3_Output_OC5CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR3_Output_OC5CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR3_Output_OC6FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR3_Output_OC6FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR3_Output_OC6PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR3_Output_OC6PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR3_Output_OC6M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR3_Output_OC6CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR3_Output_OC6CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR3_Output_OC5M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR3_Output_OC6M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x1000000) >> 24
}

// TIM.CCR5: capture/compare register
func (o *TIM_Type) SetCCR5_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR5_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0xffff
}
func (o *TIM_Type) SetCCR5_GC5C1(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20000000)|value<<29)
}
func (o *TIM_Type) GetCCR5_GC5C1() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20000000) >> 29
}
func (o *TIM_Type) SetCCR5_GC5C2(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40000000)|value<<30)
}
func (o *TIM_Type) GetCCR5_GC5C2() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40000000) >> 30
}
func (o *TIM_Type) SetCCR5_GC5C3(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCCR5_GC5C3() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80000000) >> 31
}

// TIM.CCR6: capture/compare register
func (o *TIM_Type) SetCCR6_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR6_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0xffff
}

// Ethernet: media access control (MAC)
type Ethernet_Type struct {
	MACCR      volatile.Register32 // 0x0
	MACFFR     volatile.Register32 // 0x4
	MACHTHR    volatile.Register32 // 0x8
	MACHTLR    volatile.Register32 // 0xC
	MACMIIAR   volatile.Register32 // 0x10
	MACMIIDR   volatile.Register32 // 0x14
	MACFCR     volatile.Register32 // 0x18
	MACVLANTR  volatile.Register32 // 0x1C
	_          [12]byte
	MACPMTCSR  volatile.Register32 // 0x2C
	_          [4]byte
	MACDBGR    volatile.Register32 // 0x34
	MACSR      volatile.Register32 // 0x38
	MACIMR     volatile.Register32 // 0x3C
	MACA0HR    volatile.Register32 // 0x40
	MACA0LR    volatile.Register32 // 0x44
	MACA1HR    volatile.Register32 // 0x48
	MACA1LR    volatile.Register32 // 0x4C
	MACA2HR    volatile.Register32 // 0x50
	MACA2LR    volatile.Register32 // 0x54
	MACA3HR    volatile.Register32 // 0x58
	MACA3LR    volatile.Register32 // 0x5C
	MACRWUFFER volatile.Register32 // 0x60
}

// Ethernet.MACCR: Ethernet MAC configuration register
func (o *Ethernet_Type) SetMACCR_RE(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACCR_RE() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACCR_TE(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACCR_TE() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACCR_DC(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACCR_DC() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACCR_BL(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x60)|value<<5)
}
func (o *Ethernet_Type) GetMACCR_BL() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x60) >> 5
}
func (o *Ethernet_Type) SetMACCR_APCS(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x80)|value<<7)
}
func (o *Ethernet_Type) GetMACCR_APCS() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x80) >> 7
}
func (o *Ethernet_Type) SetMACCR_RD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACCR_RD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACCR_IPCO(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x400)|value<<10)
}
func (o *Ethernet_Type) GetMACCR_IPCO() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x400) >> 10
}
func (o *Ethernet_Type) SetMACCR_DM(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x800)|value<<11)
}
func (o *Ethernet_Type) GetMACCR_DM() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x800) >> 11
}
func (o *Ethernet_Type) SetMACCR_LM(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x1000)|value<<12)
}
func (o *Ethernet_Type) GetMACCR_LM() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x1000) >> 12
}
func (o *Ethernet_Type) SetMACCR_ROD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x2000)|value<<13)
}
func (o *Ethernet_Type) GetMACCR_ROD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x2000) >> 13
}
func (o *Ethernet_Type) SetMACCR_FES(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x4000)|value<<14)
}
func (o *Ethernet_Type) GetMACCR_FES() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x4000) >> 14
}
func (o *Ethernet_Type) SetMACCR_CSD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACCR_CSD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACCR_IFG(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0xe0000)|value<<17)
}
func (o *Ethernet_Type) GetMACCR_IFG() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0xe0000) >> 17
}
func (o *Ethernet_Type) SetMACCR_JD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x400000)|value<<22)
}
func (o *Ethernet_Type) GetMACCR_JD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x400000) >> 22
}
func (o *Ethernet_Type) SetMACCR_WD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x800000)|value<<23)
}
func (o *Ethernet_Type) GetMACCR_WD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x800000) >> 23
}
func (o *Ethernet_Type) SetMACCR_CSTF(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x2000000)|value<<25)
}
func (o *Ethernet_Type) GetMACCR_CSTF() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x2000000) >> 25
}

// Ethernet.MACFFR: Ethernet MAC frame filter register
func (o *Ethernet_Type) SetMACFFR_PM(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACFFR_PM() uint32 {
	return volatile.LoadUint32(&o.MACFFR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACFFR_HU(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACFFR_HU() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACFFR_HM(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACFFR_HM() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACFFR_DAIF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACFFR_DAIF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACFFR_PAM(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACFFR_PAM() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACFFR_BFD(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACFFR_BFD() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACFFR_PCF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0xc0)|value<<6)
}
func (o *Ethernet_Type) GetMACFFR_PCF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0xc0) >> 6
}
func (o *Ethernet_Type) SetMACFFR_SAIF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x80)|value<<7)
}
func (o *Ethernet_Type) GetMACFFR_SAIF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x80) >> 7
}
func (o *Ethernet_Type) SetMACFFR_SAF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACFFR_SAF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x100) >> 8
}
func (o *Ethernet_Type) SetMACFFR_HPF(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACFFR_HPF() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACFFR_RA(value uint32) {
	volatile.StoreUint32(&o.MACFFR.Reg, volatile.LoadUint32(&o.MACFFR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACFFR_RA() uint32 {
	return (volatile.LoadUint32(&o.MACFFR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACHTHR: Ethernet MAC hash table high register
func (o *Ethernet_Type) SetMACHTHR(value uint32) {
	volatile.StoreUint32(&o.MACHTHR.Reg, value)
}
func (o *Ethernet_Type) GetMACHTHR() uint32 {
	return volatile.LoadUint32(&o.MACHTHR.Reg)
}

// Ethernet.MACHTLR: Ethernet MAC hash table low register
func (o *Ethernet_Type) SetMACHTLR(value uint32) {
	volatile.StoreUint32(&o.MACHTLR.Reg, value)
}
func (o *Ethernet_Type) GetMACHTLR() uint32 {
	return volatile.LoadUint32(&o.MACHTLR.Reg)
}

// Ethernet.MACMIIAR: Ethernet MAC MII address register
func (o *Ethernet_Type) SetMACMIIAR_MB(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACMIIAR_MB() uint32 {
	return volatile.LoadUint32(&o.MACMIIAR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACMIIAR_MW(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACMIIAR_MW() uint32 {
	return (volatile.LoadUint32(&o.MACMIIAR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACMIIAR_CR(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0x1c)|value<<2)
}
func (o *Ethernet_Type) GetMACMIIAR_CR() uint32 {
	return (volatile.LoadUint32(&o.MACMIIAR.Reg) & 0x1c) >> 2
}
func (o *Ethernet_Type) SetMACMIIAR_MR(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0x7c0)|value<<6)
}
func (o *Ethernet_Type) GetMACMIIAR_MR() uint32 {
	return (volatile.LoadUint32(&o.MACMIIAR.Reg) & 0x7c0) >> 6
}
func (o *Ethernet_Type) SetMACMIIAR_PA(value uint32) {
	volatile.StoreUint32(&o.MACMIIAR.Reg, volatile.LoadUint32(&o.MACMIIAR.Reg)&^(0xf800)|value<<11)
}
func (o *Ethernet_Type) GetMACMIIAR_PA() uint32 {
	return (volatile.LoadUint32(&o.MACMIIAR.Reg) & 0xf800) >> 11
}

// Ethernet.MACMIIDR: Ethernet MAC MII data register
func (o *Ethernet_Type) SetMACMIIDR_MD(value uint32) {
	volatile.StoreUint32(&o.MACMIIDR.Reg, volatile.LoadUint32(&o.MACMIIDR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACMIIDR_MD() uint32 {
	return volatile.LoadUint32(&o.MACMIIDR.Reg) & 0xffff
}

// Ethernet.MACFCR: Ethernet MAC flow control register
func (o *Ethernet_Type) SetMACFCR_FCB(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACFCR_FCB() uint32 {
	return volatile.LoadUint32(&o.MACFCR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACFCR_TFCE(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACFCR_TFCE() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACFCR_RFCE(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACFCR_RFCE() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACFCR_UPFD(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACFCR_UPFD() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACFCR_PLT(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x30)|value<<4)
}
func (o *Ethernet_Type) GetMACFCR_PLT() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x30) >> 4
}
func (o *Ethernet_Type) SetMACFCR_ZQPD(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0x80)|value<<7)
}
func (o *Ethernet_Type) GetMACFCR_ZQPD() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0x80) >> 7
}
func (o *Ethernet_Type) SetMACFCR_PT(value uint32) {
	volatile.StoreUint32(&o.MACFCR.Reg, volatile.LoadUint32(&o.MACFCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *Ethernet_Type) GetMACFCR_PT() uint32 {
	return (volatile.LoadUint32(&o.MACFCR.Reg) & 0xffff0000) >> 16
}

// Ethernet.MACVLANTR: Ethernet MAC VLAN tag register
func (o *Ethernet_Type) SetMACVLANTR_VLANTI(value uint32) {
	volatile.StoreUint32(&o.MACVLANTR.Reg, volatile.LoadUint32(&o.MACVLANTR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACVLANTR_VLANTI() uint32 {
	return volatile.LoadUint32(&o.MACVLANTR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACVLANTR_VLANTC(value uint32) {
	volatile.StoreUint32(&o.MACVLANTR.Reg, volatile.LoadUint32(&o.MACVLANTR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACVLANTR_VLANTC() uint32 {
	return (volatile.LoadUint32(&o.MACVLANTR.Reg) & 0x10000) >> 16
}

// Ethernet.MACPMTCSR: Ethernet MAC PMT control and status register
func (o *Ethernet_Type) SetMACPMTCSR_PD(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACPMTCSR_PD() uint32 {
	return volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACPMTCSR_MPE(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACPMTCSR_MPE() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACPMTCSR_WFE(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACPMTCSR_WFE() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACPMTCSR_MPR(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACPMTCSR_MPR() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACPMTCSR_WFR(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x40)|value<<6)
}
func (o *Ethernet_Type) GetMACPMTCSR_WFR() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x40) >> 6
}
func (o *Ethernet_Type) SetMACPMTCSR_GU(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACPMTCSR_GU() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACPMTCSR_WFFRPR(value uint32) {
	volatile.StoreUint32(&o.MACPMTCSR.Reg, volatile.LoadUint32(&o.MACPMTCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACPMTCSR_WFFRPR() uint32 {
	return (volatile.LoadUint32(&o.MACPMTCSR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACDBGR: Ethernet MAC debug register
func (o *Ethernet_Type) SetMACDBGR_TFF(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x2000000)|value<<25)
}
func (o *Ethernet_Type) GetMACDBGR_TFF() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x2000000) >> 25
}
func (o *Ethernet_Type) SetMACDBGR_TFNE(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x1000000)|value<<24)
}
func (o *Ethernet_Type) GetMACDBGR_TFNE() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x1000000) >> 24
}
func (o *Ethernet_Type) SetMACDBGR_TFWA(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x400000)|value<<22)
}
func (o *Ethernet_Type) GetMACDBGR_TFWA() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x400000) >> 22
}
func (o *Ethernet_Type) SetMACDBGR_TFRS(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x300000)|value<<20)
}
func (o *Ethernet_Type) GetMACDBGR_TFRS() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x300000) >> 20
}
func (o *Ethernet_Type) SetMACDBGR_MTP(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACDBGR_MTP() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACDBGR_MTFCS(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x60000)|value<<17)
}
func (o *Ethernet_Type) GetMACDBGR_MTFCS() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x60000) >> 17
}
func (o *Ethernet_Type) SetMACDBGR_MMTEA(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACDBGR_MMTEA() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACDBGR_RFFL(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x300)|value<<8)
}
func (o *Ethernet_Type) GetMACDBGR_RFFL() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x300) >> 8
}
func (o *Ethernet_Type) SetMACDBGR_RFRCS(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x60)|value<<5)
}
func (o *Ethernet_Type) GetMACDBGR_RFRCS() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x60) >> 5
}
func (o *Ethernet_Type) SetMACDBGR_RFWRA(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACDBGR_RFWRA() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACDBGR_MSFRWCS(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x6)|value<<1)
}
func (o *Ethernet_Type) GetMACDBGR_MSFRWCS() uint32 {
	return (volatile.LoadUint32(&o.MACDBGR.Reg) & 0x6) >> 1
}
func (o *Ethernet_Type) SetMACDBGR_MMRPEA(value uint32) {
	volatile.StoreUint32(&o.MACDBGR.Reg, volatile.LoadUint32(&o.MACDBGR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACDBGR_MMRPEA() uint32 {
	return volatile.LoadUint32(&o.MACDBGR.Reg) & 0x1
}

// Ethernet.MACSR: Ethernet MAC interrupt status register
func (o *Ethernet_Type) SetMACSR_PMTS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACSR_PMTS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACSR_MMCS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACSR_MMCS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACSR_MMCRS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACSR_MMCRS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACSR_MMCTS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x40)|value<<6)
}
func (o *Ethernet_Type) GetMACSR_MMCTS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x40) >> 6
}
func (o *Ethernet_Type) SetMACSR_TSTS(value uint32) {
	volatile.StoreUint32(&o.MACSR.Reg, volatile.LoadUint32(&o.MACSR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACSR_TSTS() uint32 {
	return (volatile.LoadUint32(&o.MACSR.Reg) & 0x200) >> 9
}

// Ethernet.MACIMR: Ethernet MAC interrupt mask register
func (o *Ethernet_Type) SetMACIMR_PMTIM(value uint32) {
	volatile.StoreUint32(&o.MACIMR.Reg, volatile.LoadUint32(&o.MACIMR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACIMR_PMTIM() uint32 {
	return (volatile.LoadUint32(&o.MACIMR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACIMR_TSTIM(value uint32) {
	volatile.StoreUint32(&o.MACIMR.Reg, volatile.LoadUint32(&o.MACIMR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACIMR_TSTIM() uint32 {
	return (volatile.LoadUint32(&o.MACIMR.Reg) & 0x200) >> 9
}

// Ethernet.MACA0HR: Ethernet MAC address 0 high register
func (o *Ethernet_Type) SetMACA0HR_MACA0H(value uint32) {
	volatile.StoreUint32(&o.MACA0HR.Reg, volatile.LoadUint32(&o.MACA0HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA0HR_MACA0H() uint32 {
	return volatile.LoadUint32(&o.MACA0HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA0HR_MO(value uint32) {
	volatile.StoreUint32(&o.MACA0HR.Reg, volatile.LoadUint32(&o.MACA0HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA0HR_MO() uint32 {
	return (volatile.LoadUint32(&o.MACA0HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA0LR: Ethernet MAC address 0 low register
func (o *Ethernet_Type) SetMACA0LR(value uint32) {
	volatile.StoreUint32(&o.MACA0LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA0LR() uint32 {
	return volatile.LoadUint32(&o.MACA0LR.Reg)
}

// Ethernet.MACA1HR: Ethernet MAC address 1 high register
func (o *Ethernet_Type) SetMACA1HR_MACA1H(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA1HR_MACA1H() uint32 {
	return volatile.LoadUint32(&o.MACA1HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA1HR_MBC(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0x3f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACA1HR_MBC() uint32 {
	return (volatile.LoadUint32(&o.MACA1HR.Reg) & 0x3f000000) >> 24
}
func (o *Ethernet_Type) SetMACA1HR_SA(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0x40000000)|value<<30)
}
func (o *Ethernet_Type) GetMACA1HR_SA() uint32 {
	return (volatile.LoadUint32(&o.MACA1HR.Reg) & 0x40000000) >> 30
}
func (o *Ethernet_Type) SetMACA1HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA1HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA1HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA1LR: Ethernet MAC address1 low register
func (o *Ethernet_Type) SetMACA1LR(value uint32) {
	volatile.StoreUint32(&o.MACA1LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA1LR() uint32 {
	return volatile.LoadUint32(&o.MACA1LR.Reg)
}

// Ethernet.MACA2HR: Ethernet MAC address 2 high register
func (o *Ethernet_Type) SetMACA2HR_MACA2H(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA2HR_MACA2H() uint32 {
	return volatile.LoadUint32(&o.MACA2HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA2HR_MBC(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0x3f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACA2HR_MBC() uint32 {
	return (volatile.LoadUint32(&o.MACA2HR.Reg) & 0x3f000000) >> 24
}
func (o *Ethernet_Type) SetMACA2HR_SA(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0x40000000)|value<<30)
}
func (o *Ethernet_Type) GetMACA2HR_SA() uint32 {
	return (volatile.LoadUint32(&o.MACA2HR.Reg) & 0x40000000) >> 30
}
func (o *Ethernet_Type) SetMACA2HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA2HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA2HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA2LR: Ethernet MAC address 2 low register
func (o *Ethernet_Type) SetMACA2LR(value uint32) {
	volatile.StoreUint32(&o.MACA2LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA2LR() uint32 {
	return volatile.LoadUint32(&o.MACA2LR.Reg)
}

// Ethernet.MACA3HR: Ethernet MAC address 3 high register
func (o *Ethernet_Type) SetMACA3HR_MACA3H(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA3HR_MACA3H() uint32 {
	return volatile.LoadUint32(&o.MACA3HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA3HR_MBC(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0x3f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACA3HR_MBC() uint32 {
	return (volatile.LoadUint32(&o.MACA3HR.Reg) & 0x3f000000) >> 24
}
func (o *Ethernet_Type) SetMACA3HR_SA(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0x40000000)|value<<30)
}
func (o *Ethernet_Type) GetMACA3HR_SA() uint32 {
	return (volatile.LoadUint32(&o.MACA3HR.Reg) & 0x40000000) >> 30
}
func (o *Ethernet_Type) SetMACA3HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA3HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA3HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA3LR: Ethernet MAC address 3 low register
func (o *Ethernet_Type) SetMACA3LR(value uint32) {
	volatile.StoreUint32(&o.MACA3LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA3LR() uint32 {
	return volatile.LoadUint32(&o.MACA3LR.Reg)
}

// Cryptographic processor
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent Data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xff
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: CRC polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TX    [3]CAN_TX_Type // 0x180
	RX    [2]CAN_RX_Type // 0x1B0
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	FB    [28]CAN_FB_Type // 0x240
}

// CAN.MCR: master control register
func (o *CAN_Type) SetMCR_DBF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetMCR_DBF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetMCR_RESET(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetMCR_RESET() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetMCR_TTCM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetMCR_TTCM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetMCR_ABOM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetMCR_ABOM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetMCR_AWUM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetMCR_AWUM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetMCR_NART(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMCR_NART() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMCR_RFLM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMCR_RFLM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMCR_TXFP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMCR_TXFP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMCR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMCR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMCR_INRQ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMCR_INRQ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}

// CAN.MSR: master status register
func (o *CAN_Type) SetMSR_RX(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetMSR_RX() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetMSR_SAMP(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetMSR_SAMP() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetMSR_RXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetMSR_RXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetMSR_TXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetMSR_TXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetMSR_SLAKI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMSR_SLAKI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMSR_WKUI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMSR_WKUI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMSR_ERRI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMSR_ERRI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMSR_SLAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMSR_SLAK() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMSR_INAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMSR_INAK() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}

// CAN.TSR: transmit status register
func (o *CAN_Type) SetTSR_LOW2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTSR_LOW2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetTSR_LOW1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetTSR_LOW1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetTSR_LOW0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetTSR_LOW0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000000) >> 29
}
func (o *CAN_Type) SetTSR_TME2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetTSR_TME2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000000) >> 28
}
func (o *CAN_Type) SetTSR_TME1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetTSR_TME1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetTSR_TME0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetTSR_TME0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetTSR_CODE(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetTSR_CODE() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetTSR_ABRQ2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetTSR_ABRQ2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetTSR_TERR2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetTSR_TERR2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetTSR_ALST2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetTSR_ALST2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetTSR_TXOK2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetTSR_TXOK2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetTSR_RQCP2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetTSR_RQCP2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetTSR_ABRQ1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetTSR_ABRQ1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetTSR_TERR1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetTSR_TERR1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetTSR_ALST1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetTSR_ALST1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetTSR_TXOK1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetTSR_TXOK1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetTSR_RQCP1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetTSR_RQCP1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetTSR_ABRQ0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetTSR_ABRQ0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetTSR_TERR0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetTSR_TERR0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetTSR_ALST0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetTSR_ALST0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetTSR_TXOK0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetTSR_TXOK0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetTSR_RQCP0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetTSR_RQCP0() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}

// CAN.RF0R: receive FIFO %s register
func (o *CAN_Type) SetRF0R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF0R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF0R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF0R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF0R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF0R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF0R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF0R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF0R.Reg) & 0x3
}

// CAN.RF1R: receive FIFO %s register
func (o *CAN_Type) SetRF1R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF1R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF1R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF1R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF1R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF1R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF1R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF1R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF1R.Reg) & 0x3
}

// CAN.IER: interrupt enable register
func (o *CAN_Type) SetIER_SLKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetIER_SLKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetIER_WKUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetIER_WKUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetIER_ERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetIER_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetIER_LECIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetIER_LECIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetIER_BOFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetIER_BOFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetIER_EPVIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetIER_EPVIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetIER_EWGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetIER_EWGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetIER_FOVIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIER_FOVIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIER_FFIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIER_FFIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIER_FMPIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIER_FMPIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIER_FOVIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIER_FOVIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIER_FFIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIER_FFIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIER_FMPIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIER_FMPIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIER_TMEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIER_TMEIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// CAN.ESR: interrupt enable register
func (o *CAN_Type) SetESR_REC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetESR_REC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff000000) >> 24
}
func (o *CAN_Type) SetESR_TEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetESR_TEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetESR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x70)|value<<4)
}
func (o *CAN_Type) GetESR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x70) >> 4
}
func (o *CAN_Type) SetESR_BOFF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetESR_BOFF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetESR_EPVF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetESR_EPVF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetESR_EWGF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetESR_EWGF() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}

// CAN.BTR: bit timing register
func (o *CAN_Type) SetBTR_SILM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetBTR_SILM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetBTR_LBKM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetBTR_LBKM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetBTR_SJW(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetBTR_SJW() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetBTR_TS2(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x700000)|value<<20)
}
func (o *CAN_Type) GetBTR_TS2() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x700000) >> 20
}
func (o *CAN_Type) SetBTR_TS1(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetBTR_TS1() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetBTR_BRP(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3ff)|value)
}
func (o *CAN_Type) GetBTR_BRP() uint32 {
	return volatile.LoadUint32(&o.BTR.Reg) & 0x3ff
}

// CAN.FMR: filter master register
func (o *CAN_Type) SetFMR_CAN2SB(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x3f00)|value<<8)
}
func (o *CAN_Type) GetFMR_CAN2SB() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x3f00) >> 8
}
func (o *CAN_Type) SetFMR_FINIT(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFMR_FINIT() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}

// CAN.FM1R: filter mode register
func (o *CAN_Type) SetFM1R_FBM0(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFM1R_FBM0() uint32 {
	return volatile.LoadUint32(&o.FM1R.Reg) & 0x1
}
func (o *CAN_Type) SetFM1R_FBM1(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFM1R_FBM1() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFM1R_FBM2(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFM1R_FBM2() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFM1R_FBM3(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFM1R_FBM3() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFM1R_FBM4(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFM1R_FBM4() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFM1R_FBM5(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFM1R_FBM5() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFM1R_FBM6(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFM1R_FBM6() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFM1R_FBM7(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFM1R_FBM7() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFM1R_FBM8(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFM1R_FBM8() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFM1R_FBM9(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFM1R_FBM9() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFM1R_FBM10(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFM1R_FBM10() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFM1R_FBM11(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFM1R_FBM11() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFM1R_FBM12(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFM1R_FBM12() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFM1R_FBM13(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFM1R_FBM13() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFM1R_FBM14(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFM1R_FBM14() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFM1R_FBM15(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFM1R_FBM15() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFM1R_FBM16(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFM1R_FBM16() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFM1R_FBM17(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFM1R_FBM17() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFM1R_FBM18(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFM1R_FBM18() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFM1R_FBM19(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFM1R_FBM19() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFM1R_FBM20(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFM1R_FBM20() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFM1R_FBM21(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFM1R_FBM21() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFM1R_FBM22(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFM1R_FBM22() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFM1R_FBM23(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFM1R_FBM23() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFM1R_FBM24(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFM1R_FBM24() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFM1R_FBM25(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFM1R_FBM25() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFM1R_FBM26(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFM1R_FBM26() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFM1R_FBM27(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFM1R_FBM27() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000000) >> 27
}

// CAN.FS1R: filter scale register
func (o *CAN_Type) SetFS1R_FSC0(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFS1R_FSC0() uint32 {
	return volatile.LoadUint32(&o.FS1R.Reg) & 0x1
}
func (o *CAN_Type) SetFS1R_FSC1(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFS1R_FSC1() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFS1R_FSC2(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFS1R_FSC2() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFS1R_FSC3(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFS1R_FSC3() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFS1R_FSC4(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFS1R_FSC4() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFS1R_FSC5(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFS1R_FSC5() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFS1R_FSC6(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFS1R_FSC6() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFS1R_FSC7(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFS1R_FSC7() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFS1R_FSC8(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFS1R_FSC8() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFS1R_FSC9(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFS1R_FSC9() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFS1R_FSC10(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFS1R_FSC10() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFS1R_FSC11(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFS1R_FSC11() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFS1R_FSC12(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFS1R_FSC12() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFS1R_FSC13(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFS1R_FSC13() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFS1R_FSC14(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFS1R_FSC14() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFS1R_FSC15(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFS1R_FSC15() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFS1R_FSC16(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFS1R_FSC16() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFS1R_FSC17(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFS1R_FSC17() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFS1R_FSC18(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFS1R_FSC18() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFS1R_FSC19(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFS1R_FSC19() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFS1R_FSC20(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFS1R_FSC20() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFS1R_FSC21(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFS1R_FSC21() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFS1R_FSC22(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFS1R_FSC22() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFS1R_FSC23(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFS1R_FSC23() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFS1R_FSC24(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFS1R_FSC24() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFS1R_FSC25(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFS1R_FSC25() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFS1R_FSC26(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFS1R_FSC26() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFS1R_FSC27(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFS1R_FSC27() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000000) >> 27
}

// CAN.FFA1R: filter FIFO assignment register
func (o *CAN_Type) SetFFA1R_FFA0(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFFA1R_FFA0() uint32 {
	return volatile.LoadUint32(&o.FFA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFFA1R_FFA1(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFFA1R_FFA1() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFFA1R_FFA2(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFFA1R_FFA2() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFFA1R_FFA3(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFFA1R_FFA3() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFFA1R_FFA4(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFFA1R_FFA4() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFFA1R_FFA5(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFFA1R_FFA5() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFFA1R_FFA6(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFFA1R_FFA6() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFFA1R_FFA7(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFFA1R_FFA7() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFFA1R_FFA8(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFFA1R_FFA8() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFFA1R_FFA9(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFFA1R_FFA9() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFFA1R_FFA10(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFFA1R_FFA10() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFFA1R_FFA11(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFFA1R_FFA11() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFFA1R_FFA12(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFFA1R_FFA12() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFFA1R_FFA13(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFFA1R_FFA13() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFFA1R_FFA14(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFFA1R_FFA14() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFFA1R_FFA15(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFFA1R_FFA15() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFFA1R_FFA16(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFFA1R_FFA16() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFFA1R_FFA17(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFFA1R_FFA17() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFFA1R_FFA18(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFFA1R_FFA18() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFFA1R_FFA19(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFFA1R_FFA19() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFFA1R_FFA20(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFFA1R_FFA20() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFFA1R_FFA21(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFFA1R_FFA21() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFFA1R_FFA22(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFFA1R_FFA22() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFFA1R_FFA23(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFFA1R_FFA23() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFFA1R_FFA24(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFFA1R_FFA24() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFFA1R_FFA25(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFFA1R_FFA25() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFFA1R_FFA26(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFFA1R_FFA26() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFFA1R_FFA27(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFFA1R_FFA27() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000000) >> 27
}

// CAN.FA1R: filter activation register
func (o *CAN_Type) SetFA1R_FACT0(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFA1R_FACT0() uint32 {
	return volatile.LoadUint32(&o.FA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFA1R_FACT1(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFA1R_FACT1() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFA1R_FACT2(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFA1R_FACT2() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFA1R_FACT3(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFA1R_FACT3() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFA1R_FACT4(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFA1R_FACT4() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFA1R_FACT5(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFA1R_FACT5() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFA1R_FACT6(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFA1R_FACT6() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFA1R_FACT7(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFA1R_FACT7() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFA1R_FACT8(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFA1R_FACT8() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFA1R_FACT9(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFA1R_FACT9() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFA1R_FACT10(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFA1R_FACT10() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFA1R_FACT11(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFA1R_FACT11() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFA1R_FACT12(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFA1R_FACT12() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFA1R_FACT13(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFA1R_FACT13() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFA1R_FACT14(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFA1R_FACT14() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFA1R_FACT15(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFA1R_FACT15() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFA1R_FACT16(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFA1R_FACT16() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFA1R_FACT17(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFA1R_FACT17() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFA1R_FACT18(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFA1R_FACT18() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFA1R_FACT19(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFA1R_FACT19() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFA1R_FACT20(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFA1R_FACT20() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFA1R_FACT21(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFA1R_FACT21() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFA1R_FACT22(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFA1R_FACT22() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFA1R_FACT23(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFA1R_FACT23() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFA1R_FACT24(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFA1R_FACT24() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFA1R_FACT25(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFA1R_FACT25() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFA1R_FACT26(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFA1R_FACT26() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFA1R_FACT27(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFA1R_FACT27() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000000) >> 27
}

type CAN_TX_Type struct {
	TIR  volatile.Register32 // 0x180
	TDTR volatile.Register32 // 0x184
	TDLR volatile.Register32 // 0x188
	TDHR volatile.Register32 // 0x18C
}

// CAN_TX.TIR: TX mailbox identifier register
func (o *CAN_TX_Type) SetTIR_STID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_TX_Type) GetTIR_STID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_TX_Type) SetTIR_EXID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_TX_Type) GetTIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_TX_Type) SetTIR_IDE(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_TX_Type) GetTIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x4) >> 2
}
func (o *CAN_TX_Type) SetTIR_RTR(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_TX_Type) GetTIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x2) >> 1
}
func (o *CAN_TX_Type) SetTIR_TXRQ(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1)|value)
}
func (o *CAN_TX_Type) GetTIR_TXRQ() uint32 {
	return volatile.LoadUint32(&o.TIR.Reg) & 0x1
}

// CAN_TX.TDTR: mailbox data length control and time stamp register
func (o *CAN_TX_Type) SetTDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_TX_Type) SetTDTR_TGT(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_TX_Type) GetTDTR_TGT() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0x100) >> 8
}
func (o *CAN_TX_Type) SetTDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xf)|value)
}
func (o *CAN_TX_Type) GetTDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.TDTR.Reg) & 0xf
}

// CAN_TX.TDLR: mailbox data low register
func (o *CAN_TX_Type) SetTDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.TDLR.Reg) & 0xff
}

// CAN_TX.TDHR: mailbox data high register
func (o *CAN_TX_Type) SetTDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.TDHR.Reg) & 0xff
}

type CAN_RX_Type struct {
	RIR  volatile.Register32 // 0x1B0
	RDTR volatile.Register32 // 0x1B4
	RDLR volatile.Register32 // 0x1B8
	RDHR volatile.Register32 // 0x1BC
}

// CAN_RX.RIR: receive FIFO mailbox identifier register
func (o *CAN_RX_Type) SetRIR_STID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_RX_Type) GetRIR_STID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_RX_Type) SetRIR_EXID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_RX_Type) GetRIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_RX_Type) SetRIR_IDE(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_RX_Type) GetRIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x4) >> 2
}
func (o *CAN_RX_Type) SetRIR_RTR(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_RX_Type) GetRIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x2) >> 1
}

// CAN_RX.RDTR: mailbox data high register
func (o *CAN_RX_Type) SetRDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_RX_Type) SetRDTR_FMI(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDTR_FMI() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xf)|value)
}
func (o *CAN_RX_Type) GetRDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.RDTR.Reg) & 0xf
}

// CAN_RX.RDLR: mailbox data high register
func (o *CAN_RX_Type) SetRDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RDLR.Reg) & 0xff
}

// CAN_RX.RDHR: receive FIFO mailbox data high register
func (o *CAN_RX_Type) SetRDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RDHR.Reg) & 0xff
}

type CAN_FB_Type struct {
	FR1 volatile.Register32 // 0x240
	FR2 volatile.Register32 // 0x244
}

// CAN_FB.FR1: Filter bank 0 register 1
func (o *CAN_FB_Type) SetFR1_FB0(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x1)|value)
}
func (o *CAN_FB_Type) GetFR1_FB0() uint32 {
	return volatile.LoadUint32(&o.FR1.Reg) & 0x1
}
func (o *CAN_FB_Type) SetFR1_FB1(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x2)|value<<1)
}
func (o *CAN_FB_Type) GetFR1_FB1() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x2) >> 1
}
func (o *CAN_FB_Type) SetFR1_FB2(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x4)|value<<2)
}
func (o *CAN_FB_Type) GetFR1_FB2() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x4) >> 2
}
func (o *CAN_FB_Type) SetFR1_FB3(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x8)|value<<3)
}
func (o *CAN_FB_Type) GetFR1_FB3() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x8) >> 3
}
func (o *CAN_FB_Type) SetFR1_FB4(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x10)|value<<4)
}
func (o *CAN_FB_Type) GetFR1_FB4() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x10) >> 4
}
func (o *CAN_FB_Type) SetFR1_FB5(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x20)|value<<5)
}
func (o *CAN_FB_Type) GetFR1_FB5() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x20) >> 5
}
func (o *CAN_FB_Type) SetFR1_FB6(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x40)|value<<6)
}
func (o *CAN_FB_Type) GetFR1_FB6() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x40) >> 6
}
func (o *CAN_FB_Type) SetFR1_FB7(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x80)|value<<7)
}
func (o *CAN_FB_Type) GetFR1_FB7() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x80) >> 7
}
func (o *CAN_FB_Type) SetFR1_FB8(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x100)|value<<8)
}
func (o *CAN_FB_Type) GetFR1_FB8() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x100) >> 8
}
func (o *CAN_FB_Type) SetFR1_FB9(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x200)|value<<9)
}
func (o *CAN_FB_Type) GetFR1_FB9() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x200) >> 9
}
func (o *CAN_FB_Type) SetFR1_FB10(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x400)|value<<10)
}
func (o *CAN_FB_Type) GetFR1_FB10() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x400) >> 10
}
func (o *CAN_FB_Type) SetFR1_FB11(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x800)|value<<11)
}
func (o *CAN_FB_Type) GetFR1_FB11() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x800) >> 11
}
func (o *CAN_FB_Type) SetFR1_FB12(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_FB_Type) GetFR1_FB12() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x1000) >> 12
}
func (o *CAN_FB_Type) SetFR1_FB13(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_FB_Type) GetFR1_FB13() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x2000) >> 13
}
func (o *CAN_FB_Type) SetFR1_FB14(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_FB_Type) GetFR1_FB14() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x4000) >> 14
}
func (o *CAN_FB_Type) SetFR1_FB15(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_FB_Type) GetFR1_FB15() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x8000) >> 15
}
func (o *CAN_FB_Type) SetFR1_FB16(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_FB_Type) GetFR1_FB16() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x10000) >> 16
}
func (o *CAN_FB_Type) SetFR1_FB17(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_FB_Type) GetFR1_FB17() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x20000) >> 17
}
func (o *CAN_FB_Type) SetFR1_FB18(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_FB_Type) GetFR1_FB18() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x40000) >> 18
}
func (o *CAN_FB_Type) SetFR1_FB19(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_FB_Type) GetFR1_FB19() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x80000) >> 19
}
func (o *CAN_FB_Type) SetFR1_FB20(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_FB_Type) GetFR1_FB20() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x100000) >> 20
}
func (o *CAN_FB_Type) SetFR1_FB21(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_FB_Type) GetFR1_FB21() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x200000) >> 21
}
func (o *CAN_FB_Type) SetFR1_FB22(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_FB_Type) GetFR1_FB22() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x400000) >> 22
}
func (o *CAN_FB_Type) SetFR1_FB23(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_FB_Type) GetFR1_FB23() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x800000) >> 23
}
func (o *CAN_FB_Type) SetFR1_FB24(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_FB_Type) GetFR1_FB24() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x1000000) >> 24
}
func (o *CAN_FB_Type) SetFR1_FB25(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_FB_Type) GetFR1_FB25() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x2000000) >> 25
}
func (o *CAN_FB_Type) SetFR1_FB26(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_FB_Type) GetFR1_FB26() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x4000000) >> 26
}
func (o *CAN_FB_Type) SetFR1_FB27(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_FB_Type) GetFR1_FB27() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x8000000) >> 27
}
func (o *CAN_FB_Type) SetFR1_FB28(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_FB_Type) GetFR1_FB28() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x10000000) >> 28
}
func (o *CAN_FB_Type) SetFR1_FB29(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_FB_Type) GetFR1_FB29() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x20000000) >> 29
}
func (o *CAN_FB_Type) SetFR1_FB30(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_FB_Type) GetFR1_FB30() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x40000000) >> 30
}
func (o *CAN_FB_Type) SetFR1_FB31(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_FB_Type) GetFR1_FB31() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x80000000) >> 31
}

// CAN_FB.FR2: Filter bank 0 register 2
func (o *CAN_FB_Type) SetFR2_FB0(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x1)|value)
}
func (o *CAN_FB_Type) GetFR2_FB0() uint32 {
	return volatile.LoadUint32(&o.FR2.Reg) & 0x1
}
func (o *CAN_FB_Type) SetFR2_FB1(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x2)|value<<1)
}
func (o *CAN_FB_Type) GetFR2_FB1() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x2) >> 1
}
func (o *CAN_FB_Type) SetFR2_FB2(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x4)|value<<2)
}
func (o *CAN_FB_Type) GetFR2_FB2() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x4) >> 2
}
func (o *CAN_FB_Type) SetFR2_FB3(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x8)|value<<3)
}
func (o *CAN_FB_Type) GetFR2_FB3() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x8) >> 3
}
func (o *CAN_FB_Type) SetFR2_FB4(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x10)|value<<4)
}
func (o *CAN_FB_Type) GetFR2_FB4() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x10) >> 4
}
func (o *CAN_FB_Type) SetFR2_FB5(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x20)|value<<5)
}
func (o *CAN_FB_Type) GetFR2_FB5() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x20) >> 5
}
func (o *CAN_FB_Type) SetFR2_FB6(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x40)|value<<6)
}
func (o *CAN_FB_Type) GetFR2_FB6() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x40) >> 6
}
func (o *CAN_FB_Type) SetFR2_FB7(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x80)|value<<7)
}
func (o *CAN_FB_Type) GetFR2_FB7() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x80) >> 7
}
func (o *CAN_FB_Type) SetFR2_FB8(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x100)|value<<8)
}
func (o *CAN_FB_Type) GetFR2_FB8() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x100) >> 8
}
func (o *CAN_FB_Type) SetFR2_FB9(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x200)|value<<9)
}
func (o *CAN_FB_Type) GetFR2_FB9() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x200) >> 9
}
func (o *CAN_FB_Type) SetFR2_FB10(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x400)|value<<10)
}
func (o *CAN_FB_Type) GetFR2_FB10() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x400) >> 10
}
func (o *CAN_FB_Type) SetFR2_FB11(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x800)|value<<11)
}
func (o *CAN_FB_Type) GetFR2_FB11() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x800) >> 11
}
func (o *CAN_FB_Type) SetFR2_FB12(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_FB_Type) GetFR2_FB12() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x1000) >> 12
}
func (o *CAN_FB_Type) SetFR2_FB13(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_FB_Type) GetFR2_FB13() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x2000) >> 13
}
func (o *CAN_FB_Type) SetFR2_FB14(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_FB_Type) GetFR2_FB14() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x4000) >> 14
}
func (o *CAN_FB_Type) SetFR2_FB15(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_FB_Type) GetFR2_FB15() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x8000) >> 15
}
func (o *CAN_FB_Type) SetFR2_FB16(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_FB_Type) GetFR2_FB16() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x10000) >> 16
}
func (o *CAN_FB_Type) SetFR2_FB17(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_FB_Type) GetFR2_FB17() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x20000) >> 17
}
func (o *CAN_FB_Type) SetFR2_FB18(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_FB_Type) GetFR2_FB18() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x40000) >> 18
}
func (o *CAN_FB_Type) SetFR2_FB19(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_FB_Type) GetFR2_FB19() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x80000) >> 19
}
func (o *CAN_FB_Type) SetFR2_FB20(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_FB_Type) GetFR2_FB20() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x100000) >> 20
}
func (o *CAN_FB_Type) SetFR2_FB21(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_FB_Type) GetFR2_FB21() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x200000) >> 21
}
func (o *CAN_FB_Type) SetFR2_FB22(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_FB_Type) GetFR2_FB22() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x400000) >> 22
}
func (o *CAN_FB_Type) SetFR2_FB23(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_FB_Type) GetFR2_FB23() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x800000) >> 23
}
func (o *CAN_FB_Type) SetFR2_FB24(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_FB_Type) GetFR2_FB24() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x1000000) >> 24
}
func (o *CAN_FB_Type) SetFR2_FB25(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_FB_Type) GetFR2_FB25() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x2000000) >> 25
}
func (o *CAN_FB_Type) SetFR2_FB26(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_FB_Type) GetFR2_FB26() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x4000000) >> 26
}
func (o *CAN_FB_Type) SetFR2_FB27(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_FB_Type) GetFR2_FB27() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x8000000) >> 27
}
func (o *CAN_FB_Type) SetFR2_FB28(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_FB_Type) GetFR2_FB28() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x10000000) >> 28
}
func (o *CAN_FB_Type) SetFR2_FB29(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_FB_Type) GetFR2_FB29() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x20000000) >> 29
}
func (o *CAN_FB_Type) SetFR2_FB30(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_FB_Type) GetFR2_FB30() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x40000000) >> 30
}
func (o *CAN_FB_Type) SetFR2_FB31(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_FB_Type) GetFR2_FB31() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x80000000) >> 31
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
	OPTCR1  volatile.Register32 // 0x18
}

// FLASH.ACR: Flash access control register
func (o *FLASH_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf)|value)
}
func (o *FLASH_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0xf
}
func (o *FLASH_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *FLASH_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *FLASH_Type) SetACR_ARTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *FLASH_Type) GetACR_ARTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *FLASH_Type) SetACR_ARTRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *FLASH_Type) GetACR_ARTRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}

// FLASH.KEYR: Flash key register
func (o *FLASH_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *FLASH_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// FLASH.OPTKEYR: Flash option key register
func (o *FLASH_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *FLASH_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// FLASH.SR: Status register
func (o *FLASH_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FLASH_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FLASH_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FLASH_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetSR_PGPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetSR_PGPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetSR_ERSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetSR_ERSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// FLASH.CR: Control register
func (o *FLASH_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *FLASH_Type) SetCR_SER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetCR_SER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetCR_MER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *FLASH_Type) GetCR_MER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *FLASH_Type) SetCR_SNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x78)|value<<3)
}
func (o *FLASH_Type) GetCR_SNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x78) >> 3
}
func (o *FLASH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *FLASH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *FLASH_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *FLASH_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// FLASH.OPTCR: Flash option control register
func (o *FLASH_Type) SetOPTCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetOPTCR_OPTLOCK() uint32 {
	return volatile.LoadUint32(&o.OPTCR.Reg) & 0x1
}
func (o *FLASH_Type) SetOPTCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetOPTCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetOPTCR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xc)|value<<2)
}
func (o *FLASH_Type) GetOPTCR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xc) >> 2
}
func (o *FLASH_Type) SetOPTCR_WWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x10)|value<<4)
}
func (o *FLASH_Type) GetOPTCR_WWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x10) >> 4
}
func (o *FLASH_Type) SetOPTCR_IWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetOPTCR_IWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetOPTCR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetOPTCR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetOPTCR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetOPTCR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetOPTCR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xff00)|value<<8)
}
func (o *FLASH_Type) GetOPTCR_RDP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xff00) >> 8
}
func (o *FLASH_Type) SetOPTCR_NWRP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xff0000)|value<<16)
}
func (o *FLASH_Type) GetOPTCR_NWRP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xff0000) >> 16
}
func (o *FLASH_Type) SetOPTCR_IWDG_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FLASH_Type) GetOPTCR_IWDG_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x40000000) >> 30
}
func (o *FLASH_Type) SetOPTCR_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_Type) GetOPTCR_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x80000000) >> 31
}

// FLASH.OPTCR1: Flash option control register 1
func (o *FLASH_Type) SetOPTCR1_BOOT_ADD0(value uint32) {
	volatile.StoreUint32(&o.OPTCR1.Reg, volatile.LoadUint32(&o.OPTCR1.Reg)&^(0xffff)|value)
}
func (o *FLASH_Type) GetOPTCR1_BOOT_ADD0() uint32 {
	return volatile.LoadUint32(&o.OPTCR1.Reg) & 0xffff
}
func (o *FLASH_Type) SetOPTCR1_BOOT_ADD1(value uint32) {
	volatile.StoreUint32(&o.OPTCR1.Reg, volatile.LoadUint32(&o.OPTCR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *FLASH_Type) GetOPTCR1_BOOT_ADD1() uint32 {
	return (volatile.LoadUint32(&o.OPTCR1.Reg) & 0xffff0000) >> 16
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// EXTI.IMR: Interrupt mask register (EXTI_IMR)
func (o *EXTI_Type) SetIMR_MR0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR_MR0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR_MR1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR_MR2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR_MR3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR_MR4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR_MR5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR_MR6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR_MR7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR_MR8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR_MR9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR_MR10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR_MR11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR_MR12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR_MR13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR_MR14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR_MR15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR_MR16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR_MR17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR_MR18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR_MR19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR_MR20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR_MR21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR_MR22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}

// EXTI.EMR: Event mask register (EXTI_EMR)
func (o *EXTI_Type) SetEMR_MR0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR_MR0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR_MR1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR_MR2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR_MR3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR_MR4(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR_MR5(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR_MR6(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR_MR7(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR_MR8(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR_MR9(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR_MR10(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR_MR11(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR_MR12(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR_MR13(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR_MR14(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR_MR15(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR_MR16(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR_MR17(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR_MR18(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR_MR19(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR_MR20(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR_MR21(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR_MR22(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400000) >> 22
}

// EXTI.RTSR: Rising Trigger selection register (EXTI_RTSR)
func (o *EXTI_Type) SetRTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400000) >> 22
}

// EXTI.FTSR: Falling Trigger selection register (EXTI_FTSR)
func (o *EXTI_Type) SetFTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400000) >> 22
}

// EXTI.SWIER: Software interrupt event register (EXTI_SWIER)
func (o *EXTI_Type) SetSWIER_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER_SWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER_SWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER_SWIER17(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER_SWIER17() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER_SWIER22(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER_SWIER22() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400000) >> 22
}

// EXTI.PR: Pending register (EXTI_PR)
func (o *EXTI_Type) SetPR_PR0(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR_PR0() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x1
}
func (o *EXTI_Type) SetPR_PR1(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR_PR1() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR_PR2(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR_PR2() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR_PR3(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR_PR3() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR_PR4(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR_PR4() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR_PR5(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR_PR5() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR_PR6(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR_PR6() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR_PR7(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR_PR7() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR_PR8(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR_PR8() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR_PR9(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR_PR9() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR_PR10(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR_PR10() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR_PR11(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR_PR11() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR_PR12(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR_PR12() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR_PR13(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR_PR13() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR_PR14(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR_PR14() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR_PR15(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR_PR15() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR_PR16(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR_PR16() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR_PR17(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPR_PR17() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetPR_PR18(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPR_PR18() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPR_PR19(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR_PR19() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR_PR20(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR_PR20() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR_PR21(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR_PR21() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR_PR22(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR_PR22() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400000) >> 22
}

// LCD-TFT Controller
type LTDC_Type struct {
	_     [8]byte
	SSCR  volatile.Register32 // 0x8
	BPCR  volatile.Register32 // 0xC
	AWCR  volatile.Register32 // 0x10
	TWCR  volatile.Register32 // 0x14
	GCR   volatile.Register32 // 0x18
	_     [8]byte
	SRCR  volatile.Register32 // 0x24
	_     [4]byte
	BCCR  volatile.Register32 // 0x2C
	_     [4]byte
	IER   volatile.Register32 // 0x34
	ISR   volatile.Register32 // 0x38
	ICR   volatile.Register32 // 0x3C
	LIPCR volatile.Register32 // 0x40
	CPSR  volatile.Register32 // 0x44
	CDSR  volatile.Register32 // 0x48
	_     [56]byte
	LAYER [2]LTDC_LAYER_Type // 0x84
}

// LTDC.SSCR: Synchronization Size Configuration Register
func (o *LTDC_Type) SetSSCR_HSW(value uint32) {
	volatile.StoreUint32(&o.SSCR.Reg, volatile.LoadUint32(&o.SSCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetSSCR_HSW() uint32 {
	return (volatile.LoadUint32(&o.SSCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetSSCR_VSH(value uint32) {
	volatile.StoreUint32(&o.SSCR.Reg, volatile.LoadUint32(&o.SSCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetSSCR_VSH() uint32 {
	return volatile.LoadUint32(&o.SSCR.Reg) & 0x7ff
}

// LTDC.BPCR: Back Porch Configuration Register
func (o *LTDC_Type) SetBPCR_AHBP(value uint32) {
	volatile.StoreUint32(&o.BPCR.Reg, volatile.LoadUint32(&o.BPCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetBPCR_AHBP() uint32 {
	return (volatile.LoadUint32(&o.BPCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetBPCR_AVBP(value uint32) {
	volatile.StoreUint32(&o.BPCR.Reg, volatile.LoadUint32(&o.BPCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetBPCR_AVBP() uint32 {
	return volatile.LoadUint32(&o.BPCR.Reg) & 0x7ff
}

// LTDC.AWCR: Active Width Configuration Register
func (o *LTDC_Type) SetAWCR_AAW(value uint32) {
	volatile.StoreUint32(&o.AWCR.Reg, volatile.LoadUint32(&o.AWCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetAWCR_AAW() uint32 {
	return (volatile.LoadUint32(&o.AWCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetAWCR_AAH(value uint32) {
	volatile.StoreUint32(&o.AWCR.Reg, volatile.LoadUint32(&o.AWCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetAWCR_AAH() uint32 {
	return volatile.LoadUint32(&o.AWCR.Reg) & 0x7ff
}

// LTDC.TWCR: Total Width Configuration Register
func (o *LTDC_Type) SetTWCR_TOTALW(value uint32) {
	volatile.StoreUint32(&o.TWCR.Reg, volatile.LoadUint32(&o.TWCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetTWCR_TOTALW() uint32 {
	return (volatile.LoadUint32(&o.TWCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetTWCR_TOTALH(value uint32) {
	volatile.StoreUint32(&o.TWCR.Reg, volatile.LoadUint32(&o.TWCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetTWCR_TOTALH() uint32 {
	return volatile.LoadUint32(&o.TWCR.Reg) & 0x7ff
}

// LTDC.GCR: Global Control Register
func (o *LTDC_Type) SetGCR_HSPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x80000000)|value<<31)
}
func (o *LTDC_Type) GetGCR_HSPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x80000000) >> 31
}
func (o *LTDC_Type) SetGCR_VSPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x40000000)|value<<30)
}
func (o *LTDC_Type) GetGCR_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x40000000) >> 30
}
func (o *LTDC_Type) SetGCR_DEPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x20000000)|value<<29)
}
func (o *LTDC_Type) GetGCR_DEPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x20000000) >> 29
}
func (o *LTDC_Type) SetGCR_PCPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x10000000)|value<<28)
}
func (o *LTDC_Type) GetGCR_PCPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x10000000) >> 28
}
func (o *LTDC_Type) SetGCR_DEN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x10000)|value<<16)
}
func (o *LTDC_Type) GetGCR_DEN() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x10000) >> 16
}
func (o *LTDC_Type) SetGCR_DRW(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x7000)|value<<12)
}
func (o *LTDC_Type) GetGCR_DRW() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x7000) >> 12
}
func (o *LTDC_Type) SetGCR_DGW(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x700)|value<<8)
}
func (o *LTDC_Type) GetGCR_DGW() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x700) >> 8
}
func (o *LTDC_Type) SetGCR_DBW(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x70)|value<<4)
}
func (o *LTDC_Type) GetGCR_DBW() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x70) >> 4
}
func (o *LTDC_Type) SetGCR_LTDCEN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetGCR_LTDCEN() uint32 {
	return volatile.LoadUint32(&o.GCR.Reg) & 0x1
}

// LTDC.SRCR: Shadow Reload Configuration Register
func (o *LTDC_Type) SetSRCR_VBR(value uint32) {
	volatile.StoreUint32(&o.SRCR.Reg, volatile.LoadUint32(&o.SRCR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetSRCR_VBR() uint32 {
	return (volatile.LoadUint32(&o.SRCR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetSRCR_IMR(value uint32) {
	volatile.StoreUint32(&o.SRCR.Reg, volatile.LoadUint32(&o.SRCR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetSRCR_IMR() uint32 {
	return volatile.LoadUint32(&o.SRCR.Reg) & 0x1
}

// LTDC.BCCR: Background Color Configuration Register
func (o *LTDC_Type) SetBCCR_BCBLUE(value uint32) {
	volatile.StoreUint32(&o.BCCR.Reg, volatile.LoadUint32(&o.BCCR.Reg)&^(0xff)|value)
}
func (o *LTDC_Type) GetBCCR_BCBLUE() uint32 {
	return volatile.LoadUint32(&o.BCCR.Reg) & 0xff
}
func (o *LTDC_Type) SetBCCR_BCGREEN(value uint32) {
	volatile.StoreUint32(&o.BCCR.Reg, volatile.LoadUint32(&o.BCCR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_Type) GetBCCR_BCGREEN() uint32 {
	return (volatile.LoadUint32(&o.BCCR.Reg) & 0xff00) >> 8
}
func (o *LTDC_Type) SetBCCR_BCRED(value uint32) {
	volatile.StoreUint32(&o.BCCR.Reg, volatile.LoadUint32(&o.BCCR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_Type) GetBCCR_BCRED() uint32 {
	return (volatile.LoadUint32(&o.BCCR.Reg) & 0xff0000) >> 16
}

// LTDC.IER: Interrupt Enable Register
func (o *LTDC_Type) SetIER_RRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetIER_RRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetIER_TERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetIER_TERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetIER_FUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetIER_FUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetIER_LIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetIER_LIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LTDC.ISR: Interrupt Status Register
func (o *LTDC_Type) SetISR_RRIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetISR_RRIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetISR_TERRIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetISR_TERRIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetISR_FUIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetISR_FUIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetISR_LIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetISR_LIF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LTDC.ICR: Interrupt Clear Register
func (o *LTDC_Type) SetICR_CRRIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetICR_CRRIF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetICR_CTERRIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetICR_CTERRIF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetICR_CFUIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetICR_CFUIF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetICR_CLIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetICR_CLIF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LTDC.LIPCR: Line Interrupt Position Configuration Register
func (o *LTDC_Type) SetLIPCR_LIPOS(value uint32) {
	volatile.StoreUint32(&o.LIPCR.Reg, volatile.LoadUint32(&o.LIPCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetLIPCR_LIPOS() uint32 {
	return volatile.LoadUint32(&o.LIPCR.Reg) & 0x7ff
}

// LTDC.CPSR: Current Position Status Register
func (o *LTDC_Type) SetCPSR_CXPOS(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xffff0000)|value<<16)
}
func (o *LTDC_Type) GetCPSR_CXPOS() uint32 {
	return (volatile.LoadUint32(&o.CPSR.Reg) & 0xffff0000) >> 16
}
func (o *LTDC_Type) SetCPSR_CYPOS(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xffff)|value)
}
func (o *LTDC_Type) GetCPSR_CYPOS() uint32 {
	return volatile.LoadUint32(&o.CPSR.Reg) & 0xffff
}

// LTDC.CDSR: Current Display Status Register
func (o *LTDC_Type) SetCDSR_HSYNCS(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetCDSR_HSYNCS() uint32 {
	return (volatile.LoadUint32(&o.CDSR.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetCDSR_VSYNCS(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetCDSR_VSYNCS() uint32 {
	return (volatile.LoadUint32(&o.CDSR.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetCDSR_HDES(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetCDSR_HDES() uint32 {
	return (volatile.LoadUint32(&o.CDSR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetCDSR_VDES(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetCDSR_VDES() uint32 {
	return volatile.LoadUint32(&o.CDSR.Reg) & 0x1
}

type LTDC_LAYER_Type struct {
	CR     volatile.Register32 // 0x84
	WHPCR  volatile.Register32 // 0x88
	WVPCR  volatile.Register32 // 0x8C
	CKCR   volatile.Register32 // 0x90
	PFCR   volatile.Register32 // 0x94
	CACR   volatile.Register32 // 0x98
	DCCR   volatile.Register32 // 0x9C
	BFCR   volatile.Register32 // 0xA0
	_      [8]byte
	CFBAR  volatile.Register32 // 0xAC
	CFBLR  volatile.Register32 // 0xB0
	CFBLNR volatile.Register32 // 0xB4
	_      [12]byte
	CLUTWR volatile.Register32 // 0xC4
	_      [60]byte
}

// LTDC_LAYER.CR: Layerx Control Register
func (o *LTDC_LAYER_Type) SetCR_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LTDC_LAYER_Type) GetCR_CLUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *LTDC_LAYER_Type) SetCR_COLKEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_LAYER_Type) GetCR_COLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LTDC_LAYER_Type) SetCR_LEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LTDC_LAYER_Type) GetCR_LEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LTDC_LAYER.WHPCR: Layerx Window Horizontal Position Configuration Register
func (o *LTDC_LAYER_Type) SetWHPCR_WHSPPOS(value uint32) {
	volatile.StoreUint32(&o.WHPCR.Reg, volatile.LoadUint32(&o.WHPCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetWHPCR_WHSPPOS() uint32 {
	return (volatile.LoadUint32(&o.WHPCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetWHPCR_WHSTPOS(value uint32) {
	volatile.StoreUint32(&o.WHPCR.Reg, volatile.LoadUint32(&o.WHPCR.Reg)&^(0xfff)|value)
}
func (o *LTDC_LAYER_Type) GetWHPCR_WHSTPOS() uint32 {
	return volatile.LoadUint32(&o.WHPCR.Reg) & 0xfff
}

// LTDC_LAYER.WVPCR: Layerx Window Vertical Position Configuration Register
func (o *LTDC_LAYER_Type) SetWVPCR_WVSPPOS(value uint32) {
	volatile.StoreUint32(&o.WVPCR.Reg, volatile.LoadUint32(&o.WVPCR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetWVPCR_WVSPPOS() uint32 {
	return (volatile.LoadUint32(&o.WVPCR.Reg) & 0x7ff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetWVPCR_WVSTPOS(value uint32) {
	volatile.StoreUint32(&o.WVPCR.Reg, volatile.LoadUint32(&o.WVPCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_LAYER_Type) GetWVPCR_WVSTPOS() uint32 {
	return volatile.LoadUint32(&o.WVPCR.Reg) & 0x7ff
}

// LTDC_LAYER.CKCR: Layerx Color Keying Configuration Register
func (o *LTDC_LAYER_Type) SetCKCR_CKRED(value uint32) {
	volatile.StoreUint32(&o.CKCR.Reg, volatile.LoadUint32(&o.CKCR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetCKCR_CKRED() uint32 {
	return (volatile.LoadUint32(&o.CKCR.Reg) & 0xff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetCKCR_CKGREEN(value uint32) {
	volatile.StoreUint32(&o.CKCR.Reg, volatile.LoadUint32(&o.CKCR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_LAYER_Type) GetCKCR_CKGREEN() uint32 {
	return (volatile.LoadUint32(&o.CKCR.Reg) & 0xff00) >> 8
}
func (o *LTDC_LAYER_Type) SetCKCR_CKBLUE(value uint32) {
	volatile.StoreUint32(&o.CKCR.Reg, volatile.LoadUint32(&o.CKCR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetCKCR_CKBLUE() uint32 {
	return volatile.LoadUint32(&o.CKCR.Reg) & 0xff
}

// LTDC_LAYER.PFCR: Layerx Pixel Format Configuration Register
func (o *LTDC_LAYER_Type) SetPFCR_PF(value uint32) {
	volatile.StoreUint32(&o.PFCR.Reg, volatile.LoadUint32(&o.PFCR.Reg)&^(0x7)|value)
}
func (o *LTDC_LAYER_Type) GetPFCR_PF() uint32 {
	return volatile.LoadUint32(&o.PFCR.Reg) & 0x7
}

// LTDC_LAYER.CACR: Layerx Constant Alpha Configuration Register
func (o *LTDC_LAYER_Type) SetCACR_CONSTA(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetCACR_CONSTA() uint32 {
	return volatile.LoadUint32(&o.CACR.Reg) & 0xff
}

// LTDC_LAYER.DCCR: Layerx Default Color Configuration Register
func (o *LTDC_LAYER_Type) SetDCCR_DCALPHA(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCALPHA() uint32 {
	return (volatile.LoadUint32(&o.DCCR.Reg) & 0xff000000) >> 24
}
func (o *LTDC_LAYER_Type) SetDCCR_DCRED(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCRED() uint32 {
	return (volatile.LoadUint32(&o.DCCR.Reg) & 0xff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetDCCR_DCGREEN(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCGREEN() uint32 {
	return (volatile.LoadUint32(&o.DCCR.Reg) & 0xff00) >> 8
}
func (o *LTDC_LAYER_Type) SetDCCR_DCBLUE(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCBLUE() uint32 {
	return volatile.LoadUint32(&o.DCCR.Reg) & 0xff
}

// LTDC_LAYER.BFCR: Layerx Blending Factors Configuration Register
func (o *LTDC_LAYER_Type) SetBFCR_BF1(value uint32) {
	volatile.StoreUint32(&o.BFCR.Reg, volatile.LoadUint32(&o.BFCR.Reg)&^(0x700)|value<<8)
}
func (o *LTDC_LAYER_Type) GetBFCR_BF1() uint32 {
	return (volatile.LoadUint32(&o.BFCR.Reg) & 0x700) >> 8
}
func (o *LTDC_LAYER_Type) SetBFCR_BF2(value uint32) {
	volatile.StoreUint32(&o.BFCR.Reg, volatile.LoadUint32(&o.BFCR.Reg)&^(0x7)|value)
}
func (o *LTDC_LAYER_Type) GetBFCR_BF2() uint32 {
	return volatile.LoadUint32(&o.BFCR.Reg) & 0x7
}

// LTDC_LAYER.CFBAR: Layerx Color Frame Buffer Address Register
func (o *LTDC_LAYER_Type) SetCFBAR(value uint32) {
	volatile.StoreUint32(&o.CFBAR.Reg, value)
}
func (o *LTDC_LAYER_Type) GetCFBAR() uint32 {
	return volatile.LoadUint32(&o.CFBAR.Reg)
}

// LTDC_LAYER.CFBLR: Layerx Color Frame Buffer Length Register
func (o *LTDC_LAYER_Type) SetCFBLR_CFBP(value uint32) {
	volatile.StoreUint32(&o.CFBLR.Reg, volatile.LoadUint32(&o.CFBLR.Reg)&^(0x1fff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetCFBLR_CFBP() uint32 {
	return (volatile.LoadUint32(&o.CFBLR.Reg) & 0x1fff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetCFBLR_CFBLL(value uint32) {
	volatile.StoreUint32(&o.CFBLR.Reg, volatile.LoadUint32(&o.CFBLR.Reg)&^(0x1fff)|value)
}
func (o *LTDC_LAYER_Type) GetCFBLR_CFBLL() uint32 {
	return volatile.LoadUint32(&o.CFBLR.Reg) & 0x1fff
}

// LTDC_LAYER.CFBLNR: Layerx ColorFrame Buffer Line Number Register
func (o *LTDC_LAYER_Type) SetCFBLNR_CFBLNBR(value uint32) {
	volatile.StoreUint32(&o.CFBLNR.Reg, volatile.LoadUint32(&o.CFBLNR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_LAYER_Type) GetCFBLNR_CFBLNBR() uint32 {
	return volatile.LoadUint32(&o.CFBLNR.Reg) & 0x7ff
}

// LTDC_LAYER.CLUTWR: Layerx CLUT Write Register
func (o *LTDC_LAYER_Type) SetCLUTWR_CLUTADD(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff000000)|value<<24)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_CLUTADD() uint32 {
	return (volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff000000) >> 24
}
func (o *LTDC_LAYER_Type) SetCLUTWR_RED(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_RED() uint32 {
	return (volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetCLUTWR_GREEN(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff00) >> 8
}
func (o *LTDC_LAYER_Type) SetCLUTWR_BLUE(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_BLUE() uint32 {
	return volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff
}

// Serial audio interface
type SAI_Type struct {
	GCR volatile.Register32 // 0x0
	CH  [2]SAI_CH_Type      // 0x4
}

// SAI.GCR: Global configuration register
func (o *SAI_Type) SetGCR_SYNCIN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x3)|value)
}
func (o *SAI_Type) GetGCR_SYNCIN() uint32 {
	return volatile.LoadUint32(&o.GCR.Reg) & 0x3
}
func (o *SAI_Type) SetGCR_SYNCOUT(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x30)|value<<4)
}
func (o *SAI_Type) GetGCR_SYNCOUT() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x30) >> 4
}

type SAI_CH_Type struct {
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	FRCR  volatile.Register32 // 0xC
	SLOTR volatile.Register32 // 0x10
	IM    volatile.Register32 // 0x14
	SR    volatile.Register32 // 0x18
	CLRFR volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
}

// SAI_CH.CR1: AConfiguration register 1
func (o *SAI_CH_Type) SetCR1_MCKDIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00000)|value<<20)
}
func (o *SAI_CH_Type) GetCR1_MCKDIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00000) >> 20
}
func (o *SAI_CH_Type) SetCR1_NODIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *SAI_CH_Type) GetCR1_NODIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *SAI_CH_Type) SetCR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetCR1_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetCR1_SAIEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetCR1_SAIEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetCR1_OUTDRIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR1_OUTDRIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR1_MONO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SAI_CH_Type) GetCR1_MONO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SAI_CH_Type) SetCR1_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc00)|value<<10)
}
func (o *SAI_CH_Type) GetCR1_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc00) >> 10
}
func (o *SAI_CH_Type) SetCR1_CKSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SAI_CH_Type) GetCR1_CKSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SAI_CH_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SAI_CH_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SAI_CH_Type) SetCR1_DS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe0)|value<<5)
}
func (o *SAI_CH_Type) GetCR1_DS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe0) >> 5
}
func (o *SAI_CH_Type) SetCR1_PRTCFG(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc)|value<<2)
}
func (o *SAI_CH_Type) GetCR1_PRTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc) >> 2
}
func (o *SAI_CH_Type) SetCR1_MODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3)|value)
}
func (o *SAI_CH_Type) GetCR1_MODE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x3
}

// SAI_CH.CR2: AConfiguration register 2
func (o *SAI_CH_Type) SetCR2_COMP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xc000)|value<<14)
}
func (o *SAI_CH_Type) GetCR2_COMP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xc000) >> 14
}
func (o *SAI_CH_Type) SetCR2_CPL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR2_CPL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR2_MUTECN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1f80)|value<<7)
}
func (o *SAI_CH_Type) GetCR2_MUTECN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1f80) >> 7
}
func (o *SAI_CH_Type) SetCR2_MUTEVAL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCR2_MUTEVAL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCR2_MUTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCR2_MUTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCR2_TRIS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCR2_TRIS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCR2_FFLUSH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetCR2_FFLUSH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetCR2_FTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x7)|value)
}
func (o *SAI_CH_Type) GetCR2_FTH() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x7
}

// SAI_CH.FRCR: AFRCR
func (o *SAI_CH_Type) SetFRCR_FSOFF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x40000)|value<<18)
}
func (o *SAI_CH_Type) GetFRCR_FSOFF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x40000) >> 18
}
func (o *SAI_CH_Type) SetFRCR_FSPOL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetFRCR_FSPOL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetFRCR_FSDEF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetFRCR_FSDEF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetFRCR_FSALL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x7f00)|value<<8)
}
func (o *SAI_CH_Type) GetFRCR_FSALL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x7f00) >> 8
}
func (o *SAI_CH_Type) SetFRCR_FRL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0xff)|value)
}
func (o *SAI_CH_Type) GetFRCR_FRL() uint32 {
	return volatile.LoadUint32(&o.FRCR.Reg) & 0xff
}

// SAI_CH.SLOTR: ASlot register
func (o *SAI_CH_Type) SetSLOTR_SLOTEN(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTEN() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xffff0000) >> 16
}
func (o *SAI_CH_Type) SetSLOTR_NBSLOT(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xf00)|value<<8)
}
func (o *SAI_CH_Type) GetSLOTR_NBSLOT() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xf00) >> 8
}
func (o *SAI_CH_Type) SetSLOTR_SLOTSZ(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xc0)|value<<6)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTSZ() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xc0) >> 6
}
func (o *SAI_CH_Type) SetSLOTR_FBOFF(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0x1f)|value)
}
func (o *SAI_CH_Type) GetSLOTR_FBOFF() uint32 {
	return volatile.LoadUint32(&o.SLOTR.Reg) & 0x1f
}

// SAI_CH.IM: AInterrupt mask register2
func (o *SAI_CH_Type) SetIM_LFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetIM_LFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetIM_AFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetIM_AFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetIM_CNRDYIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetIM_CNRDYIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetIM_FREQIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetIM_FREQIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetIM_WCKCFGIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetIM_WCKCFGIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetIM_MUTEDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetIM_MUTEDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetIM_OVRUDRIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetIM_OVRUDRIE() uint32 {
	return volatile.LoadUint32(&o.IM.Reg) & 0x1
}

// SAI_CH.SR: AStatus register
func (o *SAI_CH_Type) SetSR_FLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_CH_Type) GetSR_FLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000) >> 16
}
func (o *SAI_CH_Type) SetSR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetSR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetSR_AFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetSR_AFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetSR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetSR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetSR_FREQ(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetSR_FREQ() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetSR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetSR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetSR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetSR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetSR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetSR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SAI_CH.CLRFR: AClear flag register
func (o *SAI_CH_Type) SetCLRFR_CLFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCLRFR_CLFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCLRFR_CAFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCLRFR_CAFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCLRFR_CCNRDY(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCLRFR_CCNRDY() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCLRFR_CWCKCFG(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetCLRFR_CWCKCFG() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetCLRFR_CMUTEDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetCLRFR_CMUTEDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetCLRFR_COVRUDR(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetCLRFR_COVRUDR() uint32 {
	return volatile.LoadUint32(&o.CLRFR.Reg) & 0x1
}

// SAI_CH.DR: AData register
func (o *SAI_CH_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *SAI_CH_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// DMA2D controller
type DMA2D_Type struct {
	CR      volatile.Register32 // 0x0
	ISR     volatile.Register32 // 0x4
	IFCR    volatile.Register32 // 0x8
	FGMAR   volatile.Register32 // 0xC
	FGOR    volatile.Register32 // 0x10
	BGMAR   volatile.Register32 // 0x14
	BGOR    volatile.Register32 // 0x18
	FGPFCCR volatile.Register32 // 0x1C
	FGCOLR  volatile.Register32 // 0x20
	BGPFCCR volatile.Register32 // 0x24
	BGCOLR  volatile.Register32 // 0x28
	FGCMAR  volatile.Register32 // 0x2C
	BGCMAR  volatile.Register32 // 0x30
	OPFCCR  volatile.Register32 // 0x34
	OCOLR   volatile.Register32 // 0x38
	OMAR    volatile.Register32 // 0x3C
	OOR     volatile.Register32 // 0x40
	NLR     volatile.Register32 // 0x44
	LWR     volatile.Register32 // 0x48
	AMTCR   volatile.Register32 // 0x4C
	_       [944]byte
	FGCLUT  volatile.Register32 // 0x400
	_       [1020]byte
	BGCLUT  volatile.Register32 // 0x800
}

// DMA2D.CR: control register
func (o *DMA2D_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetCR_CEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA2D_Type) GetCR_CEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DMA2D_Type) SetCR_CTCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA2D_Type) GetCR_CTCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DMA2D_Type) SetCR_CAEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *DMA2D_Type) GetCR_CAEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *DMA2D_Type) SetCR_TWIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA2D_Type) GetCR_TWIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DMA2D_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA2D_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DMA2D_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2D_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DMA2D_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetCR_SUSP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetCR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DMA2D.ISR: Interrupt Status Register
func (o *DMA2D_Type) SetISR_CEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetISR_CEIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetISR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetISR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetISR_CAEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2D_Type) GetISR_CAEIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA2D_Type) SetISR_TWIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetISR_TWIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetISR_TCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetISR_TCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetISR_TEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetISR_TEIF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DMA2D.IFCR: interrupt flag clear register
func (o *DMA2D_Type) SetIFCR_CCEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetIFCR_CCEIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetIFCR_CCTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetIFCR_CCTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetIFCR_CAECIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2D_Type) GetIFCR_CAECIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA2D_Type) SetIFCR_CTWIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetIFCR_CTWIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetIFCR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetIFCR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetIFCR_CTEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetIFCR_CTEIF() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}

// DMA2D.FGMAR: foreground memory address register
func (o *DMA2D_Type) SetFGMAR(value uint32) {
	volatile.StoreUint32(&o.FGMAR.Reg, value)
}
func (o *DMA2D_Type) GetFGMAR() uint32 {
	return volatile.LoadUint32(&o.FGMAR.Reg)
}

// DMA2D.FGOR: foreground offset register
func (o *DMA2D_Type) SetFGOR_LO(value uint32) {
	volatile.StoreUint32(&o.FGOR.Reg, volatile.LoadUint32(&o.FGOR.Reg)&^(0x3fff)|value)
}
func (o *DMA2D_Type) GetFGOR_LO() uint32 {
	return volatile.LoadUint32(&o.FGOR.Reg) & 0x3fff
}

// DMA2D.BGMAR: background memory address register
func (o *DMA2D_Type) SetBGMAR(value uint32) {
	volatile.StoreUint32(&o.BGMAR.Reg, value)
}
func (o *DMA2D_Type) GetBGMAR() uint32 {
	return volatile.LoadUint32(&o.BGMAR.Reg)
}

// DMA2D.BGOR: background offset register
func (o *DMA2D_Type) SetBGOR_LO(value uint32) {
	volatile.StoreUint32(&o.BGOR.Reg, volatile.LoadUint32(&o.BGOR.Reg)&^(0x3fff)|value)
}
func (o *DMA2D_Type) GetBGOR_LO() uint32 {
	return volatile.LoadUint32(&o.BGOR.Reg) & 0x3fff
}

// DMA2D.FGPFCCR: foreground PFC control register
func (o *DMA2D_Type) SetFGPFCCR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetFGPFCCR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetFGPFCCR_AM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetFGPFCCR_AM() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetFGPFCCR_CS(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGPFCCR_CS() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGPFCCR_START(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetFGPFCCR_START() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetFGPFCCR_CCM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetFGPFCCR_CCM() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetFGPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xf)|value)
}
func (o *DMA2D_Type) GetFGPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xf
}

// DMA2D.FGCOLR: foreground color register
func (o *DMA2D_Type) SetFGCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetFGCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetFGCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetFGCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff
}

// DMA2D.BGPFCCR: background PFC control register
func (o *DMA2D_Type) SetBGPFCCR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetBGPFCCR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetBGPFCCR_AM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetBGPFCCR_AM() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetBGPFCCR_CS(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGPFCCR_CS() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGPFCCR_START(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetBGPFCCR_START() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetBGPFCCR_CCM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetBGPFCCR_CCM() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetBGPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xf)|value)
}
func (o *DMA2D_Type) GetBGPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xf
}

// DMA2D.BGCOLR: background color register
func (o *DMA2D_Type) SetBGCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetBGCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetBGCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetBGCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff
}

// DMA2D.FGCMAR: foreground CLUT memory address register
func (o *DMA2D_Type) SetFGCMAR(value uint32) {
	volatile.StoreUint32(&o.FGCMAR.Reg, value)
}
func (o *DMA2D_Type) GetFGCMAR() uint32 {
	return volatile.LoadUint32(&o.FGCMAR.Reg)
}

// DMA2D.BGCMAR: background CLUT memory address register
func (o *DMA2D_Type) SetBGCMAR(value uint32) {
	volatile.StoreUint32(&o.BGCMAR.Reg, value)
}
func (o *DMA2D_Type) GetBGCMAR() uint32 {
	return volatile.LoadUint32(&o.BGCMAR.Reg)
}

// DMA2D.OPFCCR: output PFC control register
func (o *DMA2D_Type) SetOPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x7)|value)
}
func (o *DMA2D_Type) GetOPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.OPFCCR.Reg) & 0x7
}

// DMA2D.OCOLR: output color register
func (o *DMA2D_Type) SetOCOLR_APLHA(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetOCOLR_APLHA() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetOCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetOCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetOCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetOCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetOCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetOCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.OCOLR.Reg) & 0xff
}

// DMA2D.OMAR: output memory address register
func (o *DMA2D_Type) SetOMAR(value uint32) {
	volatile.StoreUint32(&o.OMAR.Reg, value)
}
func (o *DMA2D_Type) GetOMAR() uint32 {
	return volatile.LoadUint32(&o.OMAR.Reg)
}

// DMA2D.OOR: output offset register
func (o *DMA2D_Type) SetOOR_LO(value uint32) {
	volatile.StoreUint32(&o.OOR.Reg, volatile.LoadUint32(&o.OOR.Reg)&^(0x3fff)|value)
}
func (o *DMA2D_Type) GetOOR_LO() uint32 {
	return volatile.LoadUint32(&o.OOR.Reg) & 0x3fff
}

// DMA2D.NLR: number of line register
func (o *DMA2D_Type) SetNLR_PL(value uint32) {
	volatile.StoreUint32(&o.NLR.Reg, volatile.LoadUint32(&o.NLR.Reg)&^(0x3fff0000)|value<<16)
}
func (o *DMA2D_Type) GetNLR_PL() uint32 {
	return (volatile.LoadUint32(&o.NLR.Reg) & 0x3fff0000) >> 16
}
func (o *DMA2D_Type) SetNLR_NL(value uint32) {
	volatile.StoreUint32(&o.NLR.Reg, volatile.LoadUint32(&o.NLR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetNLR_NL() uint32 {
	return volatile.LoadUint32(&o.NLR.Reg) & 0xffff
}

// DMA2D.LWR: line watermark register
func (o *DMA2D_Type) SetLWR_LW(value uint32) {
	volatile.StoreUint32(&o.LWR.Reg, volatile.LoadUint32(&o.LWR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetLWR_LW() uint32 {
	return volatile.LoadUint32(&o.LWR.Reg) & 0xffff
}

// DMA2D.AMTCR: AHB master timer configuration register
func (o *DMA2D_Type) SetAMTCR_DT(value uint32) {
	volatile.StoreUint32(&o.AMTCR.Reg, volatile.LoadUint32(&o.AMTCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetAMTCR_DT() uint32 {
	return (volatile.LoadUint32(&o.AMTCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetAMTCR_EN(value uint32) {
	volatile.StoreUint32(&o.AMTCR.Reg, volatile.LoadUint32(&o.AMTCR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetAMTCR_EN() uint32 {
	return volatile.LoadUint32(&o.AMTCR.Reg) & 0x1
}

// DMA2D.FGCLUT: FGCLUT
func (o *DMA2D_Type) SetFGCLUT_APLHA(value uint32) {
	volatile.StoreUint32(&o.FGCLUT.Reg, volatile.LoadUint32(&o.FGCLUT.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetFGCLUT_APLHA() uint32 {
	return (volatile.LoadUint32(&o.FGCLUT.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetFGCLUT_RED(value uint32) {
	volatile.StoreUint32(&o.FGCLUT.Reg, volatile.LoadUint32(&o.FGCLUT.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetFGCLUT_RED() uint32 {
	return (volatile.LoadUint32(&o.FGCLUT.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetFGCLUT_GREEN(value uint32) {
	volatile.StoreUint32(&o.FGCLUT.Reg, volatile.LoadUint32(&o.FGCLUT.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGCLUT_GREEN() uint32 {
	return (volatile.LoadUint32(&o.FGCLUT.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGCLUT_BLUE(value uint32) {
	volatile.StoreUint32(&o.FGCLUT.Reg, volatile.LoadUint32(&o.FGCLUT.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetFGCLUT_BLUE() uint32 {
	return volatile.LoadUint32(&o.FGCLUT.Reg) & 0xff
}

// DMA2D.BGCLUT: BGCLUT
func (o *DMA2D_Type) SetBGCLUT_APLHA(value uint32) {
	volatile.StoreUint32(&o.BGCLUT.Reg, volatile.LoadUint32(&o.BGCLUT.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetBGCLUT_APLHA() uint32 {
	return (volatile.LoadUint32(&o.BGCLUT.Reg) & 0xff000000) >> 24
}
func (o *DMA2D_Type) SetBGCLUT_RED(value uint32) {
	volatile.StoreUint32(&o.BGCLUT.Reg, volatile.LoadUint32(&o.BGCLUT.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetBGCLUT_RED() uint32 {
	return (volatile.LoadUint32(&o.BGCLUT.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetBGCLUT_GREEN(value uint32) {
	volatile.StoreUint32(&o.BGCLUT.Reg, volatile.LoadUint32(&o.BGCLUT.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGCLUT_GREEN() uint32 {
	return (volatile.LoadUint32(&o.BGCLUT.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGCLUT_BLUE(value uint32) {
	volatile.StoreUint32(&o.BGCLUT.Reg, volatile.LoadUint32(&o.BGCLUT.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetBGCLUT_BLUE() uint32 {
	return volatile.LoadUint32(&o.BGCLUT.Reg) & 0xff
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// QUADSPI.CR: control register
func (o *QUADSPI_Type) SetCR_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *QUADSPI_Type) GetCR_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}
func (o *QUADSPI_Type) SetCR_PMM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *QUADSPI_Type) GetCR_PMM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *QUADSPI_Type) SetCR_APMS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *QUADSPI_Type) GetCR_APMS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *QUADSPI_Type) SetCR_TOIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *QUADSPI_Type) GetCR_TOIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *QUADSPI_Type) SetCR_SMIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *QUADSPI_Type) GetCR_SMIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *QUADSPI_Type) SetCR_FTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *QUADSPI_Type) GetCR_FTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *QUADSPI_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *QUADSPI_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *QUADSPI_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *QUADSPI_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *QUADSPI_Type) SetCR_FTHRES(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1f00)|value<<8)
}
func (o *QUADSPI_Type) GetCR_FTHRES() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1f00) >> 8
}
func (o *QUADSPI_Type) SetCR_FSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *QUADSPI_Type) GetCR_FSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *QUADSPI_Type) SetCR_DFM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *QUADSPI_Type) GetCR_DFM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *QUADSPI_Type) SetCR_SSHIFT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetCR_SSHIFT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetCR_TCEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetCR_TCEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetCR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetCR_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// QUADSPI.DCR: device configuration register
func (o *QUADSPI_Type) SetDCR_FSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *QUADSPI_Type) GetDCR_FSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f0000) >> 16
}
func (o *QUADSPI_Type) SetDCR_CSHT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x700)|value<<8)
}
func (o *QUADSPI_Type) GetDCR_CSHT() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x700) >> 8
}
func (o *QUADSPI_Type) SetDCR_CKMODE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetDCR_CKMODE() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}

// QUADSPI.SR: status register
func (o *QUADSPI_Type) SetSR_FLEVEL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7f00)|value<<8)
}
func (o *QUADSPI_Type) GetSR_FLEVEL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7f00) >> 8
}
func (o *QUADSPI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *QUADSPI_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *QUADSPI_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetSR_SMF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetSR_SMF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetSR_FTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetSR_FTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetSR_TEF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetSR_TEF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// QUADSPI.FCR: flag clear register
func (o *QUADSPI_Type) SetFCR_CTOF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetFCR_CTOF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetFCR_CSMF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetFCR_CSMF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetFCR_CTCF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetFCR_CTCF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetFCR_CTEF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetFCR_CTEF() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}

// QUADSPI.DLR: data length register
func (o *QUADSPI_Type) SetDLR(value uint32) {
	volatile.StoreUint32(&o.DLR.Reg, value)
}
func (o *QUADSPI_Type) GetDLR() uint32 {
	return volatile.LoadUint32(&o.DLR.Reg)
}

// QUADSPI.CCR: communication configuration register
func (o *QUADSPI_Type) SetCCR_DDRM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000000)|value<<31)
}
func (o *QUADSPI_Type) GetCCR_DDRM() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000000) >> 31
}
func (o *QUADSPI_Type) SetCCR_DHHC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40000000)|value<<30)
}
func (o *QUADSPI_Type) GetCCR_DHHC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40000000) >> 30
}
func (o *QUADSPI_Type) SetCCR_SIOO(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10000000)|value<<28)
}
func (o *QUADSPI_Type) GetCCR_SIOO() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10000000) >> 28
}
func (o *QUADSPI_Type) SetCCR_FMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000000)|value<<26)
}
func (o *QUADSPI_Type) GetCCR_FMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000000) >> 26
}
func (o *QUADSPI_Type) SetCCR_DMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000000)|value<<24)
}
func (o *QUADSPI_Type) GetCCR_DMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000000) >> 24
}
func (o *QUADSPI_Type) SetCCR_DCYC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x7c0000)|value<<18)
}
func (o *QUADSPI_Type) GetCCR_DCYC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x7c0000) >> 18
}
func (o *QUADSPI_Type) SetCCR_ABSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x30000)|value<<16)
}
func (o *QUADSPI_Type) GetCCR_ABSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x30000) >> 16
}
func (o *QUADSPI_Type) SetCCR_ABMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000)|value<<14)
}
func (o *QUADSPI_Type) GetCCR_ABMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000) >> 14
}
func (o *QUADSPI_Type) SetCCR_ADSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000)|value<<12)
}
func (o *QUADSPI_Type) GetCCR_ADSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000) >> 12
}
func (o *QUADSPI_Type) SetCCR_ADMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc00)|value<<10)
}
func (o *QUADSPI_Type) GetCCR_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc00) >> 10
}
func (o *QUADSPI_Type) SetCCR_IMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x300)|value<<8)
}
func (o *QUADSPI_Type) GetCCR_IMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x300) >> 8
}
func (o *QUADSPI_Type) SetCCR_INSTRUCTION(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xff)|value)
}
func (o *QUADSPI_Type) GetCCR_INSTRUCTION() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xff
}

// QUADSPI.AR: address register
func (o *QUADSPI_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *QUADSPI_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// QUADSPI.ABR: ABR
func (o *QUADSPI_Type) SetABR(value uint32) {
	volatile.StoreUint32(&o.ABR.Reg, value)
}
func (o *QUADSPI_Type) GetABR() uint32 {
	return volatile.LoadUint32(&o.ABR.Reg)
}

// QUADSPI.DR: data register
func (o *QUADSPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *QUADSPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// QUADSPI.PSMKR: polling status mask register
func (o *QUADSPI_Type) SetPSMKR(value uint32) {
	volatile.StoreUint32(&o.PSMKR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMKR() uint32 {
	return volatile.LoadUint32(&o.PSMKR.Reg)
}

// QUADSPI.PSMAR: polling status match register
func (o *QUADSPI_Type) SetPSMAR(value uint32) {
	volatile.StoreUint32(&o.PSMAR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMAR() uint32 {
	return volatile.LoadUint32(&o.PSMAR.Reg)
}

// QUADSPI.PIR: polling interval register
func (o *QUADSPI_Type) SetPIR_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.PIR.Reg, volatile.LoadUint32(&o.PIR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetPIR_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.PIR.Reg) & 0xffff
}

// QUADSPI.LPTR: low-power timeout register
func (o *QUADSPI_Type) SetLPTR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPTR.Reg, volatile.LoadUint32(&o.LPTR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetLPTR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LPTR.Reg) & 0xffff
}

// HDMI-CEC controller
type CEC_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	TXDR volatile.Register32 // 0x8
	RXDR volatile.Register32 // 0xC
	ISR  volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
}

// CEC.CR: control register
func (o *CEC_Type) SetCR_TXEOM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetCR_TXEOM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetCR_TXSOM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetCR_TXSOM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetCR_CECEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetCR_CECEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CEC.CFGR: configuration register
func (o *CEC_Type) SetCFGR_SFT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7)|value)
}
func (o *CEC_Type) GetCFGR_SFT() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x7
}
func (o *CEC_Type) SetCFGR_RXTOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetCFGR_RXTOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetCFGR_BRESTP(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetCFGR_BRESTP() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetCFGR_BREGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetCFGR_BREGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetCFGR_LBPEGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetCFGR_LBPEGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetCFGR_BRDNOGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetCFGR_BRDNOGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetCFGR_SFTOP(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetCFGR_SFTOP() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetCFGR_OAR(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7fff0000)|value<<16)
}
func (o *CEC_Type) GetCFGR_OAR() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7fff0000) >> 16
}
func (o *CEC_Type) SetCFGR_LSTN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *CEC_Type) GetCFGR_LSTN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// CEC.TXDR: Tx data register
func (o *CEC_Type) SetTXDR_TXD(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetTXDR_TXD() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// CEC.RXDR: Rx Data Register
func (o *CEC_Type) SetRXDR(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetRXDR() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// CEC.ISR: Interrupt and Status Register
func (o *CEC_Type) SetISR_TXACKE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetISR_TXACKE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *CEC_Type) SetISR_TXERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetISR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetISR_TXUDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetISR_TXUDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetISR_TXEND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetISR_TXEND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetISR_TXBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetISR_TXBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetISR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetISR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetISR_RXACKE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetISR_RXACKE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetISR_LBPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetISR_LBPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetISR_SBPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetISR_SBPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetISR_BRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetISR_BRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetISR_RXOVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetISR_RXOVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetISR_RXEND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetISR_RXEND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetISR_RXBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetISR_RXBR() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// CEC.IER: interrupt enable register
func (o *CEC_Type) SetIER_TXACKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetIER_TXACKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *CEC_Type) SetIER_TXERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetIER_TXERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetIER_TXUDRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetIER_TXUDRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetIER_TXENDIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetIER_TXENDIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetIER_TXBRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetIER_TXBRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetIER_ARBLSTIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetIER_ARBLSTIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetIER_RXACKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetIER_RXACKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetIER_LBPEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetIER_LBPEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetIER_SBPEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetIER_SBPEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetIER_BREIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetIER_BREIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetIER_RXOVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetIER_RXOVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetIER_RXENDIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetIER_RXENDIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetIER_RXBRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetIER_RXBRIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// Receiver Interface
type SPDIF_RX_Type struct {
	CR   volatile.Register32 // 0x0
	IMR  volatile.Register32 // 0x4
	SR   volatile.Register32 // 0x8
	IFCR volatile.Register32 // 0xC
	DR   volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	DIR  volatile.Register32 // 0x18
}

// SPDIF_RX.CR: Control register
func (o *SPDIF_RX_Type) SetCR_SPDIFEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3)|value)
}
func (o *SPDIF_RX_Type) GetCR_SPDIFEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3
}
func (o *SPDIF_RX_Type) SetCR_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *SPDIF_RX_Type) GetCR_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *SPDIF_RX_Type) SetCR_RXSTEO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *SPDIF_RX_Type) GetCR_RXSTEO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *SPDIF_RX_Type) SetCR_DRFMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30)|value<<4)
}
func (o *SPDIF_RX_Type) GetCR_DRFMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30) >> 4
}
func (o *SPDIF_RX_Type) SetCR_PMSK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *SPDIF_RX_Type) GetCR_PMSK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *SPDIF_RX_Type) SetCR_VMSK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPDIF_RX_Type) GetCR_VMSK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPDIF_RX_Type) SetCR_CUMSK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SPDIF_RX_Type) GetCR_CUMSK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SPDIF_RX_Type) SetCR_PTMSK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SPDIF_RX_Type) GetCR_PTMSK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SPDIF_RX_Type) SetCR_CBDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *SPDIF_RX_Type) GetCR_CBDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *SPDIF_RX_Type) SetCR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *SPDIF_RX_Type) GetCR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *SPDIF_RX_Type) SetCR_NBTR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3000)|value<<12)
}
func (o *SPDIF_RX_Type) GetCR_NBTR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3000) >> 12
}
func (o *SPDIF_RX_Type) SetCR_WFA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *SPDIF_RX_Type) GetCR_WFA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *SPDIF_RX_Type) SetCR_INSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x70000)|value<<16)
}
func (o *SPDIF_RX_Type) GetCR_INSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x70000) >> 16
}

// SPDIF_RX.IMR: Interrupt mask register
func (o *SPDIF_RX_Type) SetIMR_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPDIF_RX_Type) GetIMR_RXNEIE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPDIF_RX_Type) SetIMR_CSRNEIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPDIF_RX_Type) GetIMR_CSRNEIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPDIF_RX_Type) SetIMR_PERRIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPDIF_RX_Type) GetIMR_PERRIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPDIF_RX_Type) SetIMR_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPDIF_RX_Type) GetIMR_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPDIF_RX_Type) SetIMR_SBLKIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SPDIF_RX_Type) GetIMR_SBLKIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SPDIF_RX_Type) SetIMR_SYNCDIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SPDIF_RX_Type) GetIMR_SYNCDIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SPDIF_RX_Type) SetIMR_IFEIE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *SPDIF_RX_Type) GetIMR_IFEIE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}

// SPDIF_RX.SR: Status register
func (o *SPDIF_RX_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPDIF_RX_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPDIF_RX_Type) SetSR_CSRNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPDIF_RX_Type) GetSR_CSRNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPDIF_RX_Type) SetSR_PERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPDIF_RX_Type) GetSR_PERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPDIF_RX_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPDIF_RX_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPDIF_RX_Type) SetSR_SBD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPDIF_RX_Type) GetSR_SBD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPDIF_RX_Type) SetSR_SYNCD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPDIF_RX_Type) GetSR_SYNCD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPDIF_RX_Type) SetSR_FERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPDIF_RX_Type) GetSR_FERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPDIF_RX_Type) SetSR_SERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPDIF_RX_Type) GetSR_SERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPDIF_RX_Type) SetSR_TERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPDIF_RX_Type) GetSR_TERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPDIF_RX_Type) SetSR_WIDTH5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7fff0000)|value<<16)
}
func (o *SPDIF_RX_Type) GetSR_WIDTH5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7fff0000) >> 16
}

// SPDIF_RX.IFCR: Interrupt Flag Clear register
func (o *SPDIF_RX_Type) SetIFCR_PERRCF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *SPDIF_RX_Type) GetIFCR_PERRCF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *SPDIF_RX_Type) SetIFCR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *SPDIF_RX_Type) GetIFCR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *SPDIF_RX_Type) SetIFCR_SBDCF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *SPDIF_RX_Type) GetIFCR_SBDCF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *SPDIF_RX_Type) SetIFCR_SYNCDCF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *SPDIF_RX_Type) GetIFCR_SYNCDCF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}

// SPDIF_RX.DR: Data input register
func (o *SPDIF_RX_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffffff)|value)
}
func (o *SPDIF_RX_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffffff
}
func (o *SPDIF_RX_Type) SetDR_PE(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPDIF_RX_Type) GetDR_PE() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000000) >> 24
}
func (o *SPDIF_RX_Type) SetDR_V(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x2000000)|value<<25)
}
func (o *SPDIF_RX_Type) GetDR_V() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x2000000) >> 25
}
func (o *SPDIF_RX_Type) SetDR_U(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x4000000)|value<<26)
}
func (o *SPDIF_RX_Type) GetDR_U() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x4000000) >> 26
}
func (o *SPDIF_RX_Type) SetDR_C(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPDIF_RX_Type) GetDR_C() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x8000000) >> 27
}
func (o *SPDIF_RX_Type) SetDR_PT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30000000)|value<<28)
}
func (o *SPDIF_RX_Type) GetDR_PT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30000000) >> 28
}

// SPDIF_RX.CSR: Channel Status register
func (o *SPDIF_RX_Type) SetCSR_USR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xffff)|value)
}
func (o *SPDIF_RX_Type) GetCSR_USR() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0xffff
}
func (o *SPDIF_RX_Type) SetCSR_CS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xff0000)|value<<16)
}
func (o *SPDIF_RX_Type) GetCSR_CS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0xff0000) >> 16
}
func (o *SPDIF_RX_Type) SetCSR_SOB(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPDIF_RX_Type) GetCSR_SOB() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// SPDIF_RX.DIR: Debug Information register
func (o *SPDIF_RX_Type) SetDIR_THI(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1fff)|value)
}
func (o *SPDIF_RX_Type) GetDIR_THI() uint32 {
	return volatile.LoadUint32(&o.DIR.Reg) & 0x1fff
}
func (o *SPDIF_RX_Type) SetDIR_TLO(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1fff0000)|value<<16)
}
func (o *SPDIF_RX_Type) GetDIR_TLO() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1fff0000) >> 16
}

// Secure digital input/output interface
type SDMMC_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// SDMMC.POWER: power control register
func (o *SDMMC_Type) SetPOWER_PWRCTRL(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x3)|value)
}
func (o *SDMMC_Type) GetPOWER_PWRCTRL() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x3
}

// SDMMC.CLKCR: SDI clock control register
func (o *SDMMC_Type) SetCLKCR_HWFC_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetCLKCR_HWFC_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetCLKCR_NEGEDGE(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetCLKCR_NEGEDGE() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetCLKCR_WIDBUS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x1800)|value<<11)
}
func (o *SDMMC_Type) GetCLKCR_WIDBUS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x1800) >> 11
}
func (o *SDMMC_Type) SetCLKCR_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetCLKCR_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetCLKCR_PWRSAV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetCLKCR_PWRSAV() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetCLKCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetCLKCR_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetCLKCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0xff)|value)
}
func (o *SDMMC_Type) GetCLKCR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKCR.Reg) & 0xff
}

// SDMMC.ARG: argument register
func (o *SDMMC_Type) SetARG(value uint32) {
	volatile.StoreUint32(&o.ARG.Reg, value)
}
func (o *SDMMC_Type) GetARG() uint32 {
	return volatile.LoadUint32(&o.ARG.Reg)
}

// SDMMC.CMD: command register
func (o *SDMMC_Type) SetCMD_SDIOSuspend(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetCMD_SDIOSuspend() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetCMD_CPSMEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetCMD_CPSMEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetCMD_WAITPEND(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetCMD_WAITPEND() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetCMD_WAITINT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetCMD_WAITINT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetCMD_WAITRESP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xc0)|value<<6)
}
func (o *SDMMC_Type) GetCMD_WAITRESP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xc0) >> 6
}
func (o *SDMMC_Type) SetCMD_CMDINDEX(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3f)|value)
}
func (o *SDMMC_Type) GetCMD_CMDINDEX() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3f
}

// SDMMC.RESPCMD: command response register
func (o *SDMMC_Type) SetRESPCMD(value uint32) {
	volatile.StoreUint32(&o.RESPCMD.Reg, volatile.LoadUint32(&o.RESPCMD.Reg)&^(0x3f)|value)
}
func (o *SDMMC_Type) GetRESPCMD() uint32 {
	return volatile.LoadUint32(&o.RESPCMD.Reg) & 0x3f
}

// SDMMC.RESP1: response 1..4 register
func (o *SDMMC_Type) SetRESP1(value uint32) {
	volatile.StoreUint32(&o.RESP1.Reg, value)
}
func (o *SDMMC_Type) GetRESP1() uint32 {
	return volatile.LoadUint32(&o.RESP1.Reg)
}

// SDMMC.RESP2: response 1..4 register
func (o *SDMMC_Type) SetRESP2(value uint32) {
	volatile.StoreUint32(&o.RESP2.Reg, value)
}
func (o *SDMMC_Type) GetRESP2() uint32 {
	return volatile.LoadUint32(&o.RESP2.Reg)
}

// SDMMC.RESP3: response 1..4 register
func (o *SDMMC_Type) SetRESP3(value uint32) {
	volatile.StoreUint32(&o.RESP3.Reg, value)
}
func (o *SDMMC_Type) GetRESP3() uint32 {
	return volatile.LoadUint32(&o.RESP3.Reg)
}

// SDMMC.RESP4: response 1..4 register
func (o *SDMMC_Type) SetRESP4(value uint32) {
	volatile.StoreUint32(&o.RESP4.Reg, value)
}
func (o *SDMMC_Type) GetRESP4() uint32 {
	return volatile.LoadUint32(&o.RESP4.Reg)
}

// SDMMC.DTIMER: data timer register
func (o *SDMMC_Type) SetDTIMER(value uint32) {
	volatile.StoreUint32(&o.DTIMER.Reg, value)
}
func (o *SDMMC_Type) GetDTIMER() uint32 {
	return volatile.LoadUint32(&o.DTIMER.Reg)
}

// SDMMC.DLEN: data length register
func (o *SDMMC_Type) SetDLEN_DATALENGTH(value uint32) {
	volatile.StoreUint32(&o.DLEN.Reg, volatile.LoadUint32(&o.DLEN.Reg)&^(0x1ffffff)|value)
}
func (o *SDMMC_Type) GetDLEN_DATALENGTH() uint32 {
	return volatile.LoadUint32(&o.DLEN.Reg) & 0x1ffffff
}

// SDMMC.DCTRL: data control register
func (o *SDMMC_Type) SetDCTRL_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetDCTRL_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetDCTRL_RWMOD(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetDCTRL_RWMOD() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetDCTRL_RWSTOP(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetDCTRL_RWSTOP() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetDCTRL_RWSTART(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetDCTRL_RWSTART() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetDCTRL_DBLOCKSIZE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0xf0)|value<<4)
}
func (o *SDMMC_Type) GetDCTRL_DBLOCKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0xf0) >> 4
}
func (o *SDMMC_Type) SetDCTRL_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetDCTRL_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetDCTRL_DTMODE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetDCTRL_DTMODE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetDCTRL_DTDIR(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetDCTRL_DTDIR() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetDCTRL_DTEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetDCTRL_DTEN() uint32 {
	return volatile.LoadUint32(&o.DCTRL.Reg) & 0x1
}

// SDMMC.DCOUNT: data counter register
func (o *SDMMC_Type) SetDCOUNT_DATACOUNT(value uint32) {
	volatile.StoreUint32(&o.DCOUNT.Reg, volatile.LoadUint32(&o.DCOUNT.Reg)&^(0x1ffffff)|value)
}
func (o *SDMMC_Type) GetDCOUNT_DATACOUNT() uint32 {
	return volatile.LoadUint32(&o.DCOUNT.Reg) & 0x1ffffff
}

// SDMMC.STA: status register
func (o *SDMMC_Type) SetSTA_SDIOIT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetSTA_SDIOIT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetSTA_RXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200000)|value<<21)
}
func (o *SDMMC_Type) GetSTA_RXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200000) >> 21
}
func (o *SDMMC_Type) SetSTA_TXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100000)|value<<20)
}
func (o *SDMMC_Type) GetSTA_TXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100000) >> 20
}
func (o *SDMMC_Type) SetSTA_RXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80000)|value<<19)
}
func (o *SDMMC_Type) GetSTA_RXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80000) >> 19
}
func (o *SDMMC_Type) SetSTA_TXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40000)|value<<18)
}
func (o *SDMMC_Type) GetSTA_TXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40000) >> 18
}
func (o *SDMMC_Type) SetSTA_RXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20000)|value<<17)
}
func (o *SDMMC_Type) GetSTA_RXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20000) >> 17
}
func (o *SDMMC_Type) SetSTA_TXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetSTA_TXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetSTA_RXFIFOHF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetSTA_RXFIFOHF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetSTA_TXFIFOHE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetSTA_TXFIFOHE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetSTA_RXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetSTA_RXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetSTA_TXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetSTA_TXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetSTA_CMDACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetSTA_CMDACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetSTA_DBCKEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetSTA_DBCKEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetSTA_DATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetSTA_DATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetSTA_CMDSENT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetSTA_CMDSENT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetSTA_CMDREND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetSTA_CMDREND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetSTA_RXOVERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetSTA_RXOVERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetSTA_TXUNDERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetSTA_TXUNDERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetSTA_DTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetSTA_DTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetSTA_CTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetSTA_CTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetSTA_DCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetSTA_DCRCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetSTA_CCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetSTA_CCRCFAIL() uint32 {
	return volatile.LoadUint32(&o.STA.Reg) & 0x1
}

// SDMMC.ICR: interrupt clear register
func (o *SDMMC_Type) SetICR_SDIOITC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetICR_SDIOITC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetICR_DBCKENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetICR_DBCKENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetICR_DATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetICR_DATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetICR_CMDSENTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetICR_CMDSENTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetICR_CMDRENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetICR_CMDRENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetICR_RXOVERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetICR_RXOVERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetICR_TXUNDERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetICR_TXUNDERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetICR_DTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetICR_DTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetICR_CTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetICR_CTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetICR_DCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetICR_DCRCFAILC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetICR_CCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetICR_CCRCFAILC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// SDMMC.MASK: mask register
func (o *SDMMC_Type) SetMASK_SDIOITIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetMASK_SDIOITIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetMASK_RXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200000)|value<<21)
}
func (o *SDMMC_Type) GetMASK_RXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200000) >> 21
}
func (o *SDMMC_Type) SetMASK_TXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100000)|value<<20)
}
func (o *SDMMC_Type) GetMASK_TXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100000) >> 20
}
func (o *SDMMC_Type) SetMASK_RXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80000)|value<<19)
}
func (o *SDMMC_Type) GetMASK_RXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80000) >> 19
}
func (o *SDMMC_Type) SetMASK_TXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40000)|value<<18)
}
func (o *SDMMC_Type) GetMASK_TXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40000) >> 18
}
func (o *SDMMC_Type) SetMASK_RXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20000)|value<<17)
}
func (o *SDMMC_Type) GetMASK_RXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20000) >> 17
}
func (o *SDMMC_Type) SetMASK_TXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetMASK_TXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetMASK_RXFIFOHFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetMASK_RXFIFOHFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetMASK_TXFIFOHEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetMASK_TXFIFOHEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetMASK_RXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetMASK_RXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetMASK_TXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetMASK_TXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetMASK_CMDACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetMASK_CMDACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetMASK_DBCKENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetMASK_DBCKENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetMASK_DATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetMASK_DATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetMASK_CMDSENTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetMASK_CMDSENTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetMASK_CMDRENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetMASK_CMDRENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetMASK_RXOVERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetMASK_RXOVERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetMASK_TXUNDERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetMASK_TXUNDERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetMASK_DTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetMASK_DTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetMASK_CTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetMASK_CTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetMASK_DCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetMASK_DCRCFAILIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetMASK_CCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetMASK_CCRCFAILIE() uint32 {
	return volatile.LoadUint32(&o.MASK.Reg) & 0x1
}

// SDMMC.FIFOCNT: FIFO counter register
func (o *SDMMC_Type) SetFIFOCNT_FIFOCOUNT(value uint32) {
	volatile.StoreUint32(&o.FIFOCNT.Reg, volatile.LoadUint32(&o.FIFOCNT.Reg)&^(0xffffff)|value)
}
func (o *SDMMC_Type) GetFIFOCNT_FIFOCOUNT() uint32 {
	return volatile.LoadUint32(&o.FIFOCNT.Reg) & 0xffffff
}

// SDMMC.FIFO: data FIFO register
func (o *SDMMC_Type) SetFIFO(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, value)
}
func (o *SDMMC_Type) GetFIFO() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg)
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Status register 1
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_ITSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetCR_ITSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// RTC.ISR: initialization and status register
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetISR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetISR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetISR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetISR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetISR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetISR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.SSR: sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.SHIFTR: shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: time stamp time register
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.CALR: calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.TAMPCR: tamper configuration register
func (o *RTC_Type) SetTAMPCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAMPCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1
}
func (o *RTC_Type) SetTAMPCR_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAMPCR_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAMPCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAMPCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAMPCR_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetTAMPCR_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetTAMPCR_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetTAMPCR_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetTAMPCR_TAMP3E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetTAMPCR_TAMP3E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetTAMPCR_TAMP3TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetTAMPCR_TAMP3TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetTAMPCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTAMPCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTAMPCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetTAMPCR_TAMPFREQ() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetTAMPCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_Type) GetTAMPCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1800) >> 11
}
func (o *RTC_Type) SetTAMPCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_Type) GetTAMPCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x6000) >> 13
}
func (o *RTC_Type) SetTAMPCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTAMPCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTAMPCR_TAMP1IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetTAMPCR_TAMP1IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetTAMPCR_TAMP1NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetTAMPCR_TAMP1NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetTAMPCR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAMPCR_TAMP1MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAMPCR_TAMP2IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetTAMPCR_TAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetTAMPCR_TAMP2NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetTAMPCR_TAMP2NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetTAMPCR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_Type) GetTAMPCR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x200000) >> 21
}
func (o *RTC_Type) SetTAMPCR_TAMP3IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTAMPCR_TAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTAMPCR_TAMP3NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetTAMPCR_TAMP3NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetTAMPCR_TAMP3MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetTAMPCR_TAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1000000) >> 24
}

// RTC.ALRMASSR: alarm A sub second register
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBSSR: alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.OR: option register
func (o *RTC_Type) SetOR_RTC_ALARM_TYPE(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetOR_RTC_ALARM_TYPE() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}
func (o *RTC_Type) SetOR_RTC_OUT_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetOR_RTC_OUT_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}

// RTC.BKP0R: backup register
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: backup register
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: backup register
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: backup register
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: backup register
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: backup register
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: backup register
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: backup register
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: backup register
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: backup register
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: backup register
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: backup register
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: backup register
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: backup register
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: backup register
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: backup register
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: backup register
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: backup register
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: backup register
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: backup register
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// RTC.BKP20R: backup register
func (o *RTC_Type) SetBKP20R(value uint32) {
	volatile.StoreUint32(&o.BKP20R.Reg, value)
}
func (o *RTC_Type) GetBKP20R() uint32 {
	return volatile.LoadUint32(&o.BKP20R.Reg)
}

// RTC.BKP21R: backup register
func (o *RTC_Type) SetBKP21R(value uint32) {
	volatile.StoreUint32(&o.BKP21R.Reg, value)
}
func (o *RTC_Type) GetBKP21R() uint32 {
	return volatile.LoadUint32(&o.BKP21R.Reg)
}

// RTC.BKP22R: backup register
func (o *RTC_Type) SetBKP22R(value uint32) {
	volatile.StoreUint32(&o.BKP22R.Reg, value)
}
func (o *RTC_Type) GetBKP22R() uint32 {
	return volatile.LoadUint32(&o.BKP22R.Reg)
}

// RTC.BKP23R: backup register
func (o *RTC_Type) SetBKP23R(value uint32) {
	volatile.StoreUint32(&o.BKP23R.Reg, value)
}
func (o *RTC_Type) GetBKP23R() uint32 {
	return volatile.LoadUint32(&o.BKP23R.Reg)
}

// RTC.BKP24R: backup register
func (o *RTC_Type) SetBKP24R(value uint32) {
	volatile.StoreUint32(&o.BKP24R.Reg, value)
}
func (o *RTC_Type) GetBKP24R() uint32 {
	return volatile.LoadUint32(&o.BKP24R.Reg)
}

// RTC.BKP25R: backup register
func (o *RTC_Type) SetBKP25R(value uint32) {
	volatile.StoreUint32(&o.BKP25R.Reg, value)
}
func (o *RTC_Type) GetBKP25R() uint32 {
	return volatile.LoadUint32(&o.BKP25R.Reg)
}

// RTC.BKP26R: backup register
func (o *RTC_Type) SetBKP26R(value uint32) {
	volatile.StoreUint32(&o.BKP26R.Reg, value)
}
func (o *RTC_Type) GetBKP26R() uint32 {
	return volatile.LoadUint32(&o.BKP26R.Reg)
}

// RTC.BKP27R: backup register
func (o *RTC_Type) SetBKP27R(value uint32) {
	volatile.StoreUint32(&o.BKP27R.Reg, value)
}
func (o *RTC_Type) GetBKP27R() uint32 {
	return volatile.LoadUint32(&o.BKP27R.Reg)
}

// RTC.BKP28R: backup register
func (o *RTC_Type) SetBKP28R(value uint32) {
	volatile.StoreUint32(&o.BKP28R.Reg, value)
}
func (o *RTC_Type) GetBKP28R() uint32 {
	return volatile.LoadUint32(&o.BKP28R.Reg)
}

// RTC.BKP29R: backup register
func (o *RTC_Type) SetBKP29R(value uint32) {
	volatile.StoreUint32(&o.BKP29R.Reg, value)
}
func (o *RTC_Type) GetBKP29R() uint32 {
	return volatile.LoadUint32(&o.BKP29R.Reg)
}

// RTC.BKP30R: backup register
func (o *RTC_Type) SetBKP30R(value uint32) {
	volatile.StoreUint32(&o.BKP30R.Reg, value)
}
func (o *RTC_Type) GetBKP30R() uint32 {
	return volatile.LoadUint32(&o.BKP30R.Reg)
}

// RTC.BKP31R: backup register
func (o *RTC_Type) SetBKP31R(value uint32) {
	volatile.StoreUint32(&o.BKP31R.Reg, value)
}
func (o *RTC_Type) GetBKP31R() uint32 {
	return volatile.LoadUint32(&o.BKP31R.Reg)
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_M1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR1_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR1_EOBIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetCR1_EOBIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetCR1_RTOIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetCR1_RTOIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR1_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR1_MME(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *USART_Type) SetCR1_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3e00000)|value<<21)
}
func (o *USART_Type) GetCR1_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3e00000) >> 21
}
func (o *USART_Type) SetCR1_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f0000)|value<<16)
}
func (o *USART_Type) GetCR1_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1f0000) >> 16
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_RTOEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR2_RTOEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR2_ABREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR2_ABREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR2_ABRMOD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x600000)|value<<21)
}
func (o *USART_Type) GetCR2_ABRMOD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x600000) >> 21
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *USART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *USART_Type) SetCR3_SCARCNT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000)|value<<17)
}
func (o *USART_Type) GetCR3_SCARCNT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000) >> 17
}
func (o *USART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xffff
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// USART.RTOR: Receiver timeout register
func (o *USART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}
func (o *USART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}

// USART.RQR: Request register
func (o *USART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}

// USART.ISR: Interrupt & status register
func (o *USART_Type) SetISR_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetISR_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetISR_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetISR_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetISR_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetISR_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetISR_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetISR_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetISR_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetISR_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetISR_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetISR_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetISR_ABRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetISR_ABRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetISR_ABRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetISR_ABRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetISR_EOBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetISR_EOBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetISR_RTOF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetISR_RTOF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetISR_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetISR_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetISR_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetISR_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetISR_LBDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetISR_LBDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetISR_TXE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetISR_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetISR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetISR_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetISR_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetISR_NF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetISR_NF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetISR_FE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetISR_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetISR_PE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetISR_PE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// USART.ICR: Interrupt flag clear register
func (o *USART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetICR_EOBCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetICR_EOBCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetICR_RTOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetICR_RTOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetICR_LBDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetICR_LBDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetICR_NCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_NCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// USART.RDR: Receive data register
func (o *USART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// USART.TDR: Transmit data register
func (o *USART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	OTG_FS_GOTGCTL         volatile.Register32 // 0x0
	OTG_FS_GOTGINT         volatile.Register32 // 0x4
	OTG_FS_GAHBCFG         volatile.Register32 // 0x8
	OTG_FS_GUSBCFG         volatile.Register32 // 0xC
	OTG_FS_GRSTCTL         volatile.Register32 // 0x10
	OTG_FS_GINTSTS         volatile.Register32 // 0x14
	OTG_FS_GINTMSK         volatile.Register32 // 0x18
	OTG_FS_GRXSTSR_Device  volatile.Register32 // 0x1C
	OTG_FS_GRXSTSP_Device  volatile.Register32 // 0x20
	OTG_FS_GRXFSIZ         volatile.Register32 // 0x24
	OTG_FS_DIEPTXF0_Device volatile.Register32 // 0x28
	OTG_FS_HNPTXSTS        volatile.Register32 // 0x2C
	OTG_FS_GI2CCTL         volatile.Register32 // 0x30
	_                      [4]byte
	OTG_FS_GCCFG           volatile.Register32 // 0x38
	OTG_FS_CID             volatile.Register32 // 0x3C
	_                      [20]byte
	OTG_FS_GLPMCFG         volatile.Register32 // 0x54
	OTG_FS_GPWRDN          volatile.Register32 // 0x58
	_                      [4]byte
	OTG_FS_GADPCTL         volatile.Register32 // 0x60
	_                      [156]byte
	OTG_FS_HPTXFSIZ        volatile.Register32 // 0x100
	OTG_FS_DIEPTXF1        volatile.Register32 // 0x104
	OTG_FS_DIEPTXF2        volatile.Register32 // 0x108
	OTG_FS_DIEPTXF3        volatile.Register32 // 0x10C
	OTG_FS_DIEPTXF4        volatile.Register32 // 0x110
	OTG_FS_DIEPTXF5        volatile.Register32 // 0x114
}

// USB_OTG_FS.OTG_FS_GOTGCTL: OTG_FS control and status register (OTG_FS_GOTGCTL)
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_SRQSCS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_SRQSCS() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_SRQ(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_SRQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_HNGSCS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_HNGSCS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_HNPRQ(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_HNPRQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_HSHNPEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_HSHNPEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_DHNPEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_DHNPEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_CIDSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_CIDSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_DBCT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_DBCT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_ASVLD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_ASVLD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_BSVLD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_BSVLD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_VBVALOEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_VBVALOEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_VBVALOVAL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_VBVALOVAL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_AVALOEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_AVALOEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_AVALOVAL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_AVALOVAL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_BVALOEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_BVALOEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_BVALOVAL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_BVALOVAL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_EHEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_EHEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_OTGVER(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_OTGVER() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x100000) >> 20
}

// USB_OTG_FS.OTG_FS_GOTGINT: OTG_FS interrupt register (OTG_FS_GOTGINT)
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_SEDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_SEDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_SRSSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_SRSSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_HNSSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_HNSSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_HNGDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_HNGDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_ADTOCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_ADTOCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_DBCDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_DBCDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_IDCHNG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_IDCHNG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x100000) >> 20
}

// USB_OTG_FS.OTG_FS_GAHBCFG: OTG_FS AHB configuration register (OTG_FS_GAHBCFG)
func (o *USB_OTG_FS_Type) SetOTG_FS_GAHBCFG_GINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GAHBCFG_GINT() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GAHBCFG_TXFELVL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GAHBCFG_TXFELVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GAHBCFG_PTXFELVL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GAHBCFG_PTXFELVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg) & 0x100) >> 8
}

// USB_OTG_FS.OTG_FS_GUSBCFG: OTG_FS USB configuration register (OTG_FS_GUSBCFG)
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_TOCAL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x7)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_TOCAL() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_PHYSEL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_PHYSEL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_SRPCAP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_SRPCAP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_HNPCAP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_HNPCAP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_TRDT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x3c00)|value<<10)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_TRDT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x3c00) >> 10
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_FHMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_FHMOD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_FDMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_FDMOD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x40000000) >> 30
}

// USB_OTG_FS.OTG_FS_GRSTCTL: OTG_FS reset register (OTG_FS_GRSTCTL)
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_CSRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_CSRST() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_HSRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_HSRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_FCRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_FCRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_RXFFLSH(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_RXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_TXFFLSH(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_TXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x7c0)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x7c0) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_AHBIDL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_AHBIDL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.OTG_FS_GINTSTS: OTG_FS core interrupt register (OTG_FS_GINTSTS)
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_CMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_CMOD() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_MMIS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_MMIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_OTGINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_SOF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_SOF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_RXFLVL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_RXFLVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_NPTXFE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_NPTXFE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_GINAKEFF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_GINAKEFF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_GOUTNAKEFF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_GOUTNAKEFF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_ESUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_ESUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_USBSUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_USBSUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_USBRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_USBRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_ENUMDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_ENUMDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_ISOODRP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_ISOODRP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_EOPF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_EOPF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_IEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_OEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_IISOIXFR(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_IISOIXFR() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_IPXFR_INCOMPISOOUT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_IPXFR_INCOMPISOOUT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_HPRTINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_HPRTINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_HCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_HCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_PTXFE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_PTXFE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_CIDSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_CIDSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_DISCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_SRQINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_SRQINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_WKUPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_WKUPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_RSTDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_RSTDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x800000) >> 23
}

// USB_OTG_FS.OTG_FS_GINTMSK: OTG_FS interrupt mask register (OTG_FS_GINTMSK)
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_MMISM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_MMISM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_OTGINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_SOFM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_SOFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_RXFLVLM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_RXFLVLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_NPTXFEM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_NPTXFEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_GINAKEFFM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_GINAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_GONAKEFFM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_GONAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_ESUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_ESUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_USBSUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_USBSUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_USBRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_USBRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_ENUMDNEM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_ENUMDNEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_ISOODRPM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_ISOODRPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_EOPFM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_EOPFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_IEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_OEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_IISOIXFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_IISOIXFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_IPXFRM_IISOOXFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_IPXFRM_IISOOXFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_PRTIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_PRTIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_HCIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_HCIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_PTXFEM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_PTXFEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_CIDSCHGM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_CIDSCHGM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_DISCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_SRQIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_SRQIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_WUIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_WUIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_RSTDETM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_RSTDETM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x800000) >> 23
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_LPMIN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_LPMIN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x8000000) >> 27
}

// USB_OTG_FS.OTG_FS_GRXSTSR_Device: OTG_FS Receive status debug read(Device mode)
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0xf)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_EPNUM() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0xf
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_BCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_BCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0x1e0000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_FRMNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0x1e00000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_FRMNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0x1e00000) >> 21
}

// USB_OTG_FS.OTG_FS_GRXSTSP_Device: OTG status read and pop register (Device mode)
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0xf)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_EPNUM() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0xf
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_BCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_BCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0x1e0000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_FRMNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0x1e00000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_FRMNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0x1e00000) >> 21
}

// USB_OTG_FS.OTG_FS_GRXFSIZ: OTG_FS Receive FIFO size register (OTG_FS_GRXFSIZ)
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXFSIZ_RXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXFSIZ.Reg, volatile.LoadUint32(&o.OTG_FS_GRXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXFSIZ_RXFD() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GRXFSIZ.Reg) & 0xffff
}

// USB_OTG_FS.OTG_FS_DIEPTXF0_Device: OTG_FS Endpoint 0 Transmit FIFO size
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF0_Device_TX0FSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF0_Device.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF0_Device.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF0_Device_TX0FSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF0_Device.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF0_Device_TX0FD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF0_Device.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF0_Device.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF0_Device_TX0FD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF0_Device.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_HNPTXSTS: OTG_FS non-periodic transmit FIFO/queue status register (OTG_FS_GNPTXSTS)
func (o *USB_OTG_FS_Type) SetOTG_FS_HNPTXSTS_NPTXFSAV(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HNPTXSTS_NPTXFSAV() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_HNPTXSTS_NPTQXSAV(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg)&^(0xff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HNPTXSTS_NPTQXSAV() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg) & 0xff0000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_HNPTXSTS_NPTXQTOP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg)&^(0x7f000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HNPTXSTS_NPTXQTOP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg) & 0x7f000000) >> 24
}

// USB_OTG_FS.OTG_FS_GI2CCTL: OTG I2C access register
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_RWDATA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0xff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_RWDATA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0xff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_REGADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0xff00)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_REGADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0xff00) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_ADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_ADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x7f0000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_I2CEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_I2CEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x800000) >> 23
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_I2CDEVADR(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0xc000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_I2CDEVADR() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0xc000000) >> 26
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_I2CDATSE0(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_I2CDATSE0() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_RW(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_RW() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_BSYDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_BSYDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.OTG_FS_GCCFG: OTG_FS general core configuration register (OTG_FS_GCCFG)
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_PWRDWN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_PWRDWN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_BCDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_BCDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_DCDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_DCDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_PDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_PDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_SDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_SDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_VBDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_VBDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_DCDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_DCDET() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_PDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_PDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_SDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_SDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_PS2DET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_PS2DET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x8) >> 3
}

// USB_OTG_FS.OTG_FS_CID: core ID register
func (o *USB_OTG_FS_Type) SetOTG_FS_CID(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_CID.Reg, value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_CID() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_CID.Reg)
}

// USB_OTG_FS.OTG_FS_GLPMCFG: OTG core LPM configuration register
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMEN() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMACK(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_BESL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x3c)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_BESL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x3c) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_REMWAKE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_REMWAKE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_L1SSEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_L1SSEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_BESLTHRS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0xf00)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_BESLTHRS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0xf00) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_L1DSEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_L1DSEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x6000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x6000) >> 13
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_SLPSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_SLPSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_L1RSMOK(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_L1RSMOK() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMCHIDX(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMCHIDX() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x1e0000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMRCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0xe00000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMRCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0xe00000) >> 21
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_SNDLPM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_SNDLPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMRCNTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0xe000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMRCNTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0xe000000) >> 25
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_ENBESL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_ENBESL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x10000000) >> 28
}

// USB_OTG_FS.OTG_FS_GPWRDN: OTG power down register
func (o *USB_OTG_FS_Type) SetOTG_FS_GPWRDN_ADPMEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GPWRDN.Reg, volatile.LoadUint32(&o.OTG_FS_GPWRDN.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GPWRDN_ADPMEN() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GPWRDN.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GPWRDN_ADPIF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GPWRDN.Reg, volatile.LoadUint32(&o.OTG_FS_GPWRDN.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GPWRDN_ADPIF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GPWRDN.Reg) & 0x800000) >> 23
}

// USB_OTG_FS.OTG_FS_GADPCTL: OTG ADP timer, control and status register
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_PRBDSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x3)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_PRBDSCHG() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x3
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_PRBDELTA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0xc)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_PRBDELTA() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0xc) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_PRBPER(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x30)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_PRBPER() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x30) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_RTIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x1ffc0)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_RTIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x1ffc0) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ENAPRB(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ENAPRB() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ENASNS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ENASNS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ADPRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ADPRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ADPEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ADPEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ADPPRBIF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ADPPRBIF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ADPSNSIF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x400000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ADPSNSIF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x400000) >> 22
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ADPTOIF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ADPTOIF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x800000) >> 23
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ADPPRBIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ADPPRBIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ADPSNSIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ADPSNSIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_ADPTOIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_ADPTOIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GADPCTL_AR(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GADPCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg)&^(0x18000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GADPCTL_AR() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GADPCTL.Reg) & 0x18000000) >> 27
}

// USB_OTG_FS.OTG_FS_HPTXFSIZ: OTG_FS Host periodic transmit FIFO size register (OTG_FS_HPTXFSIZ)
func (o *USB_OTG_FS_Type) SetOTG_FS_HPTXFSIZ_PTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.OTG_FS_HPTXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HPTXFSIZ_PTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_HPTXFSIZ.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_HPTXFSIZ_PTXFSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.OTG_FS_HPTXFSIZ.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HPTXFSIZ_PTXFSIZ() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_HPTXFSIZ.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF1: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF1)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF1_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF1.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF1.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF1_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF1.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF1_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF1.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF1.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF1_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF1.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF2: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF2)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF2_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF2.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF2.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF2_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF2.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF2_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF2.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF2.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF2_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF2.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF3: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF3)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF3_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF3.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF3.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF3_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF3.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF3_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF3.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF3.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF3_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF3.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF4: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF4)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF4_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF4.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF4.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF4_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF4.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF4_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF4.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF4.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF4_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF4.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF5: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF5)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF5_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF5.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF5.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF5_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF5.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF5_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF5.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF5.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF5_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF5.Reg) & 0xffff0000) >> 16
}

// USB on the go high speed
type USB_OTG_HS_Type struct {
	OTG_HS_GOTGCTL        volatile.Register32 // 0x0
	OTG_HS_GOTGINT        volatile.Register32 // 0x4
	OTG_HS_GAHBCFG        volatile.Register32 // 0x8
	OTG_HS_GUSBCFG        volatile.Register32 // 0xC
	OTG_HS_GRSTCTL        volatile.Register32 // 0x10
	OTG_HS_GINTSTS        volatile.Register32 // 0x14
	OTG_HS_GINTMSK        volatile.Register32 // 0x18
	OTG_HS_GRXSTSR_Host   volatile.Register32 // 0x1C
	OTG_HS_GRXSTSP_Host   volatile.Register32 // 0x20
	OTG_HS_GRXFSIZ        volatile.Register32 // 0x24
	OTG_HS_HNPTXFSIZ_Host volatile.Register32 // 0x28
	OTG_HS_GNPTXSTS       volatile.Register32 // 0x2C
	_                     [8]byte
	OTG_HS_GCCFG          volatile.Register32 // 0x38
	OTG_HS_CID            volatile.Register32 // 0x3C
	_                     [20]byte
	OTG_HS_GLPMCFG        volatile.Register32 // 0x54
	_                     [168]byte
	OTG_HS_HPTXFSIZ       volatile.Register32 // 0x100
	OTG_HS_DIEPTXF1       volatile.Register32 // 0x104
	OTG_HS_DIEPTXF2       volatile.Register32 // 0x108
	_                     [16]byte
	OTG_HS_DIEPTXF3       volatile.Register32 // 0x11C
	OTG_HS_DIEPTXF4       volatile.Register32 // 0x120
	OTG_HS_DIEPTXF5       volatile.Register32 // 0x124
	OTG_HS_DIEPTXF6       volatile.Register32 // 0x128
	OTG_HS_DIEPTXF7       volatile.Register32 // 0x12C
}

// USB_OTG_HS.OTG_HS_GOTGCTL: OTG_HS control and status register
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_SRQSCS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_SRQSCS() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_SRQ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_SRQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_HNGSCS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_HNGSCS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_HNPRQ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_HNPRQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_HSHNPEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_HSHNPEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x400) >> 10
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_DHNPEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_DHNPEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_CIDSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_CIDSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_DBCT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_DBCT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_ASVLD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_ASVLD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_BSVLD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_BSVLD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGCTL_EHEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGCTL_EHEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGCTL.Reg) & 0x1000) >> 12
}

// USB_OTG_HS.OTG_HS_GOTGINT: OTG_HS interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_SEDET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_SEDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_SRSSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_SRSSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_HNSSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_HNSSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_HNGDET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_HNGDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_ADTOCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_ADTOCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_DBCDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_DBCDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GOTGINT_IDCHNG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GOTGINT_IDCHNG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GOTGINT.Reg) & 0x100000) >> 20
}

// USB_OTG_HS.OTG_HS_GAHBCFG: OTG_HS AHB configuration register
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_GINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_GINT() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_HBSTLEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x1e)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_HBSTLEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x1e) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_DMAEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_TXFELVL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_TXFELVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GAHBCFG_PTXFELVL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GAHBCFG_PTXFELVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GAHBCFG.Reg) & 0x100) >> 8
}

// USB_OTG_HS.OTG_HS_GUSBCFG: OTG_HS USB configuration register
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_TOCAL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x7)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_TOCAL() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_PHYSEL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_PHYSEL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_SRPCAP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_SRPCAP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_HNPCAP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_HNPCAP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_TRDT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x3c00)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_TRDT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x3c00) >> 10
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_PHYLPCS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_PHYLPCS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIFSLS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIFSLS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIAR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIAR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPICSM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPICSM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIEVBUSD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIEVBUSD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIEVBUSI(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIEVBUSI() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_TSDPS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x400000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_TSDPS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x400000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_PCCI(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_PCCI() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x800000) >> 23
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_PTCI(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_PTCI() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_ULPIIPD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_ULPIIPD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_FHMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_FHMOD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GUSBCFG_FDMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GUSBCFG_FDMOD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GUSBCFG.Reg) & 0x40000000) >> 30
}

// USB_OTG_HS.OTG_HS_GRSTCTL: OTG_HS reset register
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_CSRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_CSRST() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_HSRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_HSRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_FCRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_FCRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_RXFFLSH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_RXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_TXFFLSH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_TXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x7c0)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x7c0) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_AHBIDL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_AHBIDL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRSTCTL_DMAREQ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRSTCTL_DMAREQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRSTCTL.Reg) & 0x40000000) >> 30
}

// USB_OTG_HS.OTG_HS_GINTSTS: OTG_HS core interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_CMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_CMOD() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_MMIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_MMIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_OTGINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_SOF(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_SOF() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_RXFLVL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_RXFLVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_NPTXFE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_NPTXFE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_GINAKEFF(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_GINAKEFF() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_BOUTNAKEFF(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_BOUTNAKEFF() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_ESUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_ESUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x400) >> 10
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_USBSUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_USBSUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_USBRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_USBRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_ENUMDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_ENUMDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_ISOODRP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_ISOODRP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_EOPF(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_EOPF() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_IEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_OEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_IISOIXFR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_IISOIXFR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_PXFR_INCOMPISOOUT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_PXFR_INCOMPISOOUT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_DATAFSUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x400000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_DATAFSUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x400000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_HPRTINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_HPRTINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_HCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_HCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_PTXFE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_PTXFE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_CIDSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_CIDSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_DISCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_SRQINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_SRQINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTSTS_WKUINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTSTS_WKUINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTSTS.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_GINTMSK: OTG_HS interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_MMISM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_MMISM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_OTGINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_SOFM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_SOFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_RXFLVLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_RXFLVLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_NPTXFEM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_NPTXFEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_GINAKEFFM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_GINAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_GONAKEFFM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_GONAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_ESUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_ESUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x400) >> 10
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_USBSUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_USBSUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_USBRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_USBRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_ENUMDNEM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_ENUMDNEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_ISOODRPM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_ISOODRPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_EOPFM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_EOPFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_IEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_OEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_IISOIXFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_IISOIXFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_PXFRM_IISOOXFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_PXFRM_IISOOXFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_FSUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x400000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_FSUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x400000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_PRTIM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_PRTIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_HCIM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_HCIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_PTXFEM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_PTXFEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_CIDSCHGM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_CIDSCHGM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_DISCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_SRQIM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_SRQIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_WUIM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_WUIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_RSTDE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_RSTDE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x800000) >> 23
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GINTMSK_LPMINTM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GINTMSK_LPMINTM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GINTMSK.Reg) & 0x8000000) >> 27
}

// USB_OTG_HS.OTG_HS_GRXSTSR_Host: OTG_HS Receive status debug read register (host mode)
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSR_Host_CHNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSR_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg)&^(0xf)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSR_Host_CHNUM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg) & 0xf
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSR_Host_BCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSR_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSR_Host_BCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSR_Host_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSR_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSR_Host_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSR_Host_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSR_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSR_Host_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSR_Host.Reg) & 0x1e0000) >> 17
}

// USB_OTG_HS.OTG_HS_GRXSTSP_Host: OTG_HS status read and pop register (host mode)
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSP_Host_CHNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSP_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg)&^(0xf)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSP_Host_CHNUM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg) & 0xf
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSP_Host_BCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSP_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSP_Host_BCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSP_Host_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSP_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSP_Host_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXSTSP_Host_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXSTSP_Host.Reg, volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXSTSP_Host_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GRXSTSP_Host.Reg) & 0x1e0000) >> 17
}

// USB_OTG_HS.OTG_HS_GRXFSIZ: OTG_HS Receive FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_GRXFSIZ_RXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GRXFSIZ.Reg, volatile.LoadUint32(&o.OTG_HS_GRXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GRXFSIZ_RXFD() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GRXFSIZ.Reg) & 0xffff
}

// USB_OTG_HS.OTG_HS_HNPTXFSIZ_Host: OTG_HS nonperiodic transmit FIFO size register (host mode)
func (o *USB_OTG_HS_Type) SetOTG_HS_HNPTXFSIZ_Host_NPTXFSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HNPTXFSIZ_Host.Reg, volatile.LoadUint32(&o.OTG_HS_HNPTXFSIZ_Host.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HNPTXFSIZ_Host_NPTXFSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HNPTXFSIZ_Host.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HNPTXFSIZ_Host_NPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HNPTXFSIZ_Host.Reg, volatile.LoadUint32(&o.OTG_HS_HNPTXFSIZ_Host.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HNPTXFSIZ_Host_NPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HNPTXFSIZ_Host.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_GNPTXSTS: OTG_HS nonperiodic transmit FIFO/queue status register
func (o *USB_OTG_HS_Type) SetOTG_HS_GNPTXSTS_NPTXFSAV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GNPTXSTS_NPTXFSAV() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GNPTXSTS_NPTQXSAV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg)&^(0xff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GNPTXSTS_NPTQXSAV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg) & 0xff0000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GNPTXSTS_NPTXQTOP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg)&^(0x7f000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GNPTXSTS_NPTXQTOP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GNPTXSTS.Reg) & 0x7f000000) >> 24
}

// USB_OTG_HS.OTG_HS_GCCFG: OTG_HS general core configuration register
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_PWRDWN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_PWRDWN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_BCDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_BCDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_DCDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_DCDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_PDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_PDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_SDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_SDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_VBDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_VBDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_DCDET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_DCDET() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_PDET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_PDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_SDET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_SDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GCCFG_PS2DET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GCCFG_PS2DET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GCCFG.Reg) & 0x8) >> 3
}

// USB_OTG_HS.OTG_HS_CID: OTG_HS core ID register
func (o *USB_OTG_HS_Type) SetOTG_HS_CID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_CID.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_CID() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_CID.Reg)
}

// USB_OTG_HS.OTG_HS_GLPMCFG: OTG core LPM configuration register
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_LPMEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_LPMEN() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_LPMACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_LPMACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_BESL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x3c)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_BESL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x3c) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_REMWAKE(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_REMWAKE() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_L1SSEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_L1SSEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_BESLTHRS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0xf00)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_BESLTHRS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0xf00) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_L1DSEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_L1DSEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_LPMRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x6000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_LPMRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x6000) >> 13
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_SLPSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_SLPSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_L1RSMOK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_L1RSMOK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_LPMCHIDX(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_LPMCHIDX() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x1e0000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_LPMRCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0xe00000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_LPMRCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0xe00000) >> 21
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_SNDLPM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_SNDLPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_LPMRCNTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0xe000000)|value<<25)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_LPMRCNTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0xe000000) >> 25
}
func (o *USB_OTG_HS_Type) SetOTG_HS_GLPMCFG_ENBESL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_GLPMCFG_ENBESL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_GLPMCFG.Reg) & 0x10000000) >> 28
}

// USB_OTG_HS.OTG_HS_HPTXFSIZ: OTG_HS Host periodic transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HPTXFSIZ_PTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.OTG_HS_HPTXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPTXFSIZ_PTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HPTXFSIZ.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPTXFSIZ_PTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.OTG_HS_HPTXFSIZ.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPTXFSIZ_PTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPTXFSIZ.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF1: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF1_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF1.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF1.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF1_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF1.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF1_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF1.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF1.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF1_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF1.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF2: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF2_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF2.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF2.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF2_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF2.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF2_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF2.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF2.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF2_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF2.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF3: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF3_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF3.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF3.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF3_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF3.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF3_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF3.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF3.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF3_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF3.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF4: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF4_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF4.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF4.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF4_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF4.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF4_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF4.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF4.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF4_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF4.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF5: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF5_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF5.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF5.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF5_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF5.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF5_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF5.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF5.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF5_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF5.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF6: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF6_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF6.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF6.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF6_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF6.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF6_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF6.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF6.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF6_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF6.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_DIEPTXF7: OTG_HS device IN endpoint transmit FIFO size register
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF7_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF7.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF7.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF7_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_DIEPTXF7.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_DIEPTXF7_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_DIEPTXF7.Reg, volatile.LoadUint32(&o.OTG_HS_DIEPTXF7.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_DIEPTXF7_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_DIEPTXF7.Reg) & 0xffff0000) >> 16
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
	IPR21 volatile.Register32 // 0x354
	IPR22 volatile.Register32 // 0x358
	IPR23 volatile.Register32 // 0x35C
	IPR24 volatile.Register32 // 0x360
	IPR25 volatile.Register32 // 0x364
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ISER2: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER2(value uint32) {
	volatile.StoreUint32(&o.ISER2.Reg, value)
}
func (o *NVIC_Type) GetISER2() uint32 {
	return volatile.LoadUint32(&o.ISER2.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ICER2: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER2(value uint32) {
	volatile.StoreUint32(&o.ICER2.Reg, value)
}
func (o *NVIC_Type) GetICER2() uint32 {
	return volatile.LoadUint32(&o.ICER2.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ISPR2: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR2(value uint32) {
	volatile.StoreUint32(&o.ISPR2.Reg, value)
}
func (o *NVIC_Type) GetISPR2() uint32 {
	return volatile.LoadUint32(&o.ISPR2.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.ICPR2: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR2(value uint32) {
	volatile.StoreUint32(&o.ICPR2.Reg, value)
}
func (o *NVIC_Type) GetICPR2() uint32 {
	return volatile.LoadUint32(&o.ICPR2.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IABR2: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR2(value uint32) {
	volatile.StoreUint32(&o.IABR2.Reg, value)
}
func (o *NVIC_Type) GetIABR2() uint32 {
	return volatile.LoadUint32(&o.IABR2.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// NVIC.IPR18: Interrupt Priority Register
func (o *NVIC_Type) SetIPR18_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR18_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR18.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR18_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR18_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR18_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR18_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR18_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR18_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff000000) >> 24
}

// NVIC.IPR19: Interrupt Priority Register
func (o *NVIC_Type) SetIPR19_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR19_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR19.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR19_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR19_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR19_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR19_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR19_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR19_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff000000) >> 24
}

// NVIC.IPR20: Interrupt Priority Register
func (o *NVIC_Type) SetIPR20_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR20_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR20.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR20_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR20_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR20_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR20_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR20_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR20_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff000000) >> 24
}

// NVIC.IPR21: Interrupt Priority Register
func (o *NVIC_Type) SetIPR21_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR21.Reg, volatile.LoadUint32(&o.IPR21.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR21_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR21.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR21_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR21.Reg, volatile.LoadUint32(&o.IPR21.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR21_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR21.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR21_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR21.Reg, volatile.LoadUint32(&o.IPR21.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR21_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR21.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR21_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR21.Reg, volatile.LoadUint32(&o.IPR21.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR21_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR21.Reg) & 0xff000000) >> 24
}

// NVIC.IPR22: Interrupt Priority Register
func (o *NVIC_Type) SetIPR22_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR22.Reg, volatile.LoadUint32(&o.IPR22.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR22_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR22.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR22_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR22.Reg, volatile.LoadUint32(&o.IPR22.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR22_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR22.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR22_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR22.Reg, volatile.LoadUint32(&o.IPR22.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR22_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR22.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR22_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR22.Reg, volatile.LoadUint32(&o.IPR22.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR22_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR22.Reg) & 0xff000000) >> 24
}

// NVIC.IPR23: Interrupt Priority Register
func (o *NVIC_Type) SetIPR23_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR23.Reg, volatile.LoadUint32(&o.IPR23.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR23_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR23.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR23_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR23.Reg, volatile.LoadUint32(&o.IPR23.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR23_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR23.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR23_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR23.Reg, volatile.LoadUint32(&o.IPR23.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR23_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR23.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR23_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR23.Reg, volatile.LoadUint32(&o.IPR23.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR23_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR23.Reg) & 0xff000000) >> 24
}

// NVIC.IPR24: Interrupt Priority Register
func (o *NVIC_Type) SetIPR24_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR24.Reg, volatile.LoadUint32(&o.IPR24.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR24_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR24.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR24_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR24.Reg, volatile.LoadUint32(&o.IPR24.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR24_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR24.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR24_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR24.Reg, volatile.LoadUint32(&o.IPR24.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR24_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR24.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR24_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR24.Reg, volatile.LoadUint32(&o.IPR24.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR24_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR24.Reg) & 0xff000000) >> 24
}

// NVIC.IPR25: Interrupt Priority Register
func (o *NVIC_Type) SetIPR25_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR25.Reg, volatile.LoadUint32(&o.IPR25.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR25_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR25.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR25_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR25.Reg, volatile.LoadUint32(&o.IPR25.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR25_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR25.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR25_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR25.Reg, volatile.LoadUint32(&o.IPR25.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR25_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR25.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR25_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR25.Reg, volatile.LoadUint32(&o.IPR25.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR25_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR25.Reg) & 0xff000000) >> 24
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// SysTick timer
type STK_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CSR: SysTick control and status register
func (o *STK_Type) SetCSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *STK_Type) SetCSR_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCSR_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCSR_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCSR_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCSR_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCSR_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}

// STK.RVR: SysTick reload value register
func (o *STK_Type) SetRVR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.RVR.Reg, volatile.LoadUint32(&o.RVR.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetRVR_RELOAD() uint32 {
	return volatile.LoadUint32(&o.RVR.Reg) & 0xffffff
}

// STK.CVR: SysTick current value register
func (o *STK_Type) SetCVR_CURRENT(value uint32) {
	volatile.StoreUint32(&o.CVR.Reg, volatile.LoadUint32(&o.CVR.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCVR_CURRENT() uint32 {
	return volatile.LoadUint32(&o.CVR.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *STK_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *STK_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *STK_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *STK_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// Floating point unit CPACR
type FPU_Type struct {
	CPACR volatile.Register32 // 0x0
}

// FPU.CPACR: Coprocessor access control register
func (o *FPU_Type) SetCPACR_CP(value uint32) {
	volatile.StoreUint32(&o.CPACR.Reg, volatile.LoadUint32(&o.CPACR.Reg)&^(0xf00000)|value<<20)
}
func (o *FPU_Type) GetCPACR_CP() uint32 {
	return (volatile.LoadUint32(&o.CPACR.Reg) & 0xf00000) >> 20
}

// System control block ACTLR
type SCB_Type struct {
	ACTRL volatile.Register32 // 0x0
}

// SCB.ACTRL: Auxiliary control register
func (o *SCB_Type) SetACTRL_DISFOLD(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetACTRL_DISFOLD() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetACTRL_FPEXCODIS(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetACTRL_FPEXCODIS() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetACTRL_DISRAMODE(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetACTRL_DISRAMODE() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetACTRL_DISITMATBFLUSH(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetACTRL_DISITMATBFLUSH() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x1000) >> 12
}

// Processor features
type PF_Type struct {
	CLIDR  volatile.Register32 // 0x0
	CTR    volatile.Register32 // 0x4
	CCSIDR volatile.Register32 // 0x8
}

// PF.CLIDR: Cache Level ID register
func (o *PF_Type) SetCLIDR_CL1(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x7)|value)
}
func (o *PF_Type) GetCLIDR_CL1() uint32 {
	return volatile.LoadUint32(&o.CLIDR.Reg) & 0x7
}
func (o *PF_Type) SetCLIDR_CL2(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x38)|value<<3)
}
func (o *PF_Type) GetCLIDR_CL2() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x38) >> 3
}
func (o *PF_Type) SetCLIDR_CL3(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x1c0)|value<<6)
}
func (o *PF_Type) GetCLIDR_CL3() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x1c0) >> 6
}
func (o *PF_Type) SetCLIDR_CL4(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0xe00)|value<<9)
}
func (o *PF_Type) GetCLIDR_CL4() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0xe00) >> 9
}
func (o *PF_Type) SetCLIDR_CL5(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x7000)|value<<12)
}
func (o *PF_Type) GetCLIDR_CL5() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x7000) >> 12
}
func (o *PF_Type) SetCLIDR_CL6(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x38000)|value<<15)
}
func (o *PF_Type) GetCLIDR_CL6() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x38000) >> 15
}
func (o *PF_Type) SetCLIDR_CL7(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x1c0000)|value<<18)
}
func (o *PF_Type) GetCLIDR_CL7() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x1c0000) >> 18
}
func (o *PF_Type) SetCLIDR_LoUIS(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0xe00000)|value<<21)
}
func (o *PF_Type) GetCLIDR_LoUIS() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0xe00000) >> 21
}
func (o *PF_Type) SetCLIDR_LoC(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x7000000)|value<<24)
}
func (o *PF_Type) GetCLIDR_LoC() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x7000000) >> 24
}
func (o *PF_Type) SetCLIDR_LoU(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x38000000)|value<<27)
}
func (o *PF_Type) GetCLIDR_LoU() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x38000000) >> 27
}

// PF.CTR: Cache Type register
func (o *PF_Type) SetCTR__IMINLINE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf)|value)
}
func (o *PF_Type) GetCTR__IMINLINE() uint32 {
	return volatile.LoadUint32(&o.CTR.Reg) & 0xf
}
func (o *PF_Type) SetCTR_DMinLine(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf0000)|value<<16)
}
func (o *PF_Type) GetCTR_DMinLine() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xf0000) >> 16
}
func (o *PF_Type) SetCTR_ERG(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf00000)|value<<20)
}
func (o *PF_Type) GetCTR_ERG() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xf00000) >> 20
}
func (o *PF_Type) SetCTR_CWG(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf000000)|value<<24)
}
func (o *PF_Type) GetCTR_CWG() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xf000000) >> 24
}
func (o *PF_Type) SetCTR_Format(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xe0000000)|value<<29)
}
func (o *PF_Type) GetCTR_Format() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xe0000000) >> 29
}

// PF.CCSIDR: Cache Size ID register
func (o *PF_Type) SetCCSIDR_LineSize(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x7)|value)
}
func (o *PF_Type) GetCCSIDR_LineSize() uint32 {
	return volatile.LoadUint32(&o.CCSIDR.Reg) & 0x7
}
func (o *PF_Type) SetCCSIDR_Associativity(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x1ff8)|value<<3)
}
func (o *PF_Type) GetCCSIDR_Associativity() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x1ff8) >> 3
}
func (o *PF_Type) SetCCSIDR_NumSets(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0xfffe000)|value<<13)
}
func (o *PF_Type) GetCCSIDR_NumSets() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0xfffe000) >> 13
}
func (o *PF_Type) SetCCSIDR_WA(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PF_Type) GetCCSIDR_WA() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x10000000) >> 28
}
func (o *PF_Type) SetCCSIDR_RA(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PF_Type) GetCCSIDR_RA() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x20000000) >> 29
}
func (o *PF_Type) SetCCSIDR_WB(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PF_Type) GetCCSIDR_WB() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x40000000) >> 30
}
func (o *PF_Type) SetCCSIDR_WT(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PF_Type) GetCCSIDR_WT() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x80000000) >> 31
}

// Access control
type AC_Type struct {
	ITCMCR volatile.Register32 // 0x0
	DTCMCR volatile.Register32 // 0x4
	AHBPCR volatile.Register32 // 0x8
	CACR   volatile.Register32 // 0xC
	AHBSCR volatile.Register32 // 0x10
	_      [4]byte
	ABFSR  volatile.Register32 // 0x18
}

// AC.ITCMCR: Instruction and Data Tightly-Coupled Memory Control Registers
func (o *AC_Type) SetITCMCR_EN(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetITCMCR_EN() uint32 {
	return volatile.LoadUint32(&o.ITCMCR.Reg) & 0x1
}
func (o *AC_Type) SetITCMCR_RMW(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetITCMCR_RMW() uint32 {
	return (volatile.LoadUint32(&o.ITCMCR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetITCMCR_RETEN(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetITCMCR_RETEN() uint32 {
	return (volatile.LoadUint32(&o.ITCMCR.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetITCMCR_SZ(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x78)|value<<3)
}
func (o *AC_Type) GetITCMCR_SZ() uint32 {
	return (volatile.LoadUint32(&o.ITCMCR.Reg) & 0x78) >> 3
}

// AC.DTCMCR: Instruction and Data Tightly-Coupled Memory Control Registers
func (o *AC_Type) SetDTCMCR_EN(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetDTCMCR_EN() uint32 {
	return volatile.LoadUint32(&o.DTCMCR.Reg) & 0x1
}
func (o *AC_Type) SetDTCMCR_RMW(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetDTCMCR_RMW() uint32 {
	return (volatile.LoadUint32(&o.DTCMCR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetDTCMCR_RETEN(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetDTCMCR_RETEN() uint32 {
	return (volatile.LoadUint32(&o.DTCMCR.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetDTCMCR_SZ(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x78)|value<<3)
}
func (o *AC_Type) GetDTCMCR_SZ() uint32 {
	return (volatile.LoadUint32(&o.DTCMCR.Reg) & 0x78) >> 3
}

// AC.AHBPCR: AHBP Control register
func (o *AC_Type) SetAHBPCR_EN(value uint32) {
	volatile.StoreUint32(&o.AHBPCR.Reg, volatile.LoadUint32(&o.AHBPCR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetAHBPCR_EN() uint32 {
	return volatile.LoadUint32(&o.AHBPCR.Reg) & 0x1
}
func (o *AC_Type) SetAHBPCR_SZ(value uint32) {
	volatile.StoreUint32(&o.AHBPCR.Reg, volatile.LoadUint32(&o.AHBPCR.Reg)&^(0xe)|value<<1)
}
func (o *AC_Type) GetAHBPCR_SZ() uint32 {
	return (volatile.LoadUint32(&o.AHBPCR.Reg) & 0xe) >> 1
}

// AC.CACR: Auxiliary Cache Control register
func (o *AC_Type) SetCACR_SIWT(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCACR_SIWT() uint32 {
	return volatile.LoadUint32(&o.CACR.Reg) & 0x1
}
func (o *AC_Type) SetCACR_ECCEN(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCACR_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.CACR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetCACR_FORCEWT(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetCACR_FORCEWT() uint32 {
	return (volatile.LoadUint32(&o.CACR.Reg) & 0x4) >> 2
}

// AC.AHBSCR: AHB Slave Control register
func (o *AC_Type) SetAHBSCR_CTL(value uint32) {
	volatile.StoreUint32(&o.AHBSCR.Reg, volatile.LoadUint32(&o.AHBSCR.Reg)&^(0x3)|value)
}
func (o *AC_Type) GetAHBSCR_CTL() uint32 {
	return volatile.LoadUint32(&o.AHBSCR.Reg) & 0x3
}
func (o *AC_Type) SetAHBSCR_TPRI(value uint32) {
	volatile.StoreUint32(&o.AHBSCR.Reg, volatile.LoadUint32(&o.AHBSCR.Reg)&^(0x7fc)|value<<2)
}
func (o *AC_Type) GetAHBSCR_TPRI() uint32 {
	return (volatile.LoadUint32(&o.AHBSCR.Reg) & 0x7fc) >> 2
}
func (o *AC_Type) SetAHBSCR_INITCOUNT(value uint32) {
	volatile.StoreUint32(&o.AHBSCR.Reg, volatile.LoadUint32(&o.AHBSCR.Reg)&^(0xf800)|value<<11)
}
func (o *AC_Type) GetAHBSCR_INITCOUNT() uint32 {
	return (volatile.LoadUint32(&o.AHBSCR.Reg) & 0xf800) >> 11
}

// AC.ABFSR: Auxiliary Bus Fault Status register
func (o *AC_Type) SetABFSR_ITCM(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetABFSR_ITCM() uint32 {
	return volatile.LoadUint32(&o.ABFSR.Reg) & 0x1
}
func (o *AC_Type) SetABFSR_DTCM(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetABFSR_DTCM() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetABFSR_AHBP(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetABFSR_AHBP() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetABFSR_AXIM(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x8)|value<<3)
}
func (o *AC_Type) GetABFSR_AXIM() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x8) >> 3
}
func (o *AC_Type) SetABFSR_EPPB(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetABFSR_EPPB() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x10) >> 4
}
func (o *AC_Type) SetABFSR_AXIMTYPE(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x300)|value<<8)
}
func (o *AC_Type) GetABFSR_AXIMTYPE() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x300) >> 8
}

// Constants for RNG: Random number generator
const (
	// CR: control register
	// Position of IE field.
	RNG_CR_IE_Pos = 0x3
	// Bit mask of IE field.
	RNG_CR_IE_Msk = 0x8
	// Bit IE.
	RNG_CR_IE = 0x8
	// Position of RNGEN field.
	RNG_CR_RNGEN_Pos = 0x2
	// Bit mask of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4
	// Bit RNGEN.
	RNG_CR_RNGEN = 0x4

	// SR: status register
	// Position of SEIS field.
	RNG_SR_SEIS_Pos = 0x6
	// Bit mask of SEIS field.
	RNG_SR_SEIS_Msk = 0x40
	// Bit SEIS.
	RNG_SR_SEIS = 0x40
	// Position of CEIS field.
	RNG_SR_CEIS_Pos = 0x5
	// Bit mask of CEIS field.
	RNG_SR_CEIS_Msk = 0x20
	// Bit CEIS.
	RNG_SR_CEIS = 0x20
	// Position of SECS field.
	RNG_SR_SECS_Pos = 0x2
	// Bit mask of SECS field.
	RNG_SR_SECS_Msk = 0x4
	// Bit SECS.
	RNG_SR_SECS = 0x4
	// Position of CECS field.
	RNG_SR_CECS_Pos = 0x1
	// Bit mask of CECS field.
	RNG_SR_CECS_Msk = 0x2
	// Bit CECS.
	RNG_SR_CECS = 0x2
	// Position of DRDY field.
	RNG_SR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	RNG_SR_DRDY_Msk = 0x1
	// Bit DRDY.
	RNG_SR_DRDY = 0x1

	// DR: data register
	// Position of RNDATA field.
	RNG_DR_RNDATA_Pos = 0x0
	// Bit mask of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff
)

// Constants for HASH: Hash processor
const (
	// CR: control register
	// Position of INIT field.
	HASH_CR_INIT_Pos = 0x2
	// Bit mask of INIT field.
	HASH_CR_INIT_Msk = 0x4
	// Bit INIT.
	HASH_CR_INIT = 0x4
	// Position of DMAE field.
	HASH_CR_DMAE_Pos = 0x3
	// Bit mask of DMAE field.
	HASH_CR_DMAE_Msk = 0x8
	// Bit DMAE.
	HASH_CR_DMAE = 0x8
	// Position of DATATYPE field.
	HASH_CR_DATATYPE_Pos = 0x4
	// Bit mask of DATATYPE field.
	HASH_CR_DATATYPE_Msk = 0x30
	// Position of MODE field.
	HASH_CR_MODE_Pos = 0x6
	// Bit mask of MODE field.
	HASH_CR_MODE_Msk = 0x40
	// Bit MODE.
	HASH_CR_MODE = 0x40
	// Position of ALGO0 field.
	HASH_CR_ALGO0_Pos = 0x7
	// Bit mask of ALGO0 field.
	HASH_CR_ALGO0_Msk = 0x80
	// Bit ALGO0.
	HASH_CR_ALGO0 = 0x80
	// Position of NBW field.
	HASH_CR_NBW_Pos = 0x8
	// Bit mask of NBW field.
	HASH_CR_NBW_Msk = 0xf00
	// Position of DINNE field.
	HASH_CR_DINNE_Pos = 0xc
	// Bit mask of DINNE field.
	HASH_CR_DINNE_Msk = 0x1000
	// Bit DINNE.
	HASH_CR_DINNE = 0x1000
	// Position of MDMAT field.
	HASH_CR_MDMAT_Pos = 0xd
	// Bit mask of MDMAT field.
	HASH_CR_MDMAT_Msk = 0x2000
	// Bit MDMAT.
	HASH_CR_MDMAT = 0x2000
	// Position of LKEY field.
	HASH_CR_LKEY_Pos = 0x10
	// Bit mask of LKEY field.
	HASH_CR_LKEY_Msk = 0x10000
	// Bit LKEY.
	HASH_CR_LKEY = 0x10000
	// Position of ALGO1 field.
	HASH_CR_ALGO1_Pos = 0x12
	// Bit mask of ALGO1 field.
	HASH_CR_ALGO1_Msk = 0x40000
	// Bit ALGO1.
	HASH_CR_ALGO1 = 0x40000

	// DIN: data input register
	// Position of DATAIN field.
	HASH_DIN_DATAIN_Pos = 0x0
	// Bit mask of DATAIN field.
	HASH_DIN_DATAIN_Msk = 0xffffffff

	// STR: start register
	// Position of DCAL field.
	HASH_STR_DCAL_Pos = 0x8
	// Bit mask of DCAL field.
	HASH_STR_DCAL_Msk = 0x100
	// Bit DCAL.
	HASH_STR_DCAL = 0x100
	// Position of NBLW field.
	HASH_STR_NBLW_Pos = 0x0
	// Bit mask of NBLW field.
	HASH_STR_NBLW_Msk = 0x1f

	// HR0: digest registers
	// Position of H field.
	HASH_HR_H_Pos = 0x0
	// Bit mask of H field.
	HASH_HR_H_Msk = 0xffffffff

	// IMR: interrupt enable register
	// Position of DCIE field.
	HASH_IMR_DCIE_Pos = 0x1
	// Bit mask of DCIE field.
	HASH_IMR_DCIE_Msk = 0x2
	// Bit DCIE.
	HASH_IMR_DCIE = 0x2
	// Position of DINIE field.
	HASH_IMR_DINIE_Pos = 0x0
	// Bit mask of DINIE field.
	HASH_IMR_DINIE_Msk = 0x1
	// Bit DINIE.
	HASH_IMR_DINIE = 0x1

	// SR: status register
	// Position of BUSY field.
	HASH_SR_BUSY_Pos = 0x3
	// Bit mask of BUSY field.
	HASH_SR_BUSY_Msk = 0x8
	// Bit BUSY.
	HASH_SR_BUSY = 0x8
	// Position of DMAS field.
	HASH_SR_DMAS_Pos = 0x2
	// Bit mask of DMAS field.
	HASH_SR_DMAS_Msk = 0x4
	// Bit DMAS.
	HASH_SR_DMAS = 0x4
	// Position of DCIS field.
	HASH_SR_DCIS_Pos = 0x1
	// Bit mask of DCIS field.
	HASH_SR_DCIS_Msk = 0x2
	// Bit DCIS.
	HASH_SR_DCIS = 0x2
	// Position of DINIS field.
	HASH_SR_DINIS_Pos = 0x0
	// Bit mask of DINIS field.
	HASH_SR_DINIS_Msk = 0x1
	// Bit DINIS.
	HASH_SR_DINIS = 0x1

	// CSR0: context swap registers
	// Position of CSR field.
	HASH_CSR_CSR_Pos = 0x0
	// Bit mask of CSR field.
	HASH_CSR_CSR_Msk = 0xffffffff

	// HASH_HR0: HASH digest register
	// Position of H field.
	HASH_HASH_HR_H_Pos = 0x0
	// Bit mask of H field.
	HASH_HASH_HR_H_Msk = 0xffffffff
)

// Constants for CRYP: Cryptographic processor
const (
	// CR: control register
	// Position of ALGODIR field.
	CRYP_CR_ALGODIR_Pos = 0x2
	// Bit mask of ALGODIR field.
	CRYP_CR_ALGODIR_Msk = 0x4
	// Bit ALGODIR.
	CRYP_CR_ALGODIR = 0x4
	// Position of ALGOMODE0 field.
	CRYP_CR_ALGOMODE0_Pos = 0x3
	// Bit mask of ALGOMODE0 field.
	CRYP_CR_ALGOMODE0_Msk = 0x38
	// Position of DATATYPE field.
	CRYP_CR_DATATYPE_Pos = 0x6
	// Bit mask of DATATYPE field.
	CRYP_CR_DATATYPE_Msk = 0xc0
	// Position of KEYSIZE field.
	CRYP_CR_KEYSIZE_Pos = 0x8
	// Bit mask of KEYSIZE field.
	CRYP_CR_KEYSIZE_Msk = 0x300
	// Position of FFLUSH field.
	CRYP_CR_FFLUSH_Pos = 0xe
	// Bit mask of FFLUSH field.
	CRYP_CR_FFLUSH_Msk = 0x4000
	// Bit FFLUSH.
	CRYP_CR_FFLUSH = 0x4000
	// Position of CRYPEN field.
	CRYP_CR_CRYPEN_Pos = 0xf
	// Bit mask of CRYPEN field.
	CRYP_CR_CRYPEN_Msk = 0x8000
	// Bit CRYPEN.
	CRYP_CR_CRYPEN = 0x8000
	// Position of GCM_CCMPH field.
	CRYP_CR_GCM_CCMPH_Pos = 0x10
	// Bit mask of GCM_CCMPH field.
	CRYP_CR_GCM_CCMPH_Msk = 0x30000
	// Position of ALGOMODE3 field.
	CRYP_CR_ALGOMODE3_Pos = 0x13
	// Bit mask of ALGOMODE3 field.
	CRYP_CR_ALGOMODE3_Msk = 0x80000
	// Bit ALGOMODE3.
	CRYP_CR_ALGOMODE3 = 0x80000

	// SR: status register
	// Position of BUSY field.
	CRYP_SR_BUSY_Pos = 0x4
	// Bit mask of BUSY field.
	CRYP_SR_BUSY_Msk = 0x10
	// Bit BUSY.
	CRYP_SR_BUSY = 0x10
	// Position of OFFU field.
	CRYP_SR_OFFU_Pos = 0x3
	// Bit mask of OFFU field.
	CRYP_SR_OFFU_Msk = 0x8
	// Bit OFFU.
	CRYP_SR_OFFU = 0x8
	// Position of OFNE field.
	CRYP_SR_OFNE_Pos = 0x2
	// Bit mask of OFNE field.
	CRYP_SR_OFNE_Msk = 0x4
	// Bit OFNE.
	CRYP_SR_OFNE = 0x4
	// Position of IFNF field.
	CRYP_SR_IFNF_Pos = 0x1
	// Bit mask of IFNF field.
	CRYP_SR_IFNF_Msk = 0x2
	// Bit IFNF.
	CRYP_SR_IFNF = 0x2
	// Position of IFEM field.
	CRYP_SR_IFEM_Pos = 0x0
	// Bit mask of IFEM field.
	CRYP_SR_IFEM_Msk = 0x1
	// Bit IFEM.
	CRYP_SR_IFEM = 0x1

	// DIN: data input register
	// Position of DATAIN field.
	CRYP_DIN_DATAIN_Pos = 0x0
	// Bit mask of DATAIN field.
	CRYP_DIN_DATAIN_Msk = 0xffffffff

	// DOUT: data output register
	// Position of DATAOUT field.
	CRYP_DOUT_DATAOUT_Pos = 0x0
	// Bit mask of DATAOUT field.
	CRYP_DOUT_DATAOUT_Msk = 0xffffffff

	// DMACR: DMA control register
	// Position of DOEN field.
	CRYP_DMACR_DOEN_Pos = 0x1
	// Bit mask of DOEN field.
	CRYP_DMACR_DOEN_Msk = 0x2
	// Bit DOEN.
	CRYP_DMACR_DOEN = 0x2
	// Position of DIEN field.
	CRYP_DMACR_DIEN_Pos = 0x0
	// Bit mask of DIEN field.
	CRYP_DMACR_DIEN_Msk = 0x1
	// Bit DIEN.
	CRYP_DMACR_DIEN = 0x1

	// IMSCR: interrupt mask set/clear register
	// Position of OUTIM field.
	CRYP_IMSCR_OUTIM_Pos = 0x1
	// Bit mask of OUTIM field.
	CRYP_IMSCR_OUTIM_Msk = 0x2
	// Bit OUTIM.
	CRYP_IMSCR_OUTIM = 0x2
	// Position of INIM field.
	CRYP_IMSCR_INIM_Pos = 0x0
	// Bit mask of INIM field.
	CRYP_IMSCR_INIM_Msk = 0x1
	// Bit INIM.
	CRYP_IMSCR_INIM = 0x1

	// RISR: raw interrupt status register
	// Position of OUTRIS field.
	CRYP_RISR_OUTRIS_Pos = 0x1
	// Bit mask of OUTRIS field.
	CRYP_RISR_OUTRIS_Msk = 0x2
	// Bit OUTRIS.
	CRYP_RISR_OUTRIS = 0x2
	// Position of INRIS field.
	CRYP_RISR_INRIS_Pos = 0x0
	// Bit mask of INRIS field.
	CRYP_RISR_INRIS_Msk = 0x1
	// Bit INRIS.
	CRYP_RISR_INRIS = 0x1

	// MISR: masked interrupt status register
	// Position of OUTMIS field.
	CRYP_MISR_OUTMIS_Pos = 0x1
	// Bit mask of OUTMIS field.
	CRYP_MISR_OUTMIS_Msk = 0x2
	// Bit OUTMIS.
	CRYP_MISR_OUTMIS = 0x2
	// Position of INMIS field.
	CRYP_MISR_INMIS_Pos = 0x0
	// Bit mask of INMIS field.
	CRYP_MISR_INMIS_Msk = 0x1
	// Bit INMIS.
	CRYP_MISR_INMIS = 0x1

	// KEY.KLR: key registers
	// Position of B224 field.
	CRYP_KEY_KLR_B224_Pos = 0x0
	// Bit mask of B224 field.
	CRYP_KEY_KLR_B224_Msk = 0x1
	// Bit B224.
	CRYP_KEY_KLR_B224 = 0x1
	// Position of B225 field.
	CRYP_KEY_KLR_B225_Pos = 0x1
	// Bit mask of B225 field.
	CRYP_KEY_KLR_B225_Msk = 0x2
	// Bit B225.
	CRYP_KEY_KLR_B225 = 0x2
	// Position of B226 field.
	CRYP_KEY_KLR_B226_Pos = 0x2
	// Bit mask of B226 field.
	CRYP_KEY_KLR_B226_Msk = 0x4
	// Bit B226.
	CRYP_KEY_KLR_B226 = 0x4
	// Position of B227 field.
	CRYP_KEY_KLR_B227_Pos = 0x3
	// Bit mask of B227 field.
	CRYP_KEY_KLR_B227_Msk = 0x8
	// Bit B227.
	CRYP_KEY_KLR_B227 = 0x8
	// Position of B228 field.
	CRYP_KEY_KLR_B228_Pos = 0x4
	// Bit mask of B228 field.
	CRYP_KEY_KLR_B228_Msk = 0x10
	// Bit B228.
	CRYP_KEY_KLR_B228 = 0x10
	// Position of B229 field.
	CRYP_KEY_KLR_B229_Pos = 0x5
	// Bit mask of B229 field.
	CRYP_KEY_KLR_B229_Msk = 0x20
	// Bit B229.
	CRYP_KEY_KLR_B229 = 0x20
	// Position of B230 field.
	CRYP_KEY_KLR_B230_Pos = 0x6
	// Bit mask of B230 field.
	CRYP_KEY_KLR_B230_Msk = 0x40
	// Bit B230.
	CRYP_KEY_KLR_B230 = 0x40
	// Position of B231 field.
	CRYP_KEY_KLR_B231_Pos = 0x7
	// Bit mask of B231 field.
	CRYP_KEY_KLR_B231_Msk = 0x80
	// Bit B231.
	CRYP_KEY_KLR_B231 = 0x80
	// Position of B232 field.
	CRYP_KEY_KLR_B232_Pos = 0x8
	// Bit mask of B232 field.
	CRYP_KEY_KLR_B232_Msk = 0x100
	// Bit B232.
	CRYP_KEY_KLR_B232 = 0x100
	// Position of B233 field.
	CRYP_KEY_KLR_B233_Pos = 0x9
	// Bit mask of B233 field.
	CRYP_KEY_KLR_B233_Msk = 0x200
	// Bit B233.
	CRYP_KEY_KLR_B233 = 0x200
	// Position of B234 field.
	CRYP_KEY_KLR_B234_Pos = 0xa
	// Bit mask of B234 field.
	CRYP_KEY_KLR_B234_Msk = 0x400
	// Bit B234.
	CRYP_KEY_KLR_B234 = 0x400
	// Position of B235 field.
	CRYP_KEY_KLR_B235_Pos = 0xb
	// Bit mask of B235 field.
	CRYP_KEY_KLR_B235_Msk = 0x800
	// Bit B235.
	CRYP_KEY_KLR_B235 = 0x800
	// Position of B236 field.
	CRYP_KEY_KLR_B236_Pos = 0xc
	// Bit mask of B236 field.
	CRYP_KEY_KLR_B236_Msk = 0x1000
	// Bit B236.
	CRYP_KEY_KLR_B236 = 0x1000
	// Position of B237 field.
	CRYP_KEY_KLR_B237_Pos = 0xd
	// Bit mask of B237 field.
	CRYP_KEY_KLR_B237_Msk = 0x2000
	// Bit B237.
	CRYP_KEY_KLR_B237 = 0x2000
	// Position of B238 field.
	CRYP_KEY_KLR_B238_Pos = 0xe
	// Bit mask of B238 field.
	CRYP_KEY_KLR_B238_Msk = 0x4000
	// Bit B238.
	CRYP_KEY_KLR_B238 = 0x4000
	// Position of B239 field.
	CRYP_KEY_KLR_B239_Pos = 0xf
	// Bit mask of B239 field.
	CRYP_KEY_KLR_B239_Msk = 0x8000
	// Bit B239.
	CRYP_KEY_KLR_B239 = 0x8000
	// Position of B240 field.
	CRYP_KEY_KLR_B240_Pos = 0x10
	// Bit mask of B240 field.
	CRYP_KEY_KLR_B240_Msk = 0x10000
	// Bit B240.
	CRYP_KEY_KLR_B240 = 0x10000
	// Position of B241 field.
	CRYP_KEY_KLR_B241_Pos = 0x11
	// Bit mask of B241 field.
	CRYP_KEY_KLR_B241_Msk = 0x20000
	// Bit B241.
	CRYP_KEY_KLR_B241 = 0x20000
	// Position of B242 field.
	CRYP_KEY_KLR_B242_Pos = 0x12
	// Bit mask of B242 field.
	CRYP_KEY_KLR_B242_Msk = 0x40000
	// Bit B242.
	CRYP_KEY_KLR_B242 = 0x40000
	// Position of B243 field.
	CRYP_KEY_KLR_B243_Pos = 0x13
	// Bit mask of B243 field.
	CRYP_KEY_KLR_B243_Msk = 0x80000
	// Bit B243.
	CRYP_KEY_KLR_B243 = 0x80000
	// Position of B244 field.
	CRYP_KEY_KLR_B244_Pos = 0x14
	// Bit mask of B244 field.
	CRYP_KEY_KLR_B244_Msk = 0x100000
	// Bit B244.
	CRYP_KEY_KLR_B244 = 0x100000
	// Position of B245 field.
	CRYP_KEY_KLR_B245_Pos = 0x15
	// Bit mask of B245 field.
	CRYP_KEY_KLR_B245_Msk = 0x200000
	// Bit B245.
	CRYP_KEY_KLR_B245 = 0x200000
	// Position of B246 field.
	CRYP_KEY_KLR_B246_Pos = 0x16
	// Bit mask of B246 field.
	CRYP_KEY_KLR_B246_Msk = 0x400000
	// Bit B246.
	CRYP_KEY_KLR_B246 = 0x400000
	// Position of B247 field.
	CRYP_KEY_KLR_B247_Pos = 0x17
	// Bit mask of B247 field.
	CRYP_KEY_KLR_B247_Msk = 0x800000
	// Bit B247.
	CRYP_KEY_KLR_B247 = 0x800000
	// Position of B248 field.
	CRYP_KEY_KLR_B248_Pos = 0x18
	// Bit mask of B248 field.
	CRYP_KEY_KLR_B248_Msk = 0x1000000
	// Bit B248.
	CRYP_KEY_KLR_B248 = 0x1000000
	// Position of B249 field.
	CRYP_KEY_KLR_B249_Pos = 0x19
	// Bit mask of B249 field.
	CRYP_KEY_KLR_B249_Msk = 0x2000000
	// Bit B249.
	CRYP_KEY_KLR_B249 = 0x2000000
	// Position of B250 field.
	CRYP_KEY_KLR_B250_Pos = 0x1a
	// Bit mask of B250 field.
	CRYP_KEY_KLR_B250_Msk = 0x4000000
	// Bit B250.
	CRYP_KEY_KLR_B250 = 0x4000000
	// Position of B251 field.
	CRYP_KEY_KLR_B251_Pos = 0x1b
	// Bit mask of B251 field.
	CRYP_KEY_KLR_B251_Msk = 0x8000000
	// Bit B251.
	CRYP_KEY_KLR_B251 = 0x8000000
	// Position of B252 field.
	CRYP_KEY_KLR_B252_Pos = 0x1c
	// Bit mask of B252 field.
	CRYP_KEY_KLR_B252_Msk = 0x10000000
	// Bit B252.
	CRYP_KEY_KLR_B252 = 0x10000000
	// Position of B253 field.
	CRYP_KEY_KLR_B253_Pos = 0x1d
	// Bit mask of B253 field.
	CRYP_KEY_KLR_B253_Msk = 0x20000000
	// Bit B253.
	CRYP_KEY_KLR_B253 = 0x20000000
	// Position of B254 field.
	CRYP_KEY_KLR_B254_Pos = 0x1e
	// Bit mask of B254 field.
	CRYP_KEY_KLR_B254_Msk = 0x40000000
	// Bit B254.
	CRYP_KEY_KLR_B254 = 0x40000000
	// Position of B255 field.
	CRYP_KEY_KLR_B255_Pos = 0x1f
	// Bit mask of B255 field.
	CRYP_KEY_KLR_B255_Msk = 0x80000000
	// Bit B255.
	CRYP_KEY_KLR_B255 = 0x80000000

	// KEY.KRR: key registers
	// Position of B192 field.
	CRYP_KEY_KRR_B192_Pos = 0x0
	// Bit mask of B192 field.
	CRYP_KEY_KRR_B192_Msk = 0x1
	// Bit B192.
	CRYP_KEY_KRR_B192 = 0x1
	// Position of B193 field.
	CRYP_KEY_KRR_B193_Pos = 0x1
	// Bit mask of B193 field.
	CRYP_KEY_KRR_B193_Msk = 0x2
	// Bit B193.
	CRYP_KEY_KRR_B193 = 0x2
	// Position of B194 field.
	CRYP_KEY_KRR_B194_Pos = 0x2
	// Bit mask of B194 field.
	CRYP_KEY_KRR_B194_Msk = 0x4
	// Bit B194.
	CRYP_KEY_KRR_B194 = 0x4
	// Position of B195 field.
	CRYP_KEY_KRR_B195_Pos = 0x3
	// Bit mask of B195 field.
	CRYP_KEY_KRR_B195_Msk = 0x8
	// Bit B195.
	CRYP_KEY_KRR_B195 = 0x8
	// Position of B196 field.
	CRYP_KEY_KRR_B196_Pos = 0x4
	// Bit mask of B196 field.
	CRYP_KEY_KRR_B196_Msk = 0x10
	// Bit B196.
	CRYP_KEY_KRR_B196 = 0x10
	// Position of B197 field.
	CRYP_KEY_KRR_B197_Pos = 0x5
	// Bit mask of B197 field.
	CRYP_KEY_KRR_B197_Msk = 0x20
	// Bit B197.
	CRYP_KEY_KRR_B197 = 0x20
	// Position of B198 field.
	CRYP_KEY_KRR_B198_Pos = 0x6
	// Bit mask of B198 field.
	CRYP_KEY_KRR_B198_Msk = 0x40
	// Bit B198.
	CRYP_KEY_KRR_B198 = 0x40
	// Position of B199 field.
	CRYP_KEY_KRR_B199_Pos = 0x7
	// Bit mask of B199 field.
	CRYP_KEY_KRR_B199_Msk = 0x80
	// Bit B199.
	CRYP_KEY_KRR_B199 = 0x80
	// Position of B200 field.
	CRYP_KEY_KRR_B200_Pos = 0x8
	// Bit mask of B200 field.
	CRYP_KEY_KRR_B200_Msk = 0x100
	// Bit B200.
	CRYP_KEY_KRR_B200 = 0x100
	// Position of B201 field.
	CRYP_KEY_KRR_B201_Pos = 0x9
	// Bit mask of B201 field.
	CRYP_KEY_KRR_B201_Msk = 0x200
	// Bit B201.
	CRYP_KEY_KRR_B201 = 0x200
	// Position of B202 field.
	CRYP_KEY_KRR_B202_Pos = 0xa
	// Bit mask of B202 field.
	CRYP_KEY_KRR_B202_Msk = 0x400
	// Bit B202.
	CRYP_KEY_KRR_B202 = 0x400
	// Position of B203 field.
	CRYP_KEY_KRR_B203_Pos = 0xb
	// Bit mask of B203 field.
	CRYP_KEY_KRR_B203_Msk = 0x800
	// Bit B203.
	CRYP_KEY_KRR_B203 = 0x800
	// Position of B204 field.
	CRYP_KEY_KRR_B204_Pos = 0xc
	// Bit mask of B204 field.
	CRYP_KEY_KRR_B204_Msk = 0x1000
	// Bit B204.
	CRYP_KEY_KRR_B204 = 0x1000
	// Position of B205 field.
	CRYP_KEY_KRR_B205_Pos = 0xd
	// Bit mask of B205 field.
	CRYP_KEY_KRR_B205_Msk = 0x2000
	// Bit B205.
	CRYP_KEY_KRR_B205 = 0x2000
	// Position of B206 field.
	CRYP_KEY_KRR_B206_Pos = 0xe
	// Bit mask of B206 field.
	CRYP_KEY_KRR_B206_Msk = 0x4000
	// Bit B206.
	CRYP_KEY_KRR_B206 = 0x4000
	// Position of B207 field.
	CRYP_KEY_KRR_B207_Pos = 0xf
	// Bit mask of B207 field.
	CRYP_KEY_KRR_B207_Msk = 0x8000
	// Bit B207.
	CRYP_KEY_KRR_B207 = 0x8000
	// Position of B208 field.
	CRYP_KEY_KRR_B208_Pos = 0x10
	// Bit mask of B208 field.
	CRYP_KEY_KRR_B208_Msk = 0x10000
	// Bit B208.
	CRYP_KEY_KRR_B208 = 0x10000
	// Position of B209 field.
	CRYP_KEY_KRR_B209_Pos = 0x11
	// Bit mask of B209 field.
	CRYP_KEY_KRR_B209_Msk = 0x20000
	// Bit B209.
	CRYP_KEY_KRR_B209 = 0x20000
	// Position of B210 field.
	CRYP_KEY_KRR_B210_Pos = 0x12
	// Bit mask of B210 field.
	CRYP_KEY_KRR_B210_Msk = 0x40000
	// Bit B210.
	CRYP_KEY_KRR_B210 = 0x40000
	// Position of B211 field.
	CRYP_KEY_KRR_B211_Pos = 0x13
	// Bit mask of B211 field.
	CRYP_KEY_KRR_B211_Msk = 0x80000
	// Bit B211.
	CRYP_KEY_KRR_B211 = 0x80000
	// Position of B212 field.
	CRYP_KEY_KRR_B212_Pos = 0x14
	// Bit mask of B212 field.
	CRYP_KEY_KRR_B212_Msk = 0x100000
	// Bit B212.
	CRYP_KEY_KRR_B212 = 0x100000
	// Position of B213 field.
	CRYP_KEY_KRR_B213_Pos = 0x15
	// Bit mask of B213 field.
	CRYP_KEY_KRR_B213_Msk = 0x200000
	// Bit B213.
	CRYP_KEY_KRR_B213 = 0x200000
	// Position of B214 field.
	CRYP_KEY_KRR_B214_Pos = 0x16
	// Bit mask of B214 field.
	CRYP_KEY_KRR_B214_Msk = 0x400000
	// Bit B214.
	CRYP_KEY_KRR_B214 = 0x400000
	// Position of B215 field.
	CRYP_KEY_KRR_B215_Pos = 0x17
	// Bit mask of B215 field.
	CRYP_KEY_KRR_B215_Msk = 0x800000
	// Bit B215.
	CRYP_KEY_KRR_B215 = 0x800000
	// Position of B216 field.
	CRYP_KEY_KRR_B216_Pos = 0x18
	// Bit mask of B216 field.
	CRYP_KEY_KRR_B216_Msk = 0x1000000
	// Bit B216.
	CRYP_KEY_KRR_B216 = 0x1000000
	// Position of B217 field.
	CRYP_KEY_KRR_B217_Pos = 0x19
	// Bit mask of B217 field.
	CRYP_KEY_KRR_B217_Msk = 0x2000000
	// Bit B217.
	CRYP_KEY_KRR_B217 = 0x2000000
	// Position of B218 field.
	CRYP_KEY_KRR_B218_Pos = 0x1a
	// Bit mask of B218 field.
	CRYP_KEY_KRR_B218_Msk = 0x4000000
	// Bit B218.
	CRYP_KEY_KRR_B218 = 0x4000000
	// Position of B219 field.
	CRYP_KEY_KRR_B219_Pos = 0x1b
	// Bit mask of B219 field.
	CRYP_KEY_KRR_B219_Msk = 0x8000000
	// Bit B219.
	CRYP_KEY_KRR_B219 = 0x8000000
	// Position of B220 field.
	CRYP_KEY_KRR_B220_Pos = 0x1c
	// Bit mask of B220 field.
	CRYP_KEY_KRR_B220_Msk = 0x10000000
	// Bit B220.
	CRYP_KEY_KRR_B220 = 0x10000000
	// Position of B221 field.
	CRYP_KEY_KRR_B221_Pos = 0x1d
	// Bit mask of B221 field.
	CRYP_KEY_KRR_B221_Msk = 0x20000000
	// Bit B221.
	CRYP_KEY_KRR_B221 = 0x20000000
	// Position of B222 field.
	CRYP_KEY_KRR_B222_Pos = 0x1e
	// Bit mask of B222 field.
	CRYP_KEY_KRR_B222_Msk = 0x40000000
	// Bit B222.
	CRYP_KEY_KRR_B222 = 0x40000000
	// Position of B223 field.
	CRYP_KEY_KRR_B223_Pos = 0x1f
	// Bit mask of B223 field.
	CRYP_KEY_KRR_B223_Msk = 0x80000000
	// Bit B223.
	CRYP_KEY_KRR_B223 = 0x80000000

	// INIT.IVLR: initialization vector registers
	// Position of IV31 field.
	CRYP_INIT_IVLR_IV31_Pos = 0x0
	// Bit mask of IV31 field.
	CRYP_INIT_IVLR_IV31_Msk = 0x1
	// Bit IV31.
	CRYP_INIT_IVLR_IV31 = 0x1
	// Position of IV30 field.
	CRYP_INIT_IVLR_IV30_Pos = 0x1
	// Bit mask of IV30 field.
	CRYP_INIT_IVLR_IV30_Msk = 0x2
	// Bit IV30.
	CRYP_INIT_IVLR_IV30 = 0x2
	// Position of IV29 field.
	CRYP_INIT_IVLR_IV29_Pos = 0x2
	// Bit mask of IV29 field.
	CRYP_INIT_IVLR_IV29_Msk = 0x4
	// Bit IV29.
	CRYP_INIT_IVLR_IV29 = 0x4
	// Position of IV28 field.
	CRYP_INIT_IVLR_IV28_Pos = 0x3
	// Bit mask of IV28 field.
	CRYP_INIT_IVLR_IV28_Msk = 0x8
	// Bit IV28.
	CRYP_INIT_IVLR_IV28 = 0x8
	// Position of IV27 field.
	CRYP_INIT_IVLR_IV27_Pos = 0x4
	// Bit mask of IV27 field.
	CRYP_INIT_IVLR_IV27_Msk = 0x10
	// Bit IV27.
	CRYP_INIT_IVLR_IV27 = 0x10
	// Position of IV26 field.
	CRYP_INIT_IVLR_IV26_Pos = 0x5
	// Bit mask of IV26 field.
	CRYP_INIT_IVLR_IV26_Msk = 0x20
	// Bit IV26.
	CRYP_INIT_IVLR_IV26 = 0x20
	// Position of IV25 field.
	CRYP_INIT_IVLR_IV25_Pos = 0x6
	// Bit mask of IV25 field.
	CRYP_INIT_IVLR_IV25_Msk = 0x40
	// Bit IV25.
	CRYP_INIT_IVLR_IV25 = 0x40
	// Position of IV24 field.
	CRYP_INIT_IVLR_IV24_Pos = 0x7
	// Bit mask of IV24 field.
	CRYP_INIT_IVLR_IV24_Msk = 0x80
	// Bit IV24.
	CRYP_INIT_IVLR_IV24 = 0x80
	// Position of IV23 field.
	CRYP_INIT_IVLR_IV23_Pos = 0x8
	// Bit mask of IV23 field.
	CRYP_INIT_IVLR_IV23_Msk = 0x100
	// Bit IV23.
	CRYP_INIT_IVLR_IV23 = 0x100
	// Position of IV22 field.
	CRYP_INIT_IVLR_IV22_Pos = 0x9
	// Bit mask of IV22 field.
	CRYP_INIT_IVLR_IV22_Msk = 0x200
	// Bit IV22.
	CRYP_INIT_IVLR_IV22 = 0x200
	// Position of IV21 field.
	CRYP_INIT_IVLR_IV21_Pos = 0xa
	// Bit mask of IV21 field.
	CRYP_INIT_IVLR_IV21_Msk = 0x400
	// Bit IV21.
	CRYP_INIT_IVLR_IV21 = 0x400
	// Position of IV20 field.
	CRYP_INIT_IVLR_IV20_Pos = 0xb
	// Bit mask of IV20 field.
	CRYP_INIT_IVLR_IV20_Msk = 0x800
	// Bit IV20.
	CRYP_INIT_IVLR_IV20 = 0x800
	// Position of IV19 field.
	CRYP_INIT_IVLR_IV19_Pos = 0xc
	// Bit mask of IV19 field.
	CRYP_INIT_IVLR_IV19_Msk = 0x1000
	// Bit IV19.
	CRYP_INIT_IVLR_IV19 = 0x1000
	// Position of IV18 field.
	CRYP_INIT_IVLR_IV18_Pos = 0xd
	// Bit mask of IV18 field.
	CRYP_INIT_IVLR_IV18_Msk = 0x2000
	// Bit IV18.
	CRYP_INIT_IVLR_IV18 = 0x2000
	// Position of IV17 field.
	CRYP_INIT_IVLR_IV17_Pos = 0xe
	// Bit mask of IV17 field.
	CRYP_INIT_IVLR_IV17_Msk = 0x4000
	// Bit IV17.
	CRYP_INIT_IVLR_IV17 = 0x4000
	// Position of IV16 field.
	CRYP_INIT_IVLR_IV16_Pos = 0xf
	// Bit mask of IV16 field.
	CRYP_INIT_IVLR_IV16_Msk = 0x8000
	// Bit IV16.
	CRYP_INIT_IVLR_IV16 = 0x8000
	// Position of IV15 field.
	CRYP_INIT_IVLR_IV15_Pos = 0x10
	// Bit mask of IV15 field.
	CRYP_INIT_IVLR_IV15_Msk = 0x10000
	// Bit IV15.
	CRYP_INIT_IVLR_IV15 = 0x10000
	// Position of IV14 field.
	CRYP_INIT_IVLR_IV14_Pos = 0x11
	// Bit mask of IV14 field.
	CRYP_INIT_IVLR_IV14_Msk = 0x20000
	// Bit IV14.
	CRYP_INIT_IVLR_IV14 = 0x20000
	// Position of IV13 field.
	CRYP_INIT_IVLR_IV13_Pos = 0x12
	// Bit mask of IV13 field.
	CRYP_INIT_IVLR_IV13_Msk = 0x40000
	// Bit IV13.
	CRYP_INIT_IVLR_IV13 = 0x40000
	// Position of IV12 field.
	CRYP_INIT_IVLR_IV12_Pos = 0x13
	// Bit mask of IV12 field.
	CRYP_INIT_IVLR_IV12_Msk = 0x80000
	// Bit IV12.
	CRYP_INIT_IVLR_IV12 = 0x80000
	// Position of IV11 field.
	CRYP_INIT_IVLR_IV11_Pos = 0x14
	// Bit mask of IV11 field.
	CRYP_INIT_IVLR_IV11_Msk = 0x100000
	// Bit IV11.
	CRYP_INIT_IVLR_IV11 = 0x100000
	// Position of IV10 field.
	CRYP_INIT_IVLR_IV10_Pos = 0x15
	// Bit mask of IV10 field.
	CRYP_INIT_IVLR_IV10_Msk = 0x200000
	// Bit IV10.
	CRYP_INIT_IVLR_IV10 = 0x200000
	// Position of IV9 field.
	CRYP_INIT_IVLR_IV9_Pos = 0x16
	// Bit mask of IV9 field.
	CRYP_INIT_IVLR_IV9_Msk = 0x400000
	// Bit IV9.
	CRYP_INIT_IVLR_IV9 = 0x400000
	// Position of IV8 field.
	CRYP_INIT_IVLR_IV8_Pos = 0x17
	// Bit mask of IV8 field.
	CRYP_INIT_IVLR_IV8_Msk = 0x800000
	// Bit IV8.
	CRYP_INIT_IVLR_IV8 = 0x800000
	// Position of IV7 field.
	CRYP_INIT_IVLR_IV7_Pos = 0x18
	// Bit mask of IV7 field.
	CRYP_INIT_IVLR_IV7_Msk = 0x1000000
	// Bit IV7.
	CRYP_INIT_IVLR_IV7 = 0x1000000
	// Position of IV6 field.
	CRYP_INIT_IVLR_IV6_Pos = 0x19
	// Bit mask of IV6 field.
	CRYP_INIT_IVLR_IV6_Msk = 0x2000000
	// Bit IV6.
	CRYP_INIT_IVLR_IV6 = 0x2000000
	// Position of IV5 field.
	CRYP_INIT_IVLR_IV5_Pos = 0x1a
	// Bit mask of IV5 field.
	CRYP_INIT_IVLR_IV5_Msk = 0x4000000
	// Bit IV5.
	CRYP_INIT_IVLR_IV5 = 0x4000000
	// Position of IV4 field.
	CRYP_INIT_IVLR_IV4_Pos = 0x1b
	// Bit mask of IV4 field.
	CRYP_INIT_IVLR_IV4_Msk = 0x8000000
	// Bit IV4.
	CRYP_INIT_IVLR_IV4 = 0x8000000
	// Position of IV3 field.
	CRYP_INIT_IVLR_IV3_Pos = 0x1c
	// Bit mask of IV3 field.
	CRYP_INIT_IVLR_IV3_Msk = 0x10000000
	// Bit IV3.
	CRYP_INIT_IVLR_IV3 = 0x10000000
	// Position of IV2 field.
	CRYP_INIT_IVLR_IV2_Pos = 0x1d
	// Bit mask of IV2 field.
	CRYP_INIT_IVLR_IV2_Msk = 0x20000000
	// Bit IV2.
	CRYP_INIT_IVLR_IV2 = 0x20000000
	// Position of IV1 field.
	CRYP_INIT_IVLR_IV1_Pos = 0x1e
	// Bit mask of IV1 field.
	CRYP_INIT_IVLR_IV1_Msk = 0x40000000
	// Bit IV1.
	CRYP_INIT_IVLR_IV1 = 0x40000000
	// Position of IV0 field.
	CRYP_INIT_IVLR_IV0_Pos = 0x1f
	// Bit mask of IV0 field.
	CRYP_INIT_IVLR_IV0_Msk = 0x80000000
	// Bit IV0.
	CRYP_INIT_IVLR_IV0 = 0x80000000

	// INIT.IVRR: initialization vector registers
	// Position of IV63 field.
	CRYP_INIT_IVRR_IV63_Pos = 0x0
	// Bit mask of IV63 field.
	CRYP_INIT_IVRR_IV63_Msk = 0x1
	// Bit IV63.
	CRYP_INIT_IVRR_IV63 = 0x1
	// Position of IV62 field.
	CRYP_INIT_IVRR_IV62_Pos = 0x1
	// Bit mask of IV62 field.
	CRYP_INIT_IVRR_IV62_Msk = 0x2
	// Bit IV62.
	CRYP_INIT_IVRR_IV62 = 0x2
	// Position of IV61 field.
	CRYP_INIT_IVRR_IV61_Pos = 0x2
	// Bit mask of IV61 field.
	CRYP_INIT_IVRR_IV61_Msk = 0x4
	// Bit IV61.
	CRYP_INIT_IVRR_IV61 = 0x4
	// Position of IV60 field.
	CRYP_INIT_IVRR_IV60_Pos = 0x3
	// Bit mask of IV60 field.
	CRYP_INIT_IVRR_IV60_Msk = 0x8
	// Bit IV60.
	CRYP_INIT_IVRR_IV60 = 0x8
	// Position of IV59 field.
	CRYP_INIT_IVRR_IV59_Pos = 0x4
	// Bit mask of IV59 field.
	CRYP_INIT_IVRR_IV59_Msk = 0x10
	// Bit IV59.
	CRYP_INIT_IVRR_IV59 = 0x10
	// Position of IV58 field.
	CRYP_INIT_IVRR_IV58_Pos = 0x5
	// Bit mask of IV58 field.
	CRYP_INIT_IVRR_IV58_Msk = 0x20
	// Bit IV58.
	CRYP_INIT_IVRR_IV58 = 0x20
	// Position of IV57 field.
	CRYP_INIT_IVRR_IV57_Pos = 0x6
	// Bit mask of IV57 field.
	CRYP_INIT_IVRR_IV57_Msk = 0x40
	// Bit IV57.
	CRYP_INIT_IVRR_IV57 = 0x40
	// Position of IV56 field.
	CRYP_INIT_IVRR_IV56_Pos = 0x7
	// Bit mask of IV56 field.
	CRYP_INIT_IVRR_IV56_Msk = 0x80
	// Bit IV56.
	CRYP_INIT_IVRR_IV56 = 0x80
	// Position of IV55 field.
	CRYP_INIT_IVRR_IV55_Pos = 0x8
	// Bit mask of IV55 field.
	CRYP_INIT_IVRR_IV55_Msk = 0x100
	// Bit IV55.
	CRYP_INIT_IVRR_IV55 = 0x100
	// Position of IV54 field.
	CRYP_INIT_IVRR_IV54_Pos = 0x9
	// Bit mask of IV54 field.
	CRYP_INIT_IVRR_IV54_Msk = 0x200
	// Bit IV54.
	CRYP_INIT_IVRR_IV54 = 0x200
	// Position of IV53 field.
	CRYP_INIT_IVRR_IV53_Pos = 0xa
	// Bit mask of IV53 field.
	CRYP_INIT_IVRR_IV53_Msk = 0x400
	// Bit IV53.
	CRYP_INIT_IVRR_IV53 = 0x400
	// Position of IV52 field.
	CRYP_INIT_IVRR_IV52_Pos = 0xb
	// Bit mask of IV52 field.
	CRYP_INIT_IVRR_IV52_Msk = 0x800
	// Bit IV52.
	CRYP_INIT_IVRR_IV52 = 0x800
	// Position of IV51 field.
	CRYP_INIT_IVRR_IV51_Pos = 0xc
	// Bit mask of IV51 field.
	CRYP_INIT_IVRR_IV51_Msk = 0x1000
	// Bit IV51.
	CRYP_INIT_IVRR_IV51 = 0x1000
	// Position of IV50 field.
	CRYP_INIT_IVRR_IV50_Pos = 0xd
	// Bit mask of IV50 field.
	CRYP_INIT_IVRR_IV50_Msk = 0x2000
	// Bit IV50.
	CRYP_INIT_IVRR_IV50 = 0x2000
	// Position of IV49 field.
	CRYP_INIT_IVRR_IV49_Pos = 0xe
	// Bit mask of IV49 field.
	CRYP_INIT_IVRR_IV49_Msk = 0x4000
	// Bit IV49.
	CRYP_INIT_IVRR_IV49 = 0x4000
	// Position of IV48 field.
	CRYP_INIT_IVRR_IV48_Pos = 0xf
	// Bit mask of IV48 field.
	CRYP_INIT_IVRR_IV48_Msk = 0x8000
	// Bit IV48.
	CRYP_INIT_IVRR_IV48 = 0x8000
	// Position of IV47 field.
	CRYP_INIT_IVRR_IV47_Pos = 0x10
	// Bit mask of IV47 field.
	CRYP_INIT_IVRR_IV47_Msk = 0x10000
	// Bit IV47.
	CRYP_INIT_IVRR_IV47 = 0x10000
	// Position of IV46 field.
	CRYP_INIT_IVRR_IV46_Pos = 0x11
	// Bit mask of IV46 field.
	CRYP_INIT_IVRR_IV46_Msk = 0x20000
	// Bit IV46.
	CRYP_INIT_IVRR_IV46 = 0x20000
	// Position of IV45 field.
	CRYP_INIT_IVRR_IV45_Pos = 0x12
	// Bit mask of IV45 field.
	CRYP_INIT_IVRR_IV45_Msk = 0x40000
	// Bit IV45.
	CRYP_INIT_IVRR_IV45 = 0x40000
	// Position of IV44 field.
	CRYP_INIT_IVRR_IV44_Pos = 0x13
	// Bit mask of IV44 field.
	CRYP_INIT_IVRR_IV44_Msk = 0x80000
	// Bit IV44.
	CRYP_INIT_IVRR_IV44 = 0x80000
	// Position of IV43 field.
	CRYP_INIT_IVRR_IV43_Pos = 0x14
	// Bit mask of IV43 field.
	CRYP_INIT_IVRR_IV43_Msk = 0x100000
	// Bit IV43.
	CRYP_INIT_IVRR_IV43 = 0x100000
	// Position of IV42 field.
	CRYP_INIT_IVRR_IV42_Pos = 0x15
	// Bit mask of IV42 field.
	CRYP_INIT_IVRR_IV42_Msk = 0x200000
	// Bit IV42.
	CRYP_INIT_IVRR_IV42 = 0x200000
	// Position of IV41 field.
	CRYP_INIT_IVRR_IV41_Pos = 0x16
	// Bit mask of IV41 field.
	CRYP_INIT_IVRR_IV41_Msk = 0x400000
	// Bit IV41.
	CRYP_INIT_IVRR_IV41 = 0x400000
	// Position of IV40 field.
	CRYP_INIT_IVRR_IV40_Pos = 0x17
	// Bit mask of IV40 field.
	CRYP_INIT_IVRR_IV40_Msk = 0x800000
	