/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.BeanConverter;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.NullValueProvider;
import net.sf.sdedit.ui.components.configuration.StringSelectionProvider;
import net.sf.sdedit.util.DocUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Bean<T extends DataObject>
implements Serializable,
InvocationHandler {
    private static final long serialVersionUID = -8567877402350780001L;
    private transient Set<PropertyChangeListener> listeners;
    private transient SortedMap<String, PropertyDescriptor> properties;
    private transient SortedMap<String, String> order;
    private HashMap<String, Object> values = new HashMap();
    private Class<T> dataClass;
    private transient T dataObject;
    private transient StringSelectionProvider ssp;
    private boolean permitNullValues;
    private Map<String, Set<String>> stringSets;
    private Map<String, String> methodToPropertyNameMap;
    private transient Pattern pattern;
    private boolean alwaysNotifyListeners;

    public Bean(Class<T> dataClass, StringSelectionProvider ssp) {
        this.ssp = ssp;
        this.dataClass = dataClass;
        this.init();
        this.permitNullValues = false;
        this.stringSets = new HashMap<String, Set<String>>();
        this.methodToPropertyNameMap = new HashMap<String, String>();
        this.alwaysNotifyListeners = false;
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    private static String norm(String property) {
        return Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    public Set<PropertyChangeListener> getPropertyChangeListeners() {
        return Collections.checkedSet(this.listeners, PropertyChangeListener.class);
    }

    private void init() {
        this.properties = new TreeMap<String, PropertyDescriptor>();
        this.order = new TreeMap<String, String>();
        this.listeners = new LinkedHashSet<PropertyChangeListener>();
        this.pattern = Pattern.compile("get|set|is");
        Class<Object> cls = this.dataClass;
        while (cls != null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(cls);
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < propertyDescriptors.length; ++i) {
                    PropertyDescriptor property = propertyDescriptors[i];
                    if (property.getWriteMethod() == null || !property.getWriteMethod().isAnnotationPresent(Adjustable.class)) continue;
                    String key = property.getWriteMethod().getAnnotation(Adjustable.class).key();
                    if (key.equals("")) {
                        key = Bean.norm(property.getName());
                    }
                    this.order.put(key, Bean.norm(property.getName()));
                    this.properties.put(Bean.norm(property.getName()), property);
                    if (this.getValue(property) != null) continue;
                    this.setValue(property, NullValueProvider.getNullValue(property.getPropertyType()));
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IllegalStateException("FATAL: data class introspection was not successful");
            }
            if (cls.getInterfaces() != null && cls.getInterfaces().length > 0) {
                cls = cls.getInterfaces()[0];
                continue;
            }
            cls = null;
        }
    }

    public T getDataObject() {
        if (this.dataObject == null) {
            this.dataObject = (DataObject)Proxy.newProxyInstance(this.dataClass.getClassLoader(), new Class[]{this.dataClass}, (InvocationHandler)this);
        }
        return this.dataObject;
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name.equals("getBean")) {
            return this;
        }
        if (name.equals("isA")) {
            return ((Class)Class.class.cast(args[0])).isAssignableFrom(this.dataClass);
        }
        if (name.equals("cast")) {
            return proxy;
        }
        if (name.equals("copy")) {
            Bean<T> copy = this.copy();
            return copy.getDataObject();
        }
        if (name.equals("hashCode") && method.getParameterTypes().length == 1) {
            return this.hashCode();
        }
        if (name.equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
            DataObject other = (DataObject)args[0];
            return this.equals(other.getBean(DataObject.class));
        }
        String property = this.methodToPropertyNameMap.get(name);
        if (property == null) {
            Matcher matcher = this.pattern.matcher(name);
            property = matcher.replaceFirst("");
            this.methodToPropertyNameMap.put(name, property);
        }
        if (name.charAt(0) == 's') {
            this.setValue((PropertyDescriptor)this.properties.get(property), args[0]);
            return null;
        }
        return this.getValue(property);
    }

    public Collection<PropertyDescriptor> getProperties() {
        LinkedList<PropertyDescriptor> list = new LinkedList<PropertyDescriptor>();
        for (String property : this.order.values()) {
            list.add((PropertyDescriptor)this.properties.get(property));
        }
        return list;
    }

    public Collection<PropertyDescriptor> getPrimaryProperties() {
        LinkedList<PropertyDescriptor> list = new LinkedList<PropertyDescriptor>();
        Collection<PropertyDescriptor> properties = this.getProperties();
        for (PropertyDescriptor prop : properties) {
            if (!prop.getWriteMethod().getAnnotation(Adjustable.class).primary()) continue;
            list.add(prop);
        }
        return list;
    }

    public PropertyDescriptor getProperty(String name) {
        return (PropertyDescriptor)this.properties.get(Bean.norm(name));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void takeValuesFrom(Bean<T> bean) {
        for (PropertyDescriptor property : this.getProperties()) {
            this.setValue(property, bean.getValue(property.getName()));
        }
    }

    public Bean<T> copy() {
        Bean<T> copy = new Bean<T>(this.dataClass, this.ssp);
        copy.takeValuesFrom(this);
        return copy;
    }

    public final Object getValue(String property) {
        return this.values.get(Bean.norm(property));
    }

    public final Object getValue(PropertyDescriptor pd) {
        return this.getValue(pd.getName());
    }

    public void load(File file) throws DocUtil.XMLException, IOException {
        this.load(file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL url) throws DocUtil.XMLException, IOException {
        InputStream stream = url.openStream();
        try {
            Document document = DocUtil.readDocument(stream, "UTF-8");
            this.load(document, "/configuration/data");
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file) throws DocUtil.XMLException, IOException {
        FileOutputStream stream = new FileOutputStream(file);
        try {
            Document doc = DocUtil.newDocument();
            doc.appendChild(doc.createElement("configuration"));
            this.store(doc, "/configuration", "data");
            DocUtil.writeDocument(doc, "UTF-8", stream);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public void load(Document document, String pathToElement) throws DocUtil.XMLException {
        Element elem = (Element)DocUtil.evalXPathAsNode(document, pathToElement);
        if (elem != null) {
            BeanConverter converter = new BeanConverter(this, document);
            converter.setValues(elem);
        }
    }

    public void setAlwaysNotifyListeners(boolean notify) {
        this.alwaysNotifyListeners = notify;
    }

    public void store(Document document, String pathToParent, String elementName) throws DocUtil.XMLException {
        Element parent = (Element)DocUtil.evalXPathAsNode(document, pathToParent);
        BeanConverter converter = new BeanConverter(this, document);
        Element elem = converter.createElement(elementName);
        parent.appendChild(elem);
    }

    public final void setValue(PropertyDescriptor property, Object value) {
        Set<String> choices;
        if (value == null && !this.permitNullValues) {
            return;
        }
        if (!("".equals(value) || property.getPropertyType() != String.class || (choices = this.getStringsForProperty(property)).isEmpty() || choices.contains(value))) {
            return;
        }
        String propertyName = Bean.norm(property.getName());
        Object oldValue = this.values.get(propertyName);
        this.values.put(propertyName, value);
        this.firePropertyChanged(property, value, oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void firePropertyChanged(PropertyDescriptor property, Object newValue, Object oldValue) {
        LinkedList<PropertyChangeListener> _listeners;
        boolean notify;
        if (this.alwaysNotifyListeners) {
            notify = true;
        } else {
            notify = false;
            if (!(newValue == null && oldValue == null || newValue != null && oldValue != null && newValue.equals(oldValue))) {
                notify = true;
            }
        }
        if (!notify) return;
        PropertyChangeEvent event = new PropertyChangeEvent(this, property.getName(), oldValue, newValue);
        Bean bean = this;
        synchronized (bean) {
            _listeners = new LinkedList<PropertyChangeListener>(this.listeners);
        }
        Adjustable adj = property.getWriteMethod().getAnnotation(Adjustable.class);
        try {
            for (PropertyChangeListener listener : _listeners) {
                Method actionMethod = null;
                if (adj.button() && newValue != null && ((Boolean)newValue).booleanValue()) {
                    try {
                        actionMethod = listener.getClass().getMethod(property.getName(), new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (actionMethod == null) {
                    listener.propertyChange(event);
                    continue;
                }
                try {
                    actionMethod.invoke((Object)listener, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                    return;
                }
            }
        }
        finally {
            if (adj.button()) {
                this.values.put(Bean.norm(property.getName()), false);
            }
        }
    }

    public boolean equals(Object o) {
        Bean bean = (Bean)o;
        if (this.dataClass != bean.getDataClass()) {
            return false;
        }
        for (PropertyDescriptor property : this.getProperties()) {
            Object myVal = this.getValue(property.getName());
            Object yourVal = bean.getValue(property.getName());
            if (myVal == null && yourVal == null) continue;
            if (myVal == null || yourVal == null) {
                return false;
            }
            if (myVal.equals(yourVal)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuffer code = new StringBuffer();
        for (PropertyDescriptor property : this.getProperties()) {
            Object val = this.getValue(property.getName());
            code.append(val);
        }
        return code.hashCode();
    }

    public Set<String> getStringsForProperty(PropertyDescriptor property) {
        String propName = Bean.norm(property.getName());
        Set<String> strings = this.stringSets.get(propName);
        if (strings == null) {
            strings = new LinkedHashSet<String>();
            Adjustable adj = property.getWriteMethod().getAnnotation(Adjustable.class);
            String[] choices = adj.choices();
            if (choices.length == 0 && adj.stringSelectionProvided() && this.ssp != null) {
                choices = this.ssp.getStringSelection(property.getName());
            }
            for (String choice : choices) {
                strings.add(choice);
            }
            this.stringSets.put(Bean.norm(property.getName()), strings);
        }
        return strings;
    }

    public void setStringSelectionProvider(StringSelectionProvider ssp) {
        this.ssp = ssp;
    }

    public void clearStringSelection(String propertyName) {
        this.stringSets.remove(Bean.norm(propertyName));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (PropertyDescriptor property : this.getProperties()) {
            buffer.append(property.getName() + "=");
            buffer.append(this.getValue(property.getName()));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public boolean isPermitNullValues() {
        return this.permitNullValues;
    }

    public void setPermitNullValues(boolean permitNullValues) {
        this.permitNullValues = permitNullValues;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }
}

