SELECT
  NULL AS CONSTRAINT_CATALOG,
  CONSTRAINTS.OWNER AS CONSTRAINT_SCHEMA,
  CONSTRAINTS.TABLE_NAME,
  CONSTRAINTS.CONSTRAINT_NAME,
  DBMS_METADATA.GET_DDL('CONSTRAINT', CONSTRAINTS.CONSTRAINT_NAME, CONSTRAINTS.OWNER)
    AS CHECK_CLAUSE
FROM
  ${catalogscope}_CONSTRAINTS CONSTRAINTS
  INNER JOIN ${catalogscope}_USERS USERS
    ON CONSTRAINTS.OWNER = USERS.USERNAME
      AND USERS.ORACLE_MAINTAINED = 'N'
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
WHERE
  REGEXP_LIKE(CONSTRAINTS.OWNER, '${schemas}')
  AND CONSTRAINTS.TABLE_NAME NOT LIKE 'BIN$%'
  AND CONSTRAINT_TYPE IN ('C', 'U')
