/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.operation;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.loader.counts.TableRowCountsUtility;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.tools.command.text.operation.options.Operation;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.operation.options.OperationType;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.BaseTabularFormatter;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.traversal.DataTraversalHandler;
import us.fatehi.utility.Color;
import us.fatehi.utility.html.Alignment;

public final class DataTextFormatter
extends BaseTabularFormatter<OperationOptions>
implements DataTraversalHandler {
    private final Operation operation;
    private int dataBlockCount;

    private static String getMessage(double aggregate) {
        Number number = Math.abs(aggregate - (double)((int)aggregate)) < 1.0E-10 ? (Number)((int)aggregate) : (Number)aggregate;
        String message = TableRowCountsUtility.getRowCountMessage(number);
        return message;
    }

    public DataTextFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions, String identifierQuoteString) {
        super(SchemaTextDetailType.schema, options, outputOptions, identifierQuoteString);
        this.operation = Objects.requireNonNull(operation, "No operation provided");
    }

    @Override
    public void end() {
        if (this.operation == OperationType.count) {
            this.formattingHelper.writeObjectEnd();
        }
        super.end();
    }

    @Override
    public void handleData(Query query, ResultSet rows) {
        String title = query != null ? query.getName() : "";
        this.handleData(title, rows);
    }

    @Override
    public void handleData(Table table, ResultSet rows) {
        String tableName = table != null ? this.quoteName(table) : "";
        this.handleData(tableName, rows);
    }

    private void handleAggregateOperationForTable(String title, ResultSet results) {
        long aggregate = 0L;
        try {
            if (results.next()) {
                aggregate = results.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Could not obtain aggregate data", e);
        }
        String message = DataTextFormatter.getMessage(aggregate);
        this.formattingHelper.writeNameValueRow(title, message, Alignment.right);
    }

    private void handleData(String title, ResultSet rows) {
        if (rows == null) {
            return;
        }
        if (this.dataBlockCount == 0) {
            this.printHeader();
        }
        if (this.operation == OperationType.count) {
            this.handleAggregateOperationForTable(title, rows);
        } else {
            this.formattingHelper.println();
            this.formattingHelper.println();
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.writeObjectNameRow("", title, "", Color.white);
            try (MetadataResultSet dataRows = new MetadataResultSet(rows, "Data");){
                dataRows.setShowLobs(((OperationOptions)this.options).isShowLobs());
                this.formattingHelper.writeRowHeader(dataRows.getColumnNames());
                this.iterateRows(dataRows);
            }
            catch (SQLException e) {
                throw new DatabaseAccessException(e);
            }
            this.formattingHelper.writeObjectEnd();
        }
        ++this.dataBlockCount;
    }

    private void iterateRows(MetadataResultSet dataRows) throws SQLException {
        while (dataRows.next()) {
            List<Object> currentRow = dataRows.row();
            Object[] columnData = currentRow.toArray(new Object[currentRow.size()]);
            this.formattingHelper.writeRow(columnData);
        }
    }

    private void printHeader() {
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, this.operation.getTitle());
        if (this.operation == OperationType.count) {
            this.formattingHelper.writeObjectStart();
            this.formattingHelper.writeObjectNameRow("", this.operation.getTitle(), "", Color.white);
        }
    }
}

