/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.Schema;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.WrappedSQLException;
import us.fatehi.utility.string.StringFormat;

final class PrimaryKeyRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(PrimaryKeyRetriever.class.getName());

    PrimaryKeyRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrievePrimaryKeys(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.primaryKeysRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving primary keys, using fast data dictionary retrieval");
                this.retrievePrimaryKeysFromDataDictionary(allTables);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving primary keys");
                this.retrievePrimaryKeysFromMetadata(allTables);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving primary keys");
            }
        }
    }

    private void createPrimaryKeyForTable(MutableTable table, MetadataResultSet results) {
        Optional<MutableColumn> columnOptional;
        String columnName = results.getString("COLUMN_NAME");
        String primaryKeyName = results.getString("PK_NAME");
        int keySequence = Integer.parseInt(results.getString("KEY_SEQ"));
        LOGGER.log(Level.FINE, new StringFormat("Retrieving primary column <%s.%s.%s>", table, primaryKeyName, columnName));
        MutablePrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey == null) {
            primaryKey = MutablePrimaryKey.newPrimaryKey(table, primaryKeyName);
            table.setPrimaryKey(primaryKey);
        }
        if ((columnOptional = table.lookupColumn(columnName)).isPresent()) {
            MutableColumn column = columnOptional.get();
            column.markAsPartOfPrimaryKey();
            MutableTableConstraintColumn pkColumn = new MutableTableConstraintColumn(primaryKey, column);
            pkColumn.setKeyOrdinalPosition(keySequence);
            primaryKey.addColumn(pkColumn);
        }
    }

    private void retrievePrimaryKeysFromDataDictionary(NamedObjectList<MutableTable> allTables) throws WrappedSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.PRIMARY_KEYS)) {
            LOGGER.log(Level.FINE, "Extended primary keys SQL statement was not provided");
            return;
        }
        Query pkSql = informationSchemaViews.getQuery(InformationSchemaKey.PRIMARY_KEYS);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(pkSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String tableName;
                String schemaName;
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
                Optional<MutableTable> optionalTable = this.lookupTable(catalogName, schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM")), tableName = results.getString("TABLE_NAME"));
                if (!optionalTable.isPresent()) continue;
                MutableTable table = optionalTable.get();
                this.createPrimaryKeyForTable(table, results);
            }
        }
        catch (SQLException e) {
            throw new WrappedSQLException(String.format("Could not retrieve primary keys from SQL:%n%s", pkSql), e);
        }
    }

    private void retrievePrimaryKeysFromMetadata(NamedObjectList<MutableTable> allTables) throws SQLException {
        for (MutableTable table : allTables) {
            if (table instanceof View) continue;
            Schema tableSchema = table.getSchema();
            try {
                Connection connection = this.getRetrieverConnection().getConnection();
                try (MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getPrimaryKeys(tableSchema.getCatalogName(), tableSchema.getName(), table.getName()), "DatabaseMetaData::getPrimaryKeys");){
                    while (results.next()) {
                        this.createPrimaryKeyForTable(table, results);
                    }
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new WrappedSQLException(String.format("Could not retrieve primary keys for table <%s>", table), e);
            }
        }
    }
}

