/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.DatabaseObjectReference;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Grant;
import schemacrawler.schema.Privilege;
import us.fatehi.utility.Utility;

final class MutablePrivilege<D extends DatabaseObject>
extends AbstractDependantObject<D>
implements Privilege<D> {
    private static final long serialVersionUID = -1117664231494271886L;
    private final Set<Grant<D>> grants = new HashSet<Grant<D>>();

    MutablePrivilege(DatabaseObjectReference<D> parent, String name) {
        super(parent, name);
    }

    @Override
    public Collection<Grant<D>> getGrants() {
        ArrayList<Grant<D>> values = new ArrayList<Grant<D>>(this.grants);
        values.sort(Comparator.naturalOrder());
        return values;
    }

    void addGrant(String grantor, String grantee, boolean isGrantable) {
        if (!Utility.isBlank(grantor) || !Utility.isBlank(grantee)) {
            this.grants.add(new PrivilegeGrant(grantor, grantee, isGrantable));
        }
    }

    final class PrivilegeGrant
    implements Grant<D> {
        private static final long serialVersionUID = 356151825191631484L;
        private final String grantee;
        private final String grantor;
        private final boolean isGrantable;

        PrivilegeGrant(String grantor, String grantee, boolean isGrantable) {
            this.grantor = grantor;
            this.grantee = grantee;
            this.isGrantable = isGrantable;
        }

        @Override
        public int compareTo(Grant<D> otherGrant) {
            int compare = 0;
            if (compare == 0) {
                if (this.grantor == null) {
                    return -1;
                }
                compare = this.grantor.compareTo(otherGrant.getGrantor());
            }
            if (compare == 0) {
                if (this.grantee == null) {
                    return -1;
                }
                compare = this.grantee.compareTo(otherGrant.getGrantee());
            }
            return compare;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrivilegeGrant other = (PrivilegeGrant)obj;
            return Objects.equals(this.getParent(), other.getParent()) && Objects.equals(this.grantee, other.grantee) && Objects.equals(this.grantor, other.grantor) && this.isGrantable == other.isGrantable;
        }

        @Override
        public String getGrantee() {
            return this.grantee;
        }

        @Override
        public String getGrantor() {
            return this.grantor;
        }

        @Override
        public Privilege<D> getParent() {
            return MutablePrivilege.this;
        }

        public int hashCode() {
            return Objects.hash(this.getParent(), this.grantee, this.grantor, this.isGrantable);
        }

        @Override
        public boolean isGrantable() {
            return this.isGrantable;
        }

        public String toString() {
            return String.format("%s --> %s%s", Utility.trimToEmpty(this.grantor), Utility.trimToEmpty(this.grantee), this.isGrantable ? " (grantable)" : "");
        }
    }
}

