/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.jdbc.FirebirdSavepoint;

public class FBSavepoint
implements FirebirdSavepoint {
    private static final String SAVEPOINT_ID_PREFIX = "SVPT";
    private final boolean named;
    private final int savepointId;
    private final String name;
    private boolean valid = true;

    public FBSavepoint(int savepointId) {
        this(false, savepointId, FBSavepoint.getSavepointServerId(savepointId));
    }

    public FBSavepoint(String name) {
        this(true, -1, name);
    }

    private FBSavepoint(boolean named, int savepointId, String name) {
        this.named = named;
        this.savepointId = savepointId;
        this.name = name;
    }

    private static String getSavepointServerId(int savePointId) {
        if (savePointId >= 0) {
            return SAVEPOINT_ID_PREFIX + savePointId;
        }
        return "SVPT_" + Math.abs(savePointId);
    }

    String getServerSavepointId() {
        return this.name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.named) {
            throw new SQLException("Savepoint is named.");
        }
        return this.savepointId;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (!this.named) {
            throw new SQLException("Savepoint is unnamed.");
        }
        return this.name;
    }

    boolean isValid() {
        return this.valid;
    }

    void invalidate() {
        this.valid = false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FBSavepoint)) {
            return false;
        }
        FBSavepoint that = (FBSavepoint)obj;
        return this.named == that.named && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

