/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbTransaction;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class V10Transaction
extends AbstractFbTransaction
implements FbWireTransaction {
    private static final Logger log = LoggerFactory.getLogger(V10Transaction.class);
    private final int handle;

    public V10Transaction(FbWireDatabase database, int transactionHandle, TransactionState initialState) {
        super(initialState, database);
        this.handle = transactionHandle;
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getDatabase().getXdrStreamAccess().getXdrOut();
    }

    @Override
    protected FbWireDatabase getDatabase() {
        return (FbWireDatabase)super.getDatabase();
    }

    @Override
    public int getHandle() {
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.switchState(TransactionState.COMMITTING);
                this.finishTransaction(30);
                this.switchState(TransactionState.COMMITTED);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            TransactionState transactionState = this.getState();
            if (transactionState != TransactionState.COMMITTED) {
                String message = "Commit not completed, state was " + (Object)((Object)transactionState);
                log.warn(message + "; see debug level for stacktrace");
                if (log.isDebugEnabled()) {
                    log.debug(message, new RuntimeException("Commit not completed"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.switchState(TransactionState.ROLLING_BACK);
                this.finishTransaction(31);
                this.switchState(TransactionState.ROLLED_BACK);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            TransactionState transactionState = this.getState();
            if (transactionState != TransactionState.ROLLED_BACK) {
                String message = "Rollback not completed, state was " + (Object)((Object)transactionState);
                log.warn(message + "; see debug level for stacktrace");
                if (log.isDebugEnabled()) {
                    log.debug(message, new RuntimeException("Rollback not completed"));
                }
            }
        }
    }

    private void finishTransaction(int commitOrRollback) throws SQLException {
        assert (commitOrRollback == 30 || commitOrRollback == 31) : "Unsupported operation code " + commitOrRollback;
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(commitOrRollback);
            xdrOut.writeInt(this.handle);
            xdrOut.flush();
        }
        catch (IOException ioex) {
            throw new FbExceptionBuilder().exception(335544727).cause(ioex).toSQLException();
        }
        try {
            this.getDatabase().readResponse(null);
        }
        catch (IOException ioex) {
            throw new FbExceptionBuilder().exception(335544726).cause(ioex).toSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(byte[] recoveryInformation) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.switchState(TransactionState.PREPARING);
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    if (recoveryInformation != null) {
                        xdrOut.writeInt(51);
                        xdrOut.writeInt(this.handle);
                        xdrOut.writeBuffer(recoveryInformation);
                    } else {
                        xdrOut.writeInt(32);
                        xdrOut.writeInt(this.handle);
                    }
                    xdrOut.flush();
                }
                catch (IOException ioex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ioex).toSQLException();
                }
                try {
                    this.getDatabase().readResponse(null);
                }
                catch (IOException ioex) {
                    throw new FbExceptionBuilder().exception(335544726).cause(ioex).toSQLException();
                }
                this.switchState(TransactionState.PREPARED);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            if (this.getState() != TransactionState.PREPARED) {
                String message = "Prepare not completed";
                log.warn(message + "; see debug level for stacktrace");
                if (log.isDebugEnabled()) {
                    log.debug(message, new RuntimeException(message));
                }
            }
        }
    }

    @Override
    public byte[] getTransactionInfo(byte[] requestItems, int maxBufferLength) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    xdrOut.writeInt(42);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(0);
                    xdrOut.writeBuffer(requestItems);
                    xdrOut.writeInt(maxBufferLength);
                    xdrOut.flush();
                }
                catch (IOException ioex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ioex).toSQLException();
                }
                try {
                    GenericResponse genericResponse = this.getDatabase().readGenericResponse(null);
                    return genericResponse.getData();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }
}

