/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.metrics;

import net.snowflake.client.jdbc.internal.opencensus.metrics.MetricRegistry;
import net.snowflake.client.jdbc.internal.opencensus.metrics.export.ExportComponent;

public abstract class MetricsComponent {
    public abstract ExportComponent getExportComponent();

    public abstract MetricRegistry getMetricRegistry();

    static MetricsComponent newNoopMetricsComponent() {
        return new NoopMetricsComponent();
    }

    private static final class NoopMetricsComponent
    extends MetricsComponent {
        private static final ExportComponent EXPORT_COMPONENT = ExportComponent.newNoopExportComponent();
        private static final MetricRegistry METRIC_REGISTRY = MetricRegistry.newNoopMetricRegistry();

        private NoopMetricsComponent() {
        }

        @Override
        public ExportComponent getExportComponent() {
            return EXPORT_COMPONENT;
        }

        @Override
        public MetricRegistry getMetricRegistry() {
            return METRIC_REGISTRY;
        }
    }
}

