/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.sqlite;

import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.ListExclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseUrlConnectionOptions;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.sqlite.SQLiteDatabaseConnector;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.MultiUseUserCredentials;
import us.fatehi.utility.datasource.UserCredentials;

public class EmbeddedSQLiteWrapper {
    private static InclusionRule sqliteTableExclusionRule = new InclusionRule(){
        private static final long serialVersionUID = -7643052797359767051L;
        private final Predicate<String> exclusionRule = new ListExclusionRule(Arrays.asList("auth_group", "auth_group_permissions", "auth_permission", "auth_user", "auth_user_groups", "auth_user_user_permissions", "otp_totp_totpdevice", "DATABASECHANGELOG", "SCHEMA_VERSION", "_EFMigrationsHistory", "android_metadata")).and((Predicate)new RegularExpressionExclusionRule("django_.*"));

        public boolean test(String text) {
            return this.exclusionRule.test(text);
        }
    };
    private Path databaseFile;

    public DatabaseConnectionSource createDatabaseConnectionSource() {
        Objects.requireNonNull(this.databaseFile, "Database file not loaded");
        DatabaseUrlConnectionOptions urlConnectionOptions = new DatabaseUrlConnectionOptions(this.getConnectionUrl());
        DatabaseConnectionSource connectionOptions = new SQLiteDatabaseConnector().newDatabaseConnectionSource((DatabaseConnectionOptions)urlConnectionOptions, (UserCredentials)new MultiUseUserCredentials());
        return connectionOptions;
    }

    public Path executeForOutput(String title, OutputFormat extension) {
        Path path;
        block9: {
            DatabaseConnectionSource dataSource = this.createDatabaseConnectionSource();
            try {
                path = this.executeForOutput(dataSource, title, extension);
                if (dataSource == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dataSource != null) {
                        try {
                            dataSource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseAccessException("Could not create database connection", e);
                }
                catch (Exception e) {
                    throw new ExecutionRuntimeException("Could not create database connection", (Throwable)e);
                }
            }
            dataSource.close();
        }
        return path;
    }

    public String getConnectionUrl() {
        Objects.requireNonNull(this.databaseFile, "Database file not loaded");
        return "jdbc:sqlite:" + this.databaseFile.toString();
    }

    public Path getDatabasePath() {
        if (this.databaseFile == null) {
            return null;
        }
        return this.databaseFile;
    }

    public void setDatabasePath(Path dbFile) {
        this.databaseFile = this.checkDatabaseFile(dbFile);
    }

    protected final Path checkDatabaseFile(Path dbFile) {
        Path databaseFile = Objects.requireNonNull(dbFile, "No database file path provided").normalize().toAbsolutePath();
        if (!IOUtility.isFileReadable((Path)databaseFile)) {
            throw new IORuntimeException(String.format("Could not read database file <%s>", dbFile));
        }
        return databaseFile;
    }

    private Path executeForOutput(DatabaseConnectionSource dataSource, String title, OutputFormat extension) {
        try {
            LimitOptions limitOptions = LimitOptionsBuilder.builder().includeTables(sqliteTableExclusionRule).toOptions();
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptions);
            Path diagramFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)extension.getFormat());
            OutputOptions outputOptions = OutputOptionsBuilder.builder().title(title).withOutputFormat(extension).withOutputFile(diagramFile).toOptions();
            SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable("schema");
            executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
            executable.setOutputOptions(outputOptions);
            executable.setDataSource(dataSource);
            executable.execute();
            return diagramFile;
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException(String.format("Could not create database schema diagram <%s>", title), (Throwable)e);
        }
    }
}

