/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.template;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.command.template.BaseTemplateRenderer;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;

public final class MustacheRenderer
extends BaseTemplateRenderer {
    @Override
    public void execute() {
        OutputOptions outputOptions = this.getOutputOptions();
        String templateLocation = this.getResourceFilename();
        InputResource inputResource = (InputResource)InputResourceUtility.createInputResource((String)templateLocation).orElseThrow(() -> new ConfigurationException(String.format("Mustache template not found <%s>", templateLocation)));
        try {
            DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
            Mustache mustache = mustacheFactory.compile(inputResource.openNewInputReader(StandardCharsets.UTF_8), templateLocation);
            try (PrintWriter writer = outputOptions.openNewOutputWriter();){
                Map<String, Object> context = this.getContext();
                mustache.execute((Writer)writer, context).flush();
            }
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Exception rendering FreeMarker template", (Throwable)e);
        }
    }
}

