/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.shell;

import java.sql.Connection;
import picocli.CommandLine;
import schemacrawler.Version;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.tools.commandline.command.AvailableJDBCDrivers;
import schemacrawler.tools.commandline.shell.AvailableCatalogLoadersCommand;
import schemacrawler.tools.commandline.shell.AvailableCommandsCommand;
import schemacrawler.tools.commandline.shell.AvailableServersCommand;
import schemacrawler.tools.commandline.state.BaseStateHolder;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.state.StateUtility;
import schemacrawler.tools.commandline.utility.CommandLineUtility;

@CommandLine.Command(name="system", aliases={"sys", "sys-info"}, header={"** Display SchemaCrawler version and system information"}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"system"}, optionListHeading="Options:%n")
public class SystemCommand
extends BaseStateHolder
implements Runnable {
    @CommandLine.Option(names={"-C", "--is-connected"}, description={"Checks whether the shell has a connection to a database"})
    private boolean isconnected;
    @CommandLine.Option(names={"-L", "--is-loaded"}, description={"Checks whether the shell has loaded database metadata"})
    private boolean isloaded;
    @CommandLine.Option(names={"--show-stacktrace"}, description={"Shows stack trace from previous command"})
    private boolean showstacktrace;
    @CommandLine.Option(names={"--show-state"}, description={"Shows internal state"})
    private boolean showstate;
    @CommandLine.Option(names={"-E", "--show-environment"}, description={"Shows SchemaCrawler plugins and environment"})
    private boolean showenvironment;
    @CommandLine.Option(names={"-V", "--version"}, description={"Display SchemaCrawler version and system information"})
    private boolean versionRequested;

    public SystemCommand(ShellState state) {
        super(state);
    }

    public boolean isShowEnvironment() {
        return this.showenvironment;
    }

    public boolean isVersionRequested() {
        return this.versionRequested;
    }

    @Override
    public void run() {
        if (this.versionRequested) {
            this.showVersion();
        } else if (this.showenvironment) {
            this.showEnvironment();
        } else if (this.isconnected) {
            this.showConnected();
        } else if (this.isloaded) {
            this.showLoaded();
        } else if (this.showstacktrace) {
            this.showStackTrace();
        } else if (this.showstate) {
            this.showState();
        } else {
            this.showEnvironment();
            System.out.println();
            System.out.println("Connection Information:");
            this.showConnected();
            System.out.println();
            System.out.println("Load Information:");
            this.showLoaded();
            System.out.println();
        }
    }

    private void printConnectionInfo() {
        try (Connection connection = (Connection)this.state.getDataSource().get();){
            ConnectionInfo connectionInfo = ConnectionInfoBuilder.builder((Connection)connection).build();
            System.out.println(connectionInfo);
        }
        catch (Exception e) {
            System.err.println("Could not log connection information");
            e.printStackTrace();
        }
    }

    private void showConnected() {
        boolean isConnectedState = this.state.isConnected();
        if (isConnectedState) {
            this.printConnectionInfo();
        } else {
            System.out.println("Not connected to a database");
        }
    }

    private void showEnvironment() {
        System.out.println(CommandLineUtility.getEnvironment(this.state));
        new AvailableJDBCDrivers().print(System.out);
        new AvailableServersCommand().run();
        new AvailableCatalogLoadersCommand().run();
        new AvailableCommandsCommand().run();
    }

    private void showLoaded() {
        boolean isLoadedState = this.state.isLoaded();
        System.out.println(String.format("Database metadata is %sloaded", isLoadedState ? "" : "not "));
    }

    private void showStackTrace() {
        Throwable lastExceptionState = this.state.getLastException();
        if (lastExceptionState != null) {
            lastExceptionState.printStackTrace(System.out);
        }
    }

    private void showState() {
        StateUtility.logState(this.state, true);
    }

    private void showVersion() {
        System.out.println(Version.about());
    }
}

