/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.shell;

import java.util.Collection;
import picocli.CommandLine;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.executable.CommandDescription;
import us.fatehi.utility.Utility;

@CommandLine.Command(name="loaders", header={"** List available SchemaCrawler catalog loaders"}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"loaders"}, optionListHeading="Options:%n")
public class AvailableCatalogLoadersCommand
implements Runnable {
    private static String availableCatalogLoadersDescriptive() {
        CommandLine.Help.ColorScheme.Builder colorSchemaBuilder = new CommandLine.Help.ColorScheme.Builder();
        colorSchemaBuilder.ansi(CommandLine.Help.Ansi.OFF);
        CommandLine.Help.TextTable textTable = CommandLine.Help.TextTable.forColumns((CommandLine.Help.ColorScheme)colorSchemaBuilder.build(), (CommandLine.Help.Column[])new CommandLine.Help.Column[]{new CommandLine.Help.Column(15, 1, CommandLine.Help.Column.Overflow.SPAN), new CommandLine.Help.Column(65, 1, CommandLine.Help.Column.Overflow.WRAP)});
        Collection supportedCatalogLoaders = new CatalogLoaderRegistry().getSupportedCatalogLoaders();
        for (CommandDescription commandDescription : supportedCatalogLoaders) {
            textTable.addRowValues(new String[]{commandDescription.getName(), commandDescription.getDescription()});
        }
        return textTable.toString();
    }

    @Override
    public void run() {
        String availableCatalogLoaders = AvailableCatalogLoadersCommand.availableCatalogLoadersDescriptive();
        if (!Utility.isBlank((CharSequence)availableCatalogLoaders)) {
            System.out.println();
            System.out.println("Available SchemaCrawler catalog loader plugins:");
            System.out.println(availableCatalogLoaders);
            System.out.println("Notes:");
            System.out.println("- For help on an individual catalog loader,");
            System.out.println("  run SchemaCrawler with options like: `-h loader:weakassociationsloader`");
            System.out.println("  or, from the SchemaCrawler interactive shell: `help loader:weakassociationsloader`");
            System.out.println("- Options for the catalog loaders should be provided with the `load` command");
        }
    }
}

