/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NIOAcceptPacket;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIORedirectPacket;
import oracle.net.ns.NIORefusePacket;
import oracle.net.ns.NIOResendPacket;
import oracle.net.ns.NSProtocolNIO;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
abstract class NIOPacket {
    final NIOHeader header;
    public SessionAtts session;
    static final String[] toHex;
    static final char[] toChar;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    NIOPacket(SessionAtts session) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NIOPacket.class, $$$methodRef$$$15, null, session);
            }
            this.session = session;
            this.header = new NIOHeader(session);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NIOPacket.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NIOPacket.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NIOPacket.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    NIOPacket(NIOHeader header, SessionAtts session) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NIOPacket.class, $$$methodRef$$$16, null, header, session);
            }
            this.header = header;
            this.session = session;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, NIOPacket.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NIOPacket.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NIOPacket.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    abstract void readPayloadBuffer() throws IOException;

    /*
     * WARNING - void declaration
     */
    final void readFromSocketChannel(boolean bl) throws IOException {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void needToReadHeader;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NIOPacket.class, $$$methodRef$$$0, this, bl);
            }
            this.readFromSocketChannel((boolean)needToReadHeader, true);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NIOPacket.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NIOPacket.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NIOPacket.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void readFromSocketChannel(boolean bl, boolean bl2) throws IOException {
        boolean bl3 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void handleMarker;
            void needToReadHeader;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NIOPacket.class, $$$methodRef$$$1, this, bl, bl2);
            }
            if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
                this.readPacketFromMSGQ();
            } else {
                this.readPacketFromSocketChannel((boolean)needToReadHeader);
            }
            if (this.header.type == 14) {
                this.session.controlPacket.readPayloadBuffer();
                this.readFromSocketChannel((boolean)needToReadHeader, (boolean)handleMarker);
            }
            if (handleMarker != false && this.header.type == 12) {
                this.session.markerPacket.readPayloadBuffer();
                this.processMarker();
                this.session.onBreakReset = this.session.markerPacket.isBreakPkt();
                BreakNetException breakNetException = new BreakNetException(500);
                if (bl3) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NIOPacket.class, $$$methodRef$$$1, this, breakNetException);
                }
                throw breakNetException;
            }
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NIOPacket.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NIOPacket.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NIOPacket.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    private void readPacketFromMSGQ() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NIOPacket.class, $$$methodRef$$$2, this, new Object[0]);
            }
            ByteOrder byteOrder = this.session.readBuffer.order();
            ByteBuffer readBuffer = ((MQLNTAdapter)this.session.nt).readFromLocalQueue();
            int read = readBuffer.limit();
            readBuffer.order(byteOrder);
            this.session.setReadBuffer(readBuffer);
            this.session.payloadDataBufferForRead.position(this.session.payloadDataBufferForRead.limit());
            if (read >= 8) {
                this.session.headerBufferForRead.position(0);
                this.session.headerBufferForRead.limit(8);
                this.header.readNSHeader();
            }
            this.session.payloadBufferForRead.clear();
            this.session.payloadBufferForRead.limit(this.header.length - 8);
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "type=" + this.header.type + ", length=" + this.header.length + ", flags=" + this.header.flags + "\n" + this.dumpBytes(this.session.readBuffer, 0, this.header.length) + ", sessionTraceId=" + this.session.traceId);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NIOPacket.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NIOPacket.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NIOPacket.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readPacketFromSocketChannel(boolean bl) throws IOException {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void needToReadHeader;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NIOPacket.class, $$$methodRef$$$3, this, bl);
            }
            int packetStartPosition = needToReadHeader != false ? this.readHeader() : this.session.readBuffer.position() - 8;
            int payloadLength = this.header.length - 8;
            if (payloadLength <= 0) {
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NIOPacket.class, $$$methodRef$$$3, this);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NIOPacket.class, $$$methodRef$$$3, this, null);
                }
                return;
            }
            if (this.session.readBuffer.remaining() < payloadLength) {
                packetStartPosition = this.readPayload(packetStartPosition, payloadLength);
            }
            this.session.readBuffer.position(packetStartPosition + 8);
            this.session.payloadBufferForRead = this.session.readBuffer.slice();
            this.session.payloadBufferForRead.limit(this.header.length - 8);
            this.session.readBuffer.position(packetStartPosition + this.header.length);
            if (bl2) {
                this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "type=" + this.header.type + ", length=" + this.header.length + ", flags=" + this.header.flags + "\n" + this.dumpBytes(this.session.readBuffer, packetStartPosition, this.header.length) + ", sessionTraceId=" + this.session.traceId);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NIOPacket.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NIOPacket.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NIOPacket.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    private int readHeader() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            int packetStartPosition;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NIOPacket.class, $$$methodRef$$$4, this, new Object[0]);
            }
            if (this.session.readBuffer.hasRemaining() && this.session.readBuffer.position() > 0) {
                if (this.session.readBuffer.remaining() < 8) {
                    this.session.readBuffer.compact();
                    packetStartPosition = 0;
                    ((NSProtocolNIO)this.session.ns).doSocketRead(8);
                } else {
                    packetStartPosition = this.session.readBuffer.position();
                }
            } else {
                this.session.readBuffer.clear();
                packetStartPosition = 0;
                ((NSProtocolNIO)this.session.ns).doSocketRead(8);
            }
            this.session.readBuffer.position(packetStartPosition);
            this.header.readHeaderBuffer();
            this.session.readBuffer.position(packetStartPosition + 8);
            int n2 = packetStartPosition;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NIOPacket.class, $$$methodRef$$$4, this, n2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NIOPacket.class, $$$methodRef$$$4, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NIOPacket.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int readPayload(int n2, int n3) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            int packetStartPosition;
            void payloadLength;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NIOPacket.class, $$$methodRef$$$5, this, n2, n3);
            }
            int remainingBytesToBeRead = Math.max((int)(payloadLength - this.session.readBuffer.remaining()), 0);
            int spaceAvailableInBuffer = this.session.readBuffer.capacity() - this.session.readBuffer.limit();
            if (spaceAvailableInBuffer < remainingBytesToBeRead) {
                this.session.readBuffer.position(packetStartPosition);
                this.session.readBuffer.compact();
                packetStartPosition = 0;
            } else {
                this.session.readBuffer.position(this.session.readBuffer.limit());
                this.session.readBuffer.limit(this.session.readBuffer.capacity());
            }
            ((NSProtocolNIO)this.session.ns).doSocketRead(packetStartPosition + this.header.length);
            int n4 = packetStartPosition;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NIOPacket.class, $$$methodRef$$$5, this, n4);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NIOPacket.class, $$$methodRef$$$5, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NIOPacket.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void processMarker() throws IOException, NetException, BreakNetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NIOPacket.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NIOPacket.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NIOPacket.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NIOPacket.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    final void writeToSocketChannel() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            block14: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NIOPacket.class, $$$methodRef$$$7, this, new Object[0]);
                }
                if (bl) {
                    this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "session.buffer: " + this.session.writeBuffer);
                }
                if (bl) {
                    this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "session.headerBuffer: " + this.session.headerBufferForWrite);
                }
                if (bl) {
                    this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "session.paylodBuffer: " + this.session.payloadBufferForWrite);
                }
                this.header.length = this.session.payloadBufferForWrite.position() + 8;
                this.header.fillHeaderBuffer();
                this.session.writeBuffer.clear();
                this.session.writeBuffer.limit(this.session.payloadBufferForWrite.position() + 8);
                if (bl) {
                    this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "type=" + this.header.type + ", length=" + this.session.writeBuffer.limit() + ", flags=" + this.header.flags + "\n" + this.dumpBytes(this.session.writeBuffer, 0, this.session.writeBuffer.limit()) + ", sessionTraceId=" + this.session.traceId);
                }
                ((NSProtocolNIO)this.session.ns).beginWrite();
                try {
                    if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
                        ((MQLNTAdapter)this.session.nt).writeToRemoteQueue(this.session.writeBuffer, true);
                        this.session.writeBuffer = null;
                        break block14;
                    }
                    while (this.session.writeBuffer.hasRemaining()) {
                        this.session.socketChannel.write(this.session.writeBuffer);
                    }
                }
                catch (Throwable throwable) {
                    ((NSProtocolNIO)this.session.ns).endWrite();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, NIOPacket.class, $$$methodRef$$$7, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            ((NSProtocolNIO)this.session.ns).endWrite();
            this.session.payloadBufferForWrite.position(this.session.payloadBufferForWrite.limit());
            this.session.payloadDataBufferForWrite.position(this.session.payloadDataBufferForWrite.limit());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NIOPacket.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NIOPacket.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NIOPacket.class, $$$methodRef$$$7, this, throwable3);
            }
            throw throwable;
        }
    }

    static NIOPacket readNIOPacket(SessionAtts sessionAtts) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            SessionAtts session;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NIOPacket.class, $$$methodRef$$$8, null, sessionAtts);
            }
            NIOPacket packet = null;
            NIOHeader header = new NIOHeader(session);
            if (session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
                ByteBuffer readBuffer = ((MQLNTAdapter)session.nt).readFromLocalQueue();
                int read = readBuffer.limit();
                session.setReadBuffer(readBuffer);
                if (read >= 8) {
                    session.headerBufferForRead.position(0);
                    session.headerBufferForRead.limit(8);
                    header.readNSHeader();
                }
                session.payloadBufferForRead.clear();
                session.payloadBufferForRead.limit(header.length - 8);
                session.readBuffer.position(header.length);
            } else {
                if (session.readBuffer.hasRemaining() && session.readBuffer.position() != 0) {
                    session.readBuffer.compact();
                } else {
                    session.readBuffer.clear();
                }
                ((NSProtocolNIO)session.ns).doSocketRead(8);
                session.readBuffer.rewind();
                header.readHeaderBuffer();
                session.readBuffer.position(8);
            }
            switch (header.type) {
                case 2: {
                    packet = new NIOAcceptPacket(header, session);
                    break;
                }
                case 5: {
                    packet = new NIORedirectPacket(header, session);
                    break;
                }
                case 4: {
                    packet = new NIORefusePacket(header, session);
                    break;
                }
                case 11: {
                    packet = new NIOResendPacket(header, session);
                    break;
                }
                case 12: {
                    packet = new NIOMarkerPacket(header, session);
                    break;
                }
                default: {
                    NetException netException = new NetException(204);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, NIOPacket.class, $$$methodRef$$$8, null, netException);
                    }
                    throw netException;
                }
            }
            if (session.networkType != NTAdapter.NetworkAdapterType.MSGQ) {
                packet.readFromSocketChannel(false);
            }
            packet.readPayloadBuffer();
            NIOPacket nIOPacket = packet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NIOPacket.class, $$$methodRef$$$8, null, nIOPacket);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NIOPacket.class, $$$methodRef$$$8, null, null);
            }
            return nIOPacket;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NIOPacket.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readInbandNotificationCtlPacket() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            block36: {
                int lastBufferPosition;
                int numberOfRetries;
                block34: {
                    int bytesRead;
                    block33: {
                        block32: {
                            block35: {
                                if (bl) {
                                    ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this, new Object[0]);
                                }
                                if (this.session.networkType != NTAdapter.NetworkAdapterType.MSGQ) break block35;
                                ByteBuffer readBuffer = ((MQLNTAdapter)this.session.nt).readFromLocalQueue(false);
                                if (readBuffer == null) {
                                    if (bl) {
                                        ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this);
                                        ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this, null);
                                    }
                                    return;
                                }
                                int read = readBuffer.limit();
                                this.session.setReadBuffer(readBuffer);
                                if (read >= 8) {
                                    this.session.headerBufferForRead.position(0);
                                    this.session.headerBufferForRead.limit(8);
                                    this.header.readNSHeader();
                                }
                                this.session.payloadBufferForRead.clear();
                                this.session.payloadBufferForRead.limit(this.header.length - 8);
                                this.session.readBuffer.position(this.header.length);
                                break block36;
                            }
                            if (this.session.socketChannel.isConnected()) break block32;
                            this.session.readBuffer.position(this.session.readBuffer.limit());
                            if (this.session.socketChannel.isConnected()) {
                                this.session.socketChannel.configureBlocking(true);
                            }
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this);
                                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this, null);
                            }
                            return;
                        }
                        this.session.readBuffer.clear();
                        this.session.readBuffer.limit(8);
                        numberOfRetries = 0;
                        lastBufferPosition = 0;
                        this.session.socketChannel.configureBlocking(false);
                        bytesRead = this.session.socketChannel.read(this.session.readBuffer);
                        this.session.socketChannel.configureBlocking(true);
                        if (bytesRead != 0) break block33;
                        this.session.readBuffer.position(this.session.readBuffer.limit());
                        if (this.session.socketChannel.isConnected()) {
                            this.session.socketChannel.configureBlocking(true);
                        }
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this);
                            ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this, null);
                        }
                        return;
                    }
                    if (bytesRead != -1) break block34;
                    if (bl) {
                        this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "Found socket closed while reading in-band notification control packet.");
                    }
                    this.session.readBuffer.position(this.session.readBuffer.limit());
                    if (this.session.socketChannel.isConnected()) {
                        this.session.socketChannel.configureBlocking(true);
                    }
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this);
                        ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this, null);
                    }
                    return;
                }
                try {
                    while (this.session.readBuffer.hasRemaining()) {
                        this.session.socketChannel.read(this.session.readBuffer);
                        numberOfRetries = lastBufferPosition == this.session.readBuffer.position() ? ++numberOfRetries : 0;
                        lastBufferPosition = this.session.readBuffer.position();
                        if (numberOfRetries < 10) continue;
                        NetException netException = new NetException(0);
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this, netException);
                        }
                        throw netException;
                    }
                    this.session.readBuffer.rewind();
                    this.session.headerBufferForRead = this.session.readBuffer.slice();
                    this.header.readNSHeader();
                    this.session.readBuffer.limit(this.header.length);
                    this.session.readBuffer.position(8);
                    while (this.session.readBuffer.hasRemaining()) {
                        this.session.socketChannel.read(this.session.readBuffer);
                    }
                    this.session.readBuffer.position(8);
                    this.session.payloadBufferForRead = this.session.readBuffer.slice();
                    this.session.readBuffer.position(this.session.readBuffer.limit());
                }
                catch (Throwable throwable) {
                    this.session.readBuffer.position(this.session.readBuffer.limit());
                    if (this.session.socketChannel.isConnected()) {
                        this.session.socketChannel.configureBlocking(true);
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this, throwable2);
                    }
                    throw throwable2;
                }
                if (this.session.socketChannel.isConnected()) {
                    this.session.socketChannel.configureBlocking(true);
                }
                if (this.header.type == 14) {
                    this.session.controlPacket.readPayloadBuffer();
                } else if (this.header.type == 6) {
                    short dataFlags = this.session.payloadBufferForRead.getShort();
                    if ((dataFlags & 0x8000) == 32768) {
                        this.session.renegotiateSSLSession();
                    }
                } else if (bl) {
                    this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "Received a different NS packet type while reading in-band notification control packet.");
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NIOPacket.class, $$$methodRef$$$9, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void reinitialize(SessionAtts sessionAtts) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _session;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NIOPacket.class, $$$methodRef$$$10, this, sessionAtts);
            }
            this.session = _session;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NIOPacket.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NIOPacket.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NIOPacket.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addFlags(int n2) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _flags;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NIOPacket.class, $$$methodRef$$$11, this, n2);
            }
            this.header.flags |= _flags;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NIOPacket.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NIOPacket.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NIOPacket.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setPoolEnabled(boolean bl) throws IOException, NetException, BreakNetException {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NIOPacket.class, $$$methodRef$$$12, this, bl);
            }
            if (value != false) {
                this.addFlags(1);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NIOPacket.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NIOPacket.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NIOPacket.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setLargeSDU(boolean bl) throws IOException, NetException, BreakNetException {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NIOPacket.class, $$$methodRef$$$13, this, bl);
            }
            if (value != false) {
                this.addFlags(32);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NIOPacket.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NIOPacket.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NIOPacket.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String dumpBytes(ByteBuffer byteBuffer, int n2, int n3) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void packetLength;
            void offset;
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NIOPacket.class, $$$methodRef$$$14, this, byteBuffer, n2, n3);
            }
            int bytesPerLine = 8;
            String DIVIDER = "     |";
            String BLANK_SPACE = "   ";
            StringBuilder sb = new StringBuilder(16384);
            StringBuilder tmpBuf = new StringBuilder(80);
            if (buffer == null) {
                String string = "NULL";
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NIOPacket.class, $$$methodRef$$$14, this, string);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NIOPacket.class, $$$methodRef$$$14, this, null);
                }
                return "NULL";
            }
            int position = buffer.position();
            int limit = buffer.limit();
            buffer.position((int)offset);
            buffer.limit((int)packetLength);
            sb.delete(0, sb.length());
            tmpBuf.delete(0, tmpBuf.length());
            int bytesThisLine = 0;
            while (buffer.hasRemaining()) {
                int x2 = buffer.get() & 0xFF;
                sb.append(toHex[x2]);
                tmpBuf.append(toChar[x2]);
                if (++bytesThisLine != 8) continue;
                sb.append("     |");
                sb.append(tmpBuf.substring(0, tmpBuf.length()));
                sb.append("|\n");
                tmpBuf.delete(0, tmpBuf.length());
                bytesThisLine = 0;
            }
            if (bytesThisLine > 0) {
                int j2;
                int spaces = 8 - bytesThisLine - 1;
                for (j2 = 0; j2 <= spaces; ++j2) {
                    sb.append("   ");
                }
                sb.append("     |");
                sb.append(tmpBuf.substring(0, tmpBuf.length()));
                for (j2 = 0; j2 <= spaces; ++j2) {
                    sb.append(" ");
                }
                sb.append("|\n");
                tmpBuf.delete(0, tmpBuf.length());
            }
            buffer.rewind();
            if (limit >= 0) {
                buffer.limit(limit);
            }
            if (position >= 0 && position <= limit) {
                buffer.position(position);
            }
            String string = sb.substring(0, sb.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NIOPacket.class, $$$methodRef$$$14, this, string);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NIOPacket.class, $$$methodRef$$$14, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NIOPacket.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$16 = NIOPacket.class.getDeclaredConstructor(NIOHeader.class, SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$15 = NIOPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$14 = NIOPacket.class.getDeclaredMethod("dumpBytes", ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$13 = NIOPacket.class.getDeclaredMethod("setLargeSDU", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$12 = NIOPacket.class.getDeclaredMethod("setPoolEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$11 = NIOPacket.class.getDeclaredMethod("addFlags", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$10 = NIOPacket.class.getDeclaredMethod("reinitialize", SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = NIOPacket.class.getDeclaredMethod("readInbandNotificationCtlPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = NIOPacket.class.getDeclaredMethod("readNIOPacket", SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = NIOPacket.class.getDeclaredMethod("writeToSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = NIOPacket.class.getDeclaredMethod("processMarker", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = NIOPacket.class.getDeclaredMethod("readPayload", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = NIOPacket.class.getDeclaredMethod("readHeader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = NIOPacket.class.getDeclaredMethod("readPacketFromSocketChannel", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NIOPacket.class.getDeclaredMethod("readPacketFromMSGQ", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NIOPacket.class.getDeclaredMethod("readFromSocketChannel", Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NIOPacket.class.getDeclaredMethod("readFromSocketChannel", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        toHex = new String[]{" 00", " 01", " 02", " 03", " 04", " 05", " 06", " 07", " 08", " 09", " 0A", " 0B", " 0C", " 0D", " 0E", " 0F", " 10", " 11", " 12", " 13", " 14", " 15", " 16", " 17", " 18", " 19", " 1A", " 1B", " 1C", " 1D", " 1E", " 1F", " 20", " 21", " 22", " 23", " 24", " 25", " 26", " 27", " 28", " 29", " 2A", " 2B", " 2C", " 2D", " 2E", " 2F", " 30", " 31", " 32", " 33", " 34", " 35", " 36", " 37", " 38", " 39", " 3A", " 3B", " 3C", " 3D", " 3E", " 3F", " 40", " 41", " 42", " 43", " 44", " 45", " 46", " 47", " 48", " 49", " 4A", " 4B", " 4C", " 4D", " 4E", " 4F", " 50", " 51", " 52", " 53", " 54", " 55", " 56", " 57", " 58", " 59", " 5A", " 5B", " 5C", " 5D", " 5E", " 5F", " 60", " 61", " 62", " 63", " 64", " 65", " 66", " 67", " 68", " 69", " 6A", " 6B", " 6C", " 6D", " 6E", " 6F", " 70", " 71", " 72", " 73", " 74", " 75", " 76", " 77", " 78", " 79", " 7A", " 7B", " 7C", " 7D", " 7E", " 7F", " 80", " 81", " 82", " 83", " 84", " 85", " 86", " 87", " 88", " 89", " 8A", " 8B", " 8C", " 8D", " 8E", " 8F", " 90", " 91", " 92", " 93", " 94", " 95", " 96", " 97", " 98", " 99", " 9A", " 9B", " 9C", " 9D", " 9E", " 9F", " A0", " A1", " A2", " A3", " A4", " A5", " A6", " A7", " A8", " A9", " AA", " AB", " AC", " AD", " AE", " AF", " B0", " B1", " B2", " B3", " B4", " B5", " B6", " B7", " B8", " B9", " BA", " BB", " BC", " BD", " BE", " BF", " C0", " C1", " C2", " C3", " C4", " C5", " C6", " C7", " C8", " C9", " CA", " CB", " CC", " CD", " CE", " CF", " D0", " D1", " D2", " D3", " D4", " D5", " D6", " D7", " D8", " D9", " DA", " DB", " DC", " DD", " DE", " DF", " E0", " E1", " E2", " E3", " E4", " E5", " E6", " E7", " E8", " E9", " EA", " EB", " EC", " ED", " EE", " EF", " F0", " F1", " F2", " F3", " F4", " F5", " F6", " F7", " F8", " F9", " FA", " FB", " FC", " FD", " FE", " FF"};
        toChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    }
}

