/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.schema.options;

import java.util.EnumMap;
import java.util.Map;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectNamesType;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptions;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.text.options.BaseTextOptionsBuilder;

public abstract class BaseSchemaTextOptionsBuilder<B extends BaseSchemaTextOptionsBuilder<B, O>, O extends SchemaTextOptions>
extends BaseTextOptionsBuilder<BaseSchemaTextOptionsBuilder<B, O>, O> {
    private static final String SHOW_ORDINAL_NUMBERS = "schemacrawler.format.show_ordinal_numbers";
    private static final String SHOW_STANDARD_COLUMN_TYPE_NAMES = "schemacrawler.format.show_standard_column_type_names";
    private static final String HIDE_TABLE_ROW_COUNTS = "schemacrawler.format.hide_table_row_counts";
    private static final String HIDE_REMARKS = "schemacrawler.format.hide_remarks";
    private static final String SC_SORT_ALPHABETICALLY_TABLE_INDEXES = "schemacrawler.format.sort_alphabetically.table_indexes";
    private static final String SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS = "schemacrawler.format.sort_alphabetically.table_foreignkeys";
    protected boolean isAlphabeticalSortForForeignKeys;
    protected boolean isAlphabeticalSortForIndexes;
    protected boolean isHideRemarks;
    protected boolean isShowOrdinalNumbers;
    protected boolean isShowStandardColumnTypeNames;
    protected boolean isHideTableRowCounts;
    protected final Map<HideDatabaseObjectNamesType, Boolean> hideNames = new EnumMap<HideDatabaseObjectNamesType, Boolean>(HideDatabaseObjectNamesType.class);

    @Override
    public B fromConfig(Config config) {
        if (config == null) {
            return (B)this;
        }
        super.fromConfig(config);
        this.isShowStandardColumnTypeNames = config.getBooleanValue(SHOW_STANDARD_COLUMN_TYPE_NAMES);
        this.isShowOrdinalNumbers = config.getBooleanValue(SHOW_ORDINAL_NUMBERS);
        this.isHideTableRowCounts = config.getBooleanValue(HIDE_TABLE_ROW_COUNTS);
        this.isHideRemarks = config.getBooleanValue(HIDE_REMARKS);
        this.isAlphabeticalSortForForeignKeys = config.getBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS);
        this.isAlphabeticalSortForIndexes = config.getBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_INDEXES);
        for (HideDatabaseObjectNamesType databaseObjectNamesType : HideDatabaseObjectNamesType.values()) {
            boolean booleanValue = config.getBooleanValue(databaseObjectNamesType.getKey());
            this.hideNames.put(databaseObjectNamesType, booleanValue);
        }
        this.fromConfigCommandLineOverride(config);
        return (B)this;
    }

    @Override
    public B fromOptions(O options) {
        if (options == null) {
            return (B)this;
        }
        super.fromOptions(options);
        this.isShowStandardColumnTypeNames = ((SchemaTextOptions)options).isShowStandardColumnTypeNames();
        this.isShowOrdinalNumbers = ((SchemaTextOptions)options).isShowOrdinalNumbers();
        this.isHideTableRowCounts = ((SchemaTextOptions)options).isHideTableRowCounts();
        this.isHideRemarks = ((SchemaTextOptions)options).isHideRemarks();
        this.isAlphabeticalSortForForeignKeys = ((SchemaTextOptions)options).isAlphabeticalSortForForeignKeys();
        this.isAlphabeticalSortForIndexes = ((SchemaTextOptions)options).isAlphabeticalSortForIndexes();
        for (HideDatabaseObjectNamesType databaseObjectNamesType : HideDatabaseObjectNamesType.values()) {
            this.hideNames.put(databaseObjectNamesType, ((SchemaTextOptions)options).get(databaseObjectNamesType));
        }
        return (B)this;
    }

    public final B hideRowCounts() {
        return this.hideRowCounts(true);
    }

    public final B hideRowCounts(boolean value) {
        this.isHideTableRowCounts = value;
        return (B)this;
    }

    public final B noAlternateKeyNames() {
        return this.noAlternateKeyNames(true);
    }

    public final B noAlternateKeyNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideAlternateKeyNames, value);
        return (B)this;
    }

    public final B noConstraintNames() {
        return this.noConstraintNames(true);
    }

    public final B noConstraintNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideTableConstraintNames, value);
        return (B)this;
    }

    public final B noForeignKeyNames() {
        return this.noForeignKeyNames(true);
    }

    public final B noForeignKeyNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideForeignKeyNames, value);
        return (B)this;
    }

    public final B noIndexNames() {
        return this.noIndexNames(true);
    }

    public final B noIndexNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideIndexNames, value);
        return (B)this;
    }

    public final B noPrimaryKeyNames() {
        return this.noPrimaryKeyNames(true);
    }

    public final B noPrimaryKeyNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hidePrimaryKeyNames, value);
        return (B)this;
    }

    public final B noRemarks() {
        return this.noRemarks(true);
    }

    public final B noRemarks(boolean value) {
        this.isHideRemarks = value;
        return (B)this;
    }

    public final B noRoutineSpecificNames() {
        return this.noRoutineSpecificNames(true);
    }

    public final B noRoutineSpecificNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideRoutineSpecificNames, value);
        return (B)this;
    }

    public final B noTriggerNames() {
        return this.noTriggerNames(true);
    }

    public final B noTriggerNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideTriggerNames, value);
        return (B)this;
    }

    public final B noWeakAssociationNames() {
        return this.noWeakAssociationNames(true);
    }

    public final B noWeakAssociationNames(boolean value) {
        this.hideNames.put(HideDatabaseObjectNamesType.hideWeakAssociationNames, value);
        return (B)this;
    }

    public final B portableNames() {
        return this.portableNames(true);
    }

    public final B portableNames(boolean value) {
        for (HideDatabaseObjectNamesType databaseObjectNamesType : HideDatabaseObjectNamesType.values()) {
            this.hideNames.put(databaseObjectNamesType, value);
        }
        this.isShowUnqualifiedNames = value;
        return (B)this;
    }

    public final B showOrdinalNumbers() {
        return this.showOrdinalNumbers(true);
    }

    public final B showOrdinalNumbers(boolean value) {
        this.isShowOrdinalNumbers = value;
        return (B)this;
    }

    public final B showStandardColumnTypeNames() {
        return this.showStandardColumnTypeNames(true);
    }

    public final B showStandardColumnTypeNames(boolean value) {
        this.isShowStandardColumnTypeNames = value;
        return (B)this;
    }

    public final B sortForeignKeys() {
        return this.sortForeignKeys(true);
    }

    public final B sortForeignKeys(boolean value) {
        this.isAlphabeticalSortForForeignKeys = value;
        return (B)this;
    }

    public final B sortIndexes() {
        return this.sortIndexes(true);
    }

    public final B sortIndexes(boolean value) {
        this.isAlphabeticalSortForIndexes = value;
        return (B)this;
    }

    @Override
    public Config toConfig() {
        Config config = super.toConfig();
        config.put(SHOW_STANDARD_COLUMN_TYPE_NAMES, (Object)this.isShowStandardColumnTypeNames);
        config.put(SHOW_ORDINAL_NUMBERS, (Object)this.isShowOrdinalNumbers);
        config.put(HIDE_TABLE_ROW_COUNTS, (Object)this.isHideTableRowCounts);
        config.put(HIDE_REMARKS, (Object)this.isHideRemarks);
        config.put(SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS, (Object)this.isAlphabeticalSortForForeignKeys);
        config.put(SC_SORT_ALPHABETICALLY_TABLE_INDEXES, (Object)this.isAlphabeticalSortForIndexes);
        for (HideDatabaseObjectNamesType databaseObjectNamesType : HideDatabaseObjectNamesType.values()) {
            config.put(databaseObjectNamesType.getKey(), (Object)this.hideNames.getOrDefault((Object)databaseObjectNamesType, false));
        }
        return config;
    }

    private void fromConfigCommandLineOverride(Config config) {
        String noremarksKey = "no-remarks";
        if (config.containsKey("no-remarks")) {
            this.noRemarks(config.getBooleanValue("no-remarks"));
        }
        String portablenamesKey = "portable-names";
        if (config.containsKey("portable-names")) {
            this.portableNames(config.getBooleanValue("portable-names"));
        }
    }
}

