/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.doc.html;

import scala.Array;
import scala.Array$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.tools.nsc.doc.html.HtmlTags;
import scala.tools.nsc.doc.html.HtmlTags$;

public final class SyntaxHigh$ {
    public static final SyntaxHigh$ MODULE$ = new SyntaxHigh$();
    private static final String[] reserved = (String[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps(new String[]{"abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "true", "try", "type", "val", "var", "while", "with", "yield"}), Ordering.String$.MODULE$);
    private static final String[] annotations = (String[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps(new String[]{"BeanProperty", "BooleanBeanProperty", "SerialVersionUID", "beanGetter", "beanSetter", "companionClass", "companionMethod", "companionObject", "compileTimeOnly", "deprecated", "deprecatedName", "deprecatedOverriding", "deprecatedInheritance", "elidable", "field", "getter", "implicitAmbiguous", "implicitNotFound", "inline", "languageFeature", "migration", "native", "noinline", "param", "setter", "showAsInfix", "specialized", "strictfp", "switch", "tailrec", "throws", "transient", "unchecked", "uncheckedStable", "uncheckedVariance", "unspecialized", "varargs", "volatile"}), Ordering.String$.MODULE$);
    private static final String[] standards = (String[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps(new String[]{"Any", "AnyRef", "AnyVal", "App", "Array", "Boolean", "Byte", "Char", "Class", "ClassManifest", "ClassTag", "Console", "Double", "Enumeration", "Float", "Function", "Int", "List", "Long", "Manifest", "Map", "NoManifest", "None", "Nothing", "Null", "Object", "Option", "OptManifest", "Predef", "Seq", "Set", "Short", "Some", "String", "Symbol", "TypeTag", "Unit", "WeakTypeTag"}), Ordering.String$.MODULE$);

    public String[] reserved() {
        return reserved;
    }

    public String[] annotations() {
        return annotations;
    }

    public String[] standards() {
        return standards;
    }

    public List<HtmlTags.Elem> apply(String data) {
        char[] buf = data.toCharArray();
        StringBuilder out = new StringBuilder();
        this.parse$1("", 0, out, buf);
        HtmlTags.Raw raw = new HtmlTags.Raw(out.toString());
        return HtmlTags$.MODULE$.NoElems().$colon$colon(raw);
    }

    private static final int compare$1(int offset, String key, char[] buf$1) {
        int j;
        int i = offset;
        int l = key.length();
        for (j = 0; i < buf$1.length && j < l; ++i, ++j) {
            char bch = buf$1[i];
            char kch = key.charAt(j);
            if (bch < kch) {
                return -1;
            }
            if (bch <= kch) continue;
            return 1;
        }
        return j < l ? -1 : (i < buf$1.length && ('A' <= buf$1[i] && buf$1[i] <= 'Z' || 'a' <= buf$1[i] && buf$1[i] <= 'z' || '0' <= buf$1[i] && buf$1[i] <= '9' || buf$1[i] == '_') ? 1 : 0);
    }

    private static final int lookup$1(String[] a, int i, char[] buf$1) {
        int lo = 0;
        int hi = a.length - 1;
        while (lo <= hi) {
            int m = (hi + lo) / 2;
            int d = SyntaxHigh$.compare$1(i, a[m], buf$1);
            if (d < 0) {
                hi = m - 1;
                continue;
            }
            if (d > 0) {
                lo = m + 1;
                continue;
            }
            return m;
        }
        return -1;
    }

    private final int line$1(int i, char[] buf$1, StringBuilder out$1) {
        while (i != buf$1.length && buf$1[i] != '\n') {
            out$1.append(buf$1[i]);
            ++i;
        }
        return i;
    }

    private final int multiline$1(int i, boolean star, char[] buf$1, StringBuilder out$1, IntRef level$1) {
        block4: while (true) {
            if (i == buf$1.length) {
                return i;
            }
            char ch = buf$1[i];
            out$1.append(ch);
            char c = ch;
            switch (c) {
                case '*': {
                    if (star) {
                        ++level$1.elem;
                    }
                    star = !star;
                    ++i;
                    continue block4;
                }
                case '/': {
                    if (star) {
                        if (level$1.elem > 0) {
                            --level$1.elem;
                        }
                        if (level$1.elem == 0) break block4;
                        star = true;
                        ++i;
                        continue block4;
                    }
                    star = false;
                    ++i;
                    continue block4;
                }
                default: {
                    star = false;
                    ++i;
                    continue block4;
                }
            }
            break;
        }
        return i;
    }

    private final String comment$1(int i, char[] buf$1) {
        StringBuilder out = new StringBuilder("/");
        IntRef level = IntRef.create(0);
        int n = buf$1[i] == '/' ? this.line$1(i, buf$1, out) : this.multiline$1(i, true, buf$1, out, level);
        return out.toString();
    }

    private final int charlit0$1(int i, boolean bslash, char[] buf$1, int j$1, StringBuilder out$2) {
        int n;
        block4: while (true) {
            if (i == buf$1.length) {
                n = i;
                break;
            }
            if (i > j$1 + 6) {
                out$2.setLength(0);
                n = j$1;
                break;
            }
            char ch = buf$1[i];
            out$2.append(ch);
            char c = ch;
            switch (c) {
                case '\\': {
                    bslash = true;
                    ++i;
                    continue block4;
                }
                case '\'': {
                    if (!bslash) {
                        n = i;
                        break block4;
                    }
                }
                default: {
                    if (bslash && '0' <= ch && ch <= '9') {
                        bslash = true;
                        ++i;
                        continue block4;
                    }
                    bslash = false;
                    ++i;
                    continue block4;
                }
            }
            break;
        }
        return n;
    }

    private final String charlit$1(int j, char[] buf$1) {
        StringBuilder out = new StringBuilder("'");
        this.charlit0$1(j, false, buf$1, j, out);
        return out.toString();
    }

    private final void rawstrlit0$1(int i, boolean bslash, char[] buf$1, StringBuilder out$3) {
        block4: while (true) {
            if (i == buf$1.length) {
                return;
            }
            char ch = buf$1[i];
            out$3.append(ch);
            char c = ch;
            switch (c) {
                case '\\': {
                    bslash = true;
                    ++i;
                    continue block4;
                }
                case '\"': {
                    if (!bslash) {
                        String string = ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.charArrayOps(buf$1), i + 1, i + 3).toString();
                        String string2 = "\"\"";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            out$3.append("\"\"");
                            break block4;
                        }
                    }
                }
                default: {
                    bslash = false;
                    ++i;
                    continue block4;
                }
            }
            break;
        }
    }

    private final void strlit0$1(int i, boolean bslash, char[] buf$1, StringBuilder out$3) {
        block4: while (true) {
            if (i == buf$1.length) {
                return;
            }
            char ch = buf$1[i];
            out$3.append(ch);
            char c = ch;
            switch (c) {
                case '\\': {
                    bslash = true;
                    ++i;
                    continue block4;
                }
                case '\"': {
                    if (!bslash) break block4;
                }
                default: {
                    bslash = false;
                    ++i;
                    continue block4;
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String strlit$1(int i, char[] buf$1) {
        Object object;
        StringBuilder out = new StringBuilder();
        char[] cArray = (char[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.charArrayOps(buf$1), i, i + 3);
        if (cArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(cArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) == 0) {
            char c = BoxesRunTime.unboxToChar(Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
            char c2 = BoxesRunTime.unboxToChar(Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
            char c3 = BoxesRunTime.unboxToChar(Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
            if ('\"' == c && '\"' == c2 && '\"' == c3) {
                out.append("\"\"\"");
                this.rawstrlit0$1(i + 3, false, buf$1, out);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return out.toString();
            }
        }
        out.append("\"");
        this.strlit0$1(i + 1, false, buf$1, out);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return out.toString();
    }

    private final int intg$1(int i, char[] buf$1, StringBuilder out$4) {
        int n;
        block3: while (true) {
            char ch;
            if (i == buf$1.length) {
                return i;
            }
            char c = ch = buf$1[i];
            switch (c) {
                case '.': {
                    out$4.append(ch);
                    n = this.frac$1(i + 1, buf$1, out$4);
                    break block3;
                }
                default: {
                    if (Character.isDigit(ch)) {
                        out$4.append(ch);
                        ++i;
                        continue block3;
                    }
                    n = i;
                    break block3;
                }
            }
            break;
        }
        return n;
    }

    private final int frac$1(int i, char[] buf$1, StringBuilder out$4) {
        int n;
        block3: while (true) {
            char ch;
            if (i == buf$1.length) {
                return i;
            }
            char c = ch = buf$1[i];
            switch (c) {
                case 'E': 
                case 'e': {
                    out$4.append(ch);
                    n = this.expo$1(i + 1, false, buf$1, out$4);
                    break block3;
                }
                default: {
                    if (Character.isDigit(ch)) {
                        out$4.append(ch);
                        ++i;
                        continue block3;
                    }
                    n = i;
                    break block3;
                }
            }
            break;
        }
        return n;
    }

    private final int expo$1(int i, boolean signed, char[] buf$1, StringBuilder out$4) {
        block3: while (true) {
            char ch;
            if (i == buf$1.length) {
                return i;
            }
            char c = ch = buf$1[i];
            switch (c) {
                case '+': 
                case '-': {
                    if (signed) break;
                    out$4.append(ch);
                    signed = true;
                    ++i;
                    continue block3;
                }
            }
            if (!Character.isDigit(ch)) break;
            out$4.append(ch);
            ++i;
        }
        return i;
    }

    private final String numlit$1(int i, char[] buf$1) {
        StringBuilder out = new StringBuilder();
        this.intg$1(i, buf$1, out);
        return out.toString();
    }

    private final String loop$1(int i, int len$1, char[] array$1, java.lang.StringBuilder buf$2) {
        while (i < len$1) {
            char c = array$1[i];
            switch (c) {
                case '<': {
                    java.lang.StringBuilder stringBuilder = buf$2.append("&lt;");
                    break;
                }
                case '>': {
                    java.lang.StringBuilder stringBuilder = buf$2.append("&gt;");
                    break;
                }
                default: {
                    java.lang.StringBuilder stringBuilder = buf$2.append(c);
                    break;
                }
            }
            ++i;
        }
        return buf$2.toString();
    }

    private final String escape$1(String str) {
        char[] array = str.toCharArray();
        int len = array.length;
        java.lang.StringBuilder buf = new java.lang.StringBuilder(len);
        return this.loop$1(0, len, array, buf);
    }

    private final void parse$1(String pre, int i, StringBuilder out$5, char[] buf$1) {
        block12: while (true) {
            out$5.append(pre);
            if (i == buf$1.length) {
                return;
            }
            char c = buf$1[i];
            switch (c) {
                case '\n': {
                    ++i;
                    pre = "\n";
                    continue block12;
                }
                case ' ': {
                    ++i;
                    pre = " ";
                    continue block12;
                }
                case '&': {
                    ++i;
                    pre = "&amp;";
                    continue block12;
                }
                case '<': {
                    if (i + 1 >= buf$1.length) break;
                    char ch = buf$1[i + 1];
                    if (ch == '-' || ch == ':' || ch == '%') {
                        i += 2;
                        pre = new java.lang.StringBuilder(28).append("<span class=\"kw\">&lt;").append(ch).append("</span>").toString();
                        continue block12;
                    }
                    ++i;
                    pre = "&lt;";
                    continue block12;
                }
                case '>': {
                    if (i + 1 < buf$1.length && buf$1[i + 1] == ':') {
                        i += 2;
                        pre = "<span class=\"kw\">&gt;:</span>";
                        continue block12;
                    }
                    ++i;
                    pre = "&gt;";
                    continue block12;
                }
                case '=': {
                    if (i + 1 < buf$1.length && buf$1[i + 1] == '>') {
                        i += 2;
                        pre = "<span class=\"kw\">=&gt;</span>";
                        continue block12;
                    }
                    String string = Character.toString(buf$1[i]);
                    ++i;
                    pre = string;
                    continue block12;
                }
                case '/': {
                    if (i + 1 < buf$1.length && (buf$1[i + 1] == '/' || buf$1[i + 1] == '*')) {
                        String c2 = this.comment$1(i + 1, buf$1);
                        String escaped = this.escape$1(c2);
                        i += c2.length();
                        pre = new java.lang.StringBuilder(25).append("<span class=\"cmt\">").append(escaped).append("</span>").toString();
                        continue block12;
                    }
                    String string = Character.toString(buf$1[i]);
                    ++i;
                    pre = string;
                    continue block12;
                }
                case '\'': {
                    String s = this.charlit$1(i + 1, buf$1);
                    if (s.length() > 0) {
                        i += s.length();
                        pre = new java.lang.StringBuilder(25).append("<span class=\"lit\">").append(s).append("</span>").toString();
                        continue block12;
                    }
                    String string = Character.toString(buf$1[i]);
                    ++i;
                    pre = string;
                    continue block12;
                }
                case '\"': {
                    String s = this.strlit$1(i, buf$1);
                    String escaped = this.escape$1(s);
                    i += s.length();
                    pre = new java.lang.StringBuilder(25).append("<span class=\"lit\">").append(escaped).append("</span>").toString();
                    continue block12;
                }
                case '@': {
                    int k = SyntaxHigh$.lookup$1(this.annotations(), i + 1, buf$1);
                    if (k >= 0) {
                        i = i + this.annotations()[k].length() + 1;
                        pre = new java.lang.StringBuilder(26).append("<span class=\"ano\">@").append(this.annotations()[k]).append("</span>").toString();
                        continue block12;
                    }
                    String string = Character.toString(buf$1[i]);
                    ++i;
                    pre = string;
                    continue block12;
                }
            }
            if (i == 0 || i >= 1 && !Character.isJavaIdentifierPart(buf$1[i - 1])) {
                if (Character.isDigit((int)buf$1[i]) || buf$1[i] == '.' && i + 1 < buf$1.length && Character.isDigit((int)buf$1[i + 1])) {
                    String s = this.numlit$1(i, buf$1);
                    i += s.length();
                    pre = new java.lang.StringBuilder(25).append("<span class=\"num\">").append(s).append("</span>").toString();
                    continue;
                }
                int k = SyntaxHigh$.lookup$1(this.reserved(), i, buf$1);
                if (k >= 0) {
                    i += this.reserved()[k].length();
                    pre = new java.lang.StringBuilder(24).append("<span class=\"kw\">").append(this.reserved()[k]).append("</span>").toString();
                    continue;
                }
                int k2 = SyntaxHigh$.lookup$1(this.standards(), i, buf$1);
                if (k2 >= 0) {
                    i += this.standards()[k2].length();
                    pre = new java.lang.StringBuilder(25).append("<span class=\"std\">").append(this.standards()[k2]).append("</span>").toString();
                    continue;
                }
                String string = Character.toString(buf$1[i]);
                ++i;
                pre = string;
                continue;
            }
            String string = Character.toString(buf$1[i]);
            ++i;
            pre = string;
        }
    }

    private SyntaxHigh$() {
    }
}

