/*
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./SelectionPlugin',"../utils/TableUtils",'../library'],function(S,T,l){"use strict";var a=l.SelectionMode;var B=S.extend("sap.ui.table.plugins.BindingSelection",{metadata:{library:"sap.ui.table",events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});B.prototype.onDeactivate=function(t){S.prototype.onDeactivate.apply(this,arguments);d(this,this.getTableBinding());};B.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:T.hasSelectAll(this.getTable())}};};B.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){this.getTable()._toggleSelectAll();}};B.prototype.onKeyboardShortcut=function(t){if(t==="toggle"){this.getTable()._toggleSelectAll();}else if(t==="clear"){this.clearSelection();}};B.prototype.addSelectionInterval=function(i,I){if(this._getSelectionMode()===a.None){return;}var o=this.getTableBinding();if(o&&o.addSelectionInterval){if(this._getSelectionMode()===a.Single){i=I;o.setSelectionInterval(i,I);}o.addSelectionInterval(i,I);}};B.prototype.clearSelection=function(){var o=this.getTableBinding();if(o&&o.clearSelection){o.clearSelection();}};B.prototype.getSelectedIndex=function(){var o=this.getTableBinding();if(o&&o.findNode){return o.getSelectedIndex();}else{return-1;}};B.prototype.getSelectedIndices=function(){var o=this.getTableBinding();if(this._getSelectionMode()===a.Single){var s=this.getSelectedIndex();if(s===-1){return[];}return[s];}if(o&&o.findNode&&o.getSelectedIndices){return o.getSelectedIndices();}else{return[];}};B.prototype.getSelectableCount=function(){var o=this.getTableBinding();if(!o){return 0;}else if(o.getGrandTotalContextInfo){var r=o.getGrandTotalContextInfo();return r?r.totalNumberOfLeafs:0;}else{return o.getLength();}};B.prototype.getSelectedCount=function(){var o=this.getTableBinding();if(o&&o.getSelectedNodesCount){return o.getSelectedNodesCount();}else{return 0;}};B.prototype.isIndexSelectable=function(i){var o=this.getTableBinding();if(o){return o.isIndexSelectable(i);}else{return false;}};B.prototype.isIndexSelected=function(i){var o=this.getTableBinding();if(this._getSelectionMode()===a.Single){if(i<0){return false;}return i===this.getSelectedIndex();}if(o&&o.isIndexSelected){return o.isIndexSelected(i);}else{return false;}};B.prototype.removeSelectionInterval=function(i,I){var o=this.getTableBinding();if(o&&o.findNode&&o.removeSelectionInterval){o.removeSelectionInterval(i,I);}};B.prototype.selectAll=function(){if(this._getSelectionMode()===a.None){return;}var o=this.getTableBinding();if(o&&o.selectAll){o.selectAll();}};B.prototype.setSelectedIndex=function(i){if(this._getSelectionMode()===a.None){return;}if(i===-1){this.clearSelection();}else{var o=this.getTableBinding();if(o&&o.setSelectedIndex){o.setSelectedIndex(i);}}};B.prototype.setSelectionInterval=function(i,I){if(this._getSelectionMode()===a.None){return;}var o=this.getTableBinding();if(o&&o.setSelectionInterval){if(this._getSelectionMode()===a.Single){i=I;}o.setSelectionInterval(i,I);}};B.prototype.setSelectionMode=function(s){var o=this._getSelectionMode();S.prototype._setSelectionMode.apply(this,arguments);if(this._getSelectionMode()!==o){this.clearSelection();}return this;};B.prototype._getHighestSelectableIndex=function(){var o=this.getTableBinding();return o?o.getLength()-1:-1;};B.prototype.onTableRowsBound=function(o){S.prototype.onTableRowsBound.apply(this,arguments);b(this,o);};function b(p,o){if(o){o.attachChange(p._onBindingChange,p);o.attachSelectionChanged(p._onSelectionChange,p);}}function d(p,o){if(o){o.detachChange(p._onBindingChange,p);o.detachSelectionChanged(p._onSelectionChange,p);}}B.prototype._onBindingChange=function(e){var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r==="sort"||r==="filter"){this.clearSelection();}};B.prototype._onSelectionChange=function(e){var r=e.getParameter("rowIndices");var s=e.getParameter("selectAll");this.fireSelectionChange({rowIndices:r,selectAll:s});};return B;});
