/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Utils","sap/ui/thirdparty/jquery","sap/ui/fl/registry/ChangeRegistryItem","sap/ui/fl/registry/ChangeTypeMetadata","sap/ui/fl/registry/Settings","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/AddXML","sap/ui/fl/changeHandler/AddXMLAtExtensionPoint","sap/ui/fl/requireAsync","sap/base/Log"],function(U,q,C,a,S,H,M,b,P,c,d,e,f,A,g,r,L){"use strict";var h=function(){this._registeredItems={};this.initSettings();this.initDeveloperModeChangeHandlers();};h._instance=undefined;h.prototype._oDefaultActiveChangeHandlers={};h.prototype._oDefaultChangeHandlers={hideControl:H,moveElements:M,moveControls:b,unhideControl:d,stashControl:e,unstashControl:f};h.prototype._mDeveloperModeChangeHandlers={propertyChange:{changeHandler:P},propertyBindingChange:{changeHandler:c},addXML:{changeHandler:A},addXMLAtExtensionPoint:{changeHandler:g}};h.prototype.initDeveloperModeChangeHandlers=function(){Object.keys(this._mDeveloperModeChangeHandlers).forEach(function(s){var o=this._mDeveloperModeChangeHandlers[s].changeHandler;var l=this._oSettings.getDeveloperModeLayerPermissions();var i={changeType:s,changeHandler:o,layers:l};var j=this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls",i);this._oDefaultActiveChangeHandlers[s]=j;}.bind(this));};h.getInstance=function(){if(!h._instance){h._instance=new h();}return h._instance;};h.prototype.hasRegisteredChangeHandlersForControl=function(s){var i=Object.keys(this._registeredItems);return i.indexOf(s)!==-1;};h.prototype.hasChangeHandlerForControlAndChange=function(s,i){if(!this.hasRegisteredChangeHandlersForControl(s)){return false;}var R=this._registeredItems[s];var j=Object.keys(R);return j.indexOf(i)!==-1;};h.prototype.registerControlsForChanges=function(m){var p=[];q.each(m,function(s,v){var i={};if(Array.isArray(v)){v.forEach(function(o){i[o.changeType]=o.changeHandler;});}else{i=v;}p.push(this._registerChangeHandlersForControl(s,i));}.bind(this));return Promise.all(p);};h.prototype._registerChangeHandlersForControl=function(s,o){var p=Promise.resolve(o);var i="ChangeRegistry._registerChangeHandlersForControl.skip_next_then";if(typeof o==="string"){p=r(o+".flexibility").catch(function(E){L.error("Flexibility change handler registration failed.\nControlType: "+s+"\n"+E.message);return Promise.resolve(i);});}return p.then(function(R){if(R!==i){q.each(R,function(j,k){var l=this._getChangeHandlerEntry(j,k);var m={changeType:j,changeHandler:l.changeHandler,layers:l.layers};this.registerControlForSimpleChange(s,m);}.bind(this));}}.bind(this));};h.prototype._getInstanceSpecificChangeRegistryItem=function(s,o,m){var i=m&&m.getChangeHandlerModulePath(o);if(typeof i!=="string"){return new U.FakePromise(undefined);}return r(i).then(function(j){var v=j[s];if(!v){return undefined;}var k=this._getChangeHandlerEntry(s,v);var l={changeType:s,changeHandler:k.changeHandler,layers:k.layers};var n=m.getControlType(o);var p=this._createChangeRegistryItemForSimpleChange(n,l);return p;}.bind(this)).catch(function(E){L.error("Flexibility registration for control "+m.getId(o)+" failed to load module "+i+"\n"+E.message);return undefined;});};h.prototype._getChangeHandlerEntry=function(s,v){var R={};var D=Object.keys(this._mDeveloperModeChangeHandlers);if(!v||!v.changeHandler){R.changeHandler=v;}else{R=v;}if(R.changeHandler==="default"){R.changeHandler=this._oDefaultChangeHandlers[s];}else if(D.indexOf(s)>-1){throw Error("You can't use a custom change handler for the following Developer Mode change types: "+D.toString()+". Please use 'default' instead.");}return R;};h.prototype.getChangeHandler=function(s,i,o,m,l){return this._getInstanceSpecificChangeRegistryItem(s,o,m).then(function(j){var k=j||this._getRegistryItem(i,s);if(!k){throw Error("No Change handler registered for the Control and Change type");}if(!this._isRegistryItemValidForLayer(k,l)){throw Error("Change type "+s+" not enabled for layer "+l);}return k.getChangeTypeMetadata().getChangeHandler();}.bind(this));};h.prototype.registerControlForSimpleChange=function(s,o){var i;if(!s){return;}if(!o||!o.changeType||!o.changeHandler){return;}i=this._createChangeRegistryItemForSimpleChange(s,o);if(i){this.addRegistryItem(i);}};h.prototype._createChangeRegistryItemForSimpleChange=function(s,o){var p;var i;var j;var l;l=Object.assign({},this._oSettings.getDefaultLayerPermissions());var k=o.layers;if(k){Object.keys(k).forEach(function(m){if(l[m]===undefined){throw Error("The Layer '"+m+"' is not supported. Please only use supported layers");}l[m]=k[m];});}p={name:o.changeType,changeHandler:o.changeHandler,layers:l};i=new a(p);p={changeTypeMetadata:i,controlType:s};j=new C(p);return j;};h.prototype.addRegistryItem=function(R){var s;var i;if(!R){return;}s=R.getChangeTypeName();i=R.getControlType();this._registeredItems[i]=this._registeredItems[i]||{};this._registeredItems[i][s]=R;};h.prototype.removeRegistryItem=function(p){if(!p.changeTypeName&&!p.controlType){L.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");return;}if(p.controlType&&p.changeTypeName){if(this._registeredItems[p.controlType]){if(Object.keys(this._registeredItems[p.controlType]).length===1){delete this._registeredItems[p.controlType];}else{delete this._registeredItems[p.controlType][p.changeTypeName];}}}else if(p.controlType){if(this._registeredItems[p.controlType]){delete this._registeredItems[p.controlType];}}else if(p.changeTypeName){for(var i in this._registeredItems){var j=this._registeredItems[i];delete j[p.changeTypeName];}}};h.prototype._getRegistryItem=function(s,i){var o=this._registeredItems[s];if(o){var j=o[i];if(j){return j;}}var D=this._oDefaultActiveChangeHandlers[i];if(D){return D;}};h.prototype.initSettings=function(){this._oSettings=S.getInstanceOrUndef();if(!this._oSettings){this._oSettings=new S({});}};h.prototype._isRegistryItemValidForLayer=function(R,l){var o=R.getChangeTypeMetadata().getLayers();return!!o[l];};h.prototype.getDragInfo=function(s){var i=this._registeredItems[s];if(i){return i.getDragInfo();}return null;};return h;},true);
