/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/Device','sap/m/HeaderContainerItemNavigator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/library','sap/ui/core/IntervalTrigger','sap/ui/base/ManagedObject','sap/ui/core/Icon','./HeaderContainerRenderer',"sap/base/Log","sap/ui/events/PseudoEvents","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/Selectors"],function(l,C,a,D,H,I,c,b,M,d,e,L,P,q){"use strict";var O=c.Orientation;var f=a.extend("sap.m.HeaderContainerItemContainer",{metadata:{defaultAggregation:"item",properties:{position:{type:"int",defaultValue:null},setSize:{type:"int",defaultValue:null},ariaLabelledBy:{type:"string",defaultValue:null}},aggregations:{item:{type:"sap.ui.core.Control",multiple:false}}},renderer:function(r,o){var i=o.getAggregation("item");if(!i||!i.getVisible()){return;}r.write("<div");r.writeControlData(o);r.addClass("sapMHdrCntrItemCntr");r.addClass("sapMHrdrCntrInner");r.writeAttribute("aria-setsize",o.getSetSize());r.writeAttribute("aria-posinset",o.getPosition());r.writeAttribute("role","listitem");if(o.getAriaLabelledBy()){r.writeAttributeEscaped("aria-labelledby",o.getAriaLabelledBy());}r.writeClasses();r.write(">");r.renderControl(i);r.write("</div>");}});var g=a.extend("sap.m.HeaderContainer",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{scrollStep:{type:"int",defaultValue:300,group:"Behavior"},scrollStepByItem:{type:"int",defaultValue:1,group:"Behavior"},scrollTime:{type:"int",defaultValue:500,group:"Behavior"},showOverflowItem:{type:"boolean",defaultValue:true,group:"Behavior"},showDividers:{type:"boolean",defaultValue:true,group:"Appearance"},orientation:{type:"sap.ui.core.Orientation",defaultValue:O.Horizontal,group:"Appearance"},backgroundDesign:{type:"sap.m.BackgroundDesign",defaultValue:l.BackgroundDesign.Transparent,group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_scrollContainer:{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"},_prevButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});g.prototype.init=function(){this._aItemEnd=[];this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oScrollCntr=new l.ScrollContainer(this.getId()+"-scrl-cntnr",{width:"100%",height:"100%",horizontal:!D.system.desktop});this.setAggregation("_scrollContainer",this._oScrollCntr,true);if(D.system.desktop){this._oArrowPrev=new l.Button({id:this.getId()+"-scrl-prev-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_PREV_SECTION"),press:function(E){E.cancelBubble();this._scroll(this._getScrollValue(false),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this._oArrowPrev._bExcludeFromTabChain=true;this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new l.Button({id:this.getId()+"-scrl-next-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_NEXT_SECTION"),press:function(E){E.cancelBubble();this._scroll(this._getScrollValue(true),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this._oArrowNext._bExcludeFromTabChain=true;this.setAggregation("_nextButton",this._oArrowNext,true);}else if(D.system.phone||D.system.tablet){this._oArrowPrev=new d({id:this.getId()+"-scrl-prev-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new d({id:this.getId()+"-scrl-next-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this.setAggregation("_nextButton",this._oArrowNext,true);}this._oScrollCntr.addDelegate({onAfterRendering:function(){if(D.system.desktop){var F=this._oScrollCntr.getDomRef("scroll");var o=this._oScrollCntr.$("scroll");var h=o.find(".sapMHrdrCntrInner").attr("tabindex","0");if(!this._oItemNavigation){this._oItemNavigation=new H();this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleAfterFocus,this);this._oItemNavigation.attachEvent(I.Events.BeforeFocus,this._handleBeforeFocus,this);if(D.browser.msie||D.browser.edge){this._oItemNavigation.attachEvent(I.Events.FocusAgain,this._handleFocusAgain,this);}}this._oItemNavigation.setRootDomRef(F);this._oItemNavigation.setItemDomRefs(h);this._oItemNavigation.setTabIndex0();this._oItemNavigation.setCycling(false);this._handleMobileScrolling();}}.bind(this)});b.addListener(this._checkOverflow,this);};g.prototype.onBeforeRendering=function(){if(!this.getHeight()){L.warning("No height provided",this);}if(!this.getWidth()){L.warning("No width provided",this);}if(D.system.desktop){this._oArrowPrev.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}else if(D.system.phone||D.system.tablet){this._oArrowPrev.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}};g.prototype.onAfterRendering=function(){this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._checkOverflow();};g.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}b.removeListener(this._checkOverflow,this);};g.prototype.onsaptabnext=function(E){var F=this.$().find(":focusable");var t=F.index(E.target);var n=F.eq(t+1).get(0);var o=this._getParentCell(E.target);var T;if(n){T=this._getParentCell(n);}if((o&&T&&o.id!==T.id)||(n&&n.id===this.getId()+"-after")||(n&&n.id===this.getId()+"-scrl-prev-button")||(n&&n.id===this.getId()+"-scrl-next-button")){var h=F.last().get(0);if(h){this._bIgnoreFocusIn=true;h.focus();}}};g.prototype.onsaptabprevious=function(E){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");var F=this.$().find(":focusable");var t=F.index(E.target);var p=F.eq(t-1).get(0);var o=this._getParentCell(E.target);var T;if(p){T=this._getParentCell(p);}if(!T||o&&o.id!==T.id){var s=this.$().attr("tabindex");this.$().attr("tabindex","0");this.$().trigger("focus");if(!s){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",s);}}};g.prototype.setOrientation=function(v){this.setProperty("orientation",v);if(v===O.Horizontal&&!D.system.desktop){this._oScrollCntr.setHorizontal(true);this._oScrollCntr.setVertical(false);}else if(!D.system.desktop){this._oScrollCntr.setHorizontal(false);this._oScrollCntr.setVertical(true);}return this;};g.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};g.prototype.getAggregation=function(A,o,s){return this._callMethodInManagedObject("getAggregation",A,o,s);};g.prototype.setAggregation=function(A,o,s){return this._callMethodInManagedObject("setAggregation",A,o,s);};g.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};g.prototype.insertAggregation=function(A,o,i,s){return this._callMethodInManagedObject("insertAggregation",A,o,i,s);};g.prototype.addAggregation=function(A,o,s){return this._callMethodInManagedObject("addAggregation",A,o,s);};g.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};g.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};g.prototype.destroyAggregation=function(A,s){return this._callMethodInManagedObject("destroyAggregation",A,s);};g.prototype._setScrollInProcess=function(v){this.bScrollInProcess=v;};g.prototype._scroll=function(i,h){this._setScrollInProcess(true);setTimeout(this._setScrollInProcess.bind(this,false),h+300);if(this.getOrientation()===O.Horizontal){this._hScroll(i,h);}else{this._vScroll(i,h);}};g.prototype._vScroll=function(h,i){var o=this._oScrollCntr.getDomRef(),s=o.scrollTop,S=o.scrollHeight,j=s+h,k=o.clientHeight,p=parseFloat(this.$("scroll-area").css("padding-top")),r;if(j<=0){r=this._calculateRemainingScrolling(h,i,s);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrTopPadding");}else if(j+k+p>=S){r=this._calculateRemainingScrolling(h,i,S-k-s);this.$("scroll-area").css("transition","padding "+r+"s");if(k+h>S&&k!==S){this.$().removeClass("sapMHrdrBottomPadding");this.$().addClass("sapMHrdrTopPadding");}else{this.$().removeClass("sapMHrdrBottomPadding");}}else{this.$("scroll-area").css("transition","padding "+i/1000+"s");}this._oScrollCntr.scrollTo(0,j,i);};g.prototype._hScroll=function(h,i){var o=this._oScrollCntr.getDomRef();var s,S,j,k,p,r;if(!this._bRtl){S=o.scrollLeft;k=o.scrollWidth;j=o.clientWidth+(D.browser.msie?1:0);s=S+h;p=parseFloat(this.$("scroll-area").css("padding-left"));if(s<=0){r=this._calculateRemainingScrolling(h,i,S);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrLeftPadding");}else if(s+o.clientWidth+p>=k){r=this._calculateRemainingScrolling(h,i,k-j-S);this.$("scroll-area").css("transition","padding "+r+"s");if(j+h>k&&j!==k){this.$().removeClass("sapMHrdrRightPadding");this.$().addClass("sapMHrdrLeftPadding");}else{this.$().removeClass("sapMHrdrRightPadding");}}else{this.$("scroll-area").css("transition","padding "+i/1000+"s");}this._oScrollCntr.scrollTo(s,0,i);}else{s=q(o).scrollRightRTL()+h;this._oScrollCntr.scrollTo((s>0)?s:0,0,i);}};g.prototype._collectItemSize=function(){var s=0,h=this._filterVisibleItems(),F=this.getOrientation()===O.Horizontal?"outerWidth":"outerHeight";this._aItemEnd=[];h.forEach(function(o,i){s+=o.$().parent()[F](true);this._aItemEnd[i]=s;},this);};g.prototype._getScrollValue=function(F){if(!this._oScrollCntr){return 0;}var h=this.getOrientation()===O.Horizontal,$=this._oScrollCntr.$(),j=this.$("prev-button-container"),m=this.$("next-button-container"),s=h?$[0].scrollLeft:$[0].scrollTop,t=0,S=0,n,o=this._filterVisibleItems();var G=function(k){var S=0,B=0;var r=10;if(this._bRtl&&h){if(!j.is(":visible")){B=j.width();}if(!m.is(":visible")){B=m.width();}}for(var i=0;i<o.length&&i<k;i++){S+=p(o[i]);}return S!==0?S+r-B:0;}.bind(this);var p=function(k){return h?k.$().parent().outerWidth(true):k.$().parent().outerHeight(true);};var E=function(){var S=this._getSize(true),r,A=0;for(var i=t;i<o.length;i++){if(!o[i].$().is(":visible")){r=p(o[i])+G(i)-S-s;for(var k=t;k<o.length&&k<i;k++){if(n+A>r){break;}t++;A+=p(o[k]);}n+=A;break;}}}.bind(this);if(this.getScrollStepByItem()>0){s=h&&this._bRtl?$.scrollRightRTL():s;for(var i=0;i<o.length;i++){S+=p(o[i]);if(S>=s){t=i;break;}}t=(F?1:-1)*this.getScrollStepByItem()+t;if(t<0){t=0;}if(t>=o.length){t=o.length-1;}n=G(t)-s;if(F&&!this.getShowOverflowItem()){E();}return n;}return F?this.getScrollStep():-this.getScrollStep();};g.prototype._calculateRemainingScrolling=function(h,i,j){return Math.abs(j*i/(1000*h));};g.prototype._checkOverflow=function(){if(this.getOrientation()===O.Horizontal){this._checkHOverflow();}else{this._checkVOverflow();}};g.prototype._filterVisibleItems=function(){return this.getContent().filter(function(i){return i.getVisible();});};g.prototype._getFirstItemOffset=function(t){var F=this._filterVisibleItems()[0],$=F&&F.$(),h=$&&$.parent(),i=h&&h[0]&&h[0][t];return i||0;};g.prototype._checkVOverflow=function(){var B=this._oScrollCntr.getDomRef(),o,$;if(B){var F=this._getFirstItemOffset("offsetTop");var s=Math.ceil(B.scrollTop);var S=false;var h=false;var r=B.scrollHeight;var i=B.offsetHeight;if(Math.abs(r-i)===1){r=i;}if(s>F){S=true;}if((r>i)&&(s+i<r)){h=true;}h=this._checkForOverflowItem(h);$=this.$("prev-button-container");o=$.is(":visible");if(o&&!S){$.hide();this.$().removeClass("sapMHrdrTopPadding");}if(!o&&S){$.show();this.$().addClass("sapMHrdrTopPadding");}$=this.$("next-button-container");var j=$.is(":visible");if(j&&!h){$.hide();this.$().removeClass("sapMHrdrBottomPadding");}if(!j&&h){$.show();this.$().addClass("sapMHrdrBottomPadding");}}};g.prototype._handleMobileScrolling=function(){if(C.isMobile()){var $=this.$("scrl-cntnr-scroll"),i=this.getOrientation()===O.Horizontal,p=i?"clientX":"clientY",h=0,t=this,s=false;$.on("touchstart",function(E){s=true;h=E.targetTouches[0][p];});$.on("touchmove",function(E){if(s){var j=E.targetTouches[0][p],k=h-j,S=t._oScrollCntr.getDomRef();i?S.scrollLeft+=k:S.scrollTop+=k;h=j;E.preventDefault();}});$.on("touchend",function(){s=false;});}};g.prototype._checkHOverflow=function(){var B=this._oScrollCntr.getDomRef(),$;if(B){var F=this._getFirstItemOffset("offsetLeft");var s=Math.ceil(B.scrollLeft);var S=false;var h=false;var r=B.scrollWidth;var i=B.offsetWidth;if(Math.abs(r-i)===1){r=i;}if(this._bRtl){var j=q(B).scrollLeftRTL();if(j>((D.browser.msie||D.browser.edge)?1:0)){h=true;}}else if(s>F){S=true;}if(r-5>i){if(this._bRtl){if(q(B).scrollRightRTL()>1){S=true;}}else if(s+i<r){h=true;}}$=this.$("prev-button-container");h=this._checkForOverflowItem(h);var o=$.is(":visible");if(o&&!S){$.hide();this.$().removeClass("sapMHrdrLeftPadding");}if(!o&&S){$.show();this.$().addClass("sapMHrdrLeftPadding");}$=this.$("next-button-container");var k=$.is(":visible");if(k&&!h){$.hide();this.$().removeClass("sapMHrdrRightPadding");}if(!k&&h){$.show();this.$().addClass("sapMHrdrRightPadding");}}};g.prototype._getSize=function(A){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,i=this.$("next-button-container"),j=!i.is(":visible")&&A,F=h?"width":"height";return $[F]()-(j?i[F]():0);};g.prototype._checkForOverflowItem=function(s){if(this._oScrollCntr&&!this.getShowOverflowItem()){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,S=!h?$[0].scrollTop:(this._bRtl?$.scrollRightRTL():$[0].scrollLeft),F=h?"width":"height",j=this._getSize(s),k=this._filterVisibleItems();this._collectItemSize();this._aItemEnd.forEach(function(E,i){var m=k[i].$(),n=m.parent(),v=m.is(":visible");if(s&&E>S+j){if(i===0||this._aItemEnd[i-1]<=S){n.css(F,"auto");m.show();}else if(v){n[F](n[F]());m.hide();s=true;}}else{if(!v){n.css(F,"auto");m.show();}}},this);}return s;};g.prototype._handleBorderReached=function(E){if(D.browser.msie&&this.bScrollInProcess){return;}var i=E.getParameter("index");if(i===0){this._scroll(this._getScrollValue(false),this.getScrollTime());}else if(i===this._filterVisibleItems().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime());}};g.prototype._handleAfterFocus=function(E){var s=E.getParameter("event");if((D.browser.msie||D.browser.edge)&&s.type==="mousedown"&&s.srcControl instanceof sap.m.Input){s.srcControl.focus();}if(D.browser.msie&&this.bScrollInProcess){return;}var i=E.getParameter("index");if(i===0){this._scroll(this._getScrollValue(false),this.getScrollTime());}else if(i===this._filterVisibleItems().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime());}};g.prototype._handleFocusAgain=function(E){var s=E.getParameter("event");if((D.browser.msie||D.browser.edge)&&s.type==="mousedown"&&s.srcControl instanceof sap.m.Input){s.srcControl.focus();}E.getParameter("event").preventDefault();};g.prototype._handleBeforeFocus=function(E){var o=E.getParameter("event");if(q(o.target).hasClass("sapMHdrCntrItemCntr")||q(o.target).hasClass("sapMScrollContScroll")||P.events.sapprevious.fnCheck(o)||P.events.sapnext.fnCheck(o)){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");}else{this.$().find(".sapMHdrCntrItemCntr").css("border-color","transparent");}};g.prototype._unWrapHeaderContainerItemContainer=function(w){if(w instanceof f){w=w.getItem();}else if(Array.isArray(w)){for(var i=0;i<w.length;i++){if(w[i]instanceof f){w[i]=w[i].getItem();}}}return w;};g._AGGREGATION_FUNCTIONS=["validateAggregation","validateAggregation","getAggregation","setAggregation","indexOfAggregation","removeAggregation"];g._AGGREGATION_FUNCTIONS_FOR_INSERT=["insertAggregation","addAggregation"];g.prototype._callMethodInManagedObject=function(F,A){var h=Array.prototype.slice.call(arguments);if(A==="content"){var o=h[2];h[1]="content";if(o instanceof a){if(((g._AGGREGATION_FUNCTIONS?Array.prototype.indexOf.call(g._AGGREGATION_FUNCTIONS,F):-1))>-1&&o.getParent()instanceof f){h[2]=o.getParent();}else if(((g._AGGREGATION_FUNCTIONS_FOR_INSERT?Array.prototype.indexOf.call(g._AGGREGATION_FUNCTIONS_FOR_INSERT,F):-1))>-1){h[2]=new f({item:o});}}var r=this._oScrollCntr[F].apply(this._oScrollCntr,h.slice(1));if(F!=="removeAllAggregation"){var j=this._oScrollCntr.getContent();var k=this.getAriaLabelledBy();for(var i=0;i<j.length;i++){var m=j[i];m.setPosition(i+1);m.setSetSize(j.length);m.setAriaLabelledBy(k[i]);}}return this._unWrapHeaderContainerItemContainer(r);}else{return M.prototype[F].apply(this,h.slice(1));}};g.prototype._getParentCell=function(o){return q(o).parents(".sapMHrdrCntrInner").andSelf(".sapMHrdrCntrInner").get(0);};g.prototype.onfocusin=function(E){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;return;}if(E.target.id===this.getId()+"-after"){this._restoreLastFocused();}};g.prototype._restoreLastFocused=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(n[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");t.eq(-1).add($).eq(-1).trigger("focus");};return g;});
