/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Control","./ActionToolbar","./table/TableSettings","./table/GridTableType","./table/V4AnalyticsTableType","./table/ResponsiveTableType","./mixin/FilterIntegrationMixin","./library","sap/m/Text","sap/m/Title","sap/m/ColumnHeaderPopover","sap/m/ColumnPopoverSortItem","sap/m/OverflowToolbar","sap/m/library","sap/ui/core/Core","sap/ui/core/format/NumberFormat","sap/ui/core/dnd/DragDropInfo","sap/ui/core/Item","sap/ui/core/format/ListFormat","sap/ui/events/KeyCodes","sap/ui/model/Sorter","sap/ui/dom/containsOrEquals","sap/base/strings/capitalize","sap/base/util/deepEqual"],function(C,A,T,G,V,R,F,l,a,b,c,d,O,M,e,N,D,I,L,K,S,f,g,h){"use strict";var j=l.SelectionMode;var k=l.TableType;var m=l.RowAction;var n=M.ToolbarDesign;var s="sap.ui.mdc.IFilter";var o=new window.WeakMap();var p=function(i){if(!o.has(i)){o.set(i,{oFilterInfoBar:null});}return o.get(i);};function q(i,J){sap.ui.require(["sap/m/MessageToast"],function(P){var Q=e.getLibraryResourceBundle("sap.ui.mdc");P.show(Q.getText(i,J));});}var r=C.extend("sap.ui.mdc.Table",{library:"sap.ui.mdc",metadata:{designtime:"sap/ui/mdc/designtime/table/Table.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"columns",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},rowAction:{type:"sap.ui.mdc.RowAction[]",defaultValue:[]},p13nMode:{type:"sap.ui.mdc.TableP13nMode[]",defaultValue:[]},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/TableDelegate",payload:{}}},rowsBindingInfo:{type:"object",defaultValue:null},autoBindOnInit:{type:"boolean",group:"Misc",defaultValue:true},header:{type:"string",group:"Misc",defaultValue:null},headerVisible:{type:"boolean",group:"Misc",defaultValue:true},selectionMode:{type:"sap.ui.mdc.SelectionMode",defaultValue:j.None},showRowCount:{type:"boolean",group:"Misc",defaultValue:true},threshold:{type:"int",group:"Appearance",defaultValue:-1},noDataText:{type:"string"},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},enableExport:{type:"boolean",defaultValue:false},busyIndicatorDelay:{type:"int",defaultValue:100}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},type:{type:"sap.ui.mdc.table.TableTypeBase",altTypes:["sap.ui.mdc.TableType"],multiple:false},columns:{type:"sap.ui.mdc.table.Column",multiple:true},creationRow:{type:"sap.ui.mdc.table.CreationRow",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_createToolbar",aggregation:"actions"}},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},quickFilter:{type:"sap.ui.core.Control",multiple:false},rowSettings:{type:"sap.ui.mdc.table.RowSettings",multiple:false}},associations:{filter:{type:s,multiple:false}},events:{rowPress:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}},selectionChange:{parameters:{bindingContext:{type:"sap.ui.model.Context"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},beforeExport:{parameters:{exportSettings:{type:"object"},userExportSettings:{type:"object"}}},paste:{parameters:{data:{type:"string[][]"}}}}},constructor:function(){this._oTableReady=new Promise(this._resolveTable.bind(this));this._oAdaptationController=null;C.apply(this,arguments);this.bCreated=true;this._doOneTimeOperations();this._initializeContent();},renderer:{apiVersion:2,render:function(i,J){i.openStart("div",J);i.class("sapUiMdcTable");i.style("height",J.getHeight());i.style("width",J.getWidth());i.openEnd();i.renderControl(J.getAggregation("_content"));i.close("div");}}});var t=["variant","quickFilter"];F.call(r.prototype);t.forEach(function(i){var J=g(i),P="_o"+J,Q="get"+J,U="set"+J,W="destroy"+J;r.prototype[Q]=function(){return this[P];};r.prototype[W]=function(){var X=this[P];this[U]();if(X){X.destroy();}return this;};r.prototype[U]=function(X){this.validateAggregation(i,X,false);var Y=this._createToolbar(),Z=X!==this[P];if(!X||Z){Y.removeBetween((this[Q]()));this[P]=X;}if(Z&&X){this._setToolbarBetween(Y);}return this;};});r.prototype.init=function(){C.prototype.init.apply(this,arguments);this.mSkipPropagation={rowSettings:true};var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this.setProperty("adaptationConfig",{itemConfig:{changeOperations:{add:"addColumn",remove:"removeColumn",move:"moveColumn"},adaptationUI:"sap/ui/mdc/p13n/panels/SelectionPanel",containerSettings:{title:i.getText("table.SETTINGS_COLUMN")}}});};r.prototype.applySettings=function(){C.prototype.applySettings.apply(this,arguments);this.initControlDelegate();};r.prototype._setToolbarBetween=function(i){[this._oVariant,this._oQuickFilter].forEach(function(J){if(J){i.addBetween(J);}});};r.prototype.initialized=function(){return this._oTableReady;};r.prototype._resolveTable=function(i,J){this._fResolve=i;this._fReject=J;};r.prototype._getStringType=function(i){var J,P=J=i||this.getType();if(!P){J=k.Table;}else if(typeof P==="object"){if(P.isA("sap.ui.mdc.table.ResponsiveTableType")){J=k.ResponsiveTable;}else if(P.isA("sap.ui.mdc.table.V4AnalyticsTableType")){J="V4AnalyticsTable";}else{J=k.Table;}}return J;};r.prototype._updateTypeSettings=function(){var i=this.getType();if(i&&typeof i==="object"){i.updateTableSettings();}else{if(i==="ResponsiveTable"){i=R;}else if(i==="V4AnalyticsTable"){i=V;}else{i=G;}i.updateDefault(this._oTable);}};r.prototype.scrollToIndex=function(i){if(!this._oTable||(typeof i!=="number")){return;}if(this._getStringType()===k.ResponsiveTable){this._oTable.scrollToIndex(i);}else{if(i===-1){i=this.getRowBinding()?this.getRowBinding().getLength():0;}this._oTable.setFirstVisibleRow(i);}};r.prototype.setType=function(i){var J=this._getStringType(i);var P=this._getStringType();this.setAggregation("type",i,true);if(J===P&&this._oTable){this._updateTypeSettings();return this;}if(this.bCreated){if(this._oTable){if(P==="ResponsiveTable"){this._oTable.setHeaderToolbar();}else{this._oTable.removeExtension(this._oToolbar);}this._oTable.destroy("KeepDom");this._oTable=null;this._bTableExists=false;}else{this._onAfterTableCreated();}if(this._oTemplate){this._oTemplate.destroy();this._oTemplate=null;}this._oTableReady=new Promise(this._resolveTable.bind(this));this._initializeContent();}return this;};r.prototype.setRowSettings=function(i){var J=this._getStringType();this.setAggregation("rowSettings",i,true);if(this._oTable){if(J==="ResponsiveTable"){R.updateRowSettings(this._oTemplate,i);this.checkAndRebind();}else{G.updateRowSettings(this._oTable,i);}}return this;};r.prototype.focus=function(i){var J=this.getDomRef();if(this._oTable&&J&&!f(J,document.activeElement)){this._oTable.focus();}};r.prototype.setBusy=function(i){this.setProperty('busy',i,true);if(this._oTable){this._oTable.setBusy(i);}return this;};r.prototype.setBusyIndicatorDelay=function(i){this.setProperty('busyIndicatorDelay',i,true);if(this._oTable){this._oTable.setBusyIndicatorDelay(i);}return this;};r.prototype.setSelectionMode=function(i){var J=this.getSelectionMode();this.setProperty("selectionMode",i,true);if(this._oTable&&J!=this.getSelectionMode()){this._updateSelectionBehavior();}return this;};r.prototype.setRowAction=function(i){var J=this.getRowAction();this.setProperty("rowAction",i,true);if(!h(J.sort(),this.getRowAction().sort())){this._updateRowAction();}return this;};r.prototype.setCreationRow=function(i){this.setAggregation("creationRow",i,true);if(i){i.update();}return this;};r.prototype.setP13nMode=function(i){var J=this.getP13nMode();this.setProperty("p13nMode",i,true);if(!h(J.sort(),this.getP13nMode().sort())){u(this);}return this;};function u(i){if(i._oToolbar){i._oToolbar.destroyEnd();i._getP13nButtons().forEach(function(P){i._oToolbar.addEnd(P);});}if(i._oTable){var J=i._oTable.getDragDropConfig()[0];if(J){J.setEnabled(i.getP13nMode().indexOf("Column")>-1);}}if(i.isFilteringEnabled()){y(i);}v(i);}r.prototype.setFilterConditions=function(i){this.setProperty("filterConditions",i,true);if(this._oP13nFilter){this._oP13nFilter.setFilterConditions(i);}v(this);return this;};function v(i){var J=B(i);var P=E(i);var Q=H(i);if(!J){return;}if(Q.length===0||!i.isFilteringEnabled()){var U=J.getDomRef();if(U&&U.contains(document.activeElement)){i.focus();}J.setVisible(false);return;}w(i,true).then(function(W){var X=Q.map(function(_){return x(i,W[_]);});var Y=e.getLibraryResourceBundle("sap.ui.mdc");var Z=L.getInstance();var $=Y.getText("table.FILTER_INFO",Z.format(X));J.setVisible(true);P.setText($);});}function w(i,J){return i.getControlDelegate().fetchProperties(i).then(function(P){var Q={};P.forEach(function(U){if(!J||!Array.isArray(U.propertyInfos)){Q[U.name]=U;}});return Q;});}function x(i,P){if("label"in P){return P.label;}var J=[];i.getColumns().forEach(function(Q){if(Q.getDataProperties().indexOf(P.name)>-1){J.push(Q);}});if(J.length===1){return J[0].getHeader();}else{return P.name;}}function y(i){if(!i._oTable){return;}var J=B(i);if(!J){J=z(i);}if(i._bMobileTable){if(i._oTable.getInfoToolbar()!==J){i._oTable.setInfoToolbar(J);i._oTable.addAriaLabelledBy(E(i));}}else if(i._oTable.indexOfExtension(J)===-1){i._oTable.insertExtension(J,1);i._oTable.addAriaLabelledBy(E(i));}}function z(i){var J=i.getId()+"-filterInfoBar";var P=p(i).oFilterInfoBar;if(P&&!P.bIsDestroyed){P.destroy();}P=new O({id:J,active:true,design:n.Info,visible:false,content:[new a({id:J+"-text",wrapping:false})],press:function(){T.showPanel(i,"Filter",P);}});P.focus=function(){if(this.getDomRef()){O.prototype.focus.apply(this,arguments);}else{i.focus();}};p(i).oFilterInfoBar=P;v(i);return P;}function B(i){var J=p(i).oFilterInfoBar;if(J&&(J.bIsDestroyed||J.bIsBeingDestroyed)){return null;}return p(i).oFilterInfoBar;}function E(i){var J=B(i);return J?J.getContent()[0]:null;}r.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);if(!this._oTable){return this;}i=this.getThreshold()>-1?this.getThreshold():undefined;if(this._bMobileTable){this._oTable.setGrowingThreshold(i);}else{this._oTable.setThreshold(i);}return this;};r.prototype._onFilterProvided=function(){this._updateInnerTableNoDataText();};r.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);this._updateInnerTableNoDataText();return this;};r.prototype._updateInnerTableNoDataText=function(){if(!this._oTable){return;}var i=this._getNoDataText();if(this._bMobileTable){this._oTable.setNoDataText(i);}else{this._oTable.setNoData(i);}};r.prototype._getNoDataText=function(){var i=this.getNoDataText();if(i){return i;}var J=e.getLibraryResourceBundle("sap.ui.mdc");if(!this.isTableBound()){if(this.getFilter()){return J.getText("table.NO_DATA_WITH_FILTERBAR");}return J.getText("table.NO_DATA");}return J.getText("table.NO_RESULTS");};r.prototype._updateRowAction=function(){if(!this._oTable){return;}var i=this.getRowAction().indexOf(m.Navigation)>-1;var J=this._bMobileTable?R:G;J.updateRowAction(this,i,this._bMobileTable?undefined:this._onRowActionPress);};r.prototype._initializeContent=function(){var i,J=this._getStringType();if(J==="ResponsiveTable"){i=R;}else if(J==="V4AnalyticsTable"){i=V;}else{i=G;}Promise.all([this.awaitControlDelegate(),i.loadTableModules(),this.retrieveAdaptationController()]).then(function(){if(this.bIsDestroyed){return;}if(!this._bTableExists&&J===this._getStringType()){this._bMobileTable=J==="ResponsiveTable";this._createContent();this._bTableExists=true;}}.bind(this));};r.prototype._doOneTimeOperations=function(){if(!this.bColumnsOrdered){this.bColumnsOrdered=true;this._orderColumns();}};r.prototype._onAfterTableCreated=function(i){if(i&&this._fResolve){this._fResolve(this);}else if(this._fReject){this._fReject(this);}delete this._fResolve;delete this._fReject;};r.prototype._createContent=function(){this._createToolbar();this._createTable();this._updateRowAction();var i=this.getColumns();i.forEach(this._insertInnerColumn,this);this.setAggregation("_content",this._oTable);this._onAfterTableCreated(true);this.initialized().then(function(){var J=this.getCreationRow();if(J){J.update();}if(this.getAutoBindOnInit()){this.checkAndRebind();}}.bind(this));};r.prototype.setHeader=function(i){this.setProperty("header",i,true);this._updateHeaderText();this._updateExportState(true);return this;};r.prototype.setHeaderVisible=function(i){this.setProperty("headerVisible",i,true);if(this._oTitle){this._oTitle.setWidth(this.getHeaderVisible()?undefined:"0px");}return this;};r.prototype.setEnableExport=function(i){if(i!==this.getEnableExport()){this.setProperty("enableExport",i,true);if(i&&!this._oExportButton&&this._oToolbar){this._oToolbar.addEnd(this._getExportButton());}else if(this._oExportButton){this._oExportButton.setVisible(i);}}return this;};r.prototype._createToolbar=function(){if(!this._oToolbar){this._oTitle=new b(this.getId()+"-title",{text:this.getHeader(),width:this.getHeaderVisible()?undefined:"0px"});this._oToolbar=new A(this.getId()+"-toolbar",{design:"Transparent",begin:[this._oTitle],end:[this._getP13nButtons(),this._getExportButton()]});}return this._oToolbar;};r.prototype._getVisibleProperties=function(){var P=[],i;this.getColumns().forEach(function(J,Q){i=J&&J.getDataProperties()[0];if(i){P.push({name:i});}});return P;};r.prototype.getConditions=function(){return this._oP13nFilter?this._oP13nFilter.getConditions():[];};r.prototype._getSortedProperties=function(){return this.getSortConditions()?this.getSortConditions().sorters:[];};function H(i){var J=i.getFilterConditions();return Object.keys(J).filter(function(P){return J[P].length>0;});}r.prototype.getCurrentState=function(){var i={};var P=this.getP13nMode();if(P.indexOf("Column")>-1){i.items=this._getVisibleProperties();}if(this.isSortingEnabled()){i.sorters=this._getSortedProperties();}if(this.isFilteringEnabled()){i.filter=this.getFilterConditions();}return i;};r.prototype.isFilteringEnabled=function(){return this.getP13nMode().indexOf("Filter")>-1;};r.prototype.retrieveInbuiltFilter=function(){var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return C.prototype.retrieveInbuiltFilter.call(this,this._registerInnerFilter,false).then(function(J){var P={adaptationUI:J,applyFilterChangeOn:J,initializeControl:J.createFilterFields,containerSettings:{title:i.getText("filter.PERSONALIZATION_DIALOG_TITLE")}};this.enhanceAdaptationConfig({filterConfig:P});return J;}.bind(this));};r.prototype.isSortingEnabled=function(){return this.getP13nMode().indexOf("Sort")>-1;};r.prototype._getP13nButtons=function(){var P=this.getP13nMode();var i=[];if(this.isSortingEnabled()){i.push(T.createSortButton(this.getId(),[this._showSort,this]));}if(this.isFilteringEnabled()){i.push(T.createFilterButton(this.getId(),[this._showFilter,this]));}if(P.indexOf("Column")>-1){i.push(T.createColumnsButton(this.getId(),[this._showSettings,this]));}return i;};r.prototype._getExportButton=function(){if(!this.getEnableExport()){return null;}var i={fileName:this.getHeader()};if(!this._cachedExportSettings){this._cachedExportSettings=i;}if(!this._oExportButton){this._oExportButton=T.createExportButton(this.getId(),{"default":[function(){this._onExport(i);},this],"exportAs":[this._onExportAs,this]});}this._updateExportState();return this._oExportButton;};r.prototype._updateExportState=function(U){var i=this._getRowBinding();if(this._oExportButton){this._oExportButton.setEnabled(!!(i&&i.getLength()>0));if(U&&this._cachedExportSettings){this._cachedExportSettings.fileName=this.getHeader();}}};r.prototype._createExportSettingsObject=function(i,J){return Object.assign({columnId:i.getId(),label:i.getHeader(),width:this._getColumnWidthNumber(i.getWidth()),textAlign:i.getHAlign(),type:"String"},J);};r.prototype._createExportColumnConfiguration=function(i){var J=i&&i.splitCells;var P=this.getColumns();return this.getControlDelegate().fetchProperties(this).then(function(Q){var U={},W=[],X,Y,Z,$,_,a1,b1,c1;Q.forEach(function(d1){U[d1.name]=d1;});P.forEach(function(d1){Y=null;Z=null;$=[];X=d1.getDataProperties();_=null;a1=[];b1=null;c1=null;Y=U[X[0]];if(Y){if(Y.hasOwnProperty("propertyInfos")&&Y.propertyInfos.length){Z=Y.propertyInfos;Z.forEach(function(e1){$.push(U[e1]);});if(!J&&Y.hasOwnProperty("exportSettings")){_=this._createExportSettingsObject(d1,Y.exportSettings);$.forEach(function(e1){a1.push(e1.path||e1.name);});_.property=a1;W.push(_);}else{$.forEach(function(e1,f1){var g1=this._createExportSettingsObject(d1,e1.exportSettings);g1.property=e1.path||e1.name;if(!e1.exportSettings||!e1.exportSettings.label){g1.label=e1.label||d1.getHeader()+(f1>0?" ("+(f1+1)+")":"");}W.push(g1);},this);}}else if(!J&&Y.hasOwnProperty("exportSettings")){_=this._createExportSettingsObject(d1,Y.exportSettings);_.property=Y.path||Y.name;W.push(_);}else{_=this._createExportSettingsObject(d1,Y.exportSettings);_.property=Y.path||Y.name;_.displayUnit=!J?true:false;W.push(_);b1=J&&_&&_.unitProperty?_.unitProperty:null;if(b1){c1=U[b1];if(!c1){c1=Q.find(function(e1){return b1===e1.path;});}_=this._createExportSettingsObject(d1,c1.exportSettings);_.property=c1.path||c1.name;_.columnId=d1.getId()+"-additionalProperty";if(!c1.exportSettings||!c1.exportSettings.label){_.label=c1.label||d1.getHeader()+" (2)";}W.push(_);}}}},this);return[W,Q];}.bind(this));};r.prototype._getColumnWidthNumber=function(W){if(W.indexOf("em")>0){return Math.round(parseFloat(W));}if(W.indexOf("px")>0){return Math.round(parseInt(W)/16);}return"";};r.prototype._getColumnHeader=function(P){if(!P){return null;}var i=this.getColumns().find(function(J){return J.getDataProperties()[0]===P;});return i?i.getHeader():null;};r.prototype._onExport=function(i){return this._createExportColumnConfiguration(i).then(function(J){var P=J[0];if(!P||!P.length){sap.ui.require(["sap/m/MessageBox"],function(X){X.error(e.getLibraryResourceBundle("sap.ui.mdc").getText("table.NO_COLS_EXPORT"),{styleClass:(this.$()&&this.$().closest(".sapUiSizeCompact").length)?"sapUiSizeCompact":""});}.bind(this));return;}var Q=this._getRowBinding();var U=function(X){var Y=J[1];var Z=Y.find(function($){return $.name===X;});if(Z){return Z.label||Z.name||null;}return null;};var W={workbook:{columns:P},dataSource:Q,fileName:i?i.fileName:this.getHeader()};this._loadExportLibrary().then(function(){sap.ui.require(["sap/ui/export/ExportUtils","sap/ui/export/Spreadsheet"],function(X,Y){var Z=Promise.resolve();if(i.includeFilterSettings){Z=X.parseFilterConfiguration(Q,U).then(function($){if($){W.workbook.context={metaSheetName:$.name,metainfo:[$]};}});}Z.then(function(){var $={splitCells:false,includeFilterSettings:false};if(i){$.splitCells=i.splitCells;$.includeFilterSettings=i.includeFilterSettings;}var _=new Y(W);_.attachBeforeExport(function(a1){this.fireBeforeExport({exportSettings:a1.getParameter("exportSettings"),userExportSettings:$});},this);_.build().finally(function(){_.destroy();});}.bind(this));}.bind(this));}.bind(this));}.bind(this));};r.prototype._onExportAs=function(){var i=this;this._loadExportLibrary().then(function(){sap.ui.require(['sap/ui/export/ExportUtils'],function(J){J.getExportSettingsViaDialog(i._cachedExportSettings,i).then(function(U){i._cachedExportSettings=U;i._onExport(U);});});});};r.prototype._loadExportLibrary=function(){if(!this._oExportLibLoadPromise){this._oExportLibLoadPromise=e.loadLibrary("sap.ui.export",true);}return this._oExportLibLoadPromise;};r.prototype.onkeydown=function(i){if(i.isMarked()){return;}if((i.metaKey||i.ctrlKey)&&i.shiftKey&&i.which===K.E){if(this.getEnableExport()&&this._oExportButton&&this._oExportButton.getEnabled()){this._onExportAs();i.setMarked();i.preventDefault();}}};r.prototype._createTable=function(){var i=this.getThreshold()>-1?this.getThreshold():undefined;var J=this.getRowSettings()?this.getRowSettings().getAllSettings():{};if(this._bMobileTable){this._oTable=R.createTable(this.getId()+"-innerTable",{autoPopinMode:true,growing:true,sticky:["ColumnHeaders","HeaderToolbar","InfoToolbar"],itemPress:[this._onItemPress,this],selectionChange:[this._onSelectionChange,this],growingThreshold:i,noDataText:this._getNoDataText(),headerToolbar:this._oToolbar,ariaLabelledBy:[this._oTitle]});this._oTemplate=R.createTemplate(this.getId()+"-innerTableRow",J);this._createColumn=r.prototype._createMobileColumn;this._sAggregation="items";this._oTable.bindRows=this._oTable.bindItems;this._oTable.bActiveHeaders=true;this._oTable.attachEvent("columnPress",this._onResponsiveTableColumnPress,this);}else{this._oTable=G.createTable(this.getId()+"-innerTable",{enableBusyIndicator:true,enableColumnReordering:false,threshold:i,cellClick:[this._onCellClick,this],noData:this._getNoDataText(),extension:[this._oToolbar],ariaLabelledBy:[this._oTitle],plugins:[G.createMultiSelectionPlugin(this,[this._onRowSelectionChange,this])],columnSelect:[this._onGridTableColumnPress,this],rowSettingsTemplate:J});this._createColumn=r.prototype._createColumn;this._sAggregation="rows";}this._updateTypeSettings();this._updateSelectionBehavior();var P=new D({sourceAggregation:"columns",targetAggregation:"columns",dropPosition:"Between",enabled:this.getP13nMode().indexOf("Column")>-1,drop:[this._onColumnRearrange,this]});P.bIgnoreMetadataCheck=true;this._oTable.addDragDropConfig(P);this._oTable.setBusyIndicatorDelay(this.getBusyIndicatorDelay());this._oTable.attachPaste(this._onInnerTablePaste,this);if(this.isFilteringEnabled()){y(this);}};r.prototype._updateSelectionBehavior=function(){var i=this._bMobileTable?R:G;i.updateSelection(this);};r.prototype._onColumnRearrange=function(i){var J=i.getParameter("draggedControl");var P=i.getParameter("droppedControl");if(J===P){return;}var Q=i.getParameter("dropPosition");var U=this._oTable.indexOfColumn(J);var W=this._oTable.indexOfColumn(P);var X=W+(Q=="Before"?0:1)+(U<W?-1:0);T.moveColumn(this,U,X);};r.prototype._onColumnPress=function(J){if(!this.isSortingEnabled()){return;}var P;if(J.getParent()){P=J.getParent().indexOfColumn(J);}var Q=this.getColumns()[P].getDataProperties(),U;if(!Q.length){return;}this.getControlDelegate().fetchProperties(this).then(function(W){U=W.filter(function(Z){return Q.indexOf(Z.name)>=0&&Z.sortable;});if(U.length===0){return;}var X,Y=[];for(var i=0;i<U.length;i++){X=new I({text:U[i].name,key:U[i].name});Y.push(X);}if(Y.length>0){if(this._oPopover){this._oPopover.destroy();}this._oPopover=new c({items:[new d({items:Y,sort:[this._onCustomSort,this]})]});this._oPopover.openBy(J);J.addDependent(this._oPopover);}}.bind(this));};r.prototype._onCustomSort=function(i){var J=i.getParameter("property");T.createSort(this,J,true);};r.prototype._insertInnerColumn=function(i,J){if(!this._oTable){return;}var P=this._createColumn(i);this._setColumnTemplate(i,P,J);if(J===undefined){this._oTable.addColumn(P);}else{this._oTable.insertColumn(P,J);}};r.prototype._orderColumns=function(){var i,J=[],P=this.getColumns();P.forEach(function(Q){i=Q.getInitialIndex();if(i>-1){J.push({index:i,column:this.removeColumn(Q)});}},this);J.sort(function(Q,U){return Q-U;});J.forEach(function(Q){this.insertColumn(Q.column,Q.index);},this);};r.prototype._setColumnTemplate=function(i,J,P){var Q=i.getTemplate(true),U;if(!this._bMobileTable){U=i.getCreationTemplate(true);[Q,U].forEach(function(W){if(!W){return;}if(W.setWrapping){W.setWrapping(false);}if(W.setRenderWhitespace){W.setRenderWhitespace(false);}});J.setTemplate(Q);J.setCreationTemplate(U);}else if(P>=0){this._oTemplate.insertCell(Q,P);}else{this._oTemplate.addCell(Q);}};r.prototype._createColumn=function(i){return G.createColumn(i.getId()+"-innerColumn",{width:i.getWidth(),minWidth:Math.round(i.getMinWidth()*parseFloat(M.BaseFontSize)),hAlign:i.getHAlign(),label:i.getColumnHeaderControl(this._bMobileTable),showSortMenuEntry:false,showFilterMenuEntry:false,sortProperty:i.getDataProperties()[0],filterProperty:i.getDataProperties()[0]});};r.prototype._createMobileColumn=function(i){return R.createColumn(i.getId()+"-innerColumn",{width:i.getWidth(),autoPopinWidth:i.getMinWidth(),hAlign:i.getHAlign(),header:i.getColumnHeaderControl(this._bMobileTable),importance:i.getImportance(),popinDisplay:"Inline"});};r.prototype.moveColumn=function(i,J){var P;this.removeAggregation("columns",i,true);this.insertAggregation("columns",i,J,true);if(this._oTable){P=this._oTable.removeColumn(i.getId()+"-innerColumn");this._oTable.insertColumn(P,J);if(this._bMobileTable){this._updateColumnTemplate(i,J);}}};r.prototype.removeColumn=function(i){i=this.removeAggregation("columns",i,true);if(this._oTable){var J=this._oTable.removeColumn(i.getId()+"-innerColumn");J.destroy();if(this._bMobileTable){this._updateColumnTemplate(i,-1);}}return i;};r.prototype.addColumn=function(i){this.addAggregation("columns",i,true);this._insertInnerColumn(i);return this;};r.prototype.insertColumn=function(i,J){this.insertAggregation("columns",i,J,true);this._insertInnerColumn(i,J);return this;};r.prototype._updateColumnTemplate=function(i,J){var P,Q;if(this._oTemplate){P=i.getTemplate(true);Q=this._oTemplate.indexOfCell(P);r._removeItemCell(this._oTemplate,Q,J);}if(Q>-1){this._oTable.getItems().forEach(function(U){if(U.removeCell){r._removeItemCell(U,Q,J);}});}};r._removeItemCell=function(i,J,P){var Q=i.removeCell(J);if(Q){if(P>-1){i.insertCell(Q,P);}else{Q.destroy();}}};r.prototype._onItemPress=function(i){this.fireRowPress({bindingContext:i.getParameter("listItem").getBindingContext()});};r.prototype._onSelectionChange=function(i){var J=i.getParameter("selectAll");this.fireSelectionChange({bindingContext:i.getParameter("listItem").getBindingContext(),selected:i.getParameter("selected"),selectAll:J});if(J){var P=this.getRowBinding();if(P&&this._oTable){var Q=P.getLength();var U=this._oTable.getItems().length;var W=P.isLengthFinal();if(U!=Q||!W){q("table.SELECTION_LIMIT_MESSAGE",[U]);}}}};r.prototype._onResponsiveTableColumnPress=function(i){this._onColumnPress(i.getParameter("column"));};r.prototype._onCellClick=function(i){this.fireRowPress({bindingContext:i.getParameter("rowBindingContext")});};r.prototype._onRowActionPress=function(i){var J=i.getParameter("row");this.fireRowPress({bindingContext:J.getBindingContext()});};r.prototype._onRowSelectionChange=function(i){if(!this._bSelectionChangedByAPI){this.fireSelectionChange({bindingContext:i.getParameter("rowContext"),selected:i.getSource().isIndexSelected(i.getParameter("rowIndex")),selectAll:i.getParameter("selectAll")});}};r.prototype._onGridTableColumnPress=function(i){i.preventDefault();this._onColumnPress(i.getParameter("column"));};r.prototype.getSelectedContexts=function(){if(this._oTable){if(this._bMobileTable){return this._oTable.getSelectedContexts();}var i=this._oTable.getPlugins()[0].getSelectedIndices();return i.map(function(J){return this._oTable.getContextByIndex(J);},this);}return[];};r.prototype.clearSelection=function(){if(this._oTable){if(this._bMobileTable){this._oTable.removeSelections(true);}else{this._bSelectionChangedByAPI=true;this._oTable.getPlugins()[0].clearSelection();this._bSelectionChangedByAPI=false;}}};r.prototype._registerInnerFilter=function(i){i.attachSearch(this.rebind,this);};r.prototype._onFiltersChanged=function(i){if(this.isTableBound()&&i.getParameter("conditionsBased")){this._oTable.setShowOverlay(true);}};r.prototype.isTableBound=function(){return this._oTable?this._oTable.isBound(this._bMobileTable?"items":"rows"):false;};r.prototype.bindRows=function(i){if(!this.bDelegateInitialized||!this._oTable){return;}this.getControlDelegate().updateBindingInfo(this,this.getPayload(),i);if(i&&i.path){this._oTable.setShowOverlay(false);if(this._bMobileTable&&this._oTemplate){i.template=this._oTemplate;}else{delete i.template;}if(!i.parameters){i.parameters={};}i.sorter=this._getSorters();if(this.getShowRowCount()){r._addBindingListener(i,"dataReceived",this._onDataReceived.bind(this));r._addBindingListener(i,"change",this._updateHeaderText.bind(this));}this._updateColumnsBeforeBinding(i);this.getControlDelegate().rebindTable(this,i);this._updateInnerTableNoDataText();}return this;};r.prototype._onDataReceived=function(i){if(i&&i.getParameter&&i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._updateHeaderText();this._updateExportState();};r.prototype._updateHeaderText=function(){var i,J;if(this._oTitle&&this.getHeader()){i=this.getHeader();if(this.getShowRowCount()){J=this._getRowCount();if(J){i+=" ("+J+")";}}this._oTitle.setText(i);}};r.prototype._updateColumnsBeforeBinding=function(i){var J=[].concat(i.sorter||[]);var P=this.getColumns();var Q=this._bMobileTable;P.forEach(function(U){var W=e.byId(U.getId()+"-innerColumn");if(Q){W.setSortIndicator("None");}else{W.setSorted(false);}});J.forEach(function(U){var W=(U.bDescending)?"Descending":"Ascending";P.some(function(X){var Y=e.byId(X.getId()+"-innerColumn");if(X.getDataProperties().indexOf(U.sPath)>-1){if(Q){Y.setSortIndicator(W);}else{Y.setSorted(true).setSortOrder(W);}return true;}});});};r.prototype._getRowCount=function(){var i=this.getRowBinding(),J,P="";if(i){J=i.getLength();if(!this._oNumberFormatInstance){this._oNumberFormatInstance=N.getFloatInstance();}if(i.isLengthFinal()){P=this._oNumberFormatInstance.format(J);}}return P;};r.prototype.getRowBinding=function(){return this._getRowBinding();};r.prototype._getRowBinding=function(){if(this._oTable){return this._oTable.getBinding(this._sAggregation);}};r._addBindingListener=function(i,J,P){if(!i.events){i.events={};}if(!i.events[J]){i.events[J]=P;}else{var Q=i.events[J];i.events[J]=function(){P.apply(this,arguments);Q.apply(this,arguments);};}};r.prototype.rebindTable=function(){this.rebind();};r.prototype.rebind=function(){if(this._bTableExists){this.bindRows(this.getRowsBindingInfo()||{});}else{this.initialized().then(this.rebind.bind(this));}};r.prototype._showSettings=function(i){T.showPanel(this,"Columns",i.getSource());};r.prototype._showSort=function(i){T.showPanel(this,"Sort",i.getSource());};r.prototype._showFilter=function(i){T.showPanel(this,"Filter",i.getSource());};r.prototype._getSorters=function(){var i=this.getSortConditions()?this.getSortConditions().sorters:[];var J=[];i.forEach(function(P){J.push(new S(P.name,P.descending));});return J;};r.prototype._onInnerTablePaste=function(i){this.firePaste({data:i.getParameter("data")});};r.prototype.exit=function(){if(this._oTemplate){this._oTemplate.destroy();}this._oP13nFilter=null;this._oTemplate=null;this._oTable=null;if(this._oToolbar&&!this._bTableExists){this._oToolbar.destroy();}this._oToolbar=null;this._oTitle=null;this._oNumberFormatInstance=null;t.forEach(function(i){var J=g(i),P="_o"+J;this[P]=null;},this);this._oTableReady=null;this._fReject=null;this._fResolve=null;C.prototype.exit.apply(this,arguments);};return r;});
