/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.loader.config({shim:{'sap/ui/codeeditor/js/ace/ace':{exports:'ace'},'sap/ui/codeeditor/js/ace/ext-language_tools':{deps:['sap/ui/codeeditor/js/ace/ace']},'sap/ui/codeeditor/js/ace/ext-beautify':{deps:['sap/ui/codeeditor/js/ace/ace']},'sap/ui/codeeditor/js/ace/mode-javascript':{deps:['sap/ui/codeeditor/js/ace/ace']},'sap/ui/codeeditor/js/ace/mode-json':{deps:['sap/ui/codeeditor/js/ace/ace']}}});sap.ui.define(["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/RenderManager","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/thirdparty/jquery","sap/ui/codeeditor/js/ace/ace","sap/ui/codeeditor/js/ace/ext-language_tools","sap/ui/codeeditor/js/ace/ext-beautify","sap/ui/codeeditor/js/ace/mode-javascript","sap/ui/codeeditor/js/ace/mode-json"],function(l,C,a,R,b,D,q,c){"use strict";var d=a.extend("sap.ui.codeeditor.CodeEditor",{metadata:{library:"sap.ui.core",properties:{value:{type:"string",group:"Misc",defaultValue:""},type:{type:"string",group:"Appearance",defaultValue:"javascript"},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},editable:{type:"boolean",group:"Behavior",defaultValue:true},lineNumbers:{type:"boolean",group:"Behavior",defaultValue:true},valueSelection:{type:"boolean",group:"Behavior",defaultValue:false},maxLines:{type:"int",group:"Behavior",defaultValue:0},colorTheme:{type:"string",group:"Behavior",defaultValue:"default"},syntaxHints:{type:"boolean",group:"Behavior",defaultValue:true}},events:{liveChange:{parameters:{value:{type:"string"},editorEvent:{type:"object"}}},change:{parameters:{value:{type:"string"},oldValue:{type:"string"}}}},defaultProperty:"content"},renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o).class("sapCEd").style("width",o.getWidth()).style("height",o.getHeight()).attr("data-sap-ui-syntaxhints",o.getSyntaxHints()).attr("role","application").attr("aria-roledescription",C.getLibraryResourceBundle("sap.ui.codeeditor").getText("CODEEDITOR_ROLE_DESCRIPTION"));var t=o.getTooltip_AsString();if(t){r.attr("title",t);}r.openEnd();r.close("div");}}});var p=sap.ui.require.toUrl("sap/ui/codeeditor/js/ace");c.config.set("basePath",p);var L=c.require("ace/ext/language_tools");d.prototype.init=function(){this._bIsRenderingPhase=false;this._oEditorDomRef=document.createElement("div");this._oEditorDomRef.style.height="100%";this._oEditorDomRef.style.width="100%";this._oEditor=c.edit(this._oEditorDomRef);var s=this._oEditor.getSession();s.setUseWorker(false);s.setValue("");s.setUseWrapMode(true);s.setMode("ace/mode/javascript");var u=C.getConfiguration().getTheme().toLowerCase();var e="tomorrow";if(u.indexOf("hcb")>-1){e="chaos";}else if(u.indexOf("hcw")>-1){e="github";}else if(u==="sap_fiori_3"){e="crimson_editor";}else if(u==="sap_fiori_3_dark"){e="clouds_midnight";}this._oEditor.setTheme("ace/theme/"+e);this._oEditor.setOptions({enableBasicAutocompletion:true,enableSnippets:true,enableLiveAutocompletion:true});this._oEditor.renderer.setShowGutter(true);this._oEditor.addEventListener("change",function(E){if(!this.getEditable()){return;}var v=this.getCurrentValue();this.fireLiveChange({value:v,editorEvent:E});}.bind(this));this._oEditor.addEventListener("blur",function(){if(this._bIsRenderingPhase){return;}var v=this.getCurrentValue(),f=this.getValue();this.setProperty("value",v,true);if(v!=f&&this.getEditable()){this.fireChange({value:v,oldValue:f});}}.bind(this));this._oEditor.addEventListener("showGutterTooltip",function(t){if(D.browser.internet_explorer){return;}var $=q(t.$element),f=$.parents(".sapMDialog");if(f&&f.css("transform")){var m=f.position();$.css("transform","translate(-"+m.left+"px, -"+m.top+"px)");}});};d.prototype.exit=function(){this._deregisterResizeListener();this._oEditor.destroy();q(this._oEditorDomRef).remove();this._oEditorDomRef=null;this._oEditor=null;};d.prototype.onBeforeRendering=function(){this._bIsRenderingPhase=true;var o=this.getDomRef();if(o&&!R.isPreservedContent(o)){R.preserveContent(o);}this._deregisterResizeListener();};d.prototype.onAfterRendering=function(){this._bIsRenderingPhase=false;var o=this.getDomRef(),P=this.getMetadata().getPropertyDefaults();setTimeout(function(){if(this.getMaxLines()===P.maxLines&&this.getHeight()===P.height&&o.height<20){o.style.height="3rem";}}.bind(this),0);o.appendChild(this._oEditorDomRef);var e=this.getEditable();this._oEditor.setReadOnly(!e);if(e){this._oEditor.renderer.$cursorLayer.element.style.display="";}else{this._oEditor.renderer.$cursorLayer.element.style.display="none";}this._oEditor.getSession().setMode("ace/mode/"+this.getType());this._oEditor.setOption("maxLines",this.getMaxLines());this._oEditor.renderer.setShowGutter(this.getLineNumbers());this._oEditor.getSession().setValue(this.getValue());if(!this.getValueSelection()){this._oEditor.selection.clearSelection();}this._oEditor.renderer.updateText();this._oEditor.resize();this._registerResizeListener();};d.prototype._registerResizeListener=function(){if(!this._iResizeListenerId){this._iResizeListenerId=b.register(this._oEditorDomRef,function(){this._oEditor.resize();}.bind(this));}};d.prototype._deregisterResizeListener=function(){if(this._iResizeListenerId){b.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}};d.prototype.focus=function(){this._oEditor.focus();return this;};d.prototype.setColorTheme=function(t){this.setProperty("colorTheme",t,true);if(t==="default"){t="tomorrow";}else if(t==="hcb"){t="tomorrow_night";}else if(t==="hcb_bright"){t="tomorrow_night_bright";}else if(t==="hcb_blue"){t="tomorrow_night_blue";}this._oEditor.setTheme("ace/theme/"+t);return this;};d.prototype.getCurrentValue=function(){return this._oEditor.getValue();};d.prototype.addCustomCompleter=function(o){L.addCompleter({getCompletions:function(e,s,P,f,g){o.getCompletions(g,{oPos:P,sPrefix:f});}});};d.prototype._getEditorInstance=function(){return this._oEditor;};d.prototype.prettyPrint=function(){c.require("ace/ext/beautify").beautify(this._oEditor.session);};d.prototype.destroy=function(s){this._oEditor.destroy(s);a.prototype.destroy.call(this,s);};d.prototype.onfocusout=function(){this._oEditor.getSession().setUseWorker(false);};d.prototype.onfocusin=function(){this._oEditor.getSession().setUseWorker(true);};return d;});
