/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./BindingParser','./DataType','./EventProvider','./ManagedObjectMetadata','./Object','../model/BindingMode','../model/StaticBinding','../model/CompositeBinding','../model/Context','../model/FormatException','../model/ParseException','../model/Type','../model/ValidateException',"sap/ui/base/SyncPromise","sap/ui/util/ActivityDetection","sap/base/util/ObjectPath","sap/base/Log","sap/base/assert","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/uid","sap/base/util/extend","sap/base/util/isEmptyObject"],function(B,D,E,M,d,e,S,C,f,F,P,T,V,g,A,O,L,h,j,k,u,m,o){"use strict";var I;var p=E.extend("sap.ui.base.ManagedObject",{metadata:{"abstract":true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{"validationSuccess":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"validationError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"parseError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"formatError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"modelContextChange":{}},specialSettings:{id:'sap.ui.core.ID',models:'object',bindingContexts:'object',objectBindings:'object',metadataContexts:'object',Type:{type:'string',visibility:'hidden'}}},constructor:function(i,a,b){var c=this;E.call(this);if(typeof i!=='string'&&i!==undefined){b=a;a=i;i=a&&a.id;}if(!i){i=this.getMetadata().uid();}else{var l=p._fnIdPreprocessor;i=(l?l.call(this,i):i);var n=I||(I=D.getType("sap.ui.core.ID"));if(!n.isValid(i)){throw new Error("\""+i+"\" is not a valid ID.");}}this.sId=i;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=p._oEmptyPropagatedProperties;this.mSkipPropagation={};this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=p._defaultContextualSettings;this._sOwnerId=p._sOwnerId;(function(){var v=false;if(c.register){c.register();}try{if(c._initCompositeSupport){c._initCompositeSupport(a);}if(c.init){c.init();}c.applySettings(a,b);v=true;}finally{if(!v&&c.deregister){c.deregister();}}}());}},M);p.create=function(v,K,a){if(!v||v instanceof p||typeof v!=="object"||v instanceof String){return v;}function b(l){if(typeof l==="function"){return l;}if(typeof l==="string"){return O.get(l);}}var c=b(v.Type)||b(K&&K.type);if(typeof c==="function"){return new c(v,a);}var i="Don't know how to create a ManagedObject from "+v+" ("+(typeof v)+")";L.fatal(i);throw new Error(i);};var q;function r(i){if(!q){q=sap.ui.require("sap/ui/core/StashedControlSupport");}if(q){return q.getStashedControls(i);}return[];}p._fnIdPreprocessor=null;p._fnSettingsPreprocessor=null;p.runWithPreprocessors=function(a,b,c){h(typeof a==="function","fn must be a function");h(!b||typeof b==="object","oPreprocessors must be an object");var i={id:this._fnIdPreprocessor,settings:this._fnSettingsPreprocessor};b=b||{};this._fnIdPreprocessor=b.id;this._fnSettingsPreprocessor=b.settings;try{return a.call(c);}finally{this._fnIdPreprocessor=i.id;this._fnSettingsPreprocessor=i.settings;}};p.prototype.applySettings=function(a,b){if(!a||o(a)){return this;}var c=this,n=this.getMetadata(),v=n.getJSONKeys(),w=p.create,x=p._fnSettingsPreprocessor,K,y,z;function G(Q){for(var i=0,R=Q.length;i<R;i++){var U=Q[i];if(Array.isArray(U)){G(U);}else{c[z._sMutator](w(U,z,b));}}}function H(Q){c[z._sMutator](Q[0],Q[1],Q[2]);}function J(Q){var R=D.getType(Q),U=R&&R.getPrimitiveType().getName();return U==="object"||U==="any";}x&&x.call(this,a);if(a.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(a.metadataContexts,a);}if(a.models){if(typeof a.models!=="object"){throw new Error("models must be a simple object");}if(d.isA(a.models,"sap.ui.model.Model")){this.setModel(a.models);}else{for(K in a.models){this.setModel(a.models[K],K==="undefined"?undefined:K);}}}if(a.bindingContexts){if(typeof a.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object");}if(a.bindingContexts instanceof f){this.setBindingContext(a.bindingContexts);}else{for(K in a.bindingContexts){this.setBindingContext(a.bindingContexts[K],K==="undefined"?undefined:K);}}}if(a.objectBindings){if(typeof a.objectBindings!=="string"&&typeof a.objectBindings!=="object"){throw new Error("binding must be a string or simple object");}if(typeof a.objectBindings==="string"||a.objectBindings.path){this.bindObject(a.objectBindings);}else{for(var K in a.objectBindings){a.objectBindings.model=K;this.bindObject(a.objectBindings[K]);}}}for(K in a){y=a[K];if((z=v[K])!==undefined){var N;switch(z._iKind){case 0:N=this.extractBindingInfo(y,b,!J(z.type));if(N&&typeof N==="object"){this.bindProperty(K,N);}else{this[z._sMutator](N||y);}break;case 1:N=z.altTypes&&this.extractBindingInfo(y,b,!z.altTypes.some(J));if(N&&typeof N==="object"){this.bindProperty(K,N);}else{if(Array.isArray(y)){if(y.length>1){L.error("Tried to add an array of controls to a single aggregation");}y=y[0];}this[z._sMutator](w(N||y,z,b));}break;case 2:N=this.extractBindingInfo(y,b);if(N&&typeof N==="object"){this.bindAggregation(K,N);}else{y=N||y;if(y){if(Array.isArray(y)){G(y);}else{c[z._sMutator](w(y,z,b));}}}break;case 3:this[z._sMutator](y);break;case 4:if(y){if(Array.isArray(y)){for(var i=0,l=y.length;i<l;i++){this[z._sMutator](y[i]);}}else{this[z._sMutator](y);}}break;case 5:if(typeof y=="function"){this[z._sMutator](y);}else if(Array.isArray(y[0])&&(y.length<=1||Array.isArray(y[1]))){y.forEach(H);}else{H(y);}break;case-1:default:break;}}else{h(false,"ManagedObject.apply: encountered unknown setting '"+K+"' for class '"+n.getName()+"' (value:'"+y+"')");}}return this;};p.escapeSettingsValue=function(v){return(typeof v==="string")?p.bindingParser.escape(v):v;};p.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId();};p.prototype.getId=function(){return this.sId;};p.prototype.setProperty=function(a,v,b){var c=this.mProperties[a];v=this.validateProperty(a,v);if(k(c,v)){this.mProperties[a]=v;return this;}if(b){A.refresh();}this.mProperties[a]=v;if(!b&&!this.isInvalidateSuppressed()){this.invalidate();}this.updateModelProperty(a,v,c);v=this.mProperties[a];if(this.mEventRegistry["_change"]){E.prototype.fireEvent.call(this,"_change",{"id":this.getId(),"name":a,"oldValue":c,"newValue":v});}if(this._observer){this._observer.propertyChange(this,a,c,v);}return this;};p.prototype.getProperty=function(a){var v=this.mProperties[a],b=this.getMetadata().getManagedProperty(a),c;if(!b){throw new Error("Property \""+a+"\" does not exist in "+this);}c=D.getType(b.type);if(c instanceof D&&c.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v instanceof String){v=v.valueOf();}if(b.byValue){v=j(v);}return v;};p.prototype.validateProperty=function(a,v){var b=this.getMetadata().getManagedProperty(a),c;if(!b){throw new Error("Property \""+a+"\" does not exist in "+this);}c=D.getType(b.type);if(c instanceof D&&c.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v==null){v=b.getDefaultValue();}else if(c instanceof D){if(c.getName()=="string"){if(!(typeof v=="string"||v instanceof String)){v=""+v;}}else if(c.getName()=="string[]"){if(typeof v=="string"){v=[v];}if(!Array.isArray(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected string[]"+" for property \""+a+"\" of "+this);}for(var i=0;i<v.length;i++){if(typeof v[i]!=="string"){v[i]=""+v[i];}}}else if(!c.isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+c.getName()+" for property \""+a+"\" of "+this);}}if(b.byValue){v=j(v);}if(c&&c.normalize&&typeof c.normalize==="function"){v=c.normalize(v);}return v;};p.prototype.isPropertyInitial=function(a){return!Object.prototype.hasOwnProperty.call(this.mProperties,a)&&!this.isBound(a);};p.prototype.resetProperty=function(a){if(this.mProperties.hasOwnProperty(a)){var b=this.getMetadata().getManagedProperty(a);b.set(this,null);if(this.mProperties[a]===b.getDefaultValue()){delete this.mProperties[a];}}return this;};p.prototype.getOriginInfo=function(a){var v=this.mProperties[a];if(!(v instanceof String&&v.originInfo)){return null;}return v.originInfo;};p.prototype.setAssociation=function(a,i,b){if(i instanceof p){i=i.getId();}else if(i!=null&&typeof i!=="string"){h(false,"setAssociation(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");return this;}if(this.mAssociations[a]===i){return this;}if(b){this.iSuppressInvalidate++;}if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"remove",this.mAssociations[a]);}this.mAssociations[a]=i;if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return this;};p.prototype.getAssociation=function(a,b){var c=this.mAssociations[a];if(!c){c=this.mAssociations[a]=b||null;}else{if(typeof c.length==='number'&&!(c.propertyIsEnumerable('length'))){return c.slice();}return c;}return c;};p.prototype.addAssociation=function(a,i,b){if(i instanceof p){i=i.getId();}else if(typeof i!=="string"){h(false,"addAssociation(): sId must be a string or an instance of sap.ui.base.ManagedObject");return this;}if(b){this.iSuppressInvalidate++;}var c=this.mAssociations[a];if(!c){c=this.mAssociations[a]=[i];}else{c.push(i);}if(this._observer){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return this;};p.prototype.removeAssociation=function(a,v,b){var c=this.mAssociations[a];var l=null;if(!c){return null;}if(b){this.iSuppressInvalidate++;}if(typeof(v)=="object"&&v.getId){v=v.getId();}if(typeof(v)=="string"){for(var i=0;i<c.length;i++){if(c[i]==v){v=i;break;}}}if(typeof(v)=="number"){if(v<0||v>=c.length){L.warning("ManagedObject.removeAssociation called with invalid index: "+a+", "+v);}else{l=c[v];c.splice(v,1);if(this._observer){this._observer.associationChange(this,a,"remove",l);}if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(b){this.iSuppressInvalidate--;}return l;};p.prototype.removeAllAssociation=function(a,b){var i=this.mAssociations[a];if(!i){return[];}delete this.mAssociations[a];if(!i.length){return i;}if(b){this.iSuppressInvalidate++;}if(this._observer){this._observer.associationChange(this,a,"remove",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return i;};p.prototype.validateAggregation=function(a,b,c,l){var n=this.getMetadata(),v=n.getManagedAggregation(a),w,x,i,y;if(!v){throw new Error("Aggregation \""+a+"\" does not exist in "+this);}if(v.multiple!==c){throw new Error("Aggregation '"+a+"' of "+this+" used with wrong cardinality (declared as "+(v.multiple?"0..n":"0..1")+")");}var z=n.getAggregationForwarder(a);if(z&&!l){z.getTarget(this).validateAggregation(z.targetAggregationName,b,c);}if(!v.multiple&&!b){return b;}if(b instanceof d&&b.isA(v.type)){return b;}w=v.altTypes;if(w&&w.length){if(b==null){return b;}for(i=0;i<w.length;i++){x=D.getType(w[i]);if(x instanceof D){if(x.isValid(b)){return b;}}}}x=O.get(v.type);if(typeof x==="function"&&b instanceof x){return b;}y="\""+b+"\" is not valid for aggregation \""+a+"\" of "+this;if(D.isInterfaceType(v.type)){h(false,y);return b;}else{throw new Error(y);}};p.prototype.setAggregation=function(a,b,c){var i=this.getMetadata().getAggregationForwarder(a);if(i){b=this.validateAggregation(a,b,false,true);return i.set(this,b);}var l=this.mAggregations[a];if(l===b){return this;}b=this.validateAggregation(a,b,false);if(c){this.iSuppressInvalidate++;}this.mAggregations[a]=null;if(l instanceof p){l.setParent(null);}else{if(this._observer!=null&&l!=null){this._observer.aggregationChange(this,a,"remove",l);}}this.mAggregations[a]=b;if(b instanceof p){b.setParent(this,a,c);}else{if(!this.isInvalidateSuppressed()){this.invalidate();}if(this._observer!=null&&b!=null){this._observer.aggregationChange(this,a,"insert",b);}}if(c){this.iSuppressInvalidate--;}return this;};p.prototype.getAggregation=function(a,b){var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.get(this);}var i=this.mAggregations[a];if(!i){i=this.mAggregations[a]=b||null;}if(i){if(typeof i.length==='number'&&!(i.propertyIsEnumerable('length'))){return i.slice();}return i;}else{return null;}};p.prototype.indexOfAggregation=function(a,b){var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.indexOf(this,b);}var l=this.mAggregations[a];if(l){if(l.length==undefined){return-2;}for(var i=0;i<l.length;i++){if(l[i]==b){return i;}}}return-1;};p.prototype.insertAggregation=function(a,b,c,l){if(!b){return this;}b=this.validateAggregation(a,b,true,true);var n=this.getMetadata().getAggregationForwarder(a);if(n){return n.insert(this,b,c);}var v=this.mAggregations[a]||(this.mAggregations[a]=[]);var i;if(c<0){i=0;}else if(c>v.length){i=v.length;}else{i=c;}if(i!==c){L.warning("ManagedObject.insertAggregation: index '"+c+"' out of range [0,"+v.length+"], forced to "+i);}v.splice(i,0,b);b.setParent(this,a,l);return this;};p.prototype.addAggregation=function(a,b,c){if(!b){return this;}b=this.validateAggregation(a,b,true,true);var i=this.getMetadata().getAggregationForwarder(a);if(i){return i.add(this,b);}var l=this.mAggregations[a];if(!l){l=this.mAggregations[a]=[b];}else{l.push(b);}b.setParent(this,a,c);return this;};p.prototype.removeAggregation=function(a,v,b){var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.remove(this,v);}var l=this.mAggregations[a],n=null,i;if(!l){return null;}if(b){this.iSuppressInvalidate++;}if(typeof(v)=="string"){for(i=0;i<l.length;i++){if(l[i]&&l[i].getId()===v){v=i;break;}}}if(typeof(v)=="object"){for(i=0;i<l.length;i++){if(l[i]==v){v=i;break;}}}if(typeof(v)=="number"){if(v<0||v>=l.length){L.warning("ManagedObject.removeAggregation called with invalid index: "+a+", "+v);}else{n=l[v];l.splice(v,1);n.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(b){this.iSuppressInvalidate--;}return n;};p.prototype.removeAllAggregation=function(a,b){var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.removeAll(this);}var l=this.mAggregations[a];if(!l){return[];}delete this.mAggregations[a];if(!l.length){return l;}if(b){this.iSuppressInvalidate++;}for(var i=0;i<l.length;i++){l[i].setParent(null);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return l;};p.prototype.destroyAggregation=function(a,b){var l=this.getMetadata().getAggregationForwarder(a);if(l){return l.destroy(this);}var n=this.mAggregations[a],i,v;r(this.getId()).forEach(function(c){if(c.sParentAggregationName===a){c.destroy();}});if(!n){return this;}delete this.mAggregations[a];if(Array.isArray(n)&&!n.length){return this;}if(b){this.iSuppressInvalidate++;}if(n instanceof p){n.destroy(b);if(this._observer){this._observer.aggregationChange(this,a,"remove",n);}}else if(Array.isArray(n)){for(i=n.length-1;i>=0;i--){v=n[i];if(v){v.destroy(b);if(this._observer){this._observer.aggregationChange(this,a,"remove",v);}}}}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return this;};p.prototype.invalidate=function(){if(this.oParent){this.oParent.invalidate(this);}};p.prototype.isInvalidateSuppressed=function(){var i=this.iSuppressInvalidate>0;if(this.oParent&&this.oParent instanceof p){i=i||this.oParent.isInvalidateSuppressed();}return i;};p.prototype._removeChild=function(c,a,b){if(!a){L.error("Cannot remove aggregated child without aggregation name.",null,this);}else{if(b){this.iSuppressInvalidate++;}var i=this.indexOfAggregation(a,c);var l=this.getMetadata().getAggregation(a);if(i==-2){if(l&&this[l._sMutator]){this[l._sMutator](null);}else{this.setAggregation(a,null,b);}}else if(i>-1){if(l&&this[l._sRemoveMutator]){this[l._sRemoveMutator](i);}else{this.removeAggregation(a,i,b);}}if(b){this.iSuppressInvalidate--;}}};function s(a,b){while(a&&a!==b){a=a.oParent;}return!!a;}p.prototype.setParent=function(a,b,c){h(a==null||a instanceof p,"oParent either must be null, undefined or a ManagedObject");var i;if(!a){if(this.oParent){i=this._observer||this.oParent._observer;if(i){i.parentChange(this,this.sParentAggregationName,"unset",this.oParent);}if(this.aAPIParentInfos&&this.aAPIParentInfos.forwardingCounter===0){delete this.aAPIParentInfos;}}this.oParent=null;this.sParentAggregationName=null;var l=p._oEmptyPropagatedProperties;if(l!==this.oPropagatedProperties){this.oPropagatedProperties=l;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange();}}.bind(this));}}this._oContextualSettings=p._defaultContextualSettings;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this._propagateContextualSettings();}}.bind(this));}A.refresh();return;}if(s(a,this)){throw new Error("Cycle detected: new parent '"+a+"' is already a descendant of (or equal to) '"+this+"'");}if(c){A.refresh();this.iSuppressInvalidate++;}var n=this.getParent();if(n){n._removeChild(this,this.sParentAggregationName);}this.oParent=a;this.sParentAggregationName=b;if(!a.mSkipPropagation[b]){var l=this.aAPIParentInfos?this.aAPIParentInfos[0].parent._getPropertiesToPropagate():a._getPropertiesToPropagate();if(l!==this.oPropagatedProperties){this.oPropagatedProperties=l;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);}this._callPropagationListener();this.fireModelContextChange();}}this._applyContextualSettings(a._oContextualSettings);if(a&&!this.isInvalidateSuppressed()){a.invalidate(this);}if(c){this.iSuppressInvalidate--;}i=this._observer||this.oParent._observer;if(i){i.parentChange(this,b,"set",this.oParent);}return this;};p.prototype._applyContextualSettings=function(c){if(this._oContextualSettings!==c){this._oContextualSettings=c;this._propagateContextualSettings();this._onContextualSettingsChanged();}};p.prototype._onContextualSettingsChanged=function(){};p.prototype._propagateContextualSettings=function(){var a=this._oContextualSettings,b,c,i;for(b in this.mAggregations){c=this.mAggregations[b];if(c instanceof p){c._applyContextualSettings(a);}else if(c instanceof Array){for(i=0;i<c.length;i++){if(c[i]instanceof p){c[i]._applyContextualSettings(a);}}}}};p.prototype._getContextualSettings=function(){return this._oContextualSettings;};p.prototype.getParent=function(){return this.oParent;};p.prototype.destroy=function(b){var n;if(this.bIsDestroyed){return;}var a=this;this._bIsBeingDestroyed=true;if(b){this.iSuppressInvalidate++;}if(this.exit){this.exit();}if(this._exitCompositeSupport){this._exitCompositeSupport();}for(var i in this.mAggregations){this.destroyAggregation(i,b);}r(this.getId()).forEach(function(c){c.destroy();});if(this.deregister){this.deregister();}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,b);}delete this.oParent;for(n in this.mBindingInfos){if(this.mBindingInfos[n].factory){this.unbindAggregation(n,true);}else{this.unbindProperty(n,true);}}for(n in this.mObjectBindingInfos){this.unbindObject(n,true);}if(b){this.iSuppressInvalidate--;}if(this._observer){this._observer.objectDestroyed(this);}if(this.aAPIParentInfos){this.aAPIParentInfos=null;}E.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+a.getId()+" was destroyed and cannot be used anymore.");};this.bIsDestroyed=true;};p.bindingParser=B.simpleParser;p.prototype.isBinding=function(v,K){return typeof this.extractBindingInfo(v)==="object";};p.prototype.extractBindingInfo=function(v,a,b){if(v&&typeof v==="object"){if(v.ui5object){delete v.ui5object;}else if(v.path!=undefined||v.parts||(b&&v.value!=undefined)){if(v.template){v.template=p.create(v.template);}return v;}}if(typeof v==="string"){return p.bindingParser(v,a,true);}};p.prototype.getBindingInfo=function(n){var a=this.getMetadata().getAggregationForwarder(n);if(a&&a.forwardBinding){return a.getTarget(this).getBindingInfo(a.targetAggregationName);}return this.mBindingInfos[n];};p.prototype.bindObject=function(b){var a,c,i;if(typeof b=="string"){c=b;b={path:c,parameters:arguments[1]};}else{c=b.path;}i=c.indexOf(">");if(i>0){b.model=c.substr(0,i);b.path=c.substr(i+1);}a=b.model;if(this.mObjectBindingInfos[a]){this.unbindObject(a,true);}this.mObjectBindingInfos[a]=b;if(this.getModel(a)){this._bindObject(b);}return this;};p.prototype._bindObject=function(b){var a,c,i,l,n=this;var v=function(x){n.setElementBindingContext(a.getBoundContext(),i);};var w=function(x){var y=a.getDataState();if(!y){return;}if(n.refreshDataState){n.refreshDataState('',y);}};i=b.model;l=this.getModel(i);c=this.getBindingContext(i);a=l.bindContext(b.path,c,b.parameters);if(b.suspended){a.suspend(true);}a.attachChange(v);b.binding=a;b.modelChangeHandler=v;b.dataStateChangeHandler=w;a.attachEvents(b.events);if(this.refreshDataState){a.attachAggregatedDataStateChange(w);}a.initialize();};p.prototype.unbindObject=function(a,b){var c=this.mObjectBindingInfos[a];if(c){if(c.binding){c.binding.detachChange(c.modelChangeHandler);c.binding.detachEvents(c.events);if(this.refreshDataState){c.binding.detachAggregatedDataStateChange(c.dataStateChangeHandler);}c.binding.destroy();}delete this.mObjectBindingInfos[a];delete this.mElementBindingContexts[a];if(!b){this.updateBindingContext(false,a);this.propagateProperties(a);this.fireModelContextChange();}}return this;};p.prototype.bindContext=function(a){return this.bindObject(a);};p.prototype.unbindContext=function(a){return this.unbindObject(a);};p.prototype.bindProperty=function(n,b,a,c){var l,v=true,w=this.getMetadata().getPropertyLikeSetting(n);if(!w){throw new Error("Property \""+n+"\" does not exist in "+this);}if(typeof b=="string"){b={parts:[{path:b,type:a instanceof T?a:undefined,mode:c}],formatter:typeof a==='function'?a:undefined};}if(!b.parts){b.parts=[];b.parts[0]={path:b.path,targetType:b.targetType,type:b.type,suspended:b.suspended,formatOptions:b.formatOptions,constraints:b.constraints,model:b.model,mode:b.mode,value:b.value};delete b.path;delete b.targetType;delete b.mode;delete b.model;delete b.value;}for(var i=0;i<b.parts.length;i++){var x=b.parts[i];if(typeof x=="string"){x={path:x};b.parts[i]=x;}if(x.path!==undefined){l=x.path.indexOf(">");if(l>0){x.model=x.path.substr(0,l);x.path=x.path.substr(l+1);}}if(b.formatter&&x.mode!=e.OneWay&&x.mode!=e.OneTime){x.mode=e.OneWay;}if(x.value===undefined&&!this.getModel(x.model)){v=false;}}b.skipPropertyUpdate=0;b.skipModelUpdate=0;if(this.isBound(n)){this.unbindProperty(n,true);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"property");}if(v){this._bindProperty(n,b);}return this;};p.prototype._bindProperty=function(n,b){var a,c,i,l,v=e.TwoWay,w,x,y=this.getMetadata().getPropertyLikeSetting(n),z=y._iKind===0?y.type:y.altTypes[0],G=this,H=[],J=function(N){G.updateProperty(n);var Q=i.getDataState();if(Q){var R=Q.getControlMessages();if(R&&R.length>0){var U=sap.ui.getCore().getMessageManager();Q.setControlMessages([]);if(R){U.removeMessages(R);}}Q.setInvalidValue(undefined);}if(i.getBindingMode()===e.OneTime&&i.isResolved()){i.detachChange(J);if(this.refreshDataState){i.detachAggregatedDataStateChange(K);}i.detachEvents(b.events);}},K=function(){var N=i.getDataState();if(!N){return;}if(G.refreshDataState){G.refreshDataState(n,N);}};b.parts.forEach(function(N){c=G.getBindingContext(N.model);a=G.getModel(N.model);w=N.type;if(typeof w=="string"){x=O.get(w);if(typeof x!=="function"){throw new Error("Cannot find type \""+w+"\" used in control \""+G.getId()+"\"!");}w=new x(N.formatOptions,N.constraints);}if(N.value!==undefined){i=new S(N.value);}else{i=a.bindProperty(N.path,c,N.parameters||b.parameters);}i.setType(w,N.targetType||z);i.setFormatter(N.formatter);if(N.suspended){i.suspend(true);}l=N.mode||(a&&a.getDefaultBindingMode())||e.TwoWay;i.setBindingMode(l);if(l!==e.TwoWay){v=e.OneWay;}H.push(i);});if(H.length>1||(b.formatter&&b.formatter.textFragments)){w=b.type;if(typeof w=="string"){x=O.get(w);w=new x(b.formatOptions,b.constraints);}i=new C(H,b.useRawValues,b.useInternalValues);i.setType(w,b.targetType||z);i.setBindingMode(b.mode||v);}else{i=H[0];}i.attachChange(J);if(this.refreshDataState){i.attachAggregatedDataStateChange(K);}if(typeof b.formatter==="function"){i.setFormatter(b.formatter.bind(this));}b.binding=i;b.modelChangeHandler=J;b.dataStateChangeHandler=K;i.attachEvents(b.events);i.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"property");}};p.prototype.unbindProperty=function(n,b){var a=this.mBindingInfos[n],c;if(a){c=a.binding;if(c){c.detachChange(a.modelChangeHandler);c.detachEvents(a.events);c.destroy();if(this.refreshDataState){c.detachAggregatedDataStateChange(a.dataStateChangeHandler);}}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"property");}delete this.mBindingInfos[n];if(!b){this.resetProperty(n);}}return this;};p.prototype.updateProperty=function(n){var b=this.mBindingInfos[n],a=b.binding,c=this.getMetadata().getPropertyLikeSetting(n),i=this;function l(v){if(v instanceof F){i.fireFormatError({element:i,property:n,type:a.getType(),newValue:a.getValue(),oldValue:i[c._sGetter](),exception:v,message:v.message},false,true);L.error("FormatException in property '"+n+"' of '"+i+"': "+v.message+"\nHint: single properties referenced in composite bindings and within binding expressions are automatically converted "+"into the type of the bound control property, unless a different 'targetType' is specified. targetType:'any' may avoid "+"the conversion and lead to the expected behavior.");b.skipModelUpdate++;i.resetProperty(n);b.skipModelUpdate--;}else{throw v;}}if(b.skipPropertyUpdate){return;}g.resolve().then(function(){return a.getExternalValue();}).then(function(v){b.skipModelUpdate++;i[c._sMutator](v);b.skipModelUpdate--;}).catch(function(v){l(v);}).unwrap();};p.prototype.updateModelProperty=function(n,v,a){var b,c,i=this;function l(x){var y={element:i,property:n,type:c.getType(),newValue:v,oldValue:a,exception:x,message:x.message};if(x instanceof P){i.fireParseError(y,false,true);}else if(x instanceof V){i.fireValidationError(y,false,true);}else{throw x;}}function w(){var x={element:i,property:n,type:c.getType(),newValue:v,oldValue:a};if(c.hasValidation()){i.fireValidationSuccess(x,false,true);}}if(this.isBound(n)){var b=this.mBindingInfos[n],c=b.binding;if(b.skipModelUpdate||(c&&c.isSuspended())){return;}if(c&&c.getBindingMode()==e.TwoWay){b.skipPropertyUpdate++;g.resolve(v).then(function(v){return c.setExternalValue(v);}).then(function(){b.skipPropertyUpdate--;return c.getExternalValue();}).then(function(x){if(v!=x){i.updateProperty(n);}w();}).catch(function(x){b.skipPropertyUpdate--;l(x);}).unwrap();}}};var t=1;p.prototype.bindAggregation=function(n,b){var a,c,i,l,v=this.getMetadata(),w=v.getAggregation(n);if(!w){throw new Error("Aggregation \""+n+"\" does not exist in "+this);}if(!w.multiple){L.error("Binding of single aggregation \""+n+"\" of "+this+" is not supported!");}if(typeof b=="string"){a=arguments[1];c=arguments[2];i=arguments[3];l=arguments[4];b={path:a,sorter:i,filters:l};if(c instanceof p){b.template=c;}else if(typeof c==="function"){b.factory=c;}}var x=v.getAggregationForwarder(n);if(x&&x.forwardBinding){x.getTarget(this).bindAggregation(x.targetAggregationName,b);return this;}if(this.isBound(n)){this.unbindAggregation(n);}if(!(b.template||b.factory)){if(w._doesNotRequireFactory){b.factory=function(){throw new Error("dummy factory called unexpectedly ");};}else{throw new Error("Missing template or factory function for aggregation "+n+" of "+this+" !");}}if(b.template){if(b.template._sapui_candidateForDestroy){L.warning("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+n+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete b.template._sapui_candidateForDestroy;}if(b.templateShareable===undefined){b.templateShareable=t;}b.factory=function(z){return b.template.clone(z);};}var y=b.path.indexOf(">");if(y>0){b.model=b.path.substr(0,y);b.path=b.path.substr(y+1);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"aggregation");}if(this.getModel(b.model)){this._bindAggregation(n,b);}return this;};p.prototype._bindAggregation=function(n,b){var a=this,c,i=this.getMetadata().getAggregation(n),l=function(y){i.update(a,y.getParameter("reason"),{detailedReason:y.getParameter("detailedReason")});},v=function(y){i.refresh(a,y.getParameter("reason"));},w=function(y){var z=c.getDataState();if(!z){return;}if(a.refreshDataState){a.refreshDataState(n,z);}};var x=this.getModel(b.model);if(this.isTreeBinding(n)){c=x.bindTree(b.path,this.getBindingContext(b.model),b.filters,b.parameters,b.sorter);}else{c=x.bindList(b.path,this.getBindingContext(b.model),b.sorter,b.filters,b.parameters);if(this.bUseExtendedChangeDetection){h(!this.oExtendedChangeDetectionConfig||!this.oExtendedChangeDetectionConfig.symbol,"symbol function must not be set by controls");c.enableExtendedChangeDetection(!b.template,b.key,this.oExtendedChangeDetectionConfig);}}if(b.suspended){c.suspend(true);}b.binding=c;b.modelChangeHandler=l;b.modelRefreshHandler=v;b.dataStateChangeHandler=w;c.attachChange(l);c.attachRefresh(v);c.attachEvents(b.events);if(this.refreshDataState){c.attachAggregatedDataStateChange(w);}c.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"aggregation");}};p.prototype.unbindAggregation=function(n,b){var a=this.getMetadata().getAggregationForwarder(n);if(a&&a.forwardBinding){a.getTarget(this).unbindAggregation(a.targetAggregationName,b);return this;}var c=this.mBindingInfos[n],i=this.getMetadata().getAggregation(n);if(c){if(c.binding){c.binding.detachChange(c.modelChangeHandler);c.binding.detachRefresh(c.modelRefreshHandler);c.binding.detachEvents(c.events);if(this.refreshDataState){c.binding.detachAggregatedDataStateChange(c.dataStateChangeHandler);}c.binding.destroy();}if(c.template){if(!c.templateShareable&&c.template.destroy){c.template.destroy();}if(c.templateShareable===t){c.template._sapui_candidateForDestroy=true;}}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"aggregation");}delete this.mBindingInfos[n];if(!b){this[i._sDestructor]();}}return this;};p.prototype.updateAggregation=function(n,c,a){var b=this.mBindingInfos[n],l=b.binding,v=b.factory,w=this.getMetadata().getAggregation(n),G,x,y,z=w._sMutator+"Group",H=this;function J(i,U){if(H.bUseExtendedChangeDetection){return M.uid('clone');}else{return i.getId()+"-"+U;}}function K(U,y,W,X){var Y=U[w._sGetter]()||[],Z,$;if(Y.length>y.length){for(var i=y.length;i<Y.length;i++){$=Y[i];U[w._sRemoveMutator]($);$.destroy("KeepDom");}}for(var i=0;i<y.length;i++){Z=y[i];$=Y[i];if(W){W(Z);}if($){$.setBindingContext(Z,b.model);}else{$=v(J(U,i),Z);$.setBindingContext(Z,b.model);U[w._sMutator]($);}if(X){X(Z,$);}}}function N(U,y){var W=y.diff,X=U[w._sGetter]()||[],Y,Z,$,i;if(!W||X.length===0){K(U,y);return;}for(i=0;i<W.length;i++){Y=W[i];switch(Y.type){case"insert":$=y[Y.index];Z=v(J(U,Y.index),$);Z.setBindingContext($,b.model);U[w._sInsertMutator](Z,Y.index);break;case"delete":Z=U[w._sRemoveMutator](Y.index);Z.destroy("KeepDom");break;default:L.error("Unknown diff type \""+Y.type+"\"");}}X=U[w._sGetter]()||[];for(i=0;i<X.length;i++){X[i].setBindingContext(y[i],b.model);}}function Q(i){var U=l.getGroup(i);if(U.key!==G){var W;if(b.groupHeaderFactory){W=b.groupHeaderFactory(U);}H[z](U,W);G=U.key;}}function R(i,U){K(i,U,null,function(W,X){R(X,l.getNodeContexts(W));});}if(d.isA(l,"sap.ui.model.ListBinding")){y=l.getContexts(b.startIndex,b.length);x=l.isGrouped()&&H[z];if(x||l.bWasGrouped){this[w._sDestructor]();K(this,y,x?Q:undefined);}else if(this.bUseExtendedChangeDetection){N(this,y);}else{if(!b.template){this[w._sDestructor]();}K(this,y);}l.bWasGrouped=x;}else if(d.isA(l,"sap.ui.model.TreeBinding")){if(!b.template){this[w._sDestructor]();}R(this,l.getRootContexts());}};p.prototype.refreshAggregation=function(n){var b=this.mBindingInfos[n],a=b.binding;a.getContexts(b.startIndex,b.length);};p.prototype.propagateMessages=function(n,a){L.warning("Message for "+this+", Property "+n);};p.prototype.isTreeBinding=function(n){return false;};p.prototype.updateBindings=function(U,a){var b=this,n,c;function l(c){var y=c.parts,i;if(y){if(y.length==1){return(U||y[0].model==a)&&!c.binding.updateRequired(b.getModel(y[0].model));}else{for(i=0;i<y.length;i++){if((U||y[i].model==a)&&!c.binding.aBindings[i].updateRequired(b.getModel(y[i].model))){return true;}}}}else{return(U||c.model==a)&&!c.binding.updateRequired(b.getModel(c.model));}}function v(c){var y=c.parts,i;if(y){for(i=0;i<y.length;i++){if(!b.getModel(y[i].model)&&y[i].value===undefined){return false;}}return true;}else{return!!b.getModel(c.model);}}function w(c){var i=c.binding;if(b.refreshDataState){b.refreshDataState(n,i.getDataState());}i.detachChange(c.modelChangeHandler);if(c.modelRefreshHandler){i.detachRefresh(c.modelRefreshHandler);}i.detachEvents(c.events);i.destroy();delete c.binding;delete c.modelChangeHandler;delete c.dataStateChangeHandler;delete c.modelRefreshHandler;}for(n in this.mObjectBindingInfos){c=this.mObjectBindingInfos[n];if(c.binding&&l(c)){w(c);}if(!c.binding&&v(c)){this._bindObject(c);}}for(n in this.mBindingInfos){c=this.mBindingInfos[n];if(c.binding&&l(c)){if(this._observer){var x=c.factory?"aggregation":"property";this._observer.bindingChange(this,n,"remove",c,x);}w(c);}if(!c.binding&&v(c)){if(c.factory){this._bindAggregation(n,c);}else{this._bindProperty(n,c);}}}};p.prototype.isBound=function(n){return!!this.getBindingInfo(n);};p.prototype.getObjectBinding=function(a){return this.mObjectBindingInfos[a]&&this.mObjectBindingInfos[a].binding;};p.prototype.getEventingParent=function(){return this.oParent;};p.prototype.getBinding=function(n){var i=this.getBindingInfo(n);return i&&i.binding;};p.prototype.getBindingPath=function(n){var i=this.getBindingInfo(n);return i&&(i.path||(i.parts&&i.parts[0]&&i.parts[0].path));};p.prototype.setBindingContext=function(c,a){h(a===undefined||(typeof a==="string"&&!/^(undefined|null)?$/.test(a)),"sModelName must be a string or omitted");var b=this.oBindingContexts[a];if(f.hasChanged(b,c)){if(c===undefined){delete this.oBindingContexts[a];}else{this.oBindingContexts[a]=c;}this.updateBindingContext(false,a);this.propagateProperties(a);this.fireModelContextChange();}return this;};p.prototype.setElementBindingContext=function(c,a){h(a===undefined||(typeof a==="string"&&!/^(undefined|null)?$/.test(a)),"sModelName must be a string or omitted");var b=this.mElementBindingContexts[a];if(f.hasChanged(b,c)){if(c===undefined){delete this.mElementBindingContexts[a];}else{this.mElementBindingContexts[a]=c;}this.updateBindingContext(true,a);this.propagateProperties(a);this.fireModelContextChange();}return this;};p.prototype.updateBindingContext=function(b,a,U){var c,l={},n,v,N,w,i;if(U){for(n in this.oModels){if(this.oModels.hasOwnProperty(n)){l[n]=n;}}for(n in this.oPropagatedProperties.oModels){if(this.oPropagatedProperties.oModels.hasOwnProperty(n)){l[n]=n;}}}else{l[a]=a;}for(n in l){if(l.hasOwnProperty(n)){n=n==="undefined"?undefined:n;c=this.getModel(n);w=this.mObjectBindingInfos[n];if(c&&w&&!b){if(!w.binding){this._bindObject(w);}else{v=this._getBindingContext(n);if(f.hasChanged(w.binding.getContext(),v)){w.binding.setContext(v);}}continue;}v=this.getBindingContext(n);for(N in this.mBindingInfos){var w=this.mBindingInfos[N],x=w.binding,y=w.parts;if(!x){continue;}if(y&&y.length>1){for(i=0;i<y.length;i++){if(y[i].model==n&&y[i].value===undefined){x.aBindings[i].setContext(v);}}}else if(w.factory){if(w.model==n){x.setContext(v);}}else if(y[0].model==n&&y[0].value===undefined){x.setContext(v);}}}}};p.prototype.getBindingContext=function(a){var b=this.getModel(a),c=this.mElementBindingContexts[a];if(c&&!b){return c;}else if(c&&b&&c.getModel()===b){return c;}else if(c===null){return c;}else{return this._getBindingContext(a);}};p.prototype._getBindingContext=function(a){var b=this.getModel(a),c=this.oBindingContexts[a],i=this.oPropagatedProperties.oBindingContexts[a];if(c&&!b){return this.oBindingContexts[a];}else if(c&&b&&c.getModel()===b){return this.oBindingContexts[a];}else if(c===null){return c;}else if(i&&b&&i.getModel()!==b){return undefined;}else{return i;}};p.prototype.setModel=function(a,n){h(a==null||d.isA(a,"sap.ui.model.Model"),"oModel must be an instance of sap.ui.model.Model, null or undefined");h(n===undefined||(typeof n==="string"&&!/^(undefined|null)?$/.test(n)),"sName must be a string or omitted");if(!a&&this.oModels[n]){delete this.oModels[n];this.propagateProperties(n);this.updateBindings(false,n);this.fireModelContextChange();}else if(a&&a!==this.oModels[n]){this.oModels[n]=a;this.propagateProperties(n);this.updateBindingContext(false,n);this.updateBindings(false,n);this.fireModelContextChange();}return this;};p.prototype.addPropagationListener=function(l){h(typeof l==='function',"listener must be a function");this.aPropagationListeners.push(l);this.propagateProperties(false);this._callPropagationListener(l);return this;};p.prototype.removePropagationListener=function(l){h(typeof l==='function',"listener must be a function");var a=this.aPropagationListeners;var i=a.indexOf(l);if(i>=0){a.splice(i,1);this.propagateProperties(false);}return this;};p.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners);};p.prototype._callPropagationListener=function(l){var a;if(l){l(this);}else{a=this.getPropagationListeners();for(var i=0;i<a.length;i++){l=a[i];l(this);}}return this;};p._oEmptyPropagatedProperties={oModels:{},oBindingContexts:{},aPropagationListeners:[]};function _(a,c){return!c.aAPIParentInfos||c.aAPIParentInfos[0].parent===a;}p.prototype.propagateProperties=function(n){var a=this._getPropertiesToPropagate(),U=n===true,b=n===false,N=U?undefined:n,c,l,i,v=Object.assign({},this.mAggregations,this.mForwardedAggregations);for(c in v){if(this.mSkipPropagation[c]){continue;}l=v[c];if(l instanceof p){if(_(this,l)){this._propagateProperties(n,l,a,U,N,b);}}else if(l instanceof Array){for(i=0;i<l.length;i++){if(l[i]instanceof p){if(_(this,l[i])){this._propagateProperties(n,l[i],a,U,N,b);}}}}}};p.prototype._propagateProperties=function(n,a,b,U,N,c){if(!b){b=this._getPropertiesToPropagate();U=n===true;c=n===false;N=U?undefined:n;}if(a.oPropagatedProperties!==b){a.oPropagatedProperties=b;if(c!==true){a.updateBindings(U,N);a.updateBindingContext(false,N,U);}a.propagateProperties(n);if(c||U){a._callPropagationListener();}a.fireModelContextChange();}};p.prototype._getPropertiesToPropagate=function(){var n=o(this.oModels),N=o(this.oBindingContexts),b=this.aPropagationListeners.length===0,a=o(this.mElementBindingContexts);function c(l,v,w,x){return l?v:m({},v,w,x);}function i(l,v,w){return l?v:v.concat(w);}if(N&&n&&a&&b){return this.oPropagatedProperties;}else{return{oModels:c(n,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:c((N&&a),this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:i(b,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)};}};p.prototype.getModel=function(a){h(a===undefined||(typeof a==="string"&&!/^(undefined|null)?$/.test(a)),"sModelName must be a string or omitted");return this.oModels[a]||this.oPropagatedProperties.oModels[a];};p.prototype.hasModel=function(){return!(o(this.oModels)&&o(this.oPropagatedProperties.oModels));};p.prototype.clone=function(a,b,c){var n=true,v=true;if(c){n=!!c.cloneChildren;v=!!c.cloneBindings;}if(!a){a=M.uid("clone")||u();}if(!b&&n){b=this.findAggregatedObjects(true).map(function(c1){return c1.getId();});}var w=this.getMetadata(),x=w._oClass,y=this.getId()+"-"+a,z={},G,H=this.mProperties,K,N,J,Q=p.bindingParser.escape,i,R;var U=Object.keys(H);i=U.length;while(i>0){K=U[--i];G=w.getProperty(K);if(G&&!(this.isBound(K)&&v)){if(typeof H[K]==="string"){z[K]=Q(H[K]);}else{z[K]=G.byValue?j(H[K]):H[K];}}}z["models"]=this.oModels;z["bindingContexts"]=this.oBindingContexts;if(n){var W=Object.assign({},this.mAggregations,this.mForwardedAggregations);for(N in W){var X=W[N];if(w.hasAggregation(N)&&!(this.isBound(N)&&v)){if(X instanceof p){z[N]=X.clone(a,b);}else if(Array.isArray(X)){z[N]=[];for(var i=0;i<X.length;i++){z[N].push(X[i].clone(a,b));}}else{z[N]=typeof X==="string"?Q(X):X;}}}var Y=r(this.getId());for(var i=0,l=Y.length;i<l;i++){var Z=Y[i].clone(a);Z.sParentId=y;Z.sParentAggregationName=Y[i].sParentAggregationName;}for(N in this.mAssociations){if(!w.hasAssociation(N)){continue;}var $=this.mAssociations[N];if(Array.isArray($)){$=$.slice(0);for(var i=0;i<$.length;i++){if(b.indexOf($[i])>=0){$[i]+="-"+a;}}}else if(b.indexOf($)>=0){$+="-"+a;}z[N]=$;}}J=new x(y,z);function a1(c1,N,J,d1){var e1=c1.mBindingInfos[N];e1=e1||c1.getBindingInfo(N);var f1=Object.assign({},e1);if(!e1.templateShareable&&e1.template&&e1.template.clone){f1.template=e1.template.clone(a,b);delete f1.factory;}else if(e1.templateShareable===t){e1.templateShareable=f1.templateShareable=true;L.error("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+N+"' of object '"+c1.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.");}delete f1.binding;delete f1.modelChangeHandler;delete f1.dataStateChangeHandler;delete f1.modelRefreshHandler;if(e1.factory||e1.template){J.bindAggregation(d1,f1);}else{J.bindProperty(d1,f1);}}for(N in this.mObjectBindingInfos){J.mObjectBindingInfos[N]=Object.assign({},this.mObjectBindingInfos[N]);}for(N in this.mEventRegistry){J.mEventRegistry[N]=this.mEventRegistry[N].slice();}if(v){for(N in this.mBindingInfos){a1(this,N,J,N);}}if(p._supportInfo){p._supportInfo.addSupportInfo(J.getId(),p._supportInfo.byId(this.getId()));}if(this._cloneMetadataContexts){this._cloneMetadataContexts(J);}if(this.mForwardedAggregations){for(N in this.mForwardedAggregations){var b1=J.getMetadata().getAggregationForwarder(N);if(b1){R=b1.getTarget(J,true);if(b1.forwardBinding&&this.isBound(N)){a1(this,N,R,b1.targetAggregationName);}}}}return J;};p._handleLocalizationChange=function(a){var b,n,c,i;if(a===1){for(n in this.oModels){b=this.oModels[n];if(b&&b._handleLocalizationChange){b._handleLocalizationChange();}}}else if(a===2){for(n in this.mBindingInfos){c=this.mBindingInfos[n];var l=c.parts;if(l){for(i=0;i<l.length;i++){if(c.type&&c.type._handleLocalizationChange){c.type._handleLocalizationChange();}}if(c.modelChangeHandler){c.modelChangeHandler();}}}}};p.prototype.findAggregatedObjects=function(R,c){var b=[];if(c&&typeof c!=="function"){c=null;}function l(v){var a,i,n;for(n in v.mAggregations){a=v.mAggregations[n];if(Array.isArray(a)){for(i=0;i<a.length;i++){if(!c||c(a[i])){b.push(a[i]);}if(R){l(a[i]);}}}else if(a instanceof p){if(!c||c(a)){b.push(a);}if(R){l(a);}}}}l(this);return b;};p._defaultContextualSettings={};return p;});
