/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/core/util/ResponsivePaddingsEnablement','sap/ui/Device','sap/m/Text','sap/ui/events/KeyCodes','./ObjectHeaderRenderer','./ObjectMarker','./ObjectNumber',"sap/ui/thirdparty/jquery"],function(l,C,I,c,R,D,T,K,O,a,b,q){"use strict";var B=l.BackgroundDesign;var d=c.TextAlign;var e=l.ImageHelper;var f=l.ObjectMarkerType;var g=c.TitleLevel;var h=c.TextDirection;var V=c.ValueState;var j=l.ObjectHeaderPictureShape;var k=C.extend("sap.m.ObjectHeader",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ObjectHeader.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null},intro:{type:"string",group:"Misc",defaultValue:null},introActive:{type:"boolean",group:"Misc",defaultValue:null},titleActive:{type:"boolean",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconActive:{type:"boolean",group:"Misc",defaultValue:null},iconAlt:{type:"string",group:"Accessibility",defaultValue:null},iconTooltip:{type:"string",group:"Accessibility",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},imageShape:{type:"sap.m.ObjectHeaderPictureShape",group:"Appearance",defaultValue:j.Square},markFavorite:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},markFlagged:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showMarkers:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},numberState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:V.None},condensed:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"},responsive:{type:"boolean",group:"Behavior",defaultValue:false},fullScreenOptimized:{type:"boolean",group:"Appearance",defaultValue:false},titleHref:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},titleTarget:{type:"string",group:"Behavior",defaultValue:null},introHref:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},introTarget:{type:"string",group:"Behavior",defaultValue:null},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:h.Inherit},introTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:h.Inherit},numberTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:h.Inherit},titleSelectorTooltip:{type:"string",group:"Misc",defaultValue:"Options"},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:g.H1}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.m.ObjectAttribute",multiple:true,singularName:"attribute"},firstStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},secondStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},statuses:{type:"sap.ui.core.Control",multiple:true,singularName:"status"},_objectNumber:{type:"sap.m.ObjectNumber",multiple:false,visibility:"hidden"},additionalNumbers:{type:"sap.m.ObjectNumber",multiple:true,singularName:"additionalNumber"},headerContainer:{type:"sap.m.ObjectHeaderContainer",multiple:false},markers:{type:"sap.m.ObjectMarker",multiple:true,singularName:"marker"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{titlePress:{parameters:{domRef:{type:"object"}}},introPress:{parameters:{domRef:{type:"object"}}},iconPress:{parameters:{domRef:{type:"object"}}},titleSelectorPress:{parameters:{domRef:{type:"object"}}}},dnd:{draggable:false,droppable:true}}});k._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m");};R.call(k.prototype,{header:{selector:".sapMOH, .sapMOHR"}});k.prototype.init=function(){this._oTitleArrowIcon=I.createControlByURI({id:this.getId()+"-titleArrow",src:I.getIconURI("arrow-down"),decorative:false,visible:false,tooltip:k._getResourceBundle().getText("OH_SELECT_ARROW_TOOLTIP"),size:"1.375rem",press:function(E){}});this._fNumberWidth=undefined;this._titleText=new T(this.getId()+"-titleText");this._titleText.setMaxLines(3);this._initResponsivePaddingsEnablement();};k.prototype.insertAttribute=function(A,i){var r=this.insertAggregation("attributes",A,i);this._registerControlListener(A);return r;};k.prototype.addAttribute=function(A){var r=this.addAggregation("attributes",A);this._registerControlListener(A);return r;};k.prototype.removeAttribute=function(A){var r=this.removeAggregation("attributes",A);this._deregisterControlListener(r);return r;};k.prototype.removeAllAttributes=function(){var A=this.removeAllAggregation("attributes");A.forEach(this._deregisterControlListener,this);return A;};k.prototype.destroyAttributes=function(){var A=this.getAggregation("attributes");if(A!==null){A.forEach(this._deregisterControlListener,this);}return this.destroyAggregation("attributes");};k.prototype.insertStatus=function(s,i){var r=this.insertAggregation("statuses",s,i);this._registerControlListener(s);return r;};k.prototype.addStatus=function(s){var r=this.addAggregation("statuses",s);this._registerControlListener(s);return r;};k.prototype.removeStatus=function(s){var r=this.removeAggregation("statuses",s);this._deregisterControlListener(r);return r;};k.prototype.removeAllStatuses=function(){var s=this.removeAllAggregation("statuses");s.forEach(this._deregisterControlListener,this);return s;};k.prototype.destroyStatuses=function(){var s=this.getAggregation("statuses");if(s!==null){s.forEach(this._deregisterControlListener,this);}return this.destroyAggregation("statuses");};k.prototype._registerControlListener=function(o){if(o){o.attachEvent("_change",this.invalidate,this);}};k.prototype._deregisterControlListener=function(o){if(o){o.detachEvent("_change",this.invalidate,this);}};k.prototype.setCondensed=function(i){this.setProperty("condensed",i);if(this.getCondensed()){this._oTitleArrowIcon.setSize("1rem");}else{this._oTitleArrowIcon.setSize("1.375rem");}return this;};k.prototype.setNumber=function(n){this.setProperty("number",n);this._getObjectNumber().setNumber(n);return this;};k.prototype.setNumberUnit=function(u){this.setProperty("numberUnit",u);this._getObjectNumber().setUnit(u);return this;};k.prototype.setNumberState=function(s){this.setProperty("numberState",s);this._getObjectNumber().setState(s);return this;};k.prototype.setTitleSelectorTooltip=function(t){this.setProperty("titleSelectorTooltip",t);this._oTitleArrowIcon.setTooltip(t);return this;};k.prototype.setMarkFavorite=function(m){return this._setOldMarkers(f.Favorite,m);};k.prototype.setMarkFlagged=function(m){return this._setOldMarkers(f.Flagged,m);};k.prototype.setShowMarkers=function(m){var M,A=this.getMarkers(),i;this.setProperty("showMarkers",m);for(i=0;i<A.length;i++){M=A[i].getType();if((M===f.Flagged&&this.getMarkFlagged())||(M===f.Favorite&&this.getMarkFavorite())){A[i].setVisible(m);}}return this;};k.prototype._setOldMarkers=function(m,M){var A=this.getMarkers(),H=false,i,o={Flagged:"-flag",Favorite:"-favorite"};this.setProperty("mark"+m,M,false);if(!this.getShowMarkers()){M=false;}for(i=0;i<A.length;i++){if(A[i].getType()===m){H=true;A[i].setVisible(M);break;}}if(!H){this.insertAggregation("markers",new a({id:this.getId()+o[m],type:m,visible:M}));}return this;};k.prototype._getVisibleMarkers=function(){var A=this.getMarkers(),v=[],i;for(i=0;i<A.length;i++){if(A[i].getVisible()){v.push(A[i]);}}return v;};k.prototype._getObjectNumber=function(){var o=this.getAggregation("_objectNumber");if(!o){o=new b(this.getId()+"-number",{emphasized:false});this.setAggregation("_objectNumber",o,true);}return o;};k.prototype.getFocusDomRef=function(){if(this.getResponsive()){return this.$("txt")[0];}else{return this.$("title")[0];}};k.prototype.ontap=function(E){var s=E.target.id;if(this.getIntroActive()&&s===this.getId()+"-intro"){if(!this.getIntroHref()){this.fireIntroPress({domRef:window.document.getElementById(s)});}}else if(!this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-title"||q(E.target).parent().attr('id')===this.getId()+"-title"||s===this.getId()+"-titleText-inner")){if(!this.getTitleHref()){E.preventDefault();s=this.getId()+"-title";this.fireTitlePress({domRef:window.document.getElementById(s)});}}else if(this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-txt"||q(E.target).parent().attr('id')===this.getId()+"-txt")){if(!this.getTitleHref()){E.preventDefault();s=this.getId()+"-txt";this.fireTitlePress({domRef:window.document.getElementById(s)});}}else if(s===this.getId()+"-titleArrow"){this.fireTitleSelectorPress({domRef:window.document.getElementById(s)});}else if(s.indexOf(this.getId())!==-1){E.setMarked();E.preventDefault();}};k.prototype._handleSpaceOrEnter=function(E){var s=E.target.id;E.setMarked();if(!this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-title"||q(E.target).parent().attr('id')===this.getId()+"-title"||s===this.getId()+"-titleText-inner")){s=this.getId()+"-title";if(!this.getTitleHref()){E.preventDefault();this.fireTitlePress({domRef:(s?window.document.getElementById(s):null)});}else{if(E.type==="sapspace"){this._linkClick(E,s);}}}else if(this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-txt"||q(E.target).parent().attr('id')===this.getId()+"-txt")){s=this.getId()+"-txt";if(!this.getTitleHref()){E.preventDefault();this.fireTitlePress({domRef:(s?window.document.getElementById(s):null)});}else{if(E.type==="sapspace"){this._linkClick(E,s);}}}else if(this.getIntroActive()&&s===this.getId()+"-intro"){if(!this.getIntroHref()){this.fireIntroPress({domRef:(s?window.document.getElementById(s):null)});}}else if(s===this.getId()+"-titleArrow"){this.fireTitleSelectorPress({domRef:(s?window.document.getElementById(s):null)});}};k.prototype.onkeyup=function(E){if(E.which===K.SPACE){this._handleSpaceOrEnter(E);}};k.prototype.onsapenter=k.prototype._handleSpaceOrEnter;k.prototype._linkClick=function(E,s){E.setMarked();var o=document.createEvent('MouseEvents');o.initEvent('click',false,true);((s?window.document.getElementById(s):null)).dispatchEvent(o);};k.prototype._onOrientationChange=function(){var i=this.getId();if(D.system.tablet&&this.getFullScreenOptimized()&&(this._hasAttributes()||this._hasStatus())){this._rerenderStates();}if(D.system.phone){if(D.orientation.portrait){if(this.getTitle().length>50){this._rerenderTitle(50);}if(this.getIcon()){q(document.getElementById(i+"-titlediv")).removeClass("sapMOHRTitleIcon");q(document.getElementById(i+"-titleIcon")).addClass("sapMOHRHideIcon");}}else{if(D.orientation.landscape){if(this.getTitle().length>80){this._rerenderTitle(80);}if(this.getIcon()){q(document.getElementById(i+"-titlediv")).addClass("sapMOHRTitleIcon");q(document.getElementById(i+"-titleIcon")).removeClass("sapMOHRHideIcon");}}}this._adjustNumberDiv();}this._adjustIntroDiv();};k.prototype._rerenderTitle=function(n){var r=sap.ui.getCore().createRenderManager();this.getRenderer()._rerenderTitle(r,this,n);r.destroy();};k.prototype._rerenderStates=function(){var r=sap.ui.getCore().createRenderManager();this.getRenderer()._rerenderResponsiveStates(r,this);r.destroy();};k.prototype.exit=function(){if(!D.system.phone){this._detachMediaContainerWidthChange(this._rerenderOHR,this,D.media.RANGESETS.SAP_STANDARD);}if(D.system.tablet||D.system.phone){D.orientation.detachHandler(this._onOrientationChange,this);}if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=undefined;}if(this._oTitleArrowIcon){this._oTitleArrowIcon.destroy();this._oTitleArrowIcon=undefined;}if(this._titleText){this._titleText.destroy();this._titleText=undefined;}if(this._introText){this._introText.destroy();this._introText=undefined;}};k.prototype._getImageControl=function(){var i=this.getId()+"-img";var s="2.5rem";var p=q.extend({src:this.getIcon(),tooltip:this.getIconTooltip(),alt:this.getIconAlt()||k._getResourceBundle().getText("OH_ARIA_ICON"),useIconTooltip:false,densityAware:this.getIconDensityAware(),decorative:false},I.isIconURI(this.getIcon())?{size:s}:{});if(this.getIconActive()){p.press=function(E){this.fireIconPress({domRef:E.getSource().getDomRef()});}.bind(this);p.decorative=false;}this._oImageControl=e.getImageControl(i,this._oImageControl,this,p);return this._oImageControl;};k.prototype.onBeforeRendering=function(){if(D.system.tablet||D.system.phone){D.orientation.detachHandler(this._onOrientationChange,this);}if(!D.system.phone){this._detachMediaContainerWidthChange(this._rerenderOHR,this,D.media.RANGESETS.SAP_STANDARD);}if(this._introText){this._introText.destroy();this._introText=undefined;}};k.prototype.onAfterRendering=function(){var o=this.getAggregation("_objectNumber");var p=sap.ui.getCore().getConfiguration().getRTL();var $=this.$("titleArrow");$.attr("role","button");if(this.getResponsive()){this._adjustIntroDiv();if(o&&o.getNumber()){if(D.system.desktop&&q('html').hasClass("sapUiMedia-Std-Desktop")&&this.getFullScreenOptimized()&&this._iCountVisAttrStat>=1&&this._iCountVisAttrStat<=3){o.setTextAlign(p?d.Right:d.Left);}else{o.setTextAlign(p?d.Left:d.Right);}}this._adjustNumberDiv();if(D.system.tablet||D.system.phone){D.orientation.attachHandler(this._onOrientationChange,this);}if(!D.system.phone){this._attachMediaContainerWidthChange(this._rerenderOHR,this,D.media.RANGESETS.SAP_STANDARD);}}else{var t=p?d.Left:d.Right;if(o&&o.getNumber()){o.setTextAlign(t);}if(this.getAdditionalNumbers()){this._setTextAlignANum(t);}}};k.prototype._rerenderOHR=function(){this.invalidate();};k.prototype._adjustNumberDiv=function(){var i=this.getId();var o=this.getAggregation("_objectNumber");var p=sap.ui.getCore().getConfiguration().getRTL();if(o&&o.getNumber()){var $=q(document.getElementById(i+"-number"));var m=q(document.getElementById(i+"-titlediv"));if(this._isMediaSize("Phone")){if($.hasClass("sapMObjectNumberBelowTitle")){o.setTextAlign(p?d.Left:d.Right);$.removeClass("sapMObjectNumberBelowTitle");m.removeClass("sapMOHRTitleDivFull");}var n=$.parent().width()*0.4;if($.outerWidth()>n){o.setTextAlign(p?d.Right:d.Left);$.addClass("sapMObjectNumberBelowTitle");m.addClass("sapMOHRTitleDivFull");}}}};k.prototype._adjustIntroDiv=function(){var i=this.getId();var $=q(document.getElementById(i+"-txt"));var m=q(document.getElementById(i+"-titleArrow"));var n=q(document.getElementById(i+"-intro"));if(n.parent().hasClass("sapMOHRIntroMargin")){n.parent().removeClass("sapMOHRIntroMargin");}if(m.height()!==null&&($.height()<m.height())){n.parent().addClass("sapMOHRIntroMargin");}};k._escapeId=function(i){return i?"#"+i.replace(/(:|\.)/g,'\\$1'):"";};k.prototype._hasBottomContent=function(){return(this._hasAttributes()||this._hasStatus()||this._hasMarkers());};k.prototype._hasIcon=function(){return!!this.getIcon().trim();};k.prototype._hasAttributes=function(){var m=this.getAttributes();if(m&&m.length>0){for(var i=0;i<m.length;i++){if(!m[i]._isEmpty()){return true;}}}return false;};k.prototype._hasStatus=function(){var H=((this.getFirstStatus()&&!this.getFirstStatus()._isEmpty())||(this.getSecondStatus()&&!this.getSecondStatus()._isEmpty()));if(!H&&this.getStatuses()&&this.getStatuses().length>0){var s=this.getStatuses();for(var i=0;i<s.length;i++){if(s[i]instanceof sap.m.ObjectStatus&&!s[i]._isEmpty()){H=true;break;}else if(s[i]instanceof sap.m.ProgressIndicator){H=true;break;}}}return H;};k.prototype._hasMarkers=function(){var m=this.getMarkers(),H=this.getShowMarkers()&&(this.getMarkFavorite()||this.getMarkFlagged()),i=m&&m.length;return(H||i);};k.prototype._getDefaultBackgroundDesign=function(){if(this.getCondensed()){return B.Solid;}else{if(this.getResponsive()){return B.Translucent;}else{return B.Transparent;}}};k.prototype._getBackground=function(){if(this.getBackgroundDesign()===undefined){return this._getDefaultBackgroundDesign();}else{return this.getBackgroundDesign();}};k.prototype._setTextAlignANum=function(t){var n=this.getAdditionalNumbers();for(var i=0;i<n.length;i++){n[i].setTextAlign(t);}};k.prototype._isMediaSize=function(r){return this._getCurrentMediaContainerRange(D.media.RANGESETS.SAP_STANDARD).name===r;};return k;});
