/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import org.jetbrains.annotations.Nullable;

public class PyTargetExpressionStubImpl
extends StubBase<PyTargetExpression>
implements PyTargetExpressionStub {
    private final String myName;
    private final PyTargetExpressionStub.InitializerType myInitializerType;
    private final QualifiedName myInitializer;
    private final boolean myQualified;
    private final String myTypeComment;
    private final String myAnnotation;
    private final boolean myHasAssignedValue;
    @Nullable
    private final String myDocString;
    private final CustomTargetExpressionStub myCustomStub;

    public PyTargetExpressionStubImpl(String name2, @Nullable String docString, @Nullable String typeComment, @Nullable String annotation, boolean hasAssignedValue, CustomTargetExpressionStub customStub, StubElement parent) {
        super(parent, PyElementTypes.TARGET_EXPRESSION);
        this.myName = name2;
        this.myTypeComment = typeComment;
        this.myAnnotation = annotation;
        this.myHasAssignedValue = hasAssignedValue;
        this.myInitializerType = PyTargetExpressionStub.InitializerType.Custom;
        this.myInitializer = null;
        this.myQualified = false;
        this.myCustomStub = customStub;
        this.myDocString = docString;
    }

    public PyTargetExpressionStubImpl(String name2, @Nullable String docString, PyTargetExpressionStub.InitializerType initializerType, QualifiedName initializer, boolean qualified, @Nullable String typeComment, @Nullable String annotation, boolean hasAssignedValue, StubElement parentStub) {
        super(parentStub, PyElementTypes.TARGET_EXPRESSION);
        this.myName = name2;
        this.myTypeComment = typeComment;
        this.myAnnotation = annotation;
        this.myHasAssignedValue = hasAssignedValue;
        assert (initializerType != PyTargetExpressionStub.InitializerType.Custom);
        this.myInitializerType = initializerType;
        this.myInitializer = initializer;
        this.myQualified = qualified;
        this.myCustomStub = null;
        this.myDocString = docString;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public PyTargetExpressionStub.InitializerType getInitializerType() {
        return this.myInitializerType;
    }

    @Override
    public QualifiedName getInitializer() {
        return this.myInitializer;
    }

    @Override
    public boolean isQualified() {
        return this.myQualified;
    }

    @Override
    @Nullable
    public <T> T getCustomStub(Class<T> stubClass) {
        if (stubClass.isInstance(this.myCustomStub)) {
            return stubClass.cast(this.myCustomStub);
        }
        return null;
    }

    @Override
    @Nullable
    public String getDocString() {
        return this.myDocString;
    }

    @Override
    @Nullable
    public String getTypeComment() {
        return this.myTypeComment;
    }

    @Override
    @Nullable
    public String getAnnotation() {
        return this.myAnnotation;
    }

    @Override
    public boolean hasAssignedValue() {
        return this.myHasAssignedValue;
    }

    public String toString() {
        String result = "PyTargetExpressionStub(name=" + this.myName + ", hasAssignedValue=" + this.myHasAssignedValue;
        if (this.myCustomStub == null) {
            if (this.myInitializer != null) {
                result = result + ", initializer=" + this.myInitializer;
            }
            result = result + ", initializerType=" + this.myInitializerType + ", qualified=" + this.myQualified;
        } else {
            result = result + ", customStub=" + this.myCustomStub;
        }
        if (this.myTypeComment != null) {
            result = result + ", typeComment='" + this.myTypeComment + "'";
        }
        if (this.myAnnotation != null) {
            result = result + ", annotation='" + this.myAnnotation + "'";
        }
        if (this.myDocString != null) {
            result = result + ", docString='" + StringUtil.escapeStringCharacters((String)this.myDocString) + "'";
        }
        result = result + ")";
        return result;
    }
}

