/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyTargetExpressionImpl;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.impl.stubs.PyCustomizableStubElementType;
import com.jetbrains.python.psi.impl.stubs.PyTargetExpressionStubImpl;
import com.jetbrains.python.psi.stubs.PyExportedModuleAttributeIndex;
import com.jetbrains.python.psi.stubs.PyFileStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyTargetExpressionElementType
extends PyStubElementType<PyTargetExpressionStub, PyTargetExpression>
implements PyCustomizableStubElementType<PyTargetExpression, CustomTargetExpressionStub, CustomTargetExpressionStubType<? extends CustomTargetExpressionStub>> {
    public PyTargetExpressionElementType() {
        super("TARGET_EXPRESSION");
    }

    public PyTargetExpressionElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(1);
        }
        return new PyTargetExpressionImpl(node);
    }

    public PyTargetExpression createPsi(@NotNull PyTargetExpressionStub stub) {
        if (stub == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(2);
        }
        return new PyTargetExpressionImpl(stub);
    }

    @NotNull
    public PyTargetExpressionStub createStub(@NotNull PyTargetExpression psi, StubElement parentStub) {
        if (psi == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(3);
        }
        String name2 = psi.getName();
        PyExpression assignedValue = psi.findAssignedValue();
        String docString = DocStringUtil.getDocStringValue(psi);
        String typeComment = psi.getTypeCommentAnnotation();
        String annotation = psi.getAnnotationValue();
        CustomTargetExpressionStub customStub = (CustomTargetExpressionStub)this.createCustomStub(psi);
        if (customStub != null) {
            return new PyTargetExpressionStubImpl(name2, docString, typeComment, annotation, psi.hasAssignedValue(), customStub, parentStub);
        }
        PyTargetExpressionStub.InitializerType initializerType = PyTargetExpressionStub.InitializerType.Other;
        QualifiedName initializer = null;
        Ref<QualifiedName> assignedReference = PyTargetExpressionImpl.getAssignedReferenceQualifiedName(psi);
        if (assignedReference != null) {
            initializerType = PyTargetExpressionStub.InitializerType.ReferenceExpression;
            initializer = (QualifiedName)assignedReference.get();
        } else {
            Ref<QualifiedName> assignedCallCalleeReference = PyTargetExpressionImpl.getAssignedCallCalleeQualifiedName(psi);
            if (assignedCallCalleeReference != null) {
                initializerType = PyTargetExpressionStub.InitializerType.CallExpression;
                initializer = (QualifiedName)assignedCallCalleeReference.get();
            }
        }
        return new PyTargetExpressionStubImpl(name2, docString, initializerType, initializer, psi.isQualified(), typeComment, annotation, psi.hasAssignedValue(), parentStub);
    }

    public void serialize(@NotNull PyTargetExpressionStub stub, @NotNull StubOutputStream stream) throws IOException {
        if (stub == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(4);
        }
        if (stream == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(5);
        }
        stream.writeName(stub.getName());
        String docString = stub.getDocString();
        stream.writeUTFFast(docString != null ? docString : "");
        stream.writeVarInt(stub.getInitializerType().getIndex());
        stream.writeName(stub.getTypeComment());
        stream.writeName(stub.getAnnotation());
        stream.writeBoolean(stub.hasAssignedValue());
        CustomTargetExpressionStub customStub = stub.getCustomStub(CustomTargetExpressionStub.class);
        if (customStub != null) {
            this.serializeCustomStub(customStub, stream);
        } else {
            QualifiedName.serialize((QualifiedName)stub.getInitializer(), (StubOutputStream)stream);
            stream.writeBoolean(stub.isQualified());
        }
    }

    @NotNull
    public PyTargetExpressionStub deserialize(@NotNull StubInputStream stream, StubElement parentStub) throws IOException {
        if (stream == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(6);
        }
        String name2 = stream.readNameString();
        String docString = stream.readUTFFast();
        if (docString.isEmpty()) {
            docString = null;
        }
        PyTargetExpressionStub.InitializerType initializerType = PyTargetExpressionStub.InitializerType.fromIndex(stream.readVarInt());
        String typeComment = stream.readNameString();
        String annotation = stream.readNameString();
        boolean hasAssignedValue = stream.readBoolean();
        if (initializerType == PyTargetExpressionStub.InitializerType.Custom) {
            CustomTargetExpressionStub stub = (CustomTargetExpressionStub)this.deserializeCustomStub(stream);
            return new PyTargetExpressionStubImpl(name2, docString, typeComment, annotation, hasAssignedValue, stub, parentStub);
        }
        QualifiedName initializer = QualifiedName.deserialize((StubInputStream)stream);
        boolean isQualified = stream.readBoolean();
        return new PyTargetExpressionStubImpl(name2, docString, initializerType, initializer, isQualified, typeComment, annotation, hasAssignedValue, parentStub);
    }

    public boolean shouldCreateStub(ASTNode node) {
        if (node.getTreeParent().getElementType() != PyElementTypes.ASSIGNMENT_EXPRESSION && PsiTreeUtil.getParentOfType((PsiElement)node.getPsi(), PyComprehensionElement.class, (boolean)true, (Class[])new Class[]{PyDocStringOwner.class}) != null) {
            return false;
        }
        ASTNode functionNode = TreeUtil.findParent((ASTNode)node, PyElementTypes.FUNCTION_DECLARATION);
        ASTNode qualifierNode = node.findChildByType(PythonDialectsTokenSetProvider.getInstance().getReferenceExpressionTokens());
        if (functionNode != null && qualifierNode != null) {
            if (PyUtil.isNewMethod(functionNode.getPsi())) {
                return true;
            }
            ASTNode parameterList = functionNode.findChildByType(PyElementTypes.PARAMETER_LIST);
            assert (parameterList != null);
            ASTNode[] children2 = parameterList.getChildren(PyElementTypes.FORMAL_PARAMETER_SET);
            if (children2.length > 0 && children2[0].getText().equals(qualifierNode.getText())) {
                return true;
            }
        }
        return functionNode == null && qualifierNode == null;
    }

    @Override
    public void indexStub(@NotNull PyTargetExpressionStub stub, @NotNull IndexSink sink) {
        String name2;
        if (stub == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(8);
        }
        if ((name2 = stub.getName()) != null && PyUtil.getInitialUnderscores(name2) == 0 && stub.getParentStub() instanceof PyFileStub) {
            sink.occurrence(PyVariableNameIndex.KEY, (Object)name2);
            sink.occurrence(PyExportedModuleAttributeIndex.KEY, (Object)name2);
        }
        for (CustomTargetExpressionStubType<? extends CustomTargetExpressionStub> stubType : this.getExtensions()) {
            stubType.indexStub(stub, sink);
        }
    }

    @Override
    @NotNull
    public List<CustomTargetExpressionStubType<? extends CustomTargetExpressionStub>> getExtensions() {
        List list = CustomTargetExpressionStubType.EP_NAME.getExtensionList();
        if (list == null) {
            PyTargetExpressionElementType.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

