/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorProvider;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PropertyBunch;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTargetExpressionImpl;
import com.jetbrains.python.psi.impl.stubs.PyClassElementType;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.stubs.PropertyStubStorage;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassImpl
extends PyBaseElementImpl<PyClassStub>
implements PyClass {
    public static final PyClass[] EMPTY_ARRAY = new PyClassImpl[0];
    @Nullable
    private volatile List<PyTargetExpression> myInstanceAttributes;
    @Nullable
    private volatile List<PyTargetExpression> myFallbackInstanceAttributes;
    private volatile Map<String, Property> myLocalPropertyCache;
    private static final Maybe<PyCallable> UNKNOWN_CALL = new Maybe();
    private static final Maybe<PyCallable> NONE = new Maybe<Object>(null);

    @Override
    public PyType getType(@NotNull TypeEvalContext context2, @NotNull TypeEvalContext.Key key) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(0);
        }
        if (key == null) {
            PyClassImpl.$$$reportNull$$$0(1);
        }
        return new PyClassTypeImpl(this, true);
    }

    public PyClassImpl(@NotNull ASTNode astNode) {
        if (astNode == null) {
            PyClassImpl.$$$reportNull$$$0(2);
        }
        super(astNode);
    }

    public PyClassImpl(@NotNull PyClassStub stub) {
        if (stub == null) {
            PyClassImpl.$$$reportNull$$$0(3);
        }
        this(stub, (IStubElementType)PyElementTypes.CLASS_DECLARATION);
    }

    public PyClassImpl(@NotNull PyClassStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            PyClassImpl.$$$reportNull$$$0(4);
        }
        if (nodeType == null) {
            PyClassImpl.$$$reportNull$$$0(5);
        }
        super(stub, nodeType);
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PyClassImpl.$$$reportNull$$$0(6);
        }
        ASTNode nameElement = PyUtil.createNewName(this, name2);
        ASTNode node = this.getNameNode();
        if (node != null) {
            this.getNode().replaceChild(node, nameElement);
        }
        return this;
    }

    @Nullable
    public String getName() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameNode();
        return node != null ? node.getText() : null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getPsi() : null;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.CLASS_ICON;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyClass(this);
    }

    @Override
    @NotNull
    public PyStatementList getStatementList() {
        PyStatementList statementList = (PyStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        assert (statementList != null) : "Statement list missing for class " + this.getText();
        PyStatementList pyStatementList = statementList;
        if (pyStatementList == null) {
            PyClassImpl.$$$reportNull$$$0(7);
        }
        return pyStatementList;
    }

    @Override
    public PyArgumentList getSuperClassExpressionList() {
        PyArgumentList argList = (PyArgumentList)PsiTreeUtil.getChildOfType((PsiElement)this, PyArgumentList.class);
        if (argList != null && argList.getFirstChild() != null) {
            return argList;
        }
        return null;
    }

    @Override
    public PyExpression @NotNull [] getSuperClassExpressions() {
        PyArgumentList argList = this.getSuperClassExpressionList();
        if (argList != null) {
            PyExpression[] pyExpressionArray = argList.getArguments();
            if (pyExpressionArray == null) {
                PyClassImpl.$$$reportNull$$$0(8);
            }
            return pyExpressionArray;
        }
        if (PyExpression.EMPTY_ARRAY == null) {
            PyClassImpl.$$$reportNull$$$0(9);
        }
        return PyExpression.EMPTY_ARRAY;
    }

    @NotNull
    public static List<PyExpression> getUnfoldedSuperClassExpressions(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyClassImpl.$$$reportNull$$$0(10);
        }
        List list = ((StreamEx)StreamEx.of((Object[])pyClass.getSuperClassExpressions()).filter(expression -> !(expression instanceof PyKeywordArgument))).flatCollection(PyClassImpl::unfoldSuperClassExpression).toList();
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static List<PyExpression> unfoldSuperClassExpression(@NotNull PyExpression expression) {
        if (expression == null) {
            PyClassImpl.$$$reportNull$$$0(12);
        }
        if (PyClassImpl.isSixWithMetaclassCall(expression)) {
            Object[] arguments = ((PyCallExpression)expression).getArguments();
            if (arguments.length > 1) {
                List list = ContainerUtil.newArrayList((Object[])arguments, (int)1, (int)arguments.length);
                if (list == null) {
                    PyClassImpl.$$$reportNull$$$0(13);
                }
                return list;
            }
            List<PyExpression> list = Collections.emptyList();
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (expression instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)expression;
            List<PyExpression> list = Collections.singletonList(subscriptionExpr.getOperand());
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<PyExpression> list = Collections.singletonList(expression);
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    public static boolean isSixWithMetaclassCall(@NotNull PyExpression expression) {
        PyExpression callee;
        if (expression == null) {
            PyClassImpl.$$$reportNull$$$0(17);
        }
        if (expression instanceof PyCallExpression && (callee = ((PyCallExpression)expression).getCallee()) instanceof PyReferenceExpression) {
            QualifiedName sixWithMetaclass = QualifiedName.fromComponents((String[])new String[]{"six", "with_metaclass"});
            QualifiedName djangoWithMetaclass = QualifiedName.fromDottedString((String)"django.utils.six.with_metaclass");
            return ContainerUtil.exists(PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)callee), name2 -> name2.equals((Object)sixWithMetaclass) || name2.equals((Object)djangoWithMetaclass));
        }
        return false;
    }

    @Override
    @NotNull
    public final List<PyClass> getAncestorClasses(@Nullable TypeEvalContext context2) {
        ArrayList<PyClass> results = new ArrayList<PyClass>();
        for (PyClassLikeType type : this.getAncestorTypes(this.notNullizeContext(context2))) {
            if (!(type instanceof PyClassType)) continue;
            results.add(((PyClassType)type).getPyClass());
        }
        ArrayList<PyClass> arrayList = results;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Override
    public boolean isSubclass(PyClass parent, @Nullable TypeEvalContext context2) {
        if (this == parent) {
            return true;
        }
        for (PyClass superclass : this.getAncestorClasses(context2)) {
            if (parent != superclass) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubclass(@NotNull String superClassQName, @Nullable TypeEvalContext context2) {
        if (superClassQName == null) {
            PyClassImpl.$$$reportNull$$$0(19);
        }
        if (superClassQName.equals(this.getQualifiedName())) {
            return true;
        }
        for (PyClassLikeType type : this.getAncestorTypes(this.notNullizeContext(context2))) {
            if (type == null || !superClassQName.equals(type.getClassQName())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PyDecoratorList getDecoratorList() {
        return (PyDecoratorList)this.getStubOrPsiChild(PyElementTypes.DECORATOR_LIST);
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Override
    @Nullable
    public List<String> getSlots(@Nullable TypeEvalContext context2) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        PyClassTypeImpl currentType = new PyClassTypeImpl(this, true);
        TypeEvalContext contextToUse = this.notNullizeContext(context2);
        for (PyClassLikeType type : Iterables.concat(Collections.singletonList(currentType), this.getAncestorTypes(contextToUse))) {
            if (!(type instanceof PyClassType)) {
                return null;
            }
            PyClass cls = ((PyClassType)type).getPyClass();
            if (PyUtil.isObjectClass(cls)) continue;
            if (!cls.isNewStyleClass(contextToUse)) {
                return null;
            }
            List<String> ownSlots = cls.getOwnSlots();
            if (ownSlots == null || ownSlots.contains("__dict__")) {
                return null;
            }
            result.addAll(ownSlots);
        }
        return new ArrayList<String>(result);
    }

    @Override
    @Nullable
    public List<String> getOwnSlots() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            return stub.getSlots();
        }
        PyTargetExpression slots = (PyTargetExpression)ContainerUtil.find(this.getClassAttributes(), target -> "__slots__".equals(target.getName()));
        if (slots != null) {
            PyExpression value = slots.findAssignedValue();
            return value instanceof PyStringLiteralExpression ? Collections.singletonList(((PyStringLiteralExpression)value).getStringValue()) : PyUtil.strListValue(value);
        }
        return null;
    }

    @Override
    public PyClass @NotNull [] getSuperClasses(@Nullable TypeEvalContext context2) {
        List<PyClassLikeType> superTypes = this.getSuperClassTypes(this.notNullizeContext(context2));
        if (superTypes.isEmpty()) {
            if (EMPTY_ARRAY == null) {
                PyClassImpl.$$$reportNull$$$0(20);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PyClass> result = new ArrayList<PyClass>();
        for (PyClassLikeType type : superTypes) {
            if (!(type instanceof PyClassType)) continue;
            result.add(((PyClassType)type).getPyClass());
        }
        PyClass[] pyClassArray = result.toArray(PyClass.EMPTY_ARRAY);
        if (pyClassArray == null) {
            PyClassImpl.$$$reportNull$$$0(21);
        }
        return pyClassArray;
    }

    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this){

            @Override
            @NotNull
            public String getPresentableText() {
                PyPsiUtils.assertValid((PsiElement)PyClassImpl.this);
                StringBuilder result = new StringBuilder(StringUtil.notNullize((String)PyClassImpl.this.getName(), (String)"<unnamed>"));
                List<String> superClassesText = PyClassImpl.this.getSuperClassesText();
                if (!superClassesText.isEmpty()) {
                    result.append("(");
                    result.append(StringUtil.join(superClassesText, expr -> StringUtil.notNullize((String)expr, (String)"<unnamed>"), (String)", "));
                    result.append(")");
                }
                String string = result.toString();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$1", "getPresentableText"));
            }
        };
    }

    private List<String> getSuperClassesText() {
        PyClassStub stub = (PyClassStub)this.getGreenStub();
        if (stub == null) {
            return ContainerUtil.map((Object[])this.getSuperClassExpressions(), PsiElement::getText);
        }
        return stub.getSuperClassesText();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    private static List<PyClassLikeType> mroMerge(@NotNull List<List<PyClassLikeType>> sequences) throws MROException {
        if (sequences == null) {
            PyClassImpl.$$$reportNull$$$0(22);
        }
        result = new LinkedList<PyClassLikeType>();
        block0: while (true) {
            nonBlankSequences = new ArrayList<List<PyClassLikeType>>(sequences.size());
            for (List<PyClassLikeType> item : sequences) {
                if (item.size() <= 0) continue;
                nonBlankSequences.add(item);
            }
            if (nonBlankSequences.isEmpty()) {
                v0 = result;
                if (v0 == null) {
                    PyClassImpl.$$$reportNull$$$0(23);
                }
                return v0;
            }
            found = false;
            head = null;
            for (List seq : nonBlankSequences) {
                head = (PyClassLikeType)seq.get(0);
                if (head == null) {
                    seq.remove(0);
                    found = true;
                    break;
                }
                headInTails = false;
                for (List tailSeq : nonBlankSequences) {
                    if (tailSeq.indexOf(head) <= 0) continue;
                    headInTails = true;
                    break;
                }
                if (!headInTails) {
                    found = true;
                    break;
                }
                head = null;
            }
            if (!found) {
                throw new MROException("Inconsistent class hierarchy");
            }
            result.add(head);
            if (head == null) continue;
            var5_6 = nonBlankSequences.iterator();
            while (true) {
                if (var5_6.hasNext()) ** break;
                continue block0;
                seq = (List)var5_6.next();
                if (!Comparing.equal((Object)((PyClassLikeType)seq.get(0)), (Object)head)) continue;
                seq.remove(0);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<PyClassLikeType> mroLinearize(@NotNull PyClassLikeType type, boolean addThisType, @NotNull TypeEvalContext context2, @NotNull Map<PyClassLikeType, Ref<List<PyClassLikeType>>> cache2) throws MROException {
        Ref<List<PyClassLikeType>> computed;
        if (type == null) {
            PyClassImpl.$$$reportNull$$$0(24);
        }
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(25);
        }
        if (cache2 == null) {
            PyClassImpl.$$$reportNull$$$0(26);
        }
        if ((computed = cache2.get(type)) != null) {
            if (computed.isNull()) {
                throw new MROException("Circular class inheritance");
            }
            List list = (List)computed.get();
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(27);
            }
            return list;
        }
        cache2.put(type, (Ref<List<PyClassLikeType>>)Ref.create());
        List<PyClassLikeType> result = null;
        try {
            List<PyClassLikeType> bases = PyClassImpl.removeNotNullDuplicates(type.getSuperClassTypes(context2));
            ArrayList<List<PyClassLikeType>> lines = new ArrayList<List<PyClassLikeType>>();
            for (PyClassLikeType base : bases) {
                List<PyClassLikeType> baseClassMRO;
                if (base == null) continue;
                if (base.isDefinition()) {
                    baseClassMRO = PyClassImpl.mroLinearize(base, true, context2, cache2);
                } else {
                    PyClassImpl pyClass;
                    ArrayList<PyClassLikeType> metaclassInstanceMro = new ArrayList<PyClassLikeType>();
                    metaclassInstanceMro.add(base);
                    if (base instanceof PyClassType && (pyClass = PyUtil.as(((PyClassType)base).getPyClass(), PyClassImpl.class)) != null) {
                        ContainerUtil.addIfNotNull(metaclassInstanceMro, (Object)pyClass.getImplicitSuper());
                    }
                    baseClassMRO = metaclassInstanceMro;
                }
                if (baseClassMRO.isEmpty()) continue;
                lines.add(new LinkedList<PyClassLikeType>(baseClassMRO));
            }
            if (!bases.isEmpty()) {
                lines.add(bases);
            }
            result = PyClassImpl.mroMerge(lines);
            if (addThisType) {
                result.add(0, type);
            }
            result = Collections.unmodifiableList(result);
        }
        finally {
            cache2.put(type, (Ref<List<PyClassLikeType>>)Ref.create(result));
        }
        List<PyClassLikeType> list = result;
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static <T> List<T> removeNotNullDuplicates(@NotNull List<T> list) {
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(29);
        }
        HashSet<T> distinct = new HashSet<T>();
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : list) {
            boolean isUnique;
            if (elem != null && !(isUnique = distinct.add(elem))) continue;
            result.add(elem);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Override
    public PyFunction @NotNull [] getMethods() {
        TokenSet functionDeclarationTokens = PythonDialectsTokenSetProvider.getInstance().getFunctionDeclarationTokens();
        return (PyFunction[])this.getClassChildren(functionDeclarationTokens, PyFunction.class, PyFunction.ARRAY_FACTORY);
    }

    @Override
    @NotNull
    public Map<String, Property> getProperties() {
        this.initLocalProperties();
        return new HashMap<String, Property>(this.myLocalPropertyCache);
    }

    @Override
    public PyClass[] getNestedClasses() {
        return (PyClass[])this.getClassChildren(TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.CLASS_DECLARATION}), PyClass.class, PyClass.ARRAY_FACTORY);
    }

    private <T extends StubBasedPsiElement<? extends StubElement<T>>> T @NotNull [] getClassChildren(final @NotNull TokenSet elementTypes, final @NotNull Class<T> childrenClass, @NotNull ArrayFactory<? extends T> factory) {
        if (elementTypes == null) {
            PyClassImpl.$$$reportNull$$$0(31);
        }
        if (childrenClass == null) {
            PyClassImpl.$$$reportNull$$$0(32);
        }
        if (factory == null) {
            PyClassImpl.$$$reportNull$$$0(33);
        }
        final ArrayList result = new ArrayList();
        this.processClassLevelDeclarations(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (childrenClass.isInstance(element) && elementTypes.contains((IElementType)((StubBasedPsiElement)element).getElementType())) {
                    result.add((StubBasedPsiElement)childrenClass.cast(element));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/impl/PyClassImpl$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        StubBasedPsiElement[] stubBasedPsiElementArray = (StubBasedPsiElement[])ContainerUtil.toArray(result, factory);
        if (stubBasedPsiElementArray == null) {
            PyClassImpl.$$$reportNull$$$0(34);
        }
        return stubBasedPsiElementArray;
    }

    @Override
    public PyFunction findMethodByName(@Nullable String name2, boolean inherited, @Nullable TypeEvalContext context2) {
        if (name2 == null) {
            return null;
        }
        NameFinder proc = new NameFinder(this.notNullizeContext(context2), name2);
        this.visitMethods(proc, inherited, context2);
        return (PyFunction)proc.getResult();
    }

    @Override
    @NotNull
    public List<PyFunction> multiFindMethodByName(@NotNull String name2, boolean inherited, @Nullable TypeEvalContext context2) {
        if (name2 == null) {
            PyClassImpl.$$$reportNull$$$0(35);
        }
        MultiNameFinder processor2 = new MultiNameFinder(name2);
        this.visitMethods(processor2, inherited, context2);
        List<PyFunction> list = processor2.myResult;
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Override
    @Nullable
    public PyClass findNestedClass(String name2, boolean inherited) {
        if (name2 == null) {
            return null;
        }
        NameFinder proc = new NameFinder(TypeEvalContext.codeInsightFallback(this.getProject()), name2);
        this.visitNestedClasses(proc, inherited);
        return (PyClass)proc.getResult();
    }

    @Override
    @Nullable
    public PyFunction findInitOrNew(boolean inherited, @Nullable TypeEvalContext context2) {
        NameFinder<PyFunction> proc = this.isNewStyleClass(context2) ? new NameFinder<PyFunction>(this.notNullizeContext(context2), new String[]{"__init__", "__new__"}){

            @Override
            @Nullable
            protected PyClass getContainingClass(@NotNull PyFunction element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                return element.getContainingClass();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyClassImpl$3", "getContainingClass"));
            }
        } : new NameFinder<PyFunction>(this.notNullizeContext(context2), "__init__");
        this.visitMethods((Processor<? super PyFunction>)proc, inherited, context2);
        return (PyFunction)proc.getResult();
    }

    @Override
    @NotNull
    public List<PyFunction> multiFindInitOrNew(boolean inherited, @Nullable TypeEvalContext context2) {
        MultiNameFinder processor2 = this.isNewStyleClass(context2) ? new MultiNameFinder("__init__", "__new__") : new MultiNameFinder("__init__");
        this.visitMethods(processor2, inherited, context2);
        List<PyFunction> list = processor2.myResult;
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(37);
        }
        return list;
    }

    @Nullable
    private Property processPropertiesInClass(@Nullable Processor<? super Property> filter) {
        Property decoratedProperty = this.processDecoratedProperties(filter);
        if (decoratedProperty != null) {
            return decoratedProperty;
        }
        if (this.getStub() != null) {
            return this.processStubProperties(filter);
        }
        for (PyTargetExpression target : this.getClassAttributes()) {
            PropertyImpl property = PropertyImpl.fromTarget(target);
            if (property == null || filter != null && !filter.process((Object)property)) continue;
            return property;
        }
        return null;
    }

    @Nullable
    private Property processDecoratedProperties(@Nullable Processor<? super Property> filter) {
        MultiMap grouped = new MultiMap();
        for (PyFunction method : this.getMethods()) {
            grouped.putValue((Object)method.getName(), (Object)method);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            Maybe<PyCallable> getter = NONE;
            Maybe<PyCallable> setter = NONE;
            Maybe<PyCallable> deleter = NONE;
            String decoratorName = (String)entry.getKey();
            for (PyFunction method : (Collection)entry.getValue()) {
                PyDecoratorList decoratorList = method.getDecoratorList();
                if (decoratorList != null) {
                    for (PyDecorator deco : decoratorList.getDecorators()) {
                        QualifiedName qname = deco.getQualifiedName();
                        if (qname == null) continue;
                        String decoName = qname.toString();
                        for (PyKnownDecoratorProvider provider : PyKnownDecoratorProvider.EP_NAME.getExtensionList()) {
                            String knownName = provider.toKnownDecorator(decoName);
                            if (knownName == null) continue;
                            decoName = knownName;
                        }
                        if ("property".equals(decoName) || PyKnownDecoratorUtil.isPropertyDecorator(deco, TypeEvalContext.codeInsightFallback(this.getProject())) || qname.matches(new String[]{decoratorName, "getter"})) {
                            getter = new Maybe<PyFunction>(method);
                            continue;
                        }
                        if (qname.matches(new String[]{decoratorName, "setter"})) {
                            setter = new Maybe<PyFunction>(method);
                            continue;
                        }
                        if (!qname.matches(new String[]{decoratorName, "deleter"})) continue;
                        deleter = new Maybe<PyFunction>(method);
                    }
                }
                if (getter == NONE || setter == NONE || deleter == NONE) continue;
                break;
            }
            if (getter == NONE && setter == NONE && deleter == NONE) continue;
            PropertyImpl prop = new PropertyImpl(decoratorName, getter, setter, deleter, null, null);
            if (filter != null && !filter.process((Object)prop)) continue;
            return prop;
        }
        return null;
    }

    private Maybe<PyCallable> fromPacked(Maybe<String> maybeName) {
        if (maybeName.isDefined()) {
            String value = maybeName.value();
            if (value == null || "None".equals(value)) {
                return NONE;
            }
            PyFunction method = this.findMethodByName(value, true, null);
            if (method != null) {
                return new Maybe<PyCallable>(method);
            }
        }
        return UNKNOWN_CALL;
    }

    @Nullable
    private Property processStubProperties(@Nullable Processor<? super Property> filter) {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            for (StubElement subStub : stub.getChildrenStubs()) {
                PyTargetExpressionStub targetStub;
                PropertyStubStorage prop;
                if (subStub.getStubType() != PyElementTypes.TARGET_EXPRESSION || (prop = (targetStub = (PyTargetExpressionStub)subStub).getCustomStub(PropertyStubStorage.class)) == null) continue;
                Maybe<PyCallable> getter = this.fromPacked(prop.getGetter());
                Maybe<PyCallable> setter = this.fromPacked(prop.getSetter());
                Maybe<PyCallable> deleter = this.fromPacked(prop.getDeleter());
                String doc = prop.getDoc();
                if (getter == NONE && setter == NONE && deleter == NONE) continue;
                PropertyImpl property = new PropertyImpl(targetStub.getName(), getter, setter, deleter, doc, (PyTargetExpression)targetStub.getPsi());
                if (filter != null && !filter.process((Object)property)) continue;
                return property;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Property findProperty(@NotNull String name2, boolean inherited, @Nullable TypeEvalContext context2) {
        if (name2 == null) {
            PyClassImpl.$$$reportNull$$$0(38);
        }
        this.initLocalProperties();
        Property property = this.myLocalPropertyCache.get(name2);
        if (property != null) {
            return property;
        }
        if (this.findMethodByName(name2, false, context2) != null || this.findClassAttribute(name2, false, context2) != null || ContainerUtil.notNullize(this.getOwnSlots()).contains(name2)) {
            return null;
        }
        if (inherited) {
            for (PyClass cls : this.getAncestorClasses(context2)) {
                Property ancestorProperty = cls.findProperty(name2, false, context2);
                if (ancestorProperty == null) continue;
                return ancestorProperty;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Property findPropertyByCallable(PyCallable callable) {
        this.initLocalProperties();
        for (Property property : this.myLocalPropertyCache.values()) {
            if (property.getGetter().valueOrNull() != callable && property.getSetter().valueOrNull() != callable && property.getDeleter().valueOrNull() != callable) continue;
            return property;
        }
        return null;
    }

    private synchronized void initLocalProperties() {
        if (this.myLocalPropertyCache == null) {
            HashMap<String, Property> result = new HashMap<String, Property>();
            this.processProperties((Processor<? super Property>)((Processor)property -> {
                result.put(property.getName(), (Property)property);
                return false;
            }), false);
            this.myLocalPropertyCache = result;
        }
    }

    @Override
    @Nullable
    public Property scanProperties(Processor<? super Property> filter, boolean inherited) {
        return this.processProperties(filter, inherited);
    }

    @Nullable
    private Property processProperties(@Nullable Processor<? super Property> filter, boolean inherited) {
        PyPsiUtils.assertValid((PsiElement)this);
        Property local = this.processPropertiesInClass(filter);
        if (local != null) {
            return local;
        }
        if (inherited) {
            for (PyClass cls : this.getAncestorClasses(null)) {
                Property property = ((PyClassImpl)cls).processPropertiesInClass(filter);
                if (property == null) continue;
                return property;
            }
        }
        return null;
    }

    @Override
    public boolean visitMethods(Processor<? super PyFunction> processor2, boolean inherited, @Nullable TypeEvalContext context2) {
        if (!ContainerUtil.process((Object[])this.getMethods(), processor2)) {
            return false;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses(context2)) {
                if (ancestor.visitMethods(processor2, false, context2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean visitNestedClasses(Processor<? super PyClass> processor2, boolean inherited) {
        Object[] nestedClasses = this.getNestedClasses();
        if (!ContainerUtil.process((Object[])nestedClasses, processor2)) {
            return false;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses(null)) {
                if (((PyClassImpl)ancestor).visitNestedClasses(processor2, false)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean visitClassAttributes(Processor<? super PyTargetExpression> processor2, boolean inherited, @Nullable TypeEvalContext context2) {
        List<PyTargetExpression> methods = this.getClassAttributes();
        if (!ContainerUtil.process(methods, processor2)) {
            return false;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses(context2)) {
                if (ancestor.visitClassAttributes(processor2, false, context2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public final List<PyTargetExpression> getClassAttributesInherited(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(39);
        }
        MyAttributesCollector attributesCollector = new MyAttributesCollector();
        this.visitClassAttributes(attributesCollector, true, context2);
        List<PyTargetExpression> list = attributesCollector.getAttributes();
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(40);
        }
        return list;
    }

    @Override
    public List<PyTargetExpression> getClassAttributes() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            PyTargetExpression[] children2 = (PyTargetExpression[])stub.getChildrenByType((IElementType)PyElementTypes.TARGET_EXPRESSION, PyTargetExpression.EMPTY_ARRAY);
            return Arrays.asList(children2);
        }
        ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
        for (PsiElement psiElement : this.getStatementList().getChildren()) {
            PyExpression target;
            if (psiElement instanceof PyAssignmentStatement) {
                PyExpression[] targets;
                PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)psiElement;
                for (PyExpression target2 : targets = assignmentStatement.getTargets()) {
                    if (!(target2 instanceof PyTargetExpression)) continue;
                    result.add((PyTargetExpression)target2);
                }
                continue;
            }
            if (!(psiElement instanceof PyTypeDeclarationStatement) || !((target = ((PyTypeDeclarationStatement)psiElement).getTarget()) instanceof PyTargetExpression)) continue;
            result.add((PyTargetExpression)target);
        }
        return result;
    }

    @Override
    public PyTargetExpression findClassAttribute(@NotNull String name2, boolean inherited, TypeEvalContext context2) {
        if (name2 == null) {
            PyClassImpl.$$$reportNull$$$0(41);
        }
        NameFinder processor2 = new NameFinder(this.notNullizeContext(context2), name2);
        this.visitClassAttributes(processor2, inherited, context2);
        return (PyTargetExpression)processor2.getResult();
    }

    @Override
    @NotNull
    public List<PyTargetExpression> getInstanceAttributes() {
        List<PyTargetExpression> attributes = this.myInstanceAttributes;
        if (attributes != null) {
            List<PyTargetExpression> list = attributes;
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(42);
            }
            return list;
        }
        this.myInstanceAttributes = attributes = this.collectInstanceAttributes(Collections.emptyMap());
        List<PyTargetExpression> list = attributes;
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(43);
        }
        return list;
    }

    @Override
    @Nullable
    public PyTargetExpression findInstanceAttribute(String name2, boolean inherited) {
        List<PyTargetExpression> instanceAttributes = this.getInstanceAttributes();
        for (PyTargetExpression instanceAttribute : instanceAttributes) {
            if (!name2.equals(instanceAttribute.getReferencedName())) continue;
            return instanceAttribute;
        }
        if (inherited) {
            for (PyClass ancestor : this.getAncestorClasses(null)) {
                PyTargetExpression attribute = ancestor.findInstanceAttribute(name2, false);
                if (attribute == null) continue;
                return attribute;
            }
        }
        return null;
    }

    @NotNull
    private List<PyTargetExpression> getFallbackInstanceAttributes() {
        List<PyTargetExpression> attributes = this.myFallbackInstanceAttributes;
        if (attributes != null) {
            List<PyTargetExpression> list = attributes;
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(44);
            }
            return list;
        }
        Map scopesToSkip = ((StreamEx)StreamEx.of(this.getInstanceAttributes()).filter(e -> e.getName() != null)).mapToEntry(e -> e.getName(), e -> ScopeUtil.getScopeOwner(e)).toMap();
        this.myFallbackInstanceAttributes = attributes = this.collectInstanceAttributes(scopesToSkip);
        List<PyTargetExpression> list = attributes;
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    private List<PyTargetExpression> collectInstanceAttributes(@NotNull Map<String, ScopeOwner> scopesToSkip) {
        PyFunction[] methods;
        if (scopesToSkip == null) {
            PyClassImpl.$$$reportNull$$$0(46);
        }
        HashMap<String, PyTargetExpression> result = new HashMap<String, PyTargetExpression>();
        this.collectAttributesInConstructors(result, scopesToSkip);
        for (PyFunction method : methods = this.getMethods()) {
            PyClassImpl.collectInstanceAttributes(method, result, result.keySet(), scopesToSkip);
        }
        return new ArrayList<PyTargetExpression>(result.values());
    }

    private void collectAttributesInConstructors(@NotNull Map<String, PyTargetExpression> result, @NotNull Map<String, ScopeOwner> scopesToSkip) {
        PyFunction initMethod;
        PyFunction newMethod;
        if (result == null) {
            PyClassImpl.$$$reportNull$$$0(47);
        }
        if (scopesToSkip == null) {
            PyClassImpl.$$$reportNull$$$0(48);
        }
        if ((newMethod = this.findMethodByName("__new__", false, null)) != null) {
            for (PyTargetExpression target : PyClassImpl.getTargetExpressions(newMethod)) {
                String name2 = target.getName();
                if (scopesToSkip.get(name2) == newMethod) continue;
                result.put(name2, target);
            }
        }
        if ((initMethod = this.findMethodByName("__init__", false, null)) != null) {
            PyClassImpl.collectInstanceAttributes(initMethod, result, Collections.emptySet(), scopesToSkip);
        }
    }

    public static void collectInstanceAttributes(@NotNull PyFunction method, @NotNull Map<String, PyTargetExpression> result) {
        if (method == null) {
            PyClassImpl.$$$reportNull$$$0(49);
        }
        if (result == null) {
            PyClassImpl.$$$reportNull$$$0(50);
        }
        PyClassImpl.collectInstanceAttributes(method, result, Collections.emptySet(), Collections.emptyMap());
    }

    private static void collectInstanceAttributes(@NotNull PyFunction method, @NotNull Map<String, PyTargetExpression> result, @NotNull Set<String> namesToSkip, @NotNull Map<String, ScopeOwner> scopesToSkip) {
        PyParameter[] params;
        if (method == null) {
            PyClassImpl.$$$reportNull$$$0(51);
        }
        if (result == null) {
            PyClassImpl.$$$reportNull$$$0(52);
        }
        if (namesToSkip == null) {
            PyClassImpl.$$$reportNull$$$0(53);
        }
        if (scopesToSkip == null) {
            PyClassImpl.$$$reportNull$$$0(54);
        }
        if ((params = method.getParameterList().getParameters()).length == 0) {
            return;
        }
        for (PyTargetExpression target : PyClassImpl.getTargetExpressions(method)) {
            String name2 = target.getName();
            if (namesToSkip.contains(name2) || scopesToSkip.get(name2) == method || !PyUtil.isInstanceAttribute(target)) continue;
            result.put(name2, target);
        }
    }

    @NotNull
    private static List<PyTargetExpression> getTargetExpressions(@NotNull PyFunction function) {
        PyFunctionStub stub;
        if (function == null) {
            PyClassImpl.$$$reportNull$$$0(55);
        }
        if ((stub = (PyFunctionStub)function.getStub()) != null) {
            List<PyTargetExpression> list = Arrays.asList((PyTargetExpression[])stub.getChildrenByType((IElementType)PyElementTypes.TARGET_EXPRESSION, PyTargetExpression.EMPTY_ARRAY));
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(56);
            }
            return list;
        }
        PyStatementList statementList = function.getStatementList();
        final ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
        statementList.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyClass(@NotNull PyClass node) {
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
                if (node == null) {
                    4.$$$reportNull$$$0(1);
                }
                for (PyExpression expression : node.getTargets()) {
                    if (!(expression instanceof PyTargetExpression)) continue;
                    result.add((PyTargetExpression)expression);
                }
            }

            @Override
            public void visitPyWithStatement(@NotNull PyWithStatement node) {
                if (node == null) {
                    4.$$$reportNull$$$0(2);
                }
                StreamEx.of((Object[])node.getWithItems()).map(PyWithItem::getTarget).select(PyTargetExpression.class).forEach(result::add);
                super.visitPyWithStatement(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyClassImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyAssignmentStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyWithStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<PyTargetExpression> arrayList = result;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    @Override
    public boolean isNewStyleClass(@Nullable TypeEvalContext context2) {
        return (Boolean)((ParameterizedCachedValue)NotNullLazyValue.lazy(() -> CachedValuesManager.getManager((Project)this.getProject()).createParameterizedCachedValue(param -> new CachedValueProvider.Result((Object)this.calculateNewStyleClass((TypeEvalContext)param), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false)).getValue()).getValue((Object)context2);
    }

    private boolean calculateNewStyleClass(@Nullable TypeEvalContext context2) {
        PsiFile containingFile = this.getContainingFile();
        if (containingFile instanceof PyFile && ((PyFile)containingFile).getLanguageLevel().isPy3K()) {
            return true;
        }
        PyClass objClass = PyBuiltinCache.getInstance((PsiElement)this).getClass("object");
        if (this == objClass) {
            return true;
        }
        if (PyClassImpl.hasNewStyleMetaClass(this)) {
            return true;
        }
        for (PyClassLikeType type : this.getOldStyleAncestorTypes(this.notNullizeContext(context2))) {
            PyClass pyClass;
            if (type == null) {
                return true;
            }
            if (!(type instanceof PyClassType) || (pyClass = ((PyClassType)type).getPyClass()) != objClass && !PyClassImpl.hasNewStyleMetaClass(pyClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNewStyleMetaClass(PyClass pyClass) {
        QualifiedName qName;
        PsiElement element;
        PsiFile containingFile = pyClass.getContainingFile();
        if (containingFile instanceof PyFile && (element = ((PyFile)containingFile).getElementNamed("__metaclass__")) instanceof PyTargetExpression && (qName = ((PyTargetExpression)element).getAssignedQName()) != null && qName.matches(new String[]{"type"})) {
            return true;
        }
        return pyClass.findClassAttribute("__metaclass__", false, null) != null;
    }

    @Override
    public boolean processClassLevelDeclarations(@NotNull PsiScopeProcessor processor2) {
        PyClassStub stub;
        if (processor2 == null) {
            PyClassImpl.$$$reportNull$$$0(58);
        }
        if ((stub = (PyClassStub)this.getStub()) != null) {
            List children2 = stub.getChildrenStubs();
            for (StubElement child : children2) {
                if (processor2.execute(child.getPsi(), ResolveState.initial())) continue;
                return false;
            }
        } else {
            PyResolveUtil.scopeCrawlUp(processor2, this, null, (PsiElement)this);
        }
        return true;
    }

    @Override
    public boolean processInstanceLevelDeclarations(@NotNull PsiScopeProcessor processor2, @Nullable PsiElement location) {
        PyFunction instanceMethod;
        PyClass containingClass;
        if (processor2 == null) {
            PyClassImpl.$$$reportNull$$$0(59);
        }
        PyClass pyClass = containingClass = (instanceMethod = (PyFunction)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)location, PyFunction.class)) != null ? instanceMethod.getContainingClass() : null;
        if (instanceMethod != null && containingClass != null && CompletionUtilCoreImpl.getOriginalElement((PsiElement)containingClass) == this) {
            for (PyTargetExpression target : PyClassImpl.getTargetExpressions(instanceMethod)) {
                if (!PyUtil.isInstanceAttribute(target) || processor2.execute((PsiElement)target, ResolveState.initial())) continue;
                return false;
            }
        }
        if (!PyClassImpl.processInstanceAttributesNotInMethod(processor2, instanceMethod, this.getInstanceAttributes())) {
            return false;
        }
        return PyClassImpl.processInstanceAttributesNotInMethod(processor2, instanceMethod, this.getFallbackInstanceAttributes());
    }

    private static boolean processInstanceAttributesNotInMethod(@NotNull PsiScopeProcessor processor2, @Nullable PyFunction instanceMethod, @NotNull List<PyTargetExpression> instanceAttributes) {
        if (processor2 == null) {
            PyClassImpl.$$$reportNull$$$0(60);
        }
        if (instanceAttributes == null) {
            PyClassImpl.$$$reportNull$$$0(61);
        }
        for (PyTargetExpression expr : instanceAttributes) {
            if (instanceMethod != null && ScopeUtil.getScopeOwner(expr) == instanceMethod || processor2.execute((PsiElement)expr, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    public int getTextOffset() {
        ASTNode name2 = this.getNameNode();
        return name2 != null ? name2.getStartOffset() : super.getTextOffset();
    }

    @Override
    @Nullable
    public PyStringLiteralExpression getDocStringExpression() {
        return DocStringUtil.findDocStringExpression(this.getStatementList());
    }

    @Override
    public String getDocStringValue() {
        PyClassStub stub = (PyClassStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString(this);
    }

    @Override
    public String toString() {
        return "PyClass: " + this.getName();
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        ControlFlowCache.clear(this);
        this.myInstanceAttributes = null;
        this.myFallbackInstanceAttributes = null;
        this.myLocalPropertyCache = null;
    }

    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)this);
        if (scopeOwner instanceof PyFunction) {
            return new LocalSearchScope((PsiElement)scopeOwner);
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            PyClassImpl.$$$reportNull$$$0(62);
        }
        return searchScope;
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(63);
        }
        List list = (List)PyUtil.getParameterizedCachedValue((PsiElement)this, context2, this::doGetSuperClassTypes);
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(64);
        }
        return list;
    }

    @NotNull
    private List<PyClassLikeType> doGetSuperClassTypes(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(65);
        }
        ArrayList<PyClassLikeType> result = new ArrayList<PyClassLikeType>();
        if (!context2.maySwitchToAST((PsiElement)this)) {
            this.fillSuperClassesNoSwitchToAst(context2, (PyClassStub)this.getStub(), result);
        } else {
            this.fillSuperClassesSwitchingToAst(context2, result);
        }
        PyPsiUtils.assertValid((PsiElement)this);
        if (result.isEmpty()) {
            List<PyClassLikeType> list = Optional.ofNullable(this.getImplicitSuper()).map(Collections::singletonList).orElse(Collections.emptyList());
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(66);
            }
            return list;
        }
        ArrayList<PyClassLikeType> arrayList = result;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(67);
        }
        return arrayList;
    }

    private void fillSuperClassesSwitchingToAst(@NotNull TypeEvalContext context2, List<PyClassLikeType> result) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(68);
        }
        for (PyExpression expression : PyClassImpl.getUnfoldedSuperClassExpressions(this)) {
            PyType type = context2.getType(expression);
            PyClassLikeType classLikeType = null;
            if (type instanceof PyClassLikeType) {
                classLikeType = (PyClassLikeType)type;
            } else {
                PyType resolvedType;
                PsiElement resolved;
                PyReferenceExpression referenceExpr = PyUtil.as(expression, PyReferenceExpression.class);
                if (referenceExpr != null) {
                    resolved = referenceExpr.followAssignmentsChain(PyResolveContext.defaultContext(context2)).getElement();
                } else {
                    PsiReference ref = expression.getReference();
                    PsiElement psiElement = resolved = ref != null ? ref.resolve() : null;
                }
                if (resolved instanceof PyClass && (resolvedType = context2.getType((PyClass)resolved)) instanceof PyClassLikeType) {
                    classLikeType = (PyClassLikeType)resolvedType;
                }
            }
            result.add(classLikeType);
        }
    }

    private void fillSuperClassesNoSwitchToAst(@NotNull TypeEvalContext context2, @Nullable PyClassStub stub, @NotNull List<? super PyClassLikeType> result) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(69);
        }
        if (result == null) {
            PyClassImpl.$$$reportNull$$$0(70);
        }
        Map<QualifiedName, QualifiedName> superClasses = stub != null ? stub.getSuperClasses() : PyClassElementType.getSuperClassQNames(this);
        PsiFile file = this.getContainingFile();
        if (file instanceof PyFile) {
            for (QualifiedName name2 : superClasses.keySet()) {
                result.add(name2 != null ? PyClassImpl.classTypeFromQName(name2, (PyFile)file, context2) : null);
            }
        }
    }

    @Nullable
    private PyClassLikeType getImplicitSuper() {
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)this);
        PyClassType objectType = builtinCache.getObjectType();
        if (objectType != null && this == objectType.getPyClass()) {
            return null;
        }
        if (LanguageLevel.forElement((PsiElement)this).isPython2() && this.getMetaClassQName() == null && !PyClassImpl.hasNewStyleMetaClass(this)) {
            return null;
        }
        return objectType == null ? null : (PyClassLikeType)objectType.toClass();
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getAncestorTypes(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(71);
        }
        List list = ContainerUtil.filter(this.getAncestorTypesWithMetaClassInstances(context2), type -> type == null || type.isDefinition());
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(72);
        }
        return list;
    }

    @NotNull
    private List<PyClassLikeType> getAncestorTypesWithMetaClassInstances(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(73);
        }
        List list = (List)PyUtil.getParameterizedCachedValue((PsiElement)this, context2, contextArgument -> {
            List<PyClassLikeType> ancestorTypes;
            if (this.isNewStyleClass((TypeEvalContext)contextArgument)) {
                try {
                    ancestorTypes = this.getMROAncestorTypes((TypeEvalContext)contextArgument);
                }
                catch (MROException ignored) {
                    ancestorTypes = this.getOldStyleAncestorTypes((TypeEvalContext)contextArgument);
                    boolean hasUnresolvedAncestorTypes = false;
                    for (PyClassLikeType type : ancestorTypes) {
                        if (type != null) continue;
                        hasUnresolvedAncestorTypes = true;
                        break;
                    }
                    if (!hasUnresolvedAncestorTypes) {
                        ancestorTypes = Collections.singletonList(null);
                    }
                }
            } else {
                ancestorTypes = this.getOldStyleAncestorTypes((TypeEvalContext)contextArgument);
            }
            return ancestorTypes;
        });
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(74);
        }
        return list;
    }

    @Override
    @Nullable
    public PyType getMetaClassType(@NotNull TypeEvalContext context2) {
        PsiElement element;
        LanguageLevel level;
        PyFile pyFile;
        PsiFile file;
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(75);
        }
        PyPsiUtils.assertValid((PsiElement)this);
        if (context2.maySwitchToAST((PsiElement)this)) {
            PyType type;
            PyExpression expression = this.getMetaClassExpression();
            if (expression != null && (type = context2.getType(expression)) != null) {
                return type;
            }
        } else {
            QualifiedName name2 = this.getMetaClassQName();
            file = this.getContainingFile();
            if (file instanceof PyFile) {
                pyFile = (PyFile)file;
                if (name2 != null) {
                    return PyClassImpl.classTypeFromQName(name2, pyFile, context2);
                }
            }
        }
        if ((level = LanguageLevel.forElement((PsiElement)this)).isPython2() && (file = this.getContainingFile()) instanceof PyFile && (element = (pyFile = (PyFile)file).getElementNamed("__metaclass__")) instanceof PyTypedElement) {
            return context2.getType((PyTypedElement)element);
        }
        return null;
    }

    @Override
    @Nullable
    public PyClassLikeType getMetaClassType(boolean inherited, @NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(76);
        }
        if (!inherited) {
            return PyUtil.as(this.getMetaClassType(context2), PyClassLikeType.class);
        }
        List<PyClassLikeType> metaClassTypes = this.getAllPossibleMetaClassTypes(context2);
        PyClassLikeType mostDerivedMeta = PyClassImpl.getMostDerivedClassType(metaClassTypes, context2);
        return mostDerivedMeta != null ? mostDerivedMeta : PyBuiltinCache.getInstance((PsiElement)this).getObjectType("type");
    }

    @Nullable
    private static PyClassLikeType getMostDerivedClassType(@NotNull @NotNull List<@NotNull PyClassLikeType> classTypes, @NotNull TypeEvalContext context2) {
        if (classTypes == null) {
            PyClassImpl.$$$reportNull$$$0(77);
        }
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(78);
        }
        if (classTypes.isEmpty()) {
            return null;
        }
        try {
            return classTypes.stream().filter(t -> !"abc.ABCMeta".equals(t.getClassQName())).max((t1, t2) -> {
                if (Objects.equals(t1, t2)) {
                    return 0;
                }
                if (t1.getAncestorTypes(context2).contains(t2)) {
                    return 1;
                }
                if (t2.getAncestorTypes(context2).contains(t1)) {
                    return -1;
                }
                throw new NotDerivedClassTypeException();
            }).orElse(null);
        }
        catch (NotDerivedClassTypeException ignored) {
            return null;
        }
    }

    @NotNull
    private @NotNull List<@NotNull PyClassLikeType> getAllPossibleMetaClassTypes(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(79);
        }
        ArrayList<PyClassLikeType> results = new ArrayList<PyClassLikeType>();
        PyClassLikeType ownMeta = this.getMetaClassType(false, context2);
        if (ownMeta != null) {
            results.add(ownMeta);
        }
        for (PyClassLikeType ancestor : this.getAncestorTypesWithMetaClassInstances(context2)) {
            if (ancestor == null) continue;
            if (!ancestor.isDefinition()) {
                results.add((PyClassLikeType)ancestor.toClass());
                continue;
            }
            PyClassLikeType ancestorMeta = ancestor.getMetaClassType(context2, false);
            if (ancestorMeta == null) continue;
            results.add(ancestorMeta);
        }
        ArrayList<PyClassLikeType> arrayList = results;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(80);
        }
        return arrayList;
    }

    @Nullable
    private QualifiedName getMetaClassQName() {
        PyClassStub stub = (PyClassStub)this.getStub();
        return stub != null ? stub.getMetaClass() : PyPsiUtils.asQualifiedName(this.getMetaClassExpression());
    }

    @Override
    @Nullable
    public PyExpression getMetaClassExpression() {
        LanguageLevel level = LanguageLevel.forElement((PsiElement)this);
        if (!level.isPython2()) {
            for (PyExpression expression : this.getSuperClassExpressions()) {
                PyKeywordArgument argument;
                if (!(expression instanceof PyKeywordArgument) || !"metaclass".equals((argument = (PyKeywordArgument)expression).getKeyword())) continue;
                return argument.getValueExpression();
            }
        } else {
            PyExpression[] attribute = this.findClassAttribute("__metaclass__", false, null);
            if (attribute != null) {
                return attribute.findAssignedValue();
            }
        }
        for (PyExpression expression : this.getSuperClassExpressions()) {
            PyExpression[] arguments;
            if (!PyClassImpl.isSixWithMetaclassCall(expression) || (arguments = ((PyCallExpression)expression).getArguments()).length == 0) continue;
            return arguments[0];
        }
        PyDecoratorList decoratorList = this.getDecoratorList();
        if (decoratorList != null) {
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                PyExpression[] arguments;
                if (!PyClassImpl.isSixAddMetaclass(decorator) || (arguments = decorator.getArguments()).length == 0) continue;
                return arguments[0];
            }
        }
        return null;
    }

    private static boolean isSixAddMetaclass(@NotNull PyDecorator decorator) {
        PyExpression callee;
        if (decorator == null) {
            PyClassImpl.$$$reportNull$$$0(81);
        }
        if ((callee = decorator.getCallee()) instanceof PyReferenceExpression) {
            QualifiedName sixAddMetaclass = QualifiedName.fromComponents((String[])new String[]{"six", "add_metaclass"});
            QualifiedName djangoAddMetaclass = QualifiedName.fromDottedString((String)"django.utils.six.add_metaclass");
            return ContainerUtil.exists(PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)callee), name2 -> name2.equals((Object)sixAddMetaclass) || name2.equals((Object)djangoAddMetaclass));
        }
        return false;
    }

    @NotNull
    private List<PyClassLikeType> getMROAncestorTypes(@NotNull TypeEvalContext context2) throws MROException {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(82);
        }
        PyPsiUtils.assertValid((PsiElement)this);
        PyType thisType = context2.getType(this);
        if (thisType instanceof PyClassLikeType) {
            List<PyClassLikeType> ancestorTypes = PyClassImpl.mroLinearize((PyClassLikeType)thisType, false, context2, new HashMap<PyClassLikeType, Ref<List<PyClassLikeType>>>());
            if (this.isOverriddenMRO(ancestorTypes, context2)) {
                ArrayList<PyClassLikeType> withNull = new ArrayList<PyClassLikeType>(ancestorTypes);
                withNull.add(null);
                ArrayList<PyClassLikeType> arrayList = withNull;
                if (arrayList == null) {
                    PyClassImpl.$$$reportNull$$$0(83);
                }
                return arrayList;
            }
            List<PyClassLikeType> list = ancestorTypes;
            if (list == null) {
                PyClassImpl.$$$reportNull$$$0(84);
            }
            return list;
        }
        List<PyClassLikeType> list = Collections.emptyList();
        if (list == null) {
            PyClassImpl.$$$reportNull$$$0(85);
        }
        return list;
    }

    private boolean isOverriddenMRO(@NotNull List<PyClassLikeType> ancestorTypes, @NotNull TypeEvalContext context2) {
        if (ancestorTypes == null) {
            PyClassImpl.$$$reportNull$$$0(86);
        }
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(87);
        }
        ArrayList<PyClass> classes = new ArrayList<PyClass>();
        classes.add(this);
        for (PyClassLikeType ancestorType : ancestorTypes) {
            if (!(ancestorType instanceof PyClassType)) continue;
            PyClassType classType = (PyClassType)ancestorType;
            classes.add(classType.getPyClass());
        }
        PyClass typeClass = PyBuiltinCache.getInstance((PsiElement)this).getClass("type");
        for (PyClass cls : classes) {
            PyClass mroClass;
            PyType metaClassType = cls.getMetaClassType(context2);
            if (!(metaClassType instanceof PyClassType)) continue;
            PyClass metaClass = ((PyClassType)metaClassType).getPyClass();
            if (cls == metaClass) {
                return false;
            }
            PyFunction mroMethod = metaClass.findMethodByName("mro", true, null);
            if (mroMethod == null || (mroClass = mroMethod.getContainingClass()) == null || mroClass == typeClass) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<PyClassLikeType> getOldStyleAncestorTypes(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(88);
        }
        ArrayList<PyClassLikeType> results = new ArrayList<PyClassLikeType>();
        LinkedList<PyClassLikeType> toProcess = new LinkedList<PyClassLikeType>();
        HashSet<PyClassLikeType> seen = new HashSet<PyClassLikeType>();
        HashSet<PyClassLikeType> visited = new HashSet<PyClassLikeType>();
        PyType thisType = context2.getType(this);
        if (thisType instanceof PyClassLikeType) {
            toProcess.add((PyClassLikeType)thisType);
        }
        while (!toProcess.isEmpty()) {
            PyClassLikeType currentType = (PyClassLikeType)toProcess.pollFirst();
            if (!visited.add(currentType)) continue;
            for (PyClassLikeType superType : currentType.getSuperClassTypes(context2)) {
                if (superType == null || !seen.contains(superType)) {
                    results.add(superType);
                    seen.add(superType);
                }
                if (superType == null || visited.contains(superType)) continue;
                toProcess.addLast(superType);
            }
        }
        ArrayList<PyClassLikeType> arrayList = results;
        if (arrayList == null) {
            PyClassImpl.$$$reportNull$$$0(89);
        }
        return arrayList;
    }

    @Nullable
    private static PyClassLikeType classTypeFromQName(@NotNull QualifiedName qualifiedName, @NotNull PyFile containingFile, @NotNull TypeEvalContext context2) {
        PyType type;
        PsiElement element;
        if (qualifiedName == null) {
            PyClassImpl.$$$reportNull$$$0(90);
        }
        if (containingFile == null) {
            PyClassImpl.$$$reportNull$$$0(91);
        }
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(92);
        }
        if ((element = (PsiElement)ContainerUtil.getFirstItem(PyResolveUtil.resolveQualifiedNameInScope(qualifiedName, containingFile, context2))) instanceof PyTypedElement && (type = context2.getType((PyTypedElement)element)) instanceof PyClassLikeType) {
            return (PyClassLikeType)type;
        }
        return null;
    }

    @Override
    @Nullable
    public PyClassLikeType getType(@NotNull TypeEvalContext context2) {
        if (context2 == null) {
            PyClassImpl.$$$reportNull$$$0(93);
        }
        return PyUtil.as(context2.getType(this), PyClassLikeType.class);
    }

    @NotNull
    private TypeEvalContext notNullizeContext(@Nullable TypeEvalContext context2) {
        TypeEvalContext typeEvalContext = context2 == null ? TypeEvalContext.codeInsightFallback(this.getProject()) : context2;
        if (typeEvalContext == null) {
            PyClassImpl.$$$reportNull$$$0(94);
        }
        return typeEvalContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 74: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 94: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 74: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 94: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 6: 
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 74: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyClassImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassQName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequences";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 46: 
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopesToSkip";
                break;
            }
            case 47: 
            case 50: 
            case 52: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToSkip";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceAttributes";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classTypes";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorTypes";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyClassImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassExpressions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnfoldedSuperClassExpressions";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "unfoldSuperClassExpression";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorClasses";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "mroMerge";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "mroLinearize";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNotNullDuplicates";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassChildren";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "multiFindMethodByName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "multiFindInitOrNew";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAttributesInherited";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAttributes";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getFallbackInstanceAttributes";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetExpressions";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassTypes";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetSuperClassTypes";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorTypes";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorTypesWithMetaClassInstances";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPossibleMetaClassTypes";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getMROAncestorTypes";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldStyleAncestorTypes";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullizeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 74: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 94: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUnfoldedSuperClassExpressions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unfoldSuperClassExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSixWithMetaclassCall";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSubclass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mroMerge";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mroLinearize";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeNotNullDuplicates";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getClassChildren";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "multiFindMethodByName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getClassAttributesInherited";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findClassAttribute";
                break;
            }
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "collectInstanceAttributes";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "collectAttributesInConstructors";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getTargetExpressions";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "processClassLevelDeclarations";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processInstanceLevelDeclarations";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processInstanceAttributesNotInMethod";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypes";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "doGetSuperClassTypes";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "fillSuperClassesSwitchingToAst";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "fillSuperClassesNoSwitchToAst";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorTypes";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorTypesWithMetaClassInstances";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClassType";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getMostDerivedClassType";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getAllPossibleMetaClassTypes";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isSixAddMetaclass";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getMROAncestorTypes";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "isOverriddenMRO";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getOldStyleAncestorTypes";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "classTypeFromQName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 72: 
            case 74: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 89: 
            case 94: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyAttributesCollector
    implements Processor<PyTargetExpression> {
        private final List<PyTargetExpression> myAttributes = new ArrayList<PyTargetExpression>();

        private MyAttributesCollector() {
        }

        public boolean process(PyTargetExpression expression) {
            this.myAttributes.add(expression);
            return true;
        }

        @NotNull
        List<PyTargetExpression> getAttributes() {
            List<PyTargetExpression> list = Collections.unmodifiableList(this.myAttributes);
            if (list == null) {
                MyAttributesCollector.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyClassImpl$MyAttributesCollector", "getAttributes"));
        }
    }

    private static final class NotDerivedClassTypeException
    extends RuntimeException {
        private NotDerivedClassTypeException() {
        }
    }

    private static final class PropertyImpl
    extends PropertyBunch<PyCallable>
    implements Property {
        private final String myName;

        private PropertyImpl(String name2, Maybe<PyCallable> getter, Maybe<PyCallable> setter, Maybe<PyCallable> deleter, String doc, PyTargetExpression site) {
            this.myName = name2;
            this.myDeleter = deleter;
            this.myGetter = getter;
            this.mySetter = setter;
            this.myDoc = doc;
            this.mySite = site;
        }

        @Override
        @NotNull
        public Maybe<PyCallable> getGetter() {
            return PropertyImpl.filterNonStubExpression(this.myGetter);
        }

        @Override
        @NotNull
        public Maybe<PyCallable> getSetter() {
            return PropertyImpl.filterNonStubExpression(this.mySetter);
        }

        @Override
        @NotNull
        public Maybe<PyCallable> getDeleter() {
            return PropertyImpl.filterNonStubExpression(this.myDeleter);
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        @Nullable
        public PyTargetExpression getDefinitionSite() {
            return this.mySite;
        }

        @Override
        @NotNull
        public Maybe<PyCallable> getByDirection(@NotNull AccessDirection direction) {
            if (direction == null) {
                PropertyImpl.$$$reportNull$$$0(0);
            }
            switch (direction) {
                case READ: {
                    Maybe<PyCallable> maybe = this.getGetter();
                    if (maybe == null) {
                        PropertyImpl.$$$reportNull$$$0(1);
                    }
                    return maybe;
                }
                case WRITE: {
                    Maybe<PyCallable> maybe = this.getSetter();
                    if (maybe == null) {
                        PropertyImpl.$$$reportNull$$$0(2);
                    }
                    return maybe;
                }
                case DELETE: {
                    Maybe<PyCallable> maybe = this.getDeleter();
                    if (maybe == null) {
                        PropertyImpl.$$$reportNull$$$0(3);
                    }
                    return maybe;
                }
            }
            throw new IllegalArgumentException("Unknown direction " + PyUtil.nvl((Object)direction));
        }

        @Override
        @Nullable
        public PyType getType(@Nullable PyExpression receiver, @NotNull TypeEvalContext context2) {
            PyType targetDocStringType;
            if (context2 == null) {
                PropertyImpl.$$$reportNull$$$0(4);
            }
            if (this.mySite instanceof PyTargetExpressionImpl && (targetDocStringType = ((PyTargetExpressionImpl)this.mySite).getTypeFromDocString()) != null) {
                return targetDocStringType;
            }
            PyCallable callable = (PyCallable)this.myGetter.valueOrNull();
            if (callable != null) {
                if (!(callable instanceof StubBasedPsiElement) && !context2.maySwitchToAST((PsiElement)callable)) {
                    return null;
                }
                return callable.getCallType(receiver, PropertyImpl.buildArgumentsToParametersMap(receiver, callable, context2), context2);
            }
            return null;
        }

        @NotNull
        private static Map<PyExpression, PyCallableParameter> buildArgumentsToParametersMap(@Nullable PyExpression receiver, @NotNull PyCallable callable, @NotNull TypeEvalContext context2) {
            if (callable == null) {
                PropertyImpl.$$$reportNull$$$0(5);
            }
            if (context2 == null) {
                PropertyImpl.$$$reportNull$$$0(6);
            }
            if (receiver == null) {
                Map<PyExpression, PyCallableParameter> map2 = Collections.emptyMap();
                if (map2 == null) {
                    PropertyImpl.$$$reportNull$$$0(7);
                }
                return map2;
            }
            PyCallableParameter firstParameter = (PyCallableParameter)ContainerUtil.getFirstItem(callable.getParameters(context2));
            if (firstParameter == null || !firstParameter.isSelf()) {
                Map<PyExpression, PyCallableParameter> map3 = Collections.emptyMap();
                if (map3 == null) {
                    PropertyImpl.$$$reportNull$$$0(8);
                }
                return map3;
            }
            ImmutableMap immutableMap = ImmutableMap.of((Object)receiver, (Object)firstParameter);
            if (immutableMap == null) {
                PropertyImpl.$$$reportNull$$$0(9);
            }
            return immutableMap;
        }

        @Override
        @NotNull
        protected Maybe<PyCallable> translate(@Nullable PyExpression expr) {
            PsiElement something;
            if (expr == null || expr instanceof PyNoneLiteralExpression) {
                Maybe<PyCallable> maybe = NONE;
                if (maybe == null) {
                    PropertyImpl.$$$reportNull$$$0(10);
                }
                return maybe;
            }
            if (expr instanceof PyCallable) {
                return new Maybe<PyCallable>((PyCallable)((Object)expr));
            }
            PsiReference ref = expr.getReference();
            if (ref != null && (something = ref.resolve()) instanceof PyCallable) {
                return new Maybe<PyCallable>((PyCallable)something);
            }
            Maybe<PyCallable> maybe = NONE;
            if (maybe == null) {
                PropertyImpl.$$$reportNull$$$0(11);
            }
            return maybe;
        }

        @NotNull
        private static Maybe<PyCallable> filterNonStubExpression(@NotNull Maybe<PyCallable> maybeCallable) {
            PyCallable callable;
            if (maybeCallable == null) {
                PropertyImpl.$$$reportNull$$$0(12);
            }
            if ((callable = maybeCallable.valueOrNull()) != null && !(callable instanceof StubBasedPsiElement)) {
                Maybe<PyCallable> maybe = UNKNOWN_CALL;
                if (maybe == null) {
                    PropertyImpl.$$$reportNull$$$0(13);
                }
                return maybe;
            }
            Maybe<PyCallable> maybe = maybeCallable;
            if (maybe == null) {
                PropertyImpl.$$$reportNull$$$0(14);
            }
            return maybe;
        }

        public String toString() {
            return "property(" + this.myGetter + ", " + this.mySetter + ", " + this.myDeleter + ", " + this.myDoc + ")";
        }

        @Nullable
        public static PropertyImpl fromTarget(PyTargetExpression target) {
            PropertyImpl prop;
            PyExpression expr = target.findAssignedValue();
            boolean success = PropertyImpl.fillFromCall(expr, prop = new PropertyImpl(target.getName(), null, null, null, null, target));
            return success ? prop : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "direction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maybeCallable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyClassImpl$PropertyImpl";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getByDirection";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildArgumentsToParametersMap";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "translate";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterNonStubExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getByDirection";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "buildArgumentsToParametersMap";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "filterNonStubExpression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MultiNameFinder<T extends PyElement>
    implements Processor<T> {
        @NotNull
        private final List<T> myResult;
        private final String @NotNull [] myNames;
        @Nullable
        private PyClass myLastVisitedClass;

        MultiNameFinder(String ... names2) {
            if (names2 == null) {
                MultiNameFinder.$$$reportNull$$$0(0);
            }
            this.myResult = new ArrayList<T>();
            this.myNames = names2;
            this.myLastVisitedClass = null;
        }

        public boolean process(T t) {
            PyClass currentClass;
            PyClass pyClass = currentClass = t instanceof PyPossibleClassMember ? ((PyPossibleClassMember)t).getContainingClass() : null;
            if (this.myLastVisitedClass != null && currentClass != this.myLastVisitedClass && !this.myResult.isEmpty()) {
                return false;
            }
            this.myLastVisitedClass = currentClass;
            if (ArrayUtil.contains((String)t.getName(), (String[])this.myNames)) {
                this.myResult.add(t);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/python/psi/impl/PyClassImpl$MultiNameFinder", "<init>"));
        }
    }

    private static class NameFinder<T extends PyElement>
    implements Processor<T> {
        @NotNull
        private final TypeEvalContext myContext;
        private T myResult;
        private final String[] myNames;
        private int myLastResultIndex;
        private PyClass myLastVisitedClass;

        NameFinder(@NotNull TypeEvalContext context2, String ... names2) {
            if (context2 == null) {
                NameFinder.$$$reportNull$$$0(0);
            }
            this.myLastResultIndex = -1;
            this.myLastVisitedClass = null;
            this.myContext = context2;
            this.myNames = names2;
            this.myResult = null;
        }

        public T getResult() {
            return this.myResult;
        }

        @Nullable
        protected PyClass getContainingClass(@NotNull T element) {
            if (element == null) {
                NameFinder.$$$reportNull$$$0(1);
            }
            return null;
        }

        public boolean process(T target) {
            PyClass currentClass = this.getContainingClass(target);
            if (this.myLastVisitedClass != null && this.myLastVisitedClass != currentClass && this.myResult != null) {
                return false;
            }
            this.myLastVisitedClass = currentClass;
            int index = ArrayUtil.indexOf((Object[])this.myNames, (Object)target.getName());
            if (index >= 0 && (this.myLastResultIndex == -1 || index < this.myLastResultIndex || index == this.myLastResultIndex && PyiUtil.isOverload(this.myResult, this.myContext) && !PyiUtil.isOverload(target, this.myContext))) {
                this.myLastResultIndex = index;
                this.myResult = target;
                if (index == 0 && !PyiUtil.isOverload(this.myResult, this.myContext)) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/PyClassImpl$NameFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContainingClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MROException
    extends Exception {
        public MROException(String s) {
            super(s);
        }
    }
}

