/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.PyParser;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;

public class PythonParser {
    protected static final Logger LOGGER = Logger.getInstance((String)PyParser.class.getName());
    protected LanguageLevel myLanguageLevel = LanguageLevel.getDefault();

    public void setLanguageLevel(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
    }

    public void parseRoot(IElementType root, SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker rootMarker = builder.mark();
        ParsingContext context2 = this.createParsingContext(builder, this.myLanguageLevel);
        StatementParsing statementParser = context2.getStatementParser();
        builder.setTokenTypeRemapper((ITokenTypeRemapper)statementParser);
        boolean lastAfterSemicolon = false;
        while (!builder.eof()) {
            context2.pushScope(context2.emptyParsingScope());
            if (lastAfterSemicolon) {
                statementParser.parseSimpleStatement();
            } else {
                statementParser.parseStatement();
            }
            lastAfterSemicolon = context2.getScope().isAfterSemicolon();
            context2.popScope();
        }
        rootMarker.done(root);
    }

    protected ParsingContext createParsingContext(SyntaxTreeBuilder builder, LanguageLevel languageLevel) {
        return new ParsingContext(builder, languageLevel);
    }
}

